/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.output.pageable;

import java.io.Serializable;
import org.jfree.layouting.output.pageable.PhysicalPageKey;

public final class LogicalPageKey
implements Serializable {
    private int position;
    private int width;
    private int height;
    private PhysicalPageKey[] physicalPageKeys;

    public LogicalPageKey(int n, int n2, int n3) {
        this.position = n;
        this.width = n2;
        this.height = n3;
        this.physicalPageKeys = new PhysicalPageKey[n2 * n3];
        for (int i = 0; i < this.physicalPageKeys.length; ++i) {
            this.physicalPageKeys[i] = new PhysicalPageKey(this, i % n2, i / n2);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPosition() {
        return this.position;
    }

    public PhysicalPageKey getPage(int n, int n2) {
        return this.physicalPageKeys[n + n2 * this.width];
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LogicalPageKey logicalPageKey = (LogicalPageKey)object;
        if (this.height != logicalPageKey.height) {
            return false;
        }
        if (this.position != logicalPageKey.position) {
            return false;
        }
        return this.width == logicalPageKey.width;
    }

    public int hashCode() {
        int n = this.position;
        n = 29 * n + this.width;
        n = 29 * n + this.height;
        return n;
    }
}

