/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintFormula;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintTypeFormula;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InferenceFailureException;
import org.eclipse.jdt.internal.compiler.lookup.InferenceSubstitution;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionCastTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReductionResult;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBound;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

class BoundSet {
    static final BoundSet TRUE = new BoundSet();
    static final BoundSet FALSE = new BoundSet();
    HashMap<InferenceVariable, ThreeSets> boundsPerVariable = new HashMap();
    HashMap<ParameterizedTypeBinding, ParameterizedTypeBinding> captures = new HashMap();
    Set<InferenceVariable> inThrows = new HashSet<InferenceVariable>();
    Set<TypeBound> incorporatedBounds = new HashSet<TypeBound>();

    public void addBoundsFromTypeParameters(InferenceContext18 inferenceContext18, TypeVariableBinding[] typeVariableBindingArray, InferenceVariable[] inferenceVariableArray) {
        int n = typeVariableBindingArray.length;
        for (int i = 0; i < n; ++i) {
            TypeVariableBinding typeVariableBinding = typeVariableBindingArray[i];
            InferenceVariable inferenceVariable = inferenceVariableArray[i];
            TypeBound[] typeBoundArray = typeVariableBinding.getTypeBounds(inferenceVariable, new InferenceSubstitution(inferenceContext18.environment, inferenceContext18.inferenceVariables));
            boolean bl = false;
            if (typeBoundArray.length > 0) {
                bl = this.addBounds(typeBoundArray, inferenceContext18.environment);
            }
            if (bl) continue;
            this.addBound(new TypeBound(inferenceVariable, inferenceContext18.object, 2), inferenceContext18.environment);
        }
    }

    public TypeBound[] flatten() {
        int n = 0;
        Iterator<ThreeSets> iterator = this.boundsPerVariable.values().iterator();
        while (iterator.hasNext()) {
            n += iterator.next().size();
        }
        TypeBound[] typeBoundArray = new TypeBound[n];
        if (n == 0) {
            return typeBoundArray;
        }
        iterator = this.boundsPerVariable.values().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            n2 = iterator.next().flattenInto(typeBoundArray, n2);
        }
        return typeBoundArray;
    }

    public BoundSet copy() {
        BoundSet boundSet = new BoundSet();
        for (Map.Entry<InferenceVariable, ThreeSets> entry : this.boundsPerVariable.entrySet()) {
            boundSet.boundsPerVariable.put(entry.getKey(), entry.getValue().copy());
        }
        boundSet.inThrows.addAll(this.inThrows);
        boundSet.captures.putAll(this.captures);
        return boundSet;
    }

    public void addBound(TypeBound typeBound, LookupEnvironment lookupEnvironment) {
        ThreeSets threeSets = this.boundsPerVariable.get(typeBound.left);
        if (threeSets == null) {
            threeSets = new ThreeSets();
            this.boundsPerVariable.put(typeBound.left, threeSets);
        }
        threeSets.addBound(typeBound);
        TypeBinding typeBinding = typeBound.right;
        if (typeBound.relation == 4 && typeBinding.isProperType(true)) {
            threeSets.setInstantiation(typeBinding, typeBound.left, lookupEnvironment);
        }
        if (typeBound.right instanceof InferenceVariable) {
            InferenceVariable inferenceVariable = (InferenceVariable)typeBound.right;
            threeSets = this.boundsPerVariable.get(inferenceVariable);
            if (threeSets == null) {
                threeSets = new ThreeSets();
                this.boundsPerVariable.put(inferenceVariable, threeSets);
            }
            if (threeSets.inverseBounds == null) {
                threeSets.inverseBounds = new HashMap<InferenceVariable, TypeBound>();
            }
            threeSets.inverseBounds.put(inferenceVariable, typeBound);
        }
    }

    private boolean addBounds(TypeBound[] typeBoundArray, LookupEnvironment lookupEnvironment) {
        boolean bl = false;
        for (int i = 0; i < typeBoundArray.length; ++i) {
            this.addBound(typeBoundArray[i], lookupEnvironment);
            bl |= typeBoundArray[i].isBound();
        }
        return bl;
    }

    public boolean isInstantiated(InferenceVariable inferenceVariable) {
        ThreeSets threeSets = this.boundsPerVariable.get(inferenceVariable);
        if (threeSets != null) {
            return threeSets.instantiation != null;
        }
        return false;
    }

    public TypeBinding getInstantiation(InferenceVariable inferenceVariable, LookupEnvironment lookupEnvironment) {
        ThreeSets threeSets = this.boundsPerVariable.get(inferenceVariable);
        if (threeSets != null) {
            TypeBinding typeBinding = threeSets.instantiation;
            if (lookupEnvironment != null && lookupEnvironment.globalOptions.isAnnotationBasedNullAnalysisEnabled && typeBinding != null && (typeBinding.tagBits & 0x180000000000000L) == 0L) {
                return threeSets.combineAndUseNullHints(typeBinding, inferenceVariable.nullHints, lookupEnvironment);
            }
            return typeBinding;
        }
        return null;
    }

    public int numUninstantiatedVariables(InferenceVariable[] inferenceVariableArray) {
        int n = 0;
        for (int i = 0; i < inferenceVariableArray.length; ++i) {
            if (this.isInstantiated(inferenceVariableArray[i])) continue;
            ++n;
        }
        return n;
    }

    boolean incorporate(InferenceContext18 inferenceContext18) throws InferenceFailureException {
        boolean bl;
        do {
            Object[] objectArray;
            Object object;
            Object object2;
            Object object3;
            bl = false;
            TypeBound[] typeBoundArray = this.flatten();
            int n = typeBoundArray.length;
            if (n < 2) {
                return true;
            }
            for (int i = 0; i < n; ++i) {
                object3 = typeBoundArray[i];
                for (int j = i + 1; j < n; ++j) {
                    object2 = typeBoundArray[j];
                    if (this.incorporatedBounds.contains(object3) && this.incorporatedBounds.contains(object2)) continue;
                    object = null;
                    block0 : switch (((TypeBound)object3).relation) {
                        case 4: {
                            switch (((TypeBound)object2).relation) {
                                case 4: {
                                    object = this.combineSameSame((TypeBound)object3, (TypeBound)object2);
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    object = this.combineSameSubSuper((TypeBound)object3, (TypeBound)object2);
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (((TypeBound)object2).relation) {
                                case 4: {
                                    object = this.combineSameSubSuper((TypeBound)object2, (TypeBound)object3);
                                    break;
                                }
                                case 3: {
                                    object = this.combineSuperAndSub((TypeBound)object2, (TypeBound)object3);
                                    break;
                                }
                                case 2: {
                                    object = this.combineEqualSupers((TypeBound)object3, (TypeBound)object2);
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (((TypeBound)object2).relation) {
                                case 4: {
                                    object = this.combineSameSubSuper((TypeBound)object2, (TypeBound)object3);
                                    break block0;
                                }
                                case 2: {
                                    object = this.combineSuperAndSub((TypeBound)object3, (TypeBound)object2);
                                    break block0;
                                }
                                case 3: {
                                    object = this.combineEqualSupers((TypeBound)object3, (TypeBound)object2);
                                }
                            }
                        }
                    }
                    if (object != null) {
                        if (!this.reduceOneConstraint(inferenceContext18, (ConstraintFormula)object)) {
                            return false;
                        }
                        bl = true;
                        long l = (((ConstraintTypeFormula)object).left.tagBits | ((ConstraintTypeFormula)object).right.tagBits) & 0x180000000000000L;
                        ((TypeBound)object3).nullHints |= l;
                        ((TypeBound)object2).nullHints |= l;
                    }
                    if ((objectArray = this.deriveTypeArgumentConstraints((TypeBound)object3, (TypeBound)object2)) == null) continue;
                    for (int k = 0; k < objectArray.length; ++k) {
                        if (!this.reduceOneConstraint(inferenceContext18, (ConstraintFormula)objectArray[k])) {
                            return false;
                        }
                        bl = true;
                    }
                }
                this.incorporatedBounds.add((TypeBound)object3);
            }
            Iterator<Map.Entry<ParameterizedTypeBinding, ParameterizedTypeBinding>> iterator = this.captures.entrySet().iterator();
            while (iterator.hasNext()) {
                bl = true;
                object3 = iterator.next();
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)object3.getKey();
                object2 = (ParameterizedTypeBinding)object3.getValue();
                object = (ReferenceBinding)((TypeBinding)object2).original();
                objectArray = ((TypeBinding)object).typeVariables();
                InferenceVariable[] inferenceVariableArray = new InferenceVariable[parameterizedTypeBinding.arguments.length];
                System.arraycopy(parameterizedTypeBinding.arguments, 0, inferenceVariableArray, 0, inferenceVariableArray.length);
                InferenceSubstitution inferenceSubstitution = new InferenceSubstitution(inferenceContext18.environment, inferenceVariableArray, (TypeVariableBinding[])objectArray){
                    final /* synthetic */ TypeVariableBinding[] val$parameters;
                    {
                        this.val$parameters = typeVariableBindingArray;
                        super(lookupEnvironment, inferenceVariableArray);
                    }

                    @Override
                    protected TypeBinding getP(int n) {
                        return this.val$parameters[n];
                    }
                };
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object4 = objectArray[i];
                    InferenceVariable inferenceVariable = (InferenceVariable)parameterizedTypeBinding.arguments[i];
                    this.addBounds(((TypeVariableBinding)object4).getTypeBounds(inferenceVariable, inferenceSubstitution), inferenceContext18.environment);
                    TypeBinding typeBinding = ((ParameterizedTypeBinding)object2).arguments[i];
                    if (typeBinding instanceof WildcardBinding) {
                        WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                        TypeBinding typeBinding2 = wildcardBinding.bound;
                        ThreeSets threeSets = this.boundsPerVariable.get(inferenceVariable);
                        if (threeSets == null) continue;
                        if (threeSets.sameBounds != null) {
                            for (TypeBound typeBound : threeSets.sameBounds) {
                                if (typeBound.right instanceof InferenceVariable) continue;
                                return false;
                            }
                        }
                        if (threeSets.subBounds != null && ((TypeVariableBinding)object4).firstBound != null) {
                            for (TypeBound typeBound : threeSets.subBounds) {
                                TypeBinding typeBinding3;
                                if (typeBound.right instanceof InferenceVariable) continue;
                                TypeBinding typeBinding4 = typeBound.right;
                                TypeBinding typeBinding5 = ((TypeVariableBinding)object4).firstBound;
                                ReferenceBinding[] referenceBindingArray = ((TypeVariableBinding)object4).superInterfaces;
                                if (referenceBindingArray == Binding.NO_SUPERINTERFACES) {
                                    typeBinding3 = typeBinding5;
                                } else {
                                    int n2 = referenceBindingArray.length + 1;
                                    ReferenceBinding[] referenceBindingArray2 = new ReferenceBinding[n2];
                                    referenceBindingArray2[0] = (ReferenceBinding)typeBinding5;
                                    System.arraycopy(referenceBindingArray, 0, referenceBindingArray2, 1, n2 - 1);
                                    typeBinding3 = new IntersectionCastTypeBinding(referenceBindingArray2, inferenceContext18.environment);
                                }
                                this.addTypeBoundsFromWildcardBound(inferenceContext18, inferenceSubstitution, wildcardBinding.boundKind, typeBinding2, typeBinding4, typeBinding3);
                            }
                        }
                        if (threeSets.superBounds == null) continue;
                        for (TypeBound typeBound : threeSets.superBounds) {
                            if (typeBound.right instanceof InferenceVariable) continue;
                            if (wildcardBinding.boundKind == 2) {
                                this.reduceOneConstraint(inferenceContext18, ConstraintTypeFormula.create(typeBound.right, typeBinding2, 2));
                                continue;
                            }
                            return false;
                        }
                        continue;
                    }
                    this.addBound(new TypeBound(inferenceVariable, typeBinding, 4), inferenceContext18.environment);
                }
            }
            this.captures.clear();
        } while (bl);
        return true;
    }

    void addTypeBoundsFromWildcardBound(InferenceContext18 inferenceContext18, InferenceSubstitution inferenceSubstitution, int n, TypeBinding typeBinding, TypeBinding typeBinding2, TypeBinding typeBinding3) throws InferenceFailureException {
        ConstraintTypeFormula constraintTypeFormula = null;
        if (n == 1) {
            if (typeBinding3.id == 1) {
                constraintTypeFormula = ConstraintTypeFormula.create(typeBinding, typeBinding2, 2);
            }
            if (typeBinding.id == 1) {
                constraintTypeFormula = ConstraintTypeFormula.create(inferenceSubstitution.substitute((Substitution)inferenceSubstitution, typeBinding3), typeBinding2, 2);
            }
        } else {
            constraintTypeFormula = ConstraintTypeFormula.create(inferenceSubstitution.substitute((Substitution)inferenceSubstitution, typeBinding3), typeBinding2, 2);
        }
        if (constraintTypeFormula != null) {
            this.reduceOneConstraint(inferenceContext18, constraintTypeFormula);
        }
    }

    private ConstraintTypeFormula combineSameSame(TypeBound typeBound, TypeBound typeBound2) {
        if (typeBound.left == typeBound2.left) {
            return ConstraintTypeFormula.create(typeBound.right, typeBound2.right, 4, typeBound.isSoft || typeBound2.isSoft);
        }
        ConstraintTypeFormula constraintTypeFormula = this.combineSameSameWithProperType(typeBound, typeBound2);
        if (constraintTypeFormula != null) {
            return constraintTypeFormula;
        }
        constraintTypeFormula = this.combineSameSameWithProperType(typeBound2, typeBound);
        if (constraintTypeFormula != null) {
            return constraintTypeFormula;
        }
        return null;
    }

    private ConstraintTypeFormula combineSameSameWithProperType(TypeBound typeBound, TypeBound typeBound2) {
        TypeBinding typeBinding = typeBound.right;
        if (typeBinding.isProperType(true)) {
            InferenceVariable inferenceVariable = typeBound.left;
            InferenceVariable inferenceVariable2 = typeBound2.left;
            TypeBinding typeBinding2 = typeBound2.right.substituteInferenceVariable(inferenceVariable, typeBinding);
            return ConstraintTypeFormula.create(inferenceVariable2, typeBinding2, 4, typeBound.isSoft || typeBound2.isSoft);
        }
        return null;
    }

    private ConstraintTypeFormula combineSameSubSuper(TypeBound typeBound, TypeBound typeBound2) {
        TypeBinding typeBinding;
        InferenceVariable inferenceVariable = typeBound.left;
        TypeBinding typeBinding2 = typeBound.right;
        if (inferenceVariable == typeBound2.left) {
            return ConstraintTypeFormula.create(typeBinding2, typeBound2.right, typeBound2.relation, typeBound2.isSoft || typeBound.isSoft);
        }
        if (inferenceVariable == typeBound2.right) {
            return ConstraintTypeFormula.create(typeBound2.right, typeBinding2, typeBound2.relation, typeBound2.isSoft || typeBound.isSoft);
        }
        if (typeBound.right instanceof InferenceVariable) {
            inferenceVariable = (InferenceVariable)typeBound.right;
            typeBinding2 = typeBound.left;
            if (inferenceVariable == typeBound2.left) {
                return ConstraintTypeFormula.create(typeBinding2, typeBound2.right, typeBound2.relation, typeBound2.isSoft || typeBound.isSoft);
            }
            if (inferenceVariable == typeBound2.right) {
                return ConstraintTypeFormula.create(typeBound2.right, typeBinding2, typeBound2.relation, typeBound2.isSoft || typeBound.isSoft);
            }
        }
        if ((typeBinding = typeBound.right).isProperType(true)) {
            TypeBinding typeBinding3 = inferenceVariable == typeBound2.left ? typeBinding : typeBound2.left;
            TypeBinding typeBinding4 = typeBound2.right.substituteInferenceVariable(inferenceVariable, typeBinding);
            return ConstraintTypeFormula.create(typeBinding3, typeBinding4, typeBound2.relation, typeBound2.isSoft || typeBound.isSoft);
        }
        return null;
    }

    private ConstraintTypeFormula combineSuperAndSub(TypeBound typeBound, TypeBound typeBound2) {
        InferenceVariable inferenceVariable = typeBound.left;
        if (inferenceVariable == typeBound2.left) {
            return ConstraintTypeFormula.create(typeBound.right, typeBound2.right, 2, typeBound2.isSoft || typeBound.isSoft);
        }
        if (typeBound.right instanceof InferenceVariable && (inferenceVariable = (InferenceVariable)typeBound.right) == typeBound2.right) {
            return ConstraintTypeFormula.create(typeBound.left, typeBound2.left, 3, typeBound2.isSoft || typeBound.isSoft);
        }
        return null;
    }

    private ConstraintTypeFormula combineEqualSupers(TypeBound typeBound, TypeBound typeBound2) {
        if (typeBound.left == typeBound2.right) {
            return ConstraintTypeFormula.create(typeBound2.left, typeBound.right, typeBound.relation, typeBound2.isSoft || typeBound.isSoft);
        }
        if (typeBound.right == typeBound2.left) {
            return ConstraintTypeFormula.create(typeBound.left, typeBound2.right, typeBound.relation, typeBound2.isSoft || typeBound.isSoft);
        }
        return null;
    }

    private ConstraintTypeFormula[] deriveTypeArgumentConstraints(TypeBound typeBound, TypeBound typeBound2) {
        if (typeBound.relation != 2 || typeBound2.relation != 2) {
            return null;
        }
        if (typeBound.left != typeBound2.left) {
            return null;
        }
        TypeBinding[] typeBindingArray = this.superTypesWithCommonGenericType(typeBound.right, typeBound2.right);
        if (typeBindingArray != null) {
            return this.typeArgumentEqualityConstraints(typeBindingArray[0], typeBindingArray[1], typeBound.isSoft || typeBound2.isSoft);
        }
        return null;
    }

    private ConstraintTypeFormula[] typeArgumentEqualityConstraints(TypeBinding typeBinding, TypeBinding typeBinding2, boolean bl) {
        if (typeBinding == null || typeBinding.kind() != 260 || typeBinding2 == null || typeBinding2.kind() != 260) {
            return null;
        }
        if (TypeBinding.equalsEquals(typeBinding, typeBinding2)) {
            return null;
        }
        TypeBinding[] typeBindingArray = typeBinding.typeArguments();
        TypeBinding[] typeBindingArray2 = typeBinding2.typeArguments();
        if (typeBindingArray == null || typeBindingArray2 == null || typeBindingArray.length != typeBindingArray2.length) {
            return null;
        }
        ArrayList<ConstraintTypeFormula> arrayList = new ArrayList<ConstraintTypeFormula>();
        for (int i = 0; i < typeBindingArray.length; ++i) {
            TypeBinding typeBinding3 = typeBindingArray[i];
            TypeBinding typeBinding4 = typeBindingArray2[i];
            if (typeBinding3.isWildcard() || typeBinding4.isWildcard() || TypeBinding.equalsEquals(typeBinding3, typeBinding4)) continue;
            arrayList.add(ConstraintTypeFormula.create(typeBinding3, typeBinding4, 4, bl));
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray(new ConstraintTypeFormula[arrayList.size()]);
        }
        return null;
    }

    public boolean reduceOneConstraint(InferenceContext18 inferenceContext18, ConstraintFormula constraintFormula) throws InferenceFailureException {
        Object object = constraintFormula.reduce(inferenceContext18);
        if (object == ReductionResult.FALSE) {
            return false;
        }
        if (object == ReductionResult.TRUE) {
            return true;
        }
        if (object == constraintFormula) {
            throw new IllegalStateException("Failed to reduce constraint formula");
        }
        if (object != null) {
            if (object instanceof ConstraintFormula) {
                if (!this.reduceOneConstraint(inferenceContext18, (ConstraintFormula)object)) {
                    return false;
                }
            } else if (object instanceof ConstraintFormula[]) {
                ConstraintFormula[] constraintFormulaArray = (ConstraintFormula[])object;
                for (int i = 0; i < constraintFormulaArray.length; ++i) {
                    if (this.reduceOneConstraint(inferenceContext18, constraintFormulaArray[i])) continue;
                    return false;
                }
            } else {
                this.addBound((TypeBound)object, inferenceContext18.environment);
            }
        }
        return true;
    }

    public boolean dependsOnResolutionOf(InferenceVariable inferenceVariable, InferenceVariable inferenceVariable2) {
        Object object;
        Iterator<Map.Entry<ParameterizedTypeBinding, ParameterizedTypeBinding>> iterator = this.captures.entrySet().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            object = iterator.next();
            ParameterizedTypeBinding parameterizedTypeBinding = object.getKey();
            for (int i = 0; i < parameterizedTypeBinding.arguments.length; ++i) {
                if (parameterizedTypeBinding.arguments[i] == inferenceVariable) {
                    ParameterizedTypeBinding parameterizedTypeBinding2 = (ParameterizedTypeBinding)object.getValue();
                    if (parameterizedTypeBinding2.mentionsAny(new TypeBinding[]{inferenceVariable2}, -1)) {
                        return true;
                    }
                    if (!parameterizedTypeBinding.mentionsAny(new TypeBinding[]{inferenceVariable2}, i)) continue;
                    return true;
                }
                if (parameterizedTypeBinding.arguments[i] != inferenceVariable2) continue;
                bl = true;
            }
        }
        return bl ? (object = this.boundsPerVariable.get(inferenceVariable2)) != null && ((ThreeSets)object).hasDependency(inferenceVariable) : (object = this.boundsPerVariable.get(inferenceVariable)) != null && ((ThreeSets)object).hasDependency(inferenceVariable2);
    }

    public boolean hasCaptureBound(Set<InferenceVariable> set) {
        for (ParameterizedTypeBinding parameterizedTypeBinding : this.captures.keySet()) {
            for (int i = 0; i < parameterizedTypeBinding.arguments.length; ++i) {
                if (!set.contains(parameterizedTypeBinding.arguments[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasOnlyTrivialExceptionBounds(InferenceVariable inferenceVariable, TypeBinding[] typeBindingArray) {
        if (typeBindingArray != null) {
            block3: for (int i = 0; i < typeBindingArray.length; ++i) {
                switch (typeBindingArray[i].id) {
                    case 1: 
                    case 21: 
                    case 25: {
                        continue block3;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public TypeBinding[] upperBounds(InferenceVariable inferenceVariable, boolean bl) {
        ThreeSets threeSets = this.boundsPerVariable.get(inferenceVariable);
        if (threeSets == null || threeSets.subBounds == null) {
            return Binding.NO_TYPES;
        }
        return threeSets.upperBounds(bl, inferenceVariable);
    }

    TypeBinding[] lowerBounds(InferenceVariable inferenceVariable, boolean bl) {
        ThreeSets threeSets = this.boundsPerVariable.get(inferenceVariable);
        if (threeSets == null || threeSets.superBounds == null) {
            return Binding.NO_TYPES;
        }
        return threeSets.lowerBounds(bl, inferenceVariable);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Type Bounds:\n");
        TypeBound[] typeBoundArray = this.flatten();
        for (int i = 0; i < typeBoundArray.length; ++i) {
            stringBuffer.append('\t').append(typeBoundArray[i].toString()).append('\n');
        }
        stringBuffer.append("Capture Bounds:\n");
        for (Map.Entry<ParameterizedTypeBinding, ParameterizedTypeBinding> entry : this.captures.entrySet()) {
            String string = String.valueOf(((TypeBinding)entry.getKey()).shortReadableName());
            String string2 = String.valueOf(((TypeBinding)entry.getValue()).shortReadableName());
            stringBuffer.append('\t').append(string).append(" = capt(").append(string2).append(")\n");
        }
        return stringBuffer.toString();
    }

    public TypeBinding findWrapperTypeBound(InferenceVariable inferenceVariable) {
        ThreeSets threeSets = this.boundsPerVariable.get(inferenceVariable);
        if (threeSets == null) {
            return null;
        }
        return threeSets.findSingleWrapperType();
    }

    public boolean condition18_5_2_bullet_3_3_1(InferenceVariable inferenceVariable, TypeBinding typeBinding) {
        if (typeBinding.isBaseType()) {
            return false;
        }
        if (InferenceContext18.parameterizedWithWildcard(typeBinding) != null) {
            return false;
        }
        ThreeSets threeSets = this.boundsPerVariable.get(inferenceVariable);
        if (threeSets.sameBounds != null) {
            for (TypeBound typeBound : threeSets.sameBounds) {
                if (InferenceContext18.parameterizedWithWildcard(typeBound.right) == null) continue;
                return true;
            }
        }
        if (threeSets.superBounds != null) {
            for (TypeBound typeBound : threeSets.superBounds) {
                if (InferenceContext18.parameterizedWithWildcard(typeBound.right) == null) continue;
                return true;
            }
        }
        if (threeSets.superBounds != null) {
            ArrayList<TypeBound> arrayList = new ArrayList<TypeBound>(threeSets.superBounds);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                TypeBinding typeBinding2 = ((TypeBound)arrayList.get((int)i)).right;
                for (int j = i + 1; j < n; ++j) {
                    TypeBinding typeBinding3 = ((TypeBound)arrayList.get((int)j)).right;
                    TypeBinding[] typeBindingArray = this.superTypesWithCommonGenericType(typeBinding2, typeBinding3);
                    if (typeBindingArray == null || TypeBinding.equalsEquals(typeBindingArray[0], typeBindingArray[1])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean condition18_5_2_bullet_3_3_2(InferenceVariable inferenceVariable, TypeBinding typeBinding, InferenceContext18 inferenceContext18) {
        if (!typeBinding.isParameterizedType()) {
            return false;
        }
        TypeBinding typeBinding2 = typeBinding.original();
        ThreeSets threeSets = this.boundsPerVariable.get(inferenceVariable);
        if (threeSets.sameBounds != null) {
            for (TypeBound typeBound : threeSets.sameBounds) {
                if (!this.superOnlyRaw(typeBinding2, typeBound.right, inferenceContext18.environment)) continue;
                return true;
            }
        }
        if (threeSets.superBounds != null) {
            for (TypeBound typeBound : threeSets.superBounds) {
                if (!this.superOnlyRaw(typeBinding2, typeBound.right, inferenceContext18.environment)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean superOnlyRaw(TypeBinding typeBinding, TypeBinding typeBinding2, LookupEnvironment lookupEnvironment) {
        if (typeBinding2 instanceof InferenceVariable) {
            return false;
        }
        if (typeBinding2.findSuperTypeOriginatingFrom(typeBinding) == null) {
            return typeBinding2.isCompatibleWith(lookupEnvironment.convertToRawType(typeBinding, false));
        }
        return false;
    }

    protected TypeBinding[] superTypesWithCommonGenericType(TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (typeBinding == null || typeBinding.id == 1 || typeBinding2 == null || typeBinding2.id == 1) {
            return null;
        }
        if (TypeBinding.equalsEquals(typeBinding.original(), typeBinding2.original())) {
            return new TypeBinding[]{typeBinding, typeBinding2};
        }
        TypeBinding typeBinding3 = typeBinding2.findSuperTypeOriginatingFrom(typeBinding);
        if (typeBinding3 != null) {
            return new TypeBinding[]{typeBinding, typeBinding3};
        }
        TypeBinding[] typeBindingArray = this.superTypesWithCommonGenericType(typeBinding.superclass(), typeBinding2);
        if (typeBindingArray != null) {
            return typeBindingArray;
        }
        ReferenceBinding[] referenceBindingArray = typeBinding.superInterfaces();
        if (referenceBindingArray != null) {
            for (int i = 0; i < referenceBindingArray.length; ++i) {
                typeBindingArray = this.superTypesWithCommonGenericType(referenceBindingArray[i], typeBinding2);
                if (typeBindingArray == null) continue;
                return typeBindingArray;
            }
        }
        return null;
    }

    private class ThreeSets {
        Set<TypeBound> superBounds;
        Set<TypeBound> sameBounds;
        Set<TypeBound> subBounds;
        TypeBinding instantiation;
        Map<InferenceVariable, TypeBound> inverseBounds;

        public void addBound(TypeBound typeBound) {
            switch (typeBound.relation) {
                case 3: {
                    if (this.superBounds == null) {
                        this.superBounds = new HashSet<TypeBound>();
                    }
                    this.superBounds.add(typeBound);
                    break;
                }
                case 4: {
                    if (this.sameBounds == null) {
                        this.sameBounds = new HashSet<TypeBound>();
                    }
                    this.sameBounds.add(typeBound);
                    break;
                }
                case 2: {
                    if (this.subBounds == null) {
                        this.subBounds = new HashSet<TypeBound>();
                    }
                    this.subBounds.add(typeBound);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected bound relation in : " + typeBound);
                }
            }
        }

        public TypeBinding[] lowerBounds(boolean bl, InferenceVariable inferenceVariable) {
            TypeBinding[] typeBindingArray = new TypeBinding[this.superBounds.size()];
            Iterator<TypeBound> iterator = this.superBounds.iterator();
            long l = inferenceVariable.nullHints;
            int n = 0;
            while (iterator.hasNext()) {
                TypeBound typeBound = iterator.next();
                TypeBinding typeBinding = typeBound.right;
                if (bl && !typeBinding.isProperType(true)) continue;
                typeBindingArray[n++] = typeBinding;
                l |= typeBound.nullHints;
            }
            if (n == 0) {
                return Binding.NO_TYPES;
            }
            if (n < typeBindingArray.length) {
                TypeBinding[] typeBindingArray2 = typeBindingArray;
                typeBindingArray = new TypeBinding[n];
                System.arraycopy(typeBindingArray2, 0, typeBindingArray, 0, n);
            }
            this.useNullHints(l, typeBindingArray, inferenceVariable.environment);
            InferenceContext18.sortTypes(typeBindingArray);
            return typeBindingArray;
        }

        public TypeBinding[] upperBounds(boolean bl, InferenceVariable inferenceVariable) {
            TypeBinding[] typeBindingArray = new ReferenceBinding[this.subBounds.size()];
            TypeBinding typeBinding = null;
            Iterator<TypeBound> iterator = this.subBounds.iterator();
            long l = inferenceVariable.nullHints;
            int n = 0;
            while (iterator.hasNext()) {
                TypeBinding typeBinding2 = iterator.next().right;
                if (bl && !typeBinding2.isProperType(true)) continue;
                if (typeBinding2 instanceof ReferenceBinding) {
                    typeBindingArray[n++] = (ReferenceBinding)typeBinding2;
                    l |= typeBinding2.tagBits & 0x180000000000000L;
                    continue;
                }
                if (typeBinding != null) {
                    return Binding.NO_TYPES;
                }
                typeBinding = typeBinding2;
            }
            if (n == 0) {
                return Binding.NO_TYPES;
            }
            if (n == 1 && typeBinding != null) {
                return new TypeBinding[]{typeBinding};
            }
            if (n < typeBindingArray.length) {
                TypeBinding[] typeBindingArray2 = typeBindingArray;
                typeBindingArray = new ReferenceBinding[n];
                System.arraycopy(typeBindingArray2, 0, typeBindingArray, 0, n);
            }
            this.useNullHints(l, typeBindingArray, inferenceVariable.environment);
            InferenceContext18.sortTypes(typeBindingArray);
            return typeBindingArray;
        }

        public boolean hasDependency(InferenceVariable inferenceVariable) {
            if (this.superBounds != null && this.hasDependency(this.superBounds, inferenceVariable)) {
                return true;
            }
            if (this.sameBounds != null && this.hasDependency(this.sameBounds, inferenceVariable)) {
                return true;
            }
            if (this.subBounds != null && this.hasDependency(this.subBounds, inferenceVariable)) {
                return true;
            }
            return this.inverseBounds != null && this.inverseBounds.containsKey(inferenceVariable);
        }

        private boolean hasDependency(Set<TypeBound> set, InferenceVariable inferenceVariable) {
            for (TypeBound typeBound : set) {
                if (typeBound.right != inferenceVariable && !typeBound.right.mentionsAny(new TypeBinding[]{inferenceVariable}, -1)) continue;
                return true;
            }
            return false;
        }

        public int size() {
            int n = 0;
            if (this.superBounds != null) {
                n += this.superBounds.size();
            }
            if (this.sameBounds != null) {
                n += this.sameBounds.size();
            }
            if (this.subBounds != null) {
                n += this.subBounds.size();
            }
            return n;
        }

        public int flattenInto(TypeBound[] typeBoundArray, int n) {
            int n2;
            if (this.superBounds != null) {
                n2 = this.superBounds.size();
                System.arraycopy(this.superBounds.toArray(), 0, typeBoundArray, n, n2);
                n += n2;
            }
            if (this.sameBounds != null) {
                n2 = this.sameBounds.size();
                System.arraycopy(this.sameBounds.toArray(), 0, typeBoundArray, n, n2);
                n += n2;
            }
            if (this.subBounds != null) {
                n2 = this.subBounds.size();
                System.arraycopy(this.subBounds.toArray(), 0, typeBoundArray, n, n2);
                n += n2;
            }
            return n;
        }

        public ThreeSets copy() {
            ThreeSets threeSets = new ThreeSets();
            if (this.superBounds != null) {
                threeSets.superBounds = new HashSet<TypeBound>(this.superBounds);
            }
            if (this.sameBounds != null) {
                threeSets.sameBounds = new HashSet<TypeBound>(this.sameBounds);
            }
            if (this.subBounds != null) {
                threeSets.subBounds = new HashSet<TypeBound>(this.subBounds);
            }
            threeSets.instantiation = this.instantiation;
            return threeSets;
        }

        public TypeBinding findSingleWrapperType() {
            TypeBinding typeBinding;
            Iterator<TypeBound> iterator;
            TypeBinding typeBinding2 = null;
            if (this.subBounds != null) {
                iterator = this.subBounds.iterator();
                while (iterator.hasNext()) {
                    typeBinding = iterator.next().right;
                    if (!typeBinding.isProperType(true)) continue;
                    switch (typeBinding.id) {
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: {
                            if (typeBinding2 != null) {
                                return null;
                            }
                            typeBinding2 = typeBinding;
                        }
                    }
                }
            }
            if (this.superBounds != null) {
                iterator = this.superBounds.iterator();
                while (iterator.hasNext()) {
                    typeBinding = iterator.next().right;
                    if (!typeBinding.isProperType(true)) continue;
                    switch (typeBinding.id) {
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: {
                            if (typeBinding2 != null) {
                                return null;
                            }
                            typeBinding2 = typeBinding;
                        }
                    }
                }
            }
            return typeBinding2;
        }

        private void useNullHints(long l, TypeBinding[] typeBindingArray, LookupEnvironment lookupEnvironment) {
            block3: {
                block2: {
                    if (l != 0x180000000000000L) break block2;
                    for (int i = 0; i < typeBindingArray.length; ++i) {
                        typeBindingArray[i] = typeBindingArray[i].unannotated();
                    }
                    break block3;
                }
                AnnotationBinding[] annotationBindingArray = lookupEnvironment.nullAnnotationsFromTagBits(l);
                if (annotationBindingArray == null) break block3;
                for (int i = 0; i < typeBindingArray.length; ++i) {
                    typeBindingArray[i] = lookupEnvironment.createAnnotatedType(typeBindingArray[i], annotationBindingArray);
                }
            }
        }

        TypeBinding combineAndUseNullHints(TypeBinding typeBinding, long l, LookupEnvironment lookupEnvironment) {
            AnnotationBinding[] annotationBindingArray;
            if (this.sameBounds != null) {
                annotationBindingArray = this.sameBounds.iterator();
                while (annotationBindingArray.hasNext()) {
                    l |= annotationBindingArray.next().nullHints;
                }
            }
            if (this.superBounds != null) {
                annotationBindingArray = this.superBounds.iterator();
                while (annotationBindingArray.hasNext()) {
                    l |= annotationBindingArray.next().nullHints;
                }
            }
            if (this.subBounds != null) {
                annotationBindingArray = this.subBounds.iterator();
                while (annotationBindingArray.hasNext()) {
                    l |= ((TypeBound)annotationBindingArray.next()).nullHints;
                }
            }
            if (l == 0x180000000000000L) {
                return typeBinding.unannotated();
            }
            annotationBindingArray = lookupEnvironment.nullAnnotationsFromTagBits(l);
            if (annotationBindingArray != null) {
                return lookupEnvironment.createAnnotatedType(typeBinding, annotationBindingArray);
            }
            return typeBinding;
        }

        public void setInstantiation(TypeBinding typeBinding, InferenceVariable inferenceVariable, LookupEnvironment lookupEnvironment) {
            if (lookupEnvironment.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
                AnnotationBinding[] annotationBindingArray;
                long l;
                long l2 = (this.instantiation != null ? this.instantiation.tagBits : inferenceVariable.tagBits) & 0x180000000000000L;
                long l3 = typeBinding.tagBits & 0x180000000000000L;
                long l4 = l = l2 == 0x100000000000000L ? l2 : l3;
                if (this.instantiation != null && l2 == l) {
                    return;
                }
                if (l3 != l && (annotationBindingArray = lookupEnvironment.nullAnnotationsFromTagBits(l)) != null) {
                    typeBinding = lookupEnvironment.createAnnotatedType(typeBinding.unannotated(), annotationBindingArray);
                }
            }
            this.instantiation = typeBinding;
        }
    }
}

