/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc;

import java.io.IOException;
import java.util.Iterator;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentDeserializer;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.Style;
import org.openoffice.xmerge.converter.xml.StyleCatalog;
import org.openoffice.xmerge.converter.xml.sxc.BookSettings;
import org.openoffice.xmerge.converter.xml.sxc.CellStyle;
import org.openoffice.xmerge.converter.xml.sxc.ColumnRowInfo;
import org.openoffice.xmerge.converter.xml.sxc.ColumnStyle;
import org.openoffice.xmerge.converter.xml.sxc.Format;
import org.openoffice.xmerge.converter.xml.sxc.NameDefinition;
import org.openoffice.xmerge.converter.xml.sxc.RowStyle;
import org.openoffice.xmerge.converter.xml.sxc.SpreadsheetDecoder;
import org.openoffice.xmerge.converter.xml.sxc.SxcDocument;
import org.openoffice.xmerge.util.Debug;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SxcDocumentDeserializer
implements OfficeConstants,
DocumentDeserializer {
    private SpreadsheetDecoder decoder = null;
    private org.w3c.dom.Document settings = null;
    private org.w3c.dom.Document doc = null;
    private final ConvertData cd;
    private StyleCatalog styleCat = null;
    private int textStyles = 1;
    private int colStyles = 1;
    private int rowStyles = 1;

    public SxcDocumentDeserializer(ConvertData cd) {
        this.cd = cd;
    }

    public abstract SpreadsheetDecoder createDecoder(String var1, String[] var2, String var3) throws IOException;

    protected abstract String getWorkbookName(ConvertData var1) throws IOException;

    protected abstract String[] getWorksheetNames(ConvertData var1) throws IOException;

    @Override
    public Document deserialize() throws ConvertException, IOException {
        String[] worksheetNames = this.getWorksheetNames(this.cd);
        String workbookName = this.getWorkbookName(this.cd);
        SxcDocument sxcDoc = new SxcDocument(workbookName);
        sxcDoc.initContentDOM();
        sxcDoc.initSettingsDOM();
        this.styleCat = new StyleCatalog(5);
        this.doc = sxcDoc.getContentDOM();
        this.settings = sxcDoc.getSettingsDOM();
        this.initFontTable();
        this.decoder = this.createDecoder(workbookName, worksheetNames, "password");
        Debug.log(4, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        Debug.log(4, "<DEBUGLOG>");
        this.decoder.addDeviceContent(this.cd);
        this.decode();
        Debug.log(4, "</DEBUGLOG>");
        return sxcDoc;
    }

    private void initFontTable() {
        String[] fontTable = new String[]{"Tahoma", "Tahoma", "swiss", "variable", "Courier New", "&apos;Courier New&apos;", "modern", "fixed"};
        NodeList list = this.doc.getElementsByTagName("office:font-decls");
        Node root = list.item(0);
        int i = 0;
        while (i < fontTable.length) {
            Element tableElement = this.doc.createElement("style:font-decl");
            tableElement.setAttribute("style:name", fontTable[i++]);
            tableElement.setAttribute("fo:font-family", fontTable[i++]);
            tableElement.setAttribute("fo:font-family-generic", fontTable[i++]);
            tableElement.setAttribute("style:font-pitch", fontTable[i++]);
            root.appendChild(tableElement);
        }
    }

    protected void decode() throws IOException {
        int numSheets = this.decoder.getNumberOfSheets();
        if (numSheets == 0) {
            System.err.println("Error decoding invalid Input stream");
            return;
        }
        NodeList list = this.doc.getElementsByTagName("office:body");
        Node node = list.item(0);
        for (int i = 0; i < numSheets; ++i) {
            this.decoder.setWorksheet(i);
            int len = list.getLength();
            if (len <= 0) continue;
            this.processTable(node);
        }
        Iterator<NameDefinition> nameDefinitionTable = this.decoder.getNameDefinitions();
        if (nameDefinitionTable.hasNext()) {
            this.processNameDefinition(node, nameDefinitionTable);
        }
        NodeList settingsList = this.settings.getElementsByTagName("office:settings");
        Node settingsNode = settingsList.item(0);
        this.processSettings(settingsNode);
    }

    protected void processSettings(Node root) {
        Element configItemSetEntry = this.settings.createElement("config:config-item-set");
        configItemSetEntry.setAttribute("config:name", "view-settings");
        Element configItemMapIndexed = this.settings.createElement("config:config-item-map-indexed");
        configItemMapIndexed.setAttribute("config:name", "Views");
        Element configItemMapEntry = this.settings.createElement("config:config-item-map-entry");
        BookSettings bs = this.decoder.getSettings();
        bs.writeNode(this.settings, configItemMapEntry);
        configItemMapIndexed.appendChild(configItemMapEntry);
        configItemSetEntry.appendChild(configItemMapIndexed);
        root.appendChild(configItemSetEntry);
    }

    protected void processNameDefinition(Node root, Iterator<NameDefinition> eNameDefinitions) throws IOException {
        Debug.log(4, "<NAMED-EXPRESSIONS>");
        Element namedExpressionsElement = this.doc.createElement("table:named-expressions");
        while (eNameDefinitions.hasNext()) {
            NameDefinition tableEntry = eNameDefinitions.next();
            tableEntry.writeNode(this.doc, namedExpressionsElement);
        }
        root.appendChild(namedExpressionsElement);
        Debug.log(4, "</NAMED-EXPRESSIONS>");
    }

    protected void processTable(Node root) throws IOException {
        Debug.log(4, "<TABLE>");
        Element tableElement = this.doc.createElement("table:table");
        String sheetName = this.decoder.getSheetName();
        tableElement.setAttribute("table:name", sheetName);
        tableElement.setAttribute("table:style-name", "Default");
        root.appendChild(tableElement);
        Debug.log(4, "<SheetName>" + sheetName + "</SheetName>");
        this.processColumns(tableElement);
        this.processCells(tableElement);
        Debug.log(4, "</TABLE>");
    }

    protected void processColumns(Node root) throws IOException {
        Iterator<ColumnRowInfo> e = this.decoder.getColumnRowInfos();
        while (e.hasNext()) {
            String styleName;
            ColumnRowInfo ci = e.next();
            if (!ci.isColumn()) continue;
            ColumnStyle cStyle = new ColumnStyle("Default", "table-column", "Default", ci.getSize(), null);
            Style[] result = this.styleCat.getMatching(cStyle);
            if (result.length == 0) {
                cStyle.setName("co" + this.colStyles++);
                styleName = cStyle.getName();
                Debug.log(4, "No existing style found, adding " + styleName);
                this.styleCat.add(cStyle);
            } else {
                ColumnStyle existingStyle = (ColumnStyle)result[0];
                styleName = existingStyle.getName();
                Debug.log(4, "Existing style found : " + styleName);
            }
            Element colElement = this.doc.createElement("table:table-column");
            colElement.setAttribute("table:style-name", styleName);
            if (ci.getRepeated() != 1) {
                String repeatStr = String.valueOf(ci.getRepeated());
                colElement.setAttribute("table:number-columns-repeated", repeatStr);
            }
            root.appendChild(colElement);
        }
    }

    protected void processCells(Node root) throws IOException {
        Element rowElement = null;
        Element cellElement = null;
        int row = 0;
        int col = 1;
        int lastColumn = this.decoder.getNumberOfColumns();
        Node autoStylesNode = null;
        while (this.decoder.goToNextCell()) {
            String styleName;
            CellStyle tStyle;
            Style[] result;
            int newCol;
            int newRow = this.decoder.getRowNumber();
            if (newRow != row) {
                int deltaRows;
                if (col <= lastColumn && rowElement != null) {
                    int numSkippedCells = lastColumn - col + 1;
                    this.addEmptyCells(numSkippedCells, rowElement);
                }
                if (row != 0) {
                    Debug.log(4, "</tr>");
                }
                if ((deltaRows = newRow - row) > 1) {
                    this.addEmptyRows(deltaRows - 1, root, lastColumn);
                }
                col = 1;
                rowElement = this.doc.createElement("table:table-row");
                Iterator<ColumnRowInfo> e = this.decoder.getColumnRowInfos();
                while (e.hasNext()) {
                    String styleName2;
                    ColumnRowInfo cri = e.next();
                    if (!cri.isRow() || cri.getRepeated() != newRow - 1) continue;
                    RowStyle rStyle = new RowStyle("Default", "table-row", "Default", cri.getSize(), null);
                    Style[] result2 = this.styleCat.getMatching(rStyle);
                    if (result2.length == 0) {
                        rStyle.setName("ro" + this.rowStyles++);
                        styleName2 = rStyle.getName();
                        Debug.log(4, "No existing style found, adding " + styleName2);
                        this.styleCat.add(rStyle);
                    } else {
                        RowStyle existingStyle = (RowStyle)result2[0];
                        styleName2 = existingStyle.getName();
                        Debug.log(4, "Existing style found : " + styleName2);
                    }
                    rowElement.setAttribute("table:style-name", styleName2);
                }
                root.appendChild(rowElement);
                row = newRow;
                Debug.log(4, "<tr>");
            }
            if ((newCol = this.decoder.getColNumber()) != col) {
                int numColsSkipped = newCol - col;
                this.addEmptyCells(numColsSkipped, rowElement);
                col = newCol;
            }
            Debug.log(4, "<td>");
            String cellContents = this.decoder.getCellContents();
            String cellType = this.decoder.getCellDataType();
            Format fmt = this.decoder.getCellFormat();
            cellElement = this.doc.createElement("table:table-cell");
            Node bodyNode = this.doc.getElementsByTagName("office:body").item(0);
            autoStylesNode = this.doc.getElementsByTagName("office:automatic-styles").item(0);
            if (autoStylesNode == null) {
                autoStylesNode = this.doc.createElement("office:automatic-styles");
                this.doc.insertBefore(autoStylesNode, bodyNode);
            }
            if ((result = this.styleCat.getMatching(tStyle = new CellStyle("Default", "table-cell", "Default", fmt, null))).length == 0) {
                tStyle.setName("ce" + this.textStyles++);
                styleName = tStyle.getName();
                Debug.log(4, "No existing style found, adding " + styleName);
                this.styleCat.add(tStyle);
            } else {
                CellStyle existingStyle = (CellStyle)result[0];
                styleName = existingStyle.getName();
                Debug.log(4, "Existing style found : " + styleName);
            }
            cellElement.setAttribute("table:style-name", styleName);
            this.processCellData(cellElement, cellType, cellContents);
            rowElement.appendChild(cellElement);
            Element textElement = this.doc.createElement("text:p");
            cellElement.appendChild(textElement);
            textElement.appendChild(this.doc.createTextNode(cellContents));
            Debug.log(4, cellContents);
            Debug.log(4, "</td>");
            ++col;
        }
        if (col <= lastColumn && rowElement != null) {
            int numSkippedCells = lastColumn - col + 1;
            this.addEmptyCells(numSkippedCells, rowElement);
        }
        if (autoStylesNode != null) {
            Debug.log(4, "Well the autostyle node was found!!!");
            NodeList nl = this.styleCat.writeNode(this.doc, "dummy").getChildNodes();
            int nlLen = nl.getLength();
            for (int i = 0; i < nlLen; ++i) {
                autoStylesNode.appendChild(nl.item(0));
            }
        }
        if (row != 0) {
            Debug.log(4, "</tr>");
        }
    }

    protected void addEmptyRows(int numEmptyRows, Node root, int numEmptyCells) {
        Element rowElement = this.doc.createElement("table:table-row");
        rowElement.setAttribute("table:style-name", "Default");
        rowElement.setAttribute("table:number-rows-repeated", Integer.toString(numEmptyRows));
        root.appendChild(rowElement);
        this.addEmptyCells(numEmptyCells, rowElement);
        for (int i = 0; i < numEmptyRows; ++i) {
            Debug.log(4, "<tr />");
        }
    }

    protected void addEmptyCells(int numColsSkipped, Node row) {
        Element cellElement = this.doc.createElement("table:table-cell");
        cellElement.setAttribute("table:style-name", "Default");
        if (numColsSkipped > 1) {
            cellElement.setAttribute("table:number-columns-repeated", Integer.toString(numColsSkipped));
        }
        row.appendChild(cellElement);
        for (int i = 0; i < numColsSkipped; ++i) {
            Debug.log(4, "<td />");
        }
    }

    protected void processCellData(Element cellElement, String type, String contents) {
        cellElement.setAttribute("table:value-type", type);
        if (contents.startsWith("=")) {
            cellElement.setAttribute("table:formula", contents);
            cellElement.setAttribute("table:value", this.decoder.getCellValue());
        } else if (!type.equals("string")) {
            if (type.equals("time")) {
                cellElement.setAttribute("table:time-value", contents);
            } else if (type.equals("date")) {
                cellElement.setAttribute("table:date-value", contents);
            } else if (type.equals("boolean")) {
                cellElement.setAttribute("table:boolean-value", contents.toLowerCase());
            } else if (type.equals("currency")) {
                cellElement.setAttribute("table:currency", "USD");
                cellElement.setAttribute("table:value", contents);
            } else if (type.equals("percentage")) {
                cellElement.setAttribute("table:value", contents);
            } else {
                cellElement.setAttribute("table:value", contents);
            }
        }
    }
}

