/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.util;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlUtil {
    public static Node deepClone(Node oldNode, Node newNode) {
        Document docNode = oldNode.getOwnerDocument();
        Node clonedNode = XmlUtil.cloneNode(docNode, newNode);
        XmlUtil.cloneTree(docNode, clonedNode, newNode);
        return clonedNode;
    }

    private static void cloneTree(Document docNode, Node oldNode, Node newNode) {
        NodeList nodeList = newNode.getChildNodes();
        int nodeListLen = nodeList.getLength();
        for (int i = 0; i < nodeListLen; ++i) {
            Node newClonedChild = XmlUtil.cloneNode(docNode, nodeList.item(i));
            if (newClonedChild == null) continue;
            oldNode.appendChild(newClonedChild);
            XmlUtil.cloneTree(docNode, newClonedChild, nodeList.item(i));
        }
    }

    private static Node cloneNode(Document docNode, Node newNode) {
        Node clonedNode = null;
        switch (newNode.getNodeType()) {
            case 3: {
                String textStr = newNode.getNodeValue();
                clonedNode = docNode.createTextNode(textStr);
                break;
            }
            case 1: {
                Element oldElem = (Element)newNode;
                String tagName = newNode.getNodeName();
                Element newElem = docNode.createElement(tagName);
                NamedNodeMap attrs = oldElem.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    newElem.setAttribute(attrs.item(i).getNodeName(), attrs.item(i).getNodeValue());
                }
                clonedNode = newElem;
            }
        }
        return clonedNode;
    }

    public static String getNodeInfo(Node node) {
        String str = null;
        switch (node.getNodeType()) {
            case 1: {
                str = "ELEMENT";
                break;
            }
            case 2: {
                str = "ATTRIBUTE";
                break;
            }
            case 3: {
                str = "TEXT";
                break;
            }
            case 4: {
                str = "CDATA_SECTION";
                break;
            }
            case 5: {
                str = "ENTITY_REFERENCE";
                break;
            }
            case 6: {
                str = "ENTITY";
                break;
            }
            case 7: {
                str = "PROCESSING_INSTRUCTION";
                break;
            }
            case 8: {
                str = "COMMENT";
                break;
            }
            case 9: {
                str = "DOCUMENT";
                break;
            }
            case 10: {
                str = "DOCUMENT_TYPE";
                break;
            }
            case 11: {
                str = "DOCUMENT_FRAGMENT";
                break;
            }
            case 12: {
                str = "NOTATION";
            }
        }
        StringBuffer buffer = new StringBuffer("name=\"");
        buffer.append(node.getNodeName());
        buffer.append("\"  type=\"");
        buffer.append(str);
        buffer.append("\"");
        return buffer.toString();
    }
}

