/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.report;

import com.sun.star.awt.Size;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.table.XTableColumns;
import com.sun.star.text.XRelativeTextContentRemove;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NumberFormatter;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.db.RecordParser;
import com.sun.star.wizards.document.FormHandler;
import com.sun.star.wizards.report.DBColumn;
import com.sun.star.wizards.report.RecordTable;
import com.sun.star.wizards.text.TextDocument;
import com.sun.star.wizards.text.TextFieldHandler;
import com.sun.star.wizards.text.TextSectionHandler;
import com.sun.star.wizards.text.TextStyleHandler;
import com.sun.star.wizards.text.TextTableHandler;
import com.sun.star.wizards.text.ViewHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReportTextDocument
extends TextDocument
implements Comparator<FieldColumn> {
    private static final String ISLANDSCAPE = "IsLandscape";
    private static final String ISVISIBLE = "IsVisible";
    private static final String QUERYNAME = "QueryName";
    private static final String SIZE = "Size";
    private Object ReportPageStyle;
    private Object FirstPageStyle;
    public ArrayList<DBColumn> DBColumnsVector;
    private RecordTable CurRecordTable;
    private String sMsgCommonReportError;
    private String ContentTemplatePath;
    private boolean bIsCurLandscape;
    public TextTableHandler oTextTableHandler;
    public TextSectionHandler oTextSectionHandler;
    public FormHandler oFormHandler;
    private TextStyleHandler oTextStyleHandler;
    public TextFieldHandler oTextFieldHandler;
    public ViewHandler oViewHandler;
    public static final String TBLRECORDSECTION = "Tbl_RecordSection";
    public static final String TBLGROUPSECTION = "Tbl_GroupField";
    public static final String RECORDSECTION = "RecordSection";
    public static final String GROUPSECTION = "GroupField";
    public static final String COPYOFTBLRECORDSECTION = "CopyOfTbl_RecordSection";
    public static final String COPYOFTBLGROUPSECTION = "CopyOfTbl_GroupField";
    public static final String COPYOFRECORDSECTION = "CopyOfRecordSection";
    public static final String COPYOFGROUPSECTION = "CopyOfGroupField";
    private RecordParser CurDBMetaData;

    public ReportTextDocument(XMultiServiceFactory xMSF, XTextDocument _textDocument, Resource oResource, RecordParser _aRP) {
        super(xMSF, _textDocument, false);
        this.lateInit(oResource, _aRP);
    }

    public ReportTextDocument(XMultiServiceFactory xMSF, String _sPreviewURL, Resource oResource, RecordParser _aRP) {
        super(xMSF, _sPreviewURL, true, null);
        this.lateInit(oResource, _aRP);
    }

    private void lateInit(Resource oResource, RecordParser _aRecordParser) {
        this.oTextTableHandler = new TextTableHandler(this.xTextDocument);
        this.oTextSectionHandler = new TextSectionHandler(this.xMSFDoc, this.xTextDocument);
        this.oFormHandler = new FormHandler(this.xMSFDoc, this.xTextDocument);
        this.oTextStyleHandler = new TextStyleHandler(this.xTextDocument);
        this.oViewHandler = new ViewHandler(this.xTextDocument);
        this.oTextFieldHandler = new TextFieldHandler(this.xMSFDoc, this.xTextDocument);
        this.DBColumnsVector = new ArrayList();
        NumberFormatter oNumberFormatter = this.oTextTableHandler.getNumberFormatter();
        this.CurDBMetaData = _aRecordParser;
        long lDateCorrection = oNumberFormatter.getNullDateCorrection();
        oNumberFormatter.setBooleanReportDisplayNumberFormat();
        oNumberFormatter.setNullDateCorrection(lDateCorrection);
        String sMsgTableNotExisting = oResource.getResText(2461);
        this.sMsgCommonReportError = oResource.getResText(2472);
        this.sMsgCommonReportError = JavaTools.replaceSubString(this.sMsgCommonReportError, String.valueOf('\r'), "<BR>");
        String sMsgEndAutopilot = oResource.getResText(1033);
        sMsgTableNotExisting = sMsgTableNotExisting + '\r' + sMsgEndAutopilot;
        this.bIsCurLandscape = true;
        this.getReportPageStyles();
    }

    public void swapContentTemplate(String ContentTemplatePath) {
        this.ContentTemplatePath = ContentTemplatePath;
        this.loadSectionsfromTemplate(ContentTemplatePath);
        this.oTextStyleHandler.loadStyleTemplates(ContentTemplatePath, "LoadTextStyles");
        if (this.CurRecordTable != null) {
            this.CurRecordTable.adjustOptimalTableWidths(this.xMSF, this.oViewHandler);
        }
        this.oViewHandler.selectFirstPage(this.oTextTableHandler);
    }

    public void swapLayoutTemplate(String LayoutTemplatePath) {
        try {
            boolean bOldIsCurLandscape = AnyConverter.toBoolean((Object)Helper.getUnoPropertyValue(this.ReportPageStyle, ISLANDSCAPE));
            this.oTextStyleHandler.loadStyleTemplates(LayoutTemplatePath, "LoadPageStyles");
            this.changePageOrientation(bOldIsCurLandscape);
            this.oViewHandler.selectFirstPage(this.oTextTableHandler);
        }
        catch (IllegalArgumentException e) {
            Logger.getLogger(ReportTextDocument.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void createReportForm(String SOREPORTFORMNAME) {
        XNameContainer xNamedForm = this.oFormHandler.insertFormbyName(SOREPORTFORMNAME);
        XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xNamedForm);
        this.oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, PropertyNames.COMMAND_TYPE, Integer.toString(this.CurDBMetaData.getCommandType()));
        this.oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, QUERYNAME, this.CurDBMetaData.getCommandName());
        if (this.CurDBMetaData.getCommandType() == 1) {
            this.oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, PropertyNames.COMMAND, "");
        } else {
            this.oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, PropertyNames.COMMAND, this.CurDBMetaData.Command);
        }
        this.oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, "GroupFieldNames", JavaTools.ArraytoString(this.CurDBMetaData.GroupFieldNames));
        this.oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, "FieldNames", JavaTools.ArraytoString(this.CurDBMetaData.getFieldNames()));
        String[][] sortFieldNames = this.CurDBMetaData.getSortFieldNames();
        if (sortFieldNames != null && sortFieldNames.length > 0) {
            String space = ",";
            String colon = ";";
            StringBuilder orderBy = new StringBuilder();
            for (String[] sortPair : sortFieldNames) {
                orderBy.append(sortPair[0]).append(",").append(sortPair[1]).append(";");
            }
            if (orderBy.length() != 0) {
                orderBy.delete(orderBy.lastIndexOf(";"), orderBy.length());
            }
            this.oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, "Sorting", orderBy.toString());
        } else {
            this.oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, "Sorting", "");
        }
        this.oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, "RecordFieldNames", JavaTools.ArraytoString(this.CurDBMetaData.getRecordFieldNames()));
    }

    private void getReportPageStyles() {
        try {
            Object oPageStyleFamily = this.oTextStyleHandler.xStyleFamiliesSupplier.getStyleFamilies().getByName("PageStyles");
            this.ReportPageStyle = Helper.getUnoObjectbyName(oPageStyleFamily, "Standard");
            this.FirstPageStyle = Helper.getUnoObjectbyName(oPageStyleFamily, "First Page");
        }
        catch (Exception e) {
            Logger.getLogger(ReportTextDocument.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void changePageOrientation(boolean bNewLandscape) {
        try {
            this.getReportPageStyles();
            Size oLocSize = (Size)Helper.getUnoStructValue(this.ReportPageStyle, SIZE);
            this.bIsCurLandscape = AnyConverter.toBoolean((Object)Helper.getUnoPropertyValue(this.ReportPageStyle, ISLANDSCAPE));
            if (this.bIsCurLandscape != bNewLandscape) {
                Size oNewSize = new Size(oLocSize.Height, oLocSize.Width);
                Helper.setUnoPropertyValue(this.ReportPageStyle, ISLANDSCAPE, bNewLandscape);
                Helper.setUnoPropertyValue(this.ReportPageStyle, SIZE, oNewSize);
                Helper.setUnoPropertyValue(this.FirstPageStyle, ISLANDSCAPE, bNewLandscape);
                Helper.setUnoPropertyValue(this.FirstPageStyle, SIZE, oNewSize);
                AnyConverter.toInt((Object)Helper.getUnoPropertyValue(this.ReportPageStyle, "LeftMargin"));
                AnyConverter.toInt((Object)Helper.getUnoPropertyValue(this.ReportPageStyle, "RightMargin"));
                if (this.CurRecordTable != null) {
                    this.CurRecordTable.adjustOptimalTableWidths(this.xMSF, this.oViewHandler);
                }
            }
        }
        catch (IllegalArgumentException e) {
            Logger.getLogger(ReportTextDocument.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private boolean loadSectionsfromTemplate(String sTemplateUrl) {
        try {
            int i;
            int GroupCount = this.CurDBMetaData.GroupFieldNames.length;
            this.CurRecordTable = null;
            for (i = 0; i < GroupCount; ++i) {
                String SectionName = GROUPSECTION + Integer.toString(i + 1);
                this.oTextTableHandler.renameTextTable("Tbl_" + SectionName, "MyTextTable");
                this.oTextSectionHandler.linkSectiontoTemplate(sTemplateUrl, SectionName);
                this.oTextTableHandler.renameTextTable("MyTextTable", "Tbl_" + SectionName);
            }
            if (this.oTextSectionHandler.xTextSectionsSupplier.getTextSections().getElementNames().length > this.CurDBMetaData.GroupFieldNames.length) {
                this.oTextSectionHandler.linkSectiontoTemplate(sTemplateUrl, RECORDSECTION);
                this.CurRecordTable = new RecordTable(this.oTextTableHandler);
                this.insertColumnstoRecordTable();
            }
            for (i = 0; i < GroupCount; ++i) {
                DBColumn CurDBColumn = new DBColumn(this.oTextTableHandler, this.CurDBMetaData, this.CurDBMetaData.GroupFieldNames[i], TBLGROUPSECTION + (i + 1));
                CurDBColumn.formatValueCell();
                this.DBColumnsVector.set(i, CurDBColumn);
                this.replaceFieldValueInGroupTable(CurDBColumn, i);
            }
            return true;
        }
        catch (Exception e) {
            Logger.getLogger(ReportTextDocument.class.getName()).log(Level.SEVERE, null, e);
            return false;
        }
    }

    public void setupRecordSection(String TemplateName) {
        this.ContentTemplatePath = TemplateName;
        if (this.CurDBMetaData.getRecordFieldNames().length > 0) {
            boolean bAddParagraph = true;
            if (this.CurDBMetaData.GroupFieldNames != null) {
                bAddParagraph = this.CurDBMetaData.GroupFieldNames.length == 0;
            }
            this.oTextSectionHandler.insertTextSection(RECORDSECTION, TemplateName, bAddParagraph);
            this.CurRecordTable = new RecordTable(this.oTextTableHandler);
            this.insertColumnstoRecordTable();
            if (this.CurRecordTable != null) {
                this.CurRecordTable.adjustOptimalTableWidths(this.xMSF, this.oViewHandler);
            }
        } else {
            this.CurRecordTable = null;
        }
    }

    public void refreshGroupFields(String[] _sNewNames) {
        int nSize = this.DBColumnsVector.size();
        for (int i = 0; i < nSize; ++i) {
            DBColumn CurDBColumn = this.DBColumnsVector.get(i);
            String sFieldName = CurDBColumn.CurDBField.getFieldName();
            if (sFieldName.equals(_sNewNames[i])) continue;
            CurDBColumn.CurDBField = this.CurDBMetaData.getFieldColumnByDisplayName(_sNewNames[i]);
            CurDBColumn.insertColumnData(this.oTextFieldHandler, this.bIsCurLandscape);
        }
    }

    private void updateTextSections(String[] SelGroupNames) {
        int GroupFieldCount = SelGroupNames.length;
        for (int i = 0; i < GroupFieldCount; ++i) {
            String TableName = TBLGROUPSECTION + Integer.toString(i + 1);
            DBColumn OldDBColumn = this.DBColumnsVector.get(i);
            DBColumn CurDBColumn = new DBColumn(this.oTextTableHandler, this.CurDBMetaData, SelGroupNames[i], TableName, OldDBColumn);
            CurDBColumn.formatValueCell();
            this.DBColumnsVector.set(i, CurDBColumn);
            CurDBColumn.insertColumnData(this.oTextFieldHandler, this.bIsCurLandscape);
        }
    }

    private void replaceFieldValueInGroupTable(DBColumn CurDBColumn, int TableIndex) {
        String TableName = TBLGROUPSECTION + (TableIndex + 1);
        String OldTableName = CurDBColumn.xTableName.getName();
        if (OldTableName.compareTo(TableName) != 0) {
            CurDBColumn.xTableName.setName(TableName);
        }
        CurDBColumn.insertColumnData(this.oTextFieldHandler, this.bIsCurLandscape);
        CurDBColumn.setCellFont();
    }

    private void insertColumnstoRecordTable() {
        int RecordCount;
        XTableColumns xColumns;
        int ColCount;
        int GroupCount = this.CurDBMetaData.GroupFieldNames.length;
        String OldTableName = this.CurRecordTable.xTableName.getName();
        if (OldTableName.compareTo(TBLRECORDSECTION) != 0) {
            this.CurRecordTable = new RecordTable(this.oTextTableHandler);
        }
        if ((ColCount = (xColumns = this.CurRecordTable.xTextTable.getColumns()).getCount()) > (RecordCount = this.CurDBMetaData.getRecordFieldNames().length)) {
            int RemoveCount = ColCount - RecordCount;
            xColumns.removeByIndex(0, RemoveCount);
        } else if (ColCount < RecordCount) {
            int AddCount = RecordCount - ColCount;
            this.CurRecordTable.xTextTable.getColumns().insertByIndex(ColCount, AddCount);
        }
        for (int i = 0; i < RecordCount; ++i) {
            DBColumn CurDBColumn = new DBColumn(this.CurRecordTable, this.oTextTableHandler, this.CurDBMetaData, i, true);
            CurDBColumn.initializeNumberFormat();
            CurDBColumn.insertColumnData(this.oTextFieldHandler, this.bIsCurLandscape);
            if (this.DBColumnsVector.size() <= i + GroupCount) {
                this.DBColumnsVector.add(CurDBColumn);
                continue;
            }
            this.DBColumnsVector.set(i + GroupCount, CurDBColumn);
        }
    }

    public boolean addGroupNametoDocument(String CurGroupTitle, ArrayList<String> GroupFieldVector, ArrayList<String> ReportPath, int iSelCount) {
        DBColumn CurDBColumn = null;
        int GroupCount = GroupFieldVector.size();
        if (GroupCount < 4) {
            this.removeGroupNamesofRecordTable(iSelCount);
            FieldColumn CurFieldColumn = this.CurDBMetaData.getFieldColumnByTitle(CurGroupTitle);
            GroupFieldVector.add(CurFieldColumn.getFieldName());
            ++GroupCount;
            try {
                String sPath = FileAccess.getPathFromList(this.xMSF, ReportPath, "cnt-default.ott");
                this.oTextSectionHandler.insertTextSection(GROUPSECTION + GroupCount, sPath, GroupCount == 1);
                CurDBColumn = new DBColumn(this.oTextTableHandler, this.CurDBMetaData, CurFieldColumn.getFieldName(), TBLGROUPSECTION + GroupCount);
                CurDBColumn.formatValueCell();
                this.DBColumnsVector.add(CurDBColumn);
                this.replaceFieldValueInGroupTable(CurDBColumn, GroupCount - 1);
            }
            catch (Exception exception) {
                this.showCommonReportErrorBox(exception);
            }
        }
        return CurDBColumn != null;
    }

    public void removeGroupName(String[] NewSelGroupNames, String CurGroupTitle, ArrayList<String> GroupFieldVector) {
        this.removeGroupNamesofRecordTable(NewSelGroupNames.length + 1);
        FieldColumn CurFieldColumn = this.CurDBMetaData.getFieldColumnByTitle(CurGroupTitle);
        GroupFieldVector.remove(CurFieldColumn.getFieldName());
        this.oTextSectionHandler.removeLastTextSection();
        this.oTextTableHandler.removeLastTextTable();
        if (JavaTools.FieldInList(NewSelGroupNames, CurGroupTitle) == -1) {
            this.updateTextSections(NewSelGroupNames);
        }
        int iSelItemCount = NewSelGroupNames.length;
        this.DBColumnsVector.remove(iSelItemCount);
    }

    private void removeGroupNamesofRecordTable(int GroupFieldCount) {
        int CurFieldCount = this.DBColumnsVector.size();
        if (CurFieldCount > GroupFieldCount) {
            for (int i = CurFieldCount - 1; i >= GroupFieldCount; --i) {
                this.DBColumnsVector.remove(i);
            }
        }
    }

    private void showCommonReportErrorBox(Exception exception) {
        String SystemContentPath = JavaTools.convertfromURLNotation(this.ContentTemplatePath);
        String sMsgCurCommonReportError = JavaTools.replaceSubString(this.sMsgCommonReportError, SystemContentPath, "%PATH");
        this.CurDBMetaData.showMessageBox("ErrorBox", 0x400000, sMsgCurCommonReportError);
        exception.printStackTrace(System.err);
    }

    public void getallDBColumns() {
        try {
            for (int i = 0; i < this.CurDBMetaData.FieldColumns.length; ++i) {
                String DelFieldName;
                DBColumn CurDBColumn;
                if (i < this.CurDBMetaData.GroupFieldNames.length) {
                    CurDBColumn = new DBColumn(this.oTextTableHandler, this.CurDBMetaData, this.CurDBMetaData.GroupFieldNames[i], COPYOFTBLGROUPSECTION + (i + 1));
                } else {
                    if (this.CurRecordTable == null) {
                        this.CurRecordTable = new RecordTable(this.oTextTableHandler);
                    }
                    CurDBColumn = new DBColumn(this.CurRecordTable, this.oTextTableHandler, this.CurDBMetaData, i - this.CurDBMetaData.GroupFieldNames.length);
                }
                if (CurDBColumn.xNameCell != null) {
                    this.DBColumnsVector.add(CurDBColumn);
                    continue;
                }
                if (i < this.CurDBMetaData.GroupFieldNames.length) {
                    DelFieldName = this.CurDBMetaData.GroupFieldNames[i];
                    this.CurDBMetaData.GroupFieldNames = JavaTools.removefromList(this.CurDBMetaData.GroupFieldNames, new String[]{DelFieldName});
                    this.CurDBMetaData.GroupFieldColumns = ReportTextDocument.removeFieldColumnByFieldName(DelFieldName, this.CurDBMetaData.GroupFieldColumns);
                } else {
                    DelFieldName = this.CurDBMetaData.getRecordFieldName(i - this.CurDBMetaData.GroupFieldNames.length);
                    String[] aNewList = JavaTools.removefromList(this.CurDBMetaData.getRecordFieldNames(), new String[]{DelFieldName});
                    this.CurDBMetaData.setRecordFieldNames(aNewList);
                    this.CurDBMetaData.RecordFieldColumns = ReportTextDocument.removeFieldColumnByFieldName(DelFieldName, this.CurDBMetaData.RecordFieldColumns);
                    this.CurDBMetaData.FieldColumns = ReportTextDocument.removeFieldColumnByFieldName(DelFieldName, this.CurDBMetaData.FieldColumns);
                }
                --i;
            }
            Arrays.sort(this.CurDBMetaData.RecordFieldColumns, this);
        }
        catch (Exception exception) {
            this.showCommonReportErrorBox(exception);
        }
    }

    @Override
    public int compare(FieldColumn oFieldColumn1, FieldColumn oFieldColumn2) {
        DBColumn oDBColumn1 = this.getDBColumnByName(oFieldColumn1.getFieldName());
        DBColumn oDBColumn2 = this.getDBColumnByName(oFieldColumn2.getFieldName());
        if (oDBColumn1.ValColumn < oDBColumn2.ValColumn) {
            return -1;
        }
        if (oDBColumn1.ValColumn == oDBColumn2.ValColumn) {
            return 0;
        }
        return 1;
    }

    private DBColumn getDBColumnByName(String _FieldName) {
        for (int i = 0; i < this.DBColumnsVector.size(); ++i) {
            DBColumn oDBColumn = this.DBColumnsVector.get(i);
            if (!oDBColumn.CurDBField.getFieldName().equals(_FieldName)) continue;
            return oDBColumn;
        }
        return null;
    }

    private static FieldColumn[] removeFieldColumnByFieldName(String _FieldName, FieldColumn[] _FieldColumns) {
        try {
            ArrayList<FieldColumn> aFieldColumns = new ArrayList<FieldColumn>();
            for (int i = 0; i < _FieldColumns.length; ++i) {
                FieldColumn CurFieldColumn = _FieldColumns[i];
                if (CurFieldColumn.getFieldName().equals(_FieldName)) continue;
                aFieldColumns.add(CurFieldColumn);
            }
            FieldColumn[] aRetList = new FieldColumn[aFieldColumns.size()];
            aFieldColumns.toArray(aRetList);
            return aRetList;
        }
        catch (RuntimeException e) {
            Logger.getLogger(ReportTextDocument.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
    }

    public void removeAllVisibleTextSections() {
        int GroupCount = this.CurDBMetaData.GroupFieldNames.length;
        String[] sInvisibleSectionNames = new String[GroupCount + 1];
        sInvisibleSectionNames[0] = RECORDSECTION;
        for (int i = 1; i <= GroupCount; ++i) {
            sInvisibleSectionNames[i] = GROUPSECTION + i;
        }
        XNameAccess xNameAccessTextSections = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)this.oTextSectionHandler.xTextSectionsSupplier.getTextSections());
        String[] sSectionNames = xNameAccessTextSections.getElementNames();
        for (int i = 0; i < sSectionNames.length; ++i) {
            String sSectionName = sSectionNames[i];
            if (JavaTools.FieldInList(sInvisibleSectionNames, sSectionName) >= 0) continue;
            this.oTextSectionHandler.removeTextSectionbyName(sSectionName);
        }
    }

    private String[] getLayoutTextTableNames() {
        int GroupCount = this.CurDBMetaData.GroupFieldNames.length;
        String[] sLayoutTableNames = new String[GroupCount + 1];
        for (int i = 0; i < GroupCount; ++i) {
            sLayoutTableNames[i] = TBLGROUPSECTION + (i + 1);
        }
        sLayoutTableNames[GroupCount] = TBLRECORDSECTION;
        return sLayoutTableNames;
    }

    public void removeNonLayoutTextTables() {
        String[] sLayoutTableNames = this.getLayoutTextTableNames();
        XNameAccess xNameAccessTextTables = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)this.oTextTableHandler.xTextTablesSupplier.getTextTables());
        String[] sTableNames = xNameAccessTextTables.getElementNames();
        for (int i = 0; i < sTableNames.length; ++i) {
            String sTableName = sTableNames[i];
            if (JavaTools.FieldInList(sLayoutTableNames, sTableName) >= 0) continue;
            this.oTextTableHandler.removeTextTablebyName(sTableName);
        }
    }

    public void removeLayoutTextTables() {
        String[] sLayoutTableNames = this.getLayoutTextTableNames();
        XNameAccess xNameAccessTextTables = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)this.oTextTableHandler.xTextTablesSupplier.getTextTables());
        XRelativeTextContentRemove xRelativeTextContentRemove = (XRelativeTextContentRemove)UnoRuntime.queryInterface(XRelativeTextContentRemove.class, (Object)this.xText);
        String[] sTableNames = xNameAccessTextTables.getElementNames();
        for (int i = 0; i < sTableNames.length; ++i) {
            String sTableName = sTableNames[i];
            if (JavaTools.FieldInList(sLayoutTableNames, sTableName) <= -1) continue;
            if (!sTableName.equals(sLayoutTableNames[0])) {
                XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)this.oTextTableHandler.getByName(sTableName));
                boolean bleaveloop = false;
                while (!bleaveloop) {
                    try {
                        xRelativeTextContentRemove.removeTextContentAfter(xTextContent);
                    }
                    catch (IllegalArgumentException iexception) {
                        bleaveloop = true;
                    }
                }
            }
            this.oTextTableHandler.removeTextTablebyName(sTableName);
        }
    }

    public void setLayoutSectionsVisible(boolean _IsVisible) {
        try {
            Object oTextSection;
            XNameAccess xTextSections = this.oTextSectionHandler.xTextSectionsSupplier.getTextSections();
            int GroupFieldCount = this.CurDBMetaData.GroupFieldNames.length;
            for (int i = 0; i < GroupFieldCount; ++i) {
                oTextSection = xTextSections.getByName(GROUPSECTION + String.valueOf(i + 1));
                Helper.setUnoPropertyValue(oTextSection, ISVISIBLE, _IsVisible);
            }
            if (xTextSections.hasByName(RECORDSECTION)) {
                oTextSection = xTextSections.getByName(RECORDSECTION);
                Helper.setUnoPropertyValue(oTextSection, ISVISIBLE, _IsVisible);
            }
        }
        catch (Exception e) {
            Logger.getLogger(ReportTextDocument.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void removeCopiedTextSections() {
        int i;
        int GroupCount = this.CurDBMetaData.GroupFieldNames.length;
        String[] sCopyTextSections = new String[GroupCount + 1];
        String[] sCopyTextTables = new String[GroupCount + 1];
        sCopyTextSections[0] = COPYOFRECORDSECTION;
        sCopyTextTables[0] = COPYOFTBLRECORDSECTION;
        for (i = 1; i <= GroupCount; ++i) {
            sCopyTextSections[i] = COPYOFGROUPSECTION + i;
            sCopyTextTables[i] = COPYOFTBLGROUPSECTION + i;
        }
        for (i = 0; i <= GroupCount; ++i) {
            this.oTextTableHandler.removeTextTablebyName(sCopyTextTables[i]);
            this.oTextSectionHandler.removeTextSectionbyName(sCopyTextSections[i]);
        }
    }
}

