/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.debug.shell.client;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.debug.shell.REPLClient;
import com.oracle.truffle.tools.debug.shell.REPLMessage;
import com.oracle.truffle.tools.debug.shell.client.REPLClientContext;
import com.oracle.truffle.tools.debug.shell.client.REPLCommand;
import com.oracle.truffle.tools.debug.shell.client.REPLContinueException;
import com.oracle.truffle.tools.debug.shell.client.REPLFrame;
import com.oracle.truffle.tools.debug.shell.client.REPLRemoteCommand;
import com.oracle.truffle.tools.debug.shell.server.REPLServer;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import jline.console.ConsoleReader;

public class SimpleREPLClient
implements REPLClient {
    private static final String REPLY_PREFIX = "==> ";
    private static final String FAIL_PREFIX = "**> ";
    private static final String WARNING_PREFIX = "!!> ";
    private static final String TRACE_PREFIX = ">>> ";
    private static final String[] NULL_ARGS = new String[0];
    static final String INFO_LINE_FORMAT = "    %s\n";
    static final String CODE_LINE_FORMAT = "    %3d  %s\n";
    static final String CODE_LINE_BREAK_FORMAT = "--> %3d  %s\n";
    private static final String STACK_FRAME_FORMAT = "    %3d: at %s in %s    %s\n";
    private static final String STACK_FRAME_SELECTED_FORMAT = "==> %3d: at %s in %s    %s\n";
    private final Map<String, REPLCommand> commandMap = new HashMap<String, REPLCommand>();
    private final Collection<String> commandNames = new TreeSet<String>();
    private final Map<String, LocalOption> localOptions = new HashMap<String, LocalOption>();
    private final Collection<String> optionNames = new TreeSet<String>();
    ClientContextImpl clientContext;
    private final ConsoleReader reader;
    private final PrintStream writer;
    private REPLServer replServer;
    private final LocalOption astDepthOption = new IntegerOption(9, "astdepth", "default depth for AST display");
    private final LocalOption autoWhereOption = new BooleanOption(true, "autowhere", "run the \"where\" command after each navigation");
    private final LocalOption autoNodeOption = new BooleanOption(false, "autonode", "run the \"truffle node\" command after each navigation");
    private final LocalOption autoSubtreeOption = new BooleanOption(false, "autosubtree", "run the \"truffle subtree\" command after each navigation");
    private final LocalOption autoASTOption = new BooleanOption(false, "autoast", "run the \"truffle ast\" command after each navigation");
    private final LocalOption listSizeOption = new IntegerOption(25, "listsize", "default number of lines to list");
    private final LocalOption traceMessagesOption = new BooleanOption(false, "tracemessages", "trace REPL messages between client and server");
    private final LocalOption verboseBreakpointInfoOption = new BooleanOption(true, "verbosebreakpointinfo", "\"info breakpoint\" displays more info");
    private Source selectedSource = null;
    private boolean quitting;
    private final REPLCommand backtraceCommand = new REPLLocalCommand("backtrace", "bt", "Display current stack"){

        @Override
        void execute(String[] args) {
            if (SimpleREPLClient.this.clientContext.level == 0) {
                SimpleREPLClient.this.clientContext.displayFailReply("no active execution");
            } else {
                SimpleREPLClient.this.clientContext.displayStack();
            }
        }
    };
    private final REPLCommand fileCommand = new REPLRemoteCommand("file", null, "Set/display current file for viewing"){
        final String[] help;
        {
            this.help = new String[]{"file:  display current file path", "file <filename>: Set file to be current file for viewing"};
        }

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            if (args.length == 1) {
                Source source = SimpleREPLClient.this.clientContext.getSelectedSource();
                if (source == null) {
                    SimpleREPLClient.this.clientContext.displayFailReply("no file currently selected");
                } else {
                    SimpleREPLClient.this.clientContext.displayReply(source.getPath());
                }
                return null;
            }
            REPLMessage request = new REPLMessage();
            request.put("op", "file");
            request.put("source-name", args[1]);
            return request;
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            REPLMessage firstReply = replies[0];
            if (firstReply.get("status").equals("failed")) {
                String result = firstReply.get("displayable-message");
                SimpleREPLClient.this.clientContext.displayFailReply(result != null ? result : firstReply.toString());
                return;
            }
            String fileName = firstReply.get("source-name");
            String path = firstReply.get("path");
            SimpleREPLClient.this.clientContext.selectSource(path == null ? fileName : path);
            SimpleREPLClient.this.clientContext.displayReply(SimpleREPLClient.this.clientContext.getSelectedSource().getPath());
            for (int i = 1; i < replies.length; ++i) {
                REPLMessage reply = replies[i];
                String result = reply.get("displayable-message");
                SimpleREPLClient.this.clientContext.displayInfo(result != null ? result : reply.toString());
            }
        }
    };
    private final REPLCommand helpCommand = new REPLLocalCommand("help", null, "Describe commands"){
        final String[] help;
        {
            this.help = new String[]{"help:  list available commands", "help <command>: additional information about <command>"};
        }

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public void execute(String[] args) {
            if (args.length == 1) {
                SimpleREPLClient.this.clientContext.displayReply("Available commands:");
                for (String commandName : SimpleREPLClient.this.commandNames) {
                    REPLCommand command = (REPLCommand)SimpleREPLClient.this.commandMap.get(commandName);
                    if (command == null) {
                        SimpleREPLClient.this.clientContext.displayInfo(commandName + ": Error, no implementation for command");
                        continue;
                    }
                    String abbrev = command.getAbbreviation();
                    if (abbrev == null) {
                        SimpleREPLClient.this.clientContext.displayInfo(commandName + ": " + command.getDescription());
                        continue;
                    }
                    SimpleREPLClient.this.clientContext.displayInfo(commandName + "(" + abbrev + "): " + command.getDescription());
                }
            } else {
                String cmdName = args[1];
                REPLCommand cmd = (REPLCommand)SimpleREPLClient.this.commandMap.get(cmdName);
                if (cmd == null) {
                    SimpleREPLClient.this.clientContext.displayReply("command \"" + cmdName + "\" not recognized");
                } else {
                    String[] helpLines = cmd.getHelp();
                    if (helpLines == null) {
                        SimpleREPLClient.this.clientContext.displayReply("\"" + cmdName + "\":");
                    } else if (helpLines.length == 1) {
                        SimpleREPLClient.this.clientContext.displayInfo(helpLines[0]);
                    } else {
                        SimpleREPLClient.this.clientContext.displayReply("\"" + cmdName + "\":");
                        for (String line : helpLines) {
                            SimpleREPLClient.this.clientContext.displayInfo(line);
                        }
                    }
                }
            }
        }
    };
    private final REPLIndirectCommand infoCommand = new REPLIndirectCommand("info", null, "Additional information on topics"){
        private final Map<String, REPLCommand> infoCommandMap;
        private final Collection<String> infoCommandNames;
        {
            this.infoCommandMap = new HashMap<String, REPLCommand>();
            this.infoCommandNames = new TreeSet<String>();
        }

        @Override
        public String[] getHelp() {
            ArrayList<String> lines = new ArrayList<String>();
            for (String infoCommandName : this.infoCommandNames) {
                REPLCommand cmd = this.infoCommandMap.get(infoCommandName);
                if (cmd == null) {
                    lines.add("\"info " + infoCommandName + "\" not implemented");
                    continue;
                }
                lines.add("\"info " + infoCommandName + "\": " + cmd.getDescription());
            }
            return lines.toArray(new String[0]);
        }

        @Override
        void addCommand(REPLCommand replCommand) {
            String commandName = replCommand.getCommand();
            String abbreviation = replCommand.getAbbreviation();
            this.infoCommandNames.add(commandName);
            this.infoCommandMap.put(commandName, replCommand);
            if (abbreviation != null) {
                this.infoCommandMap.put(abbreviation, replCommand);
            }
        }

        @Override
        REPLCommand getCommand(String[] args) {
            if (args.length == 1) {
                SimpleREPLClient.this.clientContext.displayFailReply("info topic not specified; try \"help info\"");
                return null;
            }
            String topic = args[1];
            REPLCommand command = this.infoCommandMap.get(topic);
            if (command == null) {
                SimpleREPLClient.this.clientContext.displayFailReply("topic \"" + topic + "\" not recognized");
                return null;
            }
            return command;
        }
    };
    private final REPLCommand infoBreakCommand = new REPLRemoteCommand("breakpoint", "break", "info about breakpoints"){

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            REPLMessage request = new REPLMessage();
            request.put("op", "breakpoint-info");
            return request;
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            if (replies[0].get("status").equals("failed")) {
                SimpleREPLClient.this.clientContext.displayFailReply(replies[0].get("displayable-message"));
            } else {
                Arrays.sort(replies, new Comparator<REPLMessage>(){

                    @Override
                    public int compare(REPLMessage o1, REPLMessage o2) {
                        try {
                            int n1 = Integer.parseInt(o1.get("breakpoint-id"));
                            int n2 = Integer.parseInt(o2.get("breakpoint-id"));
                            return Integer.compare(n1, n2);
                        }
                        catch (Exception exception) {
                            return 0;
                        }
                    }
                });
                SimpleREPLClient.this.clientContext.displayReply("Breakpoints set:");
                for (REPLMessage message : replies) {
                    String condition;
                    StringBuilder sb = new StringBuilder();
                    sb.append(Integer.parseInt(message.get("breakpoint-id")) + ": ");
                    sb.append("@" + message.get("info-value"));
                    sb.append(" (state=" + message.get("breakpoint-state"));
                    if (SimpleREPLClient.this.verboseBreakpointInfoOption.getBool()) {
                        sb.append(", hits=" + Integer.parseInt(message.get("breakpoint-hit-count")));
                        sb.append(", ignore=" + Integer.parseInt(message.get("breakpoint-ignore-count")));
                    }
                    if ((condition = message.get("breakpoint-condition")) != null) {
                        sb.append(", condition=\"" + condition + "\"");
                    }
                    sb.append(")");
                    SimpleREPLClient.this.clientContext.displayInfo(sb.toString());
                }
            }
        }
    };
    private final REPLRemoteCommand infoLanguageCommand = new REPLRemoteCommand("languages", "lang", "languages supported"){
        final String[] help;
        {
            this.help = new String[]{"info language:  list details about supported languages"};
        }

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            REPLMessage request = new REPLMessage();
            request.put("op", "info");
            request.put("topic", "info-supported-languages");
            return request;
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            if (replies[0].get("status").equals("failed")) {
                SimpleREPLClient.this.clientContext.displayFailReply(replies[0].get("displayable-message"));
            } else {
                SimpleREPLClient.this.clientContext.displayReply("Languages supported:");
                SimpleREPLClient.this.displayLanguages(replies);
            }
        }
    };
    private final REPLCommand infoSetCommand = new REPLLocalCommand("set", null, "info about settings"){
        final String[] help;
        {
            this.help = new String[]{"info sets:  list local options that can be set"};
        }

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public void execute(String[] args) {
            SimpleREPLClient.this.clientContext.displayReply("Settable options:");
            for (String optionName : SimpleREPLClient.this.optionNames) {
                LocalOption localOption = (LocalOption)SimpleREPLClient.this.localOptions.get(optionName);
                if (localOption == null) {
                    SimpleREPLClient.this.clientContext.displayInfo(localOption + ": Error, no implementation for option");
                    continue;
                }
                SimpleREPLClient.this.clientContext.displayInfo(optionName + "=" + localOption.getValue() + ": " + localOption.getDescription());
            }
        }
    };
    private final REPLCommand listCommand = new REPLLocalCommand("list", null, "Display selected source file"){
        final String[] help;
        private Source lastListedSource;
        private int nextLineToList;
        {
            this.help = new String[]{"list:  list <listsize> lines of selected file (see option \"listsize\")", "list all: list all lines", "list <n>: list <listsize> lines centered around line <n>"};
            this.lastListedSource = null;
            this.nextLineToList = 1;
        }

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public void execute(String[] args) {
            Source source = SimpleREPLClient.this.clientContext.getSelectedSource();
            if (source == null) {
                SimpleREPLClient.this.clientContext.displayFailReply("No selected file");
                this.reset();
                return;
            }
            int listSize = SimpleREPLClient.this.listSizeOption.getInt();
            if (args.length == 1) {
                if (!source.equals(this.lastListedSource)) {
                    this.reset();
                } else if (this.nextLineToList > source.getLineCount()) {
                    this.reset();
                }
                int lastListedLine = this.printLines(source, this.nextLineToList, listSize);
                this.lastListedSource = source;
                this.nextLineToList = lastListedLine > source.getLineCount() ? 1 : lastListedLine + 1;
            } else if (args.length == 2) {
                this.reset();
                if (args[1].equals("all")) {
                    this.printLines(source, 1, source.getLineCount());
                } else {
                    try {
                        int line = Integer.parseInt(args[1]);
                        int halfListSize = listSize / 2;
                        int start = Math.max(1, line - halfListSize);
                        int count = Math.min(source.getLineCount() + 1 - start, listSize);
                        this.printLines(source, start, count);
                    }
                    catch (NumberFormatException e) {
                        SimpleREPLClient.this.clientContext.displayFailReply("\"" + args[1] + "\" not recognized");
                    }
                }
            }
        }

        private int printLines(Source printSource, int start, int listSize) {
            SimpleREPLClient.this.clientContext.displayReply(printSource.getShortName() + ":");
            int lastLineNumber = Math.min(start + listSize - 1, printSource.getLineCount());
            for (int line = start; line <= lastLineNumber; ++line) {
                SimpleREPLClient.this.writer.format(SimpleREPLClient.CODE_LINE_FORMAT, line, printSource.getCode(line));
            }
            return lastLineNumber;
        }

        private void reset() {
            this.lastListedSource = SimpleREPLClient.this.clientContext.getSelectedSource();
            this.nextLineToList = 1;
        }
    };
    private final REPLCommand quitCommand = new REPLRemoteCommand("quit", "q", "Quit execution and REPL"){

        @Override
        protected REPLMessage createRequest(REPLClientContext context, String[] args) {
            return null;
        }
    };
    private final REPLCommand setCommand = new REPLLocalCommand("set", null, "set <option>=<value>"){

        @Override
        public String[] getHelp() {
            return new String[]{"Sets an option \"set <option-name>=<value>\";  see also \"info set\""};
        }

        @Override
        public void execute(String[] args) {
            REPLMessage request = null;
            if (args.length == 1) {
                SimpleREPLClient.this.clientContext.displayFailReply("No option specified, try \"help set\"");
            } else if (args.length == 2) {
                String[] split = new String[]{};
                try {
                    split = args[1].split("=");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (split.length == 0) {
                    SimpleREPLClient.this.clientContext.displayFailReply("Arguments not understood, try \"help set\"");
                } else if (split.length == 1) {
                    SimpleREPLClient.this.clientContext.displayFailReply("No option value specified, try \"help set\"");
                } else if (split.length > 2) {
                    SimpleREPLClient.this.clientContext.displayFailReply("Arguments not understood, try \"help set\"");
                } else {
                    String optionName = split[0];
                    String newValue = split[1];
                    LocalOption localOption = (LocalOption)SimpleREPLClient.this.localOptions.get(optionName);
                    if (localOption != null) {
                        if (!localOption.setValue(newValue)) {
                            SimpleREPLClient.this.clientContext.displayFailReply("Invalid option value \"" + newValue + "\"");
                        }
                        SimpleREPLClient.this.clientContext.displayInfo(localOption.name + " = " + localOption.getValue());
                    } else {
                        request = new REPLMessage();
                        request.put("op", "set");
                        request.put("option", optionName);
                        request.put("value", newValue);
                    }
                }
            } else {
                SimpleREPLClient.this.clientContext.displayFailReply("Arguments not understood, try \"help set\"");
            }
        }
    };
    private final REPLIndirectCommand truffleCommand = new REPLIndirectCommand("truffle", "t", "Access to Truffle internals"){
        private final Map<String, REPLCommand> truffleCommandMap;
        private final Collection<String> truffleCommandNames;
        {
            this.truffleCommandMap = new HashMap<String, REPLCommand>();
            this.truffleCommandNames = new TreeSet<String>();
        }

        @Override
        public String[] getHelp() {
            ArrayList<String> lines = new ArrayList<String>();
            for (String truffleCommandName : this.truffleCommandNames) {
                REPLCommand cmd = this.truffleCommandMap.get(truffleCommandName);
                if (cmd == null) {
                    lines.add("\"truffle " + truffleCommandName + "\" not implemented");
                    continue;
                }
                for (String line : cmd.getHelp()) {
                    lines.add(line);
                }
            }
            return lines.toArray(new String[0]);
        }

        @Override
        void addCommand(REPLCommand replCommand) {
            String commandName = replCommand.getCommand();
            String abbreviation = replCommand.getAbbreviation();
            this.truffleCommandNames.add(commandName);
            this.truffleCommandMap.put(commandName, replCommand);
            if (abbreviation != null) {
                this.truffleCommandMap.put(abbreviation, replCommand);
            }
        }

        @Override
        REPLCommand getCommand(String[] args) {
            if (args.length == 1) {
                SimpleREPLClient.this.clientContext.displayFailReply("truffle request not specified; try \"help truffle\"");
                return null;
            }
            String topic = args[1];
            REPLCommand command = this.truffleCommandMap.get(topic);
            if (command == null) {
                SimpleREPLClient.this.clientContext.displayFailReply("truffle request \"" + topic + "\" not recognized");
                return null;
            }
            return command;
        }
    };
    private final REPLRemoteCommand truffleASTCommand = new REPLRemoteCommand("ast", null, "print the AST that contains the current node"){
        final String[] help;
        {
            this.help = new String[]{"truffle ast:  print the AST subtree that contains current node (see \"set treedepth\")", "truffle ast <n>:  print the AST subtree that contains current node to a maximum depth of <n>"};
        }

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            if (SimpleREPLClient.this.clientContext.level() == 0) {
                context.displayFailReply("no active execution");
                return null;
            }
            REPLMessage request = new REPLMessage();
            request.put("op", "truffle");
            request.put("topic", "ast");
            int astDepth = SimpleREPLClient.this.astDepthOption.getInt();
            if (args.length > 2) {
                String depthText = args[2];
                try {
                    astDepth = Integer.parseInt(depthText);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            request.put("show-max-depth", Integer.toString(astDepth));
            return request;
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            if (replies[0].get("status").equals("failed")) {
                SimpleREPLClient.this.clientContext.displayFailReply(replies[0].get("displayable-message"));
            } else {
                SimpleREPLClient.this.clientContext.displayReply("AST containing the Current Node:");
                for (REPLMessage message : replies) {
                    for (String line : message.get("displayable-message").split("\n")) {
                        SimpleREPLClient.this.clientContext.displayInfo(line);
                    }
                }
            }
        }
    };
    private final REPLRemoteCommand truffleNodeCommand = new REPLRemoteCommand("node", null, "describe current AST node"){
        final String[] help;
        {
            this.help = new String[]{"truffle node:  describe the AST node at the current execution context"};
        }

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            if (SimpleREPLClient.this.clientContext.level() == 0) {
                context.displayFailReply("no active execution");
                return null;
            }
            REPLMessage request = new REPLMessage();
            request.put("op", "truffle-node");
            return request;
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            if (replies[0].get("status").equals("failed")) {
                SimpleREPLClient.this.clientContext.displayFailReply(replies[0].get("displayable-message"));
            } else {
                SimpleREPLClient.this.displayTruffleNode(replies[0].get("displayable-message"));
            }
        }
    };
    private final REPLRemoteCommand truffleSubtreeCommand = new REPLRemoteCommand("subtree", "sub", "print the AST subtree rooted at the current node"){
        final String[] help;
        {
            this.help = new String[]{"truffle sub:  print the AST subtree at the current node (see \"set treedepth\")", "truffle sub <n>:  print the AST subtree at the current node to maximum depth <n>", "truffle subtree:   print the AST subtree at the current node (see \"set treedepth\")", "truffle sub <n>:  print the AST subtree at the current node to maximum depth <n>"};
        }

        @Override
        public String[] getHelp() {
            return this.help;
        }

        @Override
        public REPLMessage createRequest(REPLClientContext context, String[] args) {
            if (SimpleREPLClient.this.clientContext.level() == 0) {
                context.displayFailReply("no active execution");
                return null;
            }
            REPLMessage request = new REPLMessage();
            request.put("op", "truffle");
            request.put("topic", "subtree");
            int astDepth = SimpleREPLClient.this.astDepthOption.getInt();
            if (args.length > 2) {
                String depthText = args[2];
                try {
                    astDepth = Integer.parseInt(depthText);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            request.put("show-max-depth", Integer.toString(astDepth));
            return request;
        }

        @Override
        void processReply(REPLClientContext context, REPLMessage[] replies) {
            if (replies[0].get("status").equals("failed")) {
                SimpleREPLClient.this.clientContext.displayFailReply(replies[0].get("displayable-message"));
            } else {
                SimpleREPLClient.this.clientContext.displayReply("AST subtree at Current Node:");
                for (REPLMessage message : replies) {
                    for (String line : message.get("displayable-message").split("\n")) {
                        SimpleREPLClient.this.clientContext.displayInfo(line);
                    }
                }
            }
        }
    };
    private final REPLCommand whereCommand = new REPLLocalCommand("where", null, "Show code around current break location"){

        @Override
        public void execute(String[] args) {
            SimpleREPLClient.this.clientContext.displayWhere();
        }
    };

    public static void main(String[] args) {
        SimpleREPLClient client = new SimpleREPLClient();
        REPLServer replServer = new REPLServer(client);
        replServer.start();
        client.start(replServer);
    }

    private void addOption(LocalOption localOption) {
        String optionName = localOption.getName();
        this.localOptions.put(optionName, localOption);
        this.optionNames.add(optionName);
    }

    public SimpleREPLClient() {
        this.writer = System.out;
        try {
            this.reader = new ConsoleReader();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create console " + e);
        }
        this.addCommand(this.backtraceCommand);
        this.addCommand(REPLRemoteCommand.BREAK_AT_LINE_CMD);
        this.addCommand(REPLRemoteCommand.BREAK_AT_LINE_ONCE_CMD);
        this.addCommand(REPLRemoteCommand.CALL_CMD);
        this.addCommand(REPLRemoteCommand.CALL_STEP_INTO_CMD);
        this.addCommand(REPLRemoteCommand.CLEAR_BREAK_CMD);
        this.addCommand(REPLRemoteCommand.CONDITION_BREAK_CMD);
        this.addCommand(REPLRemoteCommand.CONTINUE_CMD);
        this.addCommand(REPLRemoteCommand.DELETE_CMD);
        this.addCommand(REPLRemoteCommand.DISABLE_CMD);
        this.addCommand(REPLRemoteCommand.DOWN_CMD);
        this.addCommand(REPLRemoteCommand.ENABLE_CMD);
        this.addCommand(REPLRemoteCommand.EVAL_CMD);
        this.addCommand(REPLRemoteCommand.EVAL_STEP_INTO_CMD);
        this.addCommand(this.fileCommand);
        this.addCommand(REPLRemoteCommand.FRAME_CMD);
        this.addCommand(this.helpCommand);
        this.addCommand(this.infoCommand);
        this.addCommand(REPLRemoteCommand.KILL_CMD);
        this.addCommand(this.listCommand);
        this.addCommand(REPLRemoteCommand.LOAD_CMD);
        this.addCommand(REPLRemoteCommand.LOAD_STEP_INTO_CMD);
        this.addCommand(this.quitCommand);
        this.addCommand(this.setCommand);
        this.addCommand(REPLRemoteCommand.SET_LANG_CMD);
        this.addCommand(REPLRemoteCommand.STEP_INTO_CMD);
        this.addCommand(REPLRemoteCommand.STEP_OUT_CMD);
        this.addCommand(REPLRemoteCommand.STEP_OVER_CMD);
        this.addCommand(this.truffleCommand);
        this.addCommand(REPLRemoteCommand.UP_CMD);
        this.addCommand(this.whereCommand);
        this.infoCommand.addCommand(this.infoBreakCommand);
        this.infoCommand.addCommand(this.infoLanguageCommand);
        this.infoCommand.addCommand(this.infoSetCommand);
        this.truffleCommand.addCommand(this.truffleASTCommand);
        this.truffleCommand.addCommand(this.truffleNodeCommand);
        this.truffleCommand.addCommand(this.truffleSubtreeCommand);
        this.addOption(this.astDepthOption);
        this.addOption(this.autoASTOption);
        this.addOption(this.autoNodeOption);
        this.addOption(this.autoSubtreeOption);
        this.addOption(this.autoWhereOption);
        this.addOption(this.listSizeOption);
        this.addOption(this.traceMessagesOption);
        this.addOption(this.verboseBreakpointInfoOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(REPLServer server) {
        this.replServer = server;
        this.clientContext = new ClientContextImpl(null, null);
        this.showWelcome();
        try {
            REPLMessage[] replies = this.replServer.receive(this.infoLanguageCommand.createRequest(this.clientContext, NULL_ARGS));
            if (replies.length == 0) {
                this.clientContext.displayFailReply("No languages could be loaded");
            } else if (replies.length == 1) {
                String[] args = new String[]{"", replies[0].get("language-name")};
                REPLMessage[] results = this.replServer.receive(REPLRemoteCommand.SET_LANG_CMD.createRequest(this.clientContext, args));
                if (results[0].get("status").equals("failed")) {
                    String message = results[0].get("displayable-message");
                    this.clientContext.displayFailReply(message != null ? message : results[0].toString());
                } else {
                    this.clientContext.updatePrompt();
                    this.clientContext.startContextSession();
                }
            } else {
                this.clientContext.displayInfo("Languages supported (type \"lang <name>\" to set default)");
                this.displayLanguages(replies);
                this.clientContext.updatePrompt();
                this.clientContext.startContextSession();
            }
        }
        finally {
            this.clientContext.displayReply("Goodbye");
        }
    }

    private void showWelcome() {
        REPLMessage request = new REPLMessage("op", "info");
        request.put("topic", "welcome-message");
        REPLMessage[] replies = this.clientContext.sendToServer(request);
        if (replies[0].get("status").equals("failed")) {
            this.clientContext.displayReply("Welcome");
        } else {
            this.clientContext.displayReply(replies[0].get("info-value"));
        }
    }

    public void addCommand(REPLCommand replCommand) {
        String commandName = replCommand.getCommand();
        String abbreviation = replCommand.getAbbreviation();
        this.commandNames.add(commandName);
        this.commandMap.put(commandName, replCommand);
        if (abbreviation != null) {
            this.commandMap.put(abbreviation, replCommand);
        }
    }

    @Override
    public REPLMessage receive(REPLMessage request) {
        String result = request.get("result");
        this.clientContext.displayReply(result != null ? result : request.toString());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halted(REPLMessage message) {
        String result;
        this.clientContext = new ClientContextImpl(this.clientContext, message);
        String warnings = message.get("warnings");
        if (warnings != null) {
            this.clientContext.displayWarnings(warnings);
        }
        if (this.autoWhereOption.getBool()) {
            this.clientContext.displayWhere();
        }
        if (this.autoNodeOption.getBool() && (result = this.clientContext.stringQuery("truffle-node")) != null) {
            this.displayTruffleNode(result);
        }
        if (this.autoASTOption.getBool() && (result = this.clientContext.stringQuery("truffle-ast")) != null) {
            this.displayTruffleAST(result);
        }
        if (this.autoSubtreeOption.getBool() && (result = this.clientContext.stringQuery("truffle-subtree")) != null) {
            this.displayTruffleSubtree(result);
        }
        try {
            this.clientContext.startContextSession();
        }
        finally {
            this.clientContext = this.clientContext.predecessor;
        }
    }

    private void displayLanguages(REPLMessage[] replies) {
        for (REPLMessage message : replies) {
            StringBuilder sb = new StringBuilder();
            String name = message.get("language-name");
            if (name.equals("")) continue;
            sb.append(name);
            sb.append(" ver. ");
            sb.append(message.get("language-version"));
            this.clientContext.displayInfo(sb.toString());
        }
    }

    private void displayTruffleAST(String text) {
        this.clientContext.displayReply("AST containing Current Node:");
        for (String line : text.split("\n")) {
            this.clientContext.displayInfo(line);
        }
    }

    private void displayTruffleNode(String nodeString) {
        this.clientContext.displayReply("Current Node: " + nodeString);
    }

    private void displayTruffleSubtree(String text) {
        this.clientContext.displayReply("AST subtree at Current Node:");
        for (String line : text.split("\n")) {
            this.clientContext.displayInfo(line);
        }
    }

    private static final class IntegerOption
    extends LocalOption {
        private Integer value;

        IntegerOption(int value, String name, String description) {
            super(name, description);
            this.value = value;
        }

        @Override
        public boolean setValue(String newValue) {
            Integer valueOf;
            try {
                valueOf = Integer.valueOf(newValue);
            }
            catch (NumberFormatException e) {
                return false;
            }
            this.value = valueOf;
            return true;
        }

        @Override
        public int getInt() {
            return this.value;
        }

        @Override
        public String getValue() {
            return this.value.toString();
        }
    }

    private static final class BooleanOption
    extends LocalOption {
        private Boolean value;

        BooleanOption(boolean value, String name, String description) {
            super(name, description);
            this.value = value;
        }

        @Override
        public boolean setValue(String newValue) {
            Boolean valueOf = Boolean.valueOf(newValue);
            if (valueOf == null) {
                return false;
            }
            this.value = valueOf;
            return true;
        }

        @Override
        public boolean getBool() {
            return this.value;
        }

        @Override
        public String getValue() {
            return this.value.toString();
        }
    }

    private static abstract class LocalOption {
        private final String name;
        private final String description;

        protected LocalOption(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public abstract boolean setValue(String var1);

        public boolean getBool() {
            assert (false);
            return false;
        }

        public int getInt() {
            assert (false);
            return 0;
        }

        public abstract String getValue();
    }

    private abstract class REPLIndirectCommand
    extends REPLCommand {
        REPLIndirectCommand(String command, String abbreviation, String description) {
            super(command, abbreviation, description);
        }

        abstract void addCommand(REPLCommand var1);

        abstract REPLCommand getCommand(String[] var1);
    }

    private abstract class REPLLocalCommand
    extends REPLCommand {
        REPLLocalCommand(String command, String abbreviation, String description) {
            super(command, abbreviation, description);
        }

        abstract void execute(String[] var1);
    }

    private class ClientContextImpl
    implements REPLClientContext {
        private final ClientContextImpl predecessor;
        private final int level;
        private Source haltedSource;
        private int haltedLineNumber = 0;
        private String unknownSourceName = "<unavailable>";
        private List<REPLFrame> frames = null;
        private int selectedFrameNumber = 0;
        private String currentPrompt;
        private boolean killPending;

        ClientContextImpl(ClientContextImpl predecessor, REPLMessage message) {
            this.predecessor = predecessor;
            int n = this.level = predecessor == null ? 0 : predecessor.level + 1;
            if (message != null) {
                String sourceName;
                block7: {
                    sourceName = message.get("source-name");
                    try {
                        this.haltedSource = Source.fromFileName(sourceName);
                    }
                    catch (IOException ex) {
                        String code = message.get("source-text");
                        if (code == null) break block7;
                        this.haltedSource = Source.fromText(code, sourceName);
                    }
                }
                if (this.haltedSource != null) {
                    SimpleREPLClient.this.selectedSource = this.haltedSource;
                    try {
                        this.haltedLineNumber = Integer.parseInt(message.get("line-number"));
                    }
                    catch (NumberFormatException e) {
                        this.haltedLineNumber = 0;
                    }
                } else {
                    this.haltedSource = null;
                    this.haltedLineNumber = 0;
                    this.unknownSourceName = sourceName;
                }
            }
            this.updatePrompt();
        }

        private void selectSource(String fileName) {
            try {
                SimpleREPLClient.this.selectedSource = Source.fromFileName(fileName);
            }
            catch (IOException e1) {
                SimpleREPLClient.this.selectedSource = null;
            }
            this.updatePrompt();
        }

        @Override
        public void updatePrompt() {
            String showLang;
            String languageName = "???";
            REPLMessage request = new REPLMessage();
            request.put("op", "info");
            request.put("topic", "info-current-language");
            REPLMessage[] replies = SimpleREPLClient.this.replServer.receive(request);
            if (replies[0].get("status").equals("succeeded")) {
                languageName = replies[0].get("language-name");
            }
            String string = showLang = languageName == null ? "() " : "( " + languageName + " )";
            if (this.level == 0) {
                this.currentPrompt = SimpleREPLClient.this.selectedSource == null ? showLang + " " : "(" + SimpleREPLClient.this.selectedSource.getShortName() + ") " + showLang + " ";
            } else if (SimpleREPLClient.this.selectedSource != null && SimpleREPLClient.this.selectedSource != this.haltedSource) {
                StringBuilder sb = new StringBuilder();
                sb.append("(<" + Integer.toString(this.level) + "> ");
                sb.append(SimpleREPLClient.this.selectedSource.getShortName());
                sb.append(")");
                sb.append(showLang);
                sb.append(" ");
                this.currentPrompt = sb.toString();
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("(<" + Integer.toString(this.level) + "> ");
                sb.append(this.haltedSource == null ? "??" : this.haltedSource.getShortName());
                if (this.haltedLineNumber > 0) {
                    sb.append(":" + Integer.toString(this.haltedLineNumber));
                }
                sb.append(")");
                sb.append(showLang);
                sb.append(" ");
                this.currentPrompt = sb.toString();
            }
        }

        @Override
        public Source source() {
            return this.haltedSource;
        }

        @Override
        public int lineNumber() {
            return this.haltedLineNumber;
        }

        @Override
        public List<REPLFrame> frames() {
            if (this.frames == null) {
                REPLMessage request = new REPLMessage("op", "backtrace");
                REPLMessage[] replies = this.sendToServer(request);
                if (replies[0].get("status").equals("failed")) {
                    return null;
                }
                this.frames = new ArrayList<REPLFrame>();
                for (REPLMessage reply : replies) {
                    int index = reply.getIntValue("frame-number");
                    String locationFilePath = reply.get("path");
                    Integer locationLineNumber = reply.getIntValue("line-number");
                    String locationDescription = reply.get("source-location");
                    String name = reply.get("method-name");
                    String sourceLineText = reply.get("source-line-text");
                    this.frames.add(new REPLFrameImpl(index, locationFilePath, locationLineNumber, locationDescription, name, sourceLineText));
                }
                this.frames = Collections.unmodifiableList(this.frames);
            }
            return this.frames;
        }

        @Override
        public int level() {
            return this.level;
        }

        @Override
        public Source getSelectedSource() {
            return SimpleREPLClient.this.selectedSource == null ? this.haltedSource : SimpleREPLClient.this.selectedSource;
        }

        @Override
        public int getSelectedFrameNumber() {
            return this.selectedFrameNumber;
        }

        @Override
        public String stringQuery(String op) {
            assert (op != null);
            REPLMessage request = null;
            switch (op) {
                case "truffle-ast": {
                    request = SimpleREPLClient.this.truffleASTCommand.createRequest(SimpleREPLClient.this.clientContext, NULL_ARGS);
                    break;
                }
                case "truffle-subtree": {
                    request = SimpleREPLClient.this.truffleSubtreeCommand.createRequest(SimpleREPLClient.this.clientContext, NULL_ARGS);
                    break;
                }
                default: {
                    request = new REPLMessage();
                    request.put("op", op);
                }
            }
            if (request == null) {
                return null;
            }
            REPLMessage[] replies = this.sendToServer(request);
            if (replies[0].get("status").equals("failed")) {
                return null;
            }
            return replies[0].get("displayable-message");
        }

        @Override
        public void selectFrameNumber(int frameNumber) {
            this.selectedFrameNumber = frameNumber;
        }

        void displayWhere() {
            if (this.level == 0) {
                this.displayFailReply("no active execution");
                return;
            }
            Source whereSource = null;
            int whereLineNumber = 0;
            if (this.selectedFrameNumber == 0) {
                whereSource = this.haltedSource;
                whereLineNumber = this.haltedLineNumber;
            } else {
                REPLFrame frame = this.frames().get(this.selectedFrameNumber);
                String locationFileName = frame.locationFilePath();
                if (locationFileName != null) {
                    try {
                        whereSource = Source.fromFileName(locationFileName);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                whereLineNumber = frame.locationLineNumber();
            }
            if (whereSource == null) {
                this.displayFailReply("Unavalable source=\"" + this.unknownSourceName + "\"");
                return;
            }
            int listSize = SimpleREPLClient.this.listSizeOption.getInt();
            int fileLineCount = whereSource.getLineCount();
            String code = whereSource.getCode();
            SimpleREPLClient.this.writer.println("Frame " + this.selectedFrameNumber + " in " + whereSource.getShortName());
            int halfListSize = listSize / 2;
            int startLineNumber = Math.max(1, whereLineNumber - halfListSize);
            int lastLineNumber = Math.min(startLineNumber + listSize - 1, fileLineCount);
            for (int line = startLineNumber; line <= lastLineNumber; ++line) {
                int offset = whereSource.getLineStartOffset(line);
                String lineText = code.substring(offset, offset + whereSource.getLineLength(line));
                if (line == whereLineNumber) {
                    SimpleREPLClient.this.writer.format(SimpleREPLClient.CODE_LINE_BREAK_FORMAT, line, lineText);
                    continue;
                }
                SimpleREPLClient.this.writer.format(SimpleREPLClient.CODE_LINE_FORMAT, line, lineText);
            }
        }

        @Override
        public void displayStack() {
            List<REPLFrame> frameList = this.frames();
            if (frameList == null) {
                SimpleREPLClient.this.writer.println("<empty stack>");
            } else {
                for (REPLFrame frame : frameList) {
                    String sourceLineText = frame.sourceLineText();
                    sourceLineText = sourceLineText == null ? "" : "line=\"" + sourceLineText + "\"";
                    if (frame.index() == this.selectedFrameNumber) {
                        SimpleREPLClient.this.writer.format(SimpleREPLClient.STACK_FRAME_SELECTED_FORMAT, frame.index(), frame.locationDescription(), frame.name(), sourceLineText);
                        continue;
                    }
                    SimpleREPLClient.this.writer.format(SimpleREPLClient.STACK_FRAME_FORMAT, frame.index(), frame.locationDescription(), frame.name(), sourceLineText);
                }
            }
        }

        @Override
        public void displayInfo(String message) {
            SimpleREPLClient.this.writer.format(SimpleREPLClient.INFO_LINE_FORMAT, message);
        }

        @Override
        public void displayReply(String message) {
            SimpleREPLClient.this.writer.println(SimpleREPLClient.REPLY_PREFIX + message);
        }

        @Override
        public void displayFailReply(String message) {
            if (!message.equals("KillException")) {
                SimpleREPLClient.this.writer.println(SimpleREPLClient.FAIL_PREFIX + message);
            }
        }

        @Override
        public void notifyKilled() {
            this.predecessor.killPending = true;
            SimpleREPLClient.this.writer.println(SimpleREPLClient.this.clientContext.currentPrompt + " killed");
        }

        public void displayWarnings(String warnings) {
            for (String warning : warnings.split("\\n")) {
                SimpleREPLClient.this.writer.println(SimpleREPLClient.WARNING_PREFIX + warning);
            }
        }

        public void traceMessage(String message) {
            SimpleREPLClient.this.writer.println(SimpleREPLClient.TRACE_PREFIX + message);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void startContextSession() {
            while (true) {
                try {
                    while (true) {
                        REPLCommand command = null;
                        String[] args = NULL_ARGS;
                        if (SimpleREPLClient.this.quitting) {
                            if (this.level == 0) {
                                return;
                            }
                            command = REPLRemoteCommand.KILL_CMD;
                        } else {
                            String string = SimpleREPLClient.this.reader.readLine(this.currentPrompt).trim();
                            args = string.startsWith("eval ") ? new String[]{"eval", string.substring(5)} : string.split("[ \t]+");
                            if (args.length == 0) return;
                            String cmd = args[0];
                            if (cmd.isEmpty()) continue;
                            command = (REPLCommand)SimpleREPLClient.this.commandMap.get(cmd);
                            while (command instanceof REPLIndirectCommand) {
                                if (SimpleREPLClient.this.traceMessagesOption.getBool()) {
                                    this.traceMessage("Executing indirect: " + command.getCommand());
                                }
                                command = ((REPLIndirectCommand)command).getCommand(args);
                            }
                            if (command == SimpleREPLClient.this.quitCommand) {
                                if (this.level == 0) {
                                    return;
                                }
                                SimpleREPLClient.this.quitting = true;
                                command = REPLRemoteCommand.KILL_CMD;
                            }
                            if (command == null) {
                                SimpleREPLClient.this.clientContext.displayFailReply("Unrecognized command \"" + cmd + "\"");
                                continue;
                            }
                        }
                        if (command instanceof REPLLocalCommand) {
                            if (SimpleREPLClient.this.traceMessagesOption.getBool()) {
                                this.traceMessage("Executing local: " + command.getCommand());
                            }
                            ((REPLLocalCommand)command).execute(args);
                            continue;
                        }
                        if (command instanceof REPLRemoteCommand) {
                            REPLCommand rEPLCommand = command;
                            REPLMessage request = rEPLCommand.createRequest(SimpleREPLClient.this.clientContext, args);
                            if (request == null) continue;
                            REPLMessage[] replies = this.sendToServer(request);
                            rEPLCommand.processReply(SimpleREPLClient.this.clientContext, replies);
                            String path = replies[0].get("path");
                            if (path == null || path.isEmpty()) continue;
                            this.selectSource(path);
                            continue;
                        }
                        assert (false);
                    }
                }
                catch (ThreadDeath ex) {
                    if (ex.getClass() == ThreadDeath.class || !this.killPending) throw ex;
                    this.killPending = false;
                    continue;
                }
                catch (REPLContinueException ex) {
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        private REPLMessage[] sendToServer(REPLMessage request) {
            if (SimpleREPLClient.this.traceMessagesOption.getBool()) {
                SimpleREPLClient.this.clientContext.traceMessage("Sever request:");
                request.print(SimpleREPLClient.this.writer, "  ");
            }
            REPLMessage[] replies = SimpleREPLClient.this.replServer.receive(request);
            assert (replies != null && replies.length > 0);
            if (SimpleREPLClient.this.traceMessagesOption.getBool()) {
                if (replies.length > 1) {
                    SimpleREPLClient.this.clientContext.traceMessage("Received " + replies.length + " server replies");
                    int replyCount = 0;
                    for (REPLMessage reply : replies) {
                        SimpleREPLClient.this.clientContext.traceMessage("Server Reply " + replyCount++ + ":");
                        reply.print(SimpleREPLClient.this.writer, "  ");
                    }
                } else {
                    SimpleREPLClient.this.clientContext.traceMessage("Received reply:");
                    replies[0].print(SimpleREPLClient.this.writer, "  ");
                }
            }
            return replies;
        }

        private final class REPLFrameImpl
        implements REPLFrame {
            private final int index;
            private final String locationFilePath;
            private final Integer locationLineNumber;
            private final String locationDescription;
            private final String name;
            private final String sourceLineText;

            REPLFrameImpl(int index, String locationFilePath, Integer locationLineNumber, String locationDescription, String name, String sourceLineText) {
                this.index = index;
                this.locationFilePath = locationFilePath;
                this.locationLineNumber = locationLineNumber;
                this.locationDescription = locationDescription;
                this.name = name;
                this.sourceLineText = sourceLineText;
            }

            @Override
            public int index() {
                return this.index;
            }

            @Override
            public String locationFilePath() {
                return this.locationFilePath;
            }

            @Override
            public Integer locationLineNumber() {
                return this.locationLineNumber;
            }

            @Override
            public String locationDescription() {
                return this.locationDescription;
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public String sourceLineText() {
                return this.sourceLineText;
            }
        }
    }
}

