/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayReadNormalizedNode;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=ArrayReadNormalizedNode.class)
public final class ArrayReadNormalizedNodeGen
extends ArrayReadNormalizedNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private RubyNode index_;
    @CompilerDirectives.CompilationFinal
    private Class<?> indexType_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayReadNormalizedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
        super(context, sourceSection);
        this.array_ = array;
        this.index_ = index;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeRead(DynamicObject arrayValue, int indexValue) {
        return this.specialization_.execute1(arrayValue, indexValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeDynamicObject(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    private static DynamicObject expectDynamicObject(Object value) throws UnexpectedResultException {
        if (value instanceof DynamicObject) {
            return (DynamicObject)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static ArrayReadNormalizedNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
        return new ArrayReadNormalizedNodeGen(context, sourceSection, array, index);
    }

    @GeneratedBy(methodName="readOutOfBounds(DynamicObject, int)", value=ArrayReadNormalizedNode.class)
    private static final class ReadOutOfBoundsNode_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;

        ReadOutOfBoundsNode_(ArrayReadNormalizedNodeGen root, Object indexValue) {
            super(root, 3);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((ReadOutOfBoundsNode_)other).indexImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                return ArrayReadNormalizedNodeGen.expectDynamicObject(this.getNext().execute_(ex.getResult(), indexValue));
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_(frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return ArrayReadNormalizedNodeGen.expectDynamicObject(this.getNext().execute_(arrayValue_, ex.getResult()));
            }
            if (!ArrayReadNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                return this.root.readOutOfBounds(arrayValue_, indexValue_);
            }
            return ArrayReadNormalizedNodeGen.expectDynamicObject(this.getNext().execute_(arrayValue_, indexValue_));
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue) {
            if (!ArrayReadNormalizedNode.isInBounds(arrayValue, indexValue)) {
                return this.root.readOutOfBounds(arrayValue, indexValue);
            }
            return this.getNext().execute1(arrayValue, indexValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && !ArrayReadNormalizedNode.isInBounds(arrayValue_ = (DynamicObject)arrayValue, indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType))) {
                return this.root.readOutOfBounds(arrayValue_, indexValue_);
            }
            return this.getNext().execute_(arrayValue, indexValue);
        }

        static BaseNode_ create(ArrayReadNormalizedNodeGen root, Object indexValue) {
            return new ReadOutOfBoundsNode_(root, indexValue);
        }
    }

    @GeneratedBy(methodName="readInBounds(DynamicObject, int, ArrayStrategy)", value=ArrayReadNormalizedNode.class)
    private static final class ReadInBoundsNode_
    extends BaseNode_ {
        private final ArrayStrategy strategy;
        private final Class<?> indexImplicitType;

        ReadInBoundsNode_(ArrayReadNormalizedNodeGen root, Object indexValue, ArrayStrategy strategy) {
            super(root, 2);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.strategy = strategy;
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((ReadInBoundsNode_)other).indexImplicitType;
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue, Object indexValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            return arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && ArrayReadNormalizedNode.isInBounds(arrayValue_ = (DynamicObject)arrayValue, indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType)) && this.strategy.matches(arrayValue_);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_(frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute_(arrayValue_, ex.getResult());
            }
            if (ArrayReadNormalizedNode.isInBounds(arrayValue_, indexValue_) && this.strategy.matches(arrayValue_)) {
                return this.root.readInBounds(arrayValue_, indexValue_, this.strategy);
            }
            return this.getNext().execute_(arrayValue_, indexValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue) {
            if (ArrayReadNormalizedNode.isInBounds(arrayValue, indexValue) && this.strategy.matches(arrayValue)) {
                return this.root.readInBounds(arrayValue, indexValue, this.strategy);
            }
            return this.getNext().execute1(arrayValue, indexValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && ArrayReadNormalizedNode.isInBounds(arrayValue_ = (DynamicObject)arrayValue, indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType)) && this.strategy.matches(arrayValue_)) {
                return this.root.readInBounds(arrayValue_, indexValue_, this.strategy);
            }
            return this.getNext().execute_(arrayValue, indexValue);
        }

        static BaseNode_ create(ArrayReadNormalizedNodeGen root, Object indexValue, ArrayStrategy strategy) {
            return new ReadInBoundsNode_(root, indexValue, strategy);
        }
    }

    @GeneratedBy(methodName="readNull(DynamicObject, int)", value=ArrayReadNormalizedNode.class)
    private static final class ReadNullNode_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;

        ReadNullNode_(ArrayReadNormalizedNodeGen root, Object indexValue) {
            super(root, 1);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((ReadNullNode_)other).indexImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                return ArrayReadNormalizedNodeGen.expectDynamicObject(this.getNext().execute_(ex.getResult(), indexValue));
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_(frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return ArrayReadNormalizedNodeGen.expectDynamicObject(this.getNext().execute_(arrayValue_, ex.getResult()));
            }
            if (ArrayGuards.isNullArray(arrayValue_)) {
                return this.root.readNull(arrayValue_, indexValue_);
            }
            return ArrayReadNormalizedNodeGen.expectDynamicObject(this.getNext().execute_(arrayValue_, indexValue_));
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue) {
            if (ArrayGuards.isNullArray(arrayValue)) {
                return this.root.readNull(arrayValue, indexValue);
            }
            return this.getNext().execute1(arrayValue, indexValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                if (ArrayGuards.isNullArray(arrayValue_)) {
                    return this.root.readNull(arrayValue_, indexValue_);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue);
        }

        static BaseNode_ create(ArrayReadNormalizedNodeGen root, Object indexValue) {
            return new ReadNullNode_(root, indexValue);
        }
    }

    @GeneratedBy(value=ArrayReadNormalizedNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayReadNormalizedNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object indexValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, indexValue));
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue) {
            return this.getNext().execute_(arrayValue, indexValue);
        }

        static BaseNode_ create(ArrayReadNormalizedNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayReadNormalizedNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayReadNormalizedNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue) {
            return this.uninitialized((Frame)null, arrayValue, indexValue);
        }

        static BaseNode_ create(ArrayReadNormalizedNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayReadNormalizedNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ArrayReadNormalizedNodeGen root;

        BaseNode_(ArrayReadNormalizedNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (ArrayReadNormalizedNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_, this.root.index_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object indexValue) {
            return this.execute_(arrayValue, indexValue);
        }

        public abstract Object execute_(Object var1, Object var2);

        public Object execute1(DynamicObject arrayValue, int indexValue) {
            return this.execute_(arrayValue, indexValue);
        }

        public Object execute0(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            Object indexValue_ = this.executeIndex_(frameValue);
            return this.execute_(arrayValue_, indexValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            return ArrayReadNormalizedNodeGen.expectDynamicObject(this.execute0(frameValue));
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object indexValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue)) {
                BaseNode_ s;
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue);
                if (ArrayGuards.isNullArray(arrayValue_)) {
                    return ReadNullNode_.create(this.root, indexValue);
                }
                ArrayStrategy strategy2 = ArrayStrategy.of(arrayValue_);
                if (ArrayReadNormalizedNode.isInBounds(arrayValue_, indexValue_) && strategy2.matches(arrayValue_) && this.countSame(s = ReadInBoundsNode_.create(this.root, indexValue, strategy2)) < 25) {
                    return s;
                }
                if (!ArrayReadNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return ReadOutOfBoundsNode_.create(this.root, indexValue);
                }
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeIndex_(Frame frameValue) {
            Object object;
            Class indexType_ = this.root.indexType_;
            if (indexType_ == Integer.TYPE) {
                return this.root.index_.executeInteger((VirtualFrame)frameValue);
            }
            if (indexType_ != null) return this.root.index_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.index_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.indexType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.indexType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.indexType_ = _type;
            return object;
        }
    }
}

