/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.locals;

import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.locals.FlipFlopStateNode;

public class DeclarationFlipFlopStateNode
extends FlipFlopStateNode {
    private final int frameLevel;
    private final FrameSlot frameSlot;

    public DeclarationFlipFlopStateNode(int frameLevel, FrameSlot frameSlot) {
        this.frameLevel = frameLevel;
        this.frameSlot = frameSlot;
    }

    @Override
    public boolean getState(VirtualFrame frame) {
        MaterializedFrame declarationFrame = RubyArguments.getDeclarationFrame(frame, this.frameLevel);
        try {
            return declarationFrame.getBoolean(this.frameSlot);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void setState(VirtualFrame frame, boolean state) {
        MaterializedFrame declarationFrame = RubyArguments.getDeclarationFrame(frame, this.frameLevel);
        declarationFrame.setBoolean(this.frameSlot, state);
    }
}

