# Module stdlib

## Kotlin Standard Library

The Kotlin Standard Library provides living essentials for everyday work with Kotlin.
These include:
  - Higher-order functions implementing idiomatic patterns ([let], [apply], [use], [synchronized], etc).
  - Extension functions providing querying operations for collections (eager) and sequences (lazy).
  - Various utilities for working with strings and char sequences.
  - Extensions for JDK classes making it convenient to work with files, IO, and threading.

# Package kotlin

Core functions and types, available on all supported platforms.

# Package kotlin.annotation

Library support for the Kotlin annotation facility.

# Package kotlin.collections

Collection types, such as [Iterable], [Collection], [List], [Set], [Map] and related top-level and extension functions.

# Package kotlin.comparisons

[Comparator] factory and extension functions and comparison helper functions.

# Package kotlin.concurrent

Utility functions for concurrent programming.

# Package kotlin.io

IO API for working with files and streams.

# Package kotlin.jvm

Functions and annotations specific to the Java platform.

# Package kotlin.properties

Standard implementations of delegates for [delegated properties](/docs/reference/delegated-properties.html)
and helper functions for implementing custom delegates.

# Package kotlin.ranges

[Ranges](/docs/reference/ranges.html), Progressions and related top-level and extension functions.

# Package kotlin.reflect

Runtime API for [Kotlin reflection](/docs/reference/reflection.html)

# Package kotlin.reflect.jvm

Runtime API for interoperability between [Kotlin reflection](/docs/reference/reflection.html) and
Java reflection.

# Package kotlin.sequences

[Sequence] type that represents lazily evaluated collections. Top-level functions for instantiating sequences
and extension functions for sequences.

# Package kotlin.system

System-related utility functions.

# Package kotlin.test

Functions for writing test assertions.

# Package kotlin.text

Functions for working with text and regular expressions.

