/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib.zoom;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.SimpleUpdateStrategy;
import CH.ifa.draw.standard.StandardDrawing;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.util.Geom;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import javax.swing.JViewport;

public class ZoomDrawingView
extends StandardDrawingView {
    private double scale = 1.0;
    private Rectangle damagedArea = null;
    private boolean isPrinting = false;

    public ZoomDrawingView(DrawingEditor editor) {
        this(editor, 400, 300);
    }

    public ZoomDrawingView(DrawingEditor editor, int width, int height) {
        super(editor, width, height);
        this.setDisplayUpdate(new SimpleUpdateStrategy());
        this.addKeyListener(this.createKeyListener());
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        Dimension oldSize = this.getUserSize();
        this.scale = scale;
        this.setUserSize(oldSize.width, oldSize.height);
        this.centralize(this.drawing());
        this.forceRedraw();
    }

    private void forceRedraw() {
        this.drawingInvalidated(new DrawingChangeEvent(this.drawing(), new Rectangle(this.getSize())));
        this.repairDamage();
    }

    public void setUserSize(int width, int height) {
        this.setSize((int)((double)width * this.scale), (int)((double)height * this.scale));
    }

    public void setUserSize(Dimension d) {
        this.setUserSize(d.width, d.height);
    }

    public Dimension getSize() {
        return super.getSize();
    }

    public Dimension getUserSize() {
        Dimension screenSize = this.getSize();
        return new Dimension((int)((double)screenSize.width / this.scale), (int)((double)screenSize.height / this.scale));
    }

    public void zoom(int x, int y, int width, int height) {
        double newScale;
        if (!(this.getParent() instanceof JViewport)) {
            throw new RuntimeException("zooming only works if this view is contained in a ScrollPane");
        }
        JViewport viewport = (JViewport)this.getParent();
        Dimension viewportSize = viewport.getSize();
        Dimension userSize = this.getUserSize();
        double xScale = (double)viewportSize.width / (double)width;
        double yScale = (double)viewportSize.height / (double)height;
        this.scale = newScale = Math.min(xScale, yScale);
        this.setUserSize(userSize);
        this.revalidate();
        viewport.setViewPosition(new Point((int)((double)x * this.scale), (int)((double)y * this.scale)));
        this.forceRedraw();
    }

    public void zoomOut(int x, int y) {
        int yOrigin;
        int xOrigin;
        Dimension userSize;
        JViewport viewport;
        if (this.getParent() instanceof JViewport) {
            viewport = (JViewport)this.getParent();
            Dimension viewportSize = viewport.getSize();
            userSize = this.getUserSize();
            this.scale /= 2.0;
            int xScreen = (int)((double)x * this.scale);
            int yScreen = (int)((double)y * this.scale);
            xOrigin = xScreen - viewportSize.width / 2;
            yOrigin = yScreen - viewportSize.height / 2;
            if (xOrigin < 0) {
                xOrigin = 0;
            }
            if (yOrigin < 0) {
                yOrigin = 0;
            }
        } else {
            throw new RuntimeException("zooming only works if this view is contained in a ScrollPane");
        }
        this.setUserSize(userSize);
        this.revalidate();
        viewport.setViewPosition(new Point(xOrigin, yOrigin));
        this.forceRedraw();
    }

    public void deZoom(int x, int y) {
        int yOrigin;
        int xOrigin;
        Dimension userSize;
        JViewport viewport;
        if (this.getParent() instanceof JViewport) {
            viewport = (JViewport)this.getParent();
            Dimension viewportSize = viewport.getSize();
            userSize = this.getUserSize();
            xOrigin = x - viewportSize.width / 2;
            yOrigin = y - viewportSize.height / 2;
            if (xOrigin < 0) {
                xOrigin = 0;
            }
            if (yOrigin < 0) {
                yOrigin = 0;
            }
        } else {
            throw new RuntimeException("zooming only works if this view is contained in a ScrollPane");
        }
        this.scale = 1.0;
        this.setUserSize(userSize);
        this.revalidate();
        viewport.setViewPosition(new Point(xOrigin, yOrigin));
        this.forceRedraw();
    }

    public void print(Graphics g) {
        this.isPrinting = true;
        super.print(g);
        this.isPrinting = false;
    }

    public void paint(Graphics g) {
        if (this.scale != 1.0 && !this.isPrinting) {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform oldXform = g2.getTransform();
            g2.scale(this.scale, this.scale);
            super.paint(g);
            g2.setTransform(oldXform);
        } else {
            super.paint(g);
        }
    }

    protected Point constrainPoint(Point p) {
        Dimension size = this.getSize();
        p.x = Geom.range(1, (int)((double)size.width / this.scale), p.x);
        p.y = Geom.range(1, (int)((double)size.height / this.scale), p.y);
        if (this.getConstrainer() != null) {
            return this.getConstrainer().constrainPoint(p);
        }
        return p;
    }

    public void drawBackground(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, (int)((double)this.getBounds().width / this.scale), (int)((double)this.getBounds().height / this.scale));
    }

    private void centralize(Drawing d, Dimension bounds) {
        Point boundsCenter = new Point(bounds.width / 2, bounds.height / 2);
        Rectangle r = ((StandardDrawing)d).displayBox();
        Point drawingCenter = new Point(r.x + r.width / 2, r.y + r.height / 2);
        int diffX = boundsCenter.x - drawingCenter.x;
        int diffY = boundsCenter.y - drawingCenter.y;
        if (diffX != 0 || diffY != 0) {
            FigureEnumeration k = d.figures();
            while (k.hasMoreElements()) {
                k.nextFigure().moveBy(diffX, diffY);
            }
        }
    }

    private void centralize(Drawing d) {
        this.centralize(d, this.getUserSize());
    }

    public void setDrawing(Drawing d) {
        super.setDrawing(d);
        Rectangle r = ((StandardDrawing)d).displayBox();
        Dimension drawingSize = new Dimension(r.width, r.height);
        Dimension viewportSize = new Dimension(r.width, r.height);
        if (this.getParent() != null) {
            viewportSize = ((JViewport)this.getParent()).getSize();
        }
        Dimension userSize = new Dimension(viewportSize);
        this.scale = 1.0;
        while (drawingSize.width > userSize.width || drawingSize.height > userSize.height) {
            this.scale /= 2.0;
            userSize.width *= 2;
            userSize.height *= 2;
        }
        this.centralize(d, userSize);
        super.setPreferredSize(viewportSize);
        super.setSize(viewportSize);
        this.revalidate();
    }

    public Dimension getMinimumSize() {
        return super.getSize();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void repairDamage() {
        if (this.damagedArea != null) {
            this.repaint((int)((double)this.damagedArea.x * this.scale), (int)((double)this.damagedArea.y * this.scale), (int)((double)this.damagedArea.width * this.scale), (int)((double)this.damagedArea.height * this.scale));
            this.damagedArea = null;
        }
    }

    public void drawingInvalidated(DrawingChangeEvent e) {
        Rectangle r = e.getInvalidatedRectangle();
        if (this.damagedArea == null) {
            this.damagedArea = r;
        } else {
            this.damagedArea.add(r);
        }
    }

    private MouseEvent createScaledEvent(MouseEvent e) {
        return new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), (int)((double)e.getX() / this.getScale()), (int)((double)e.getY() / this.getScale()), e.getClickCount(), e.isPopupTrigger());
    }

    protected MouseListener createMouseListener() {
        return new StandardDrawingView.DrawingViewMouseListener(){

            public void mousePressed(MouseEvent e) {
                super.mousePressed(ZoomDrawingView.this.createScaledEvent(e));
            }

            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(ZoomDrawingView.this.createScaledEvent(e));
            }
        };
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new StandardDrawingView.DrawingViewMouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                super.mouseDragged(ZoomDrawingView.this.createScaledEvent(e));
            }

            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(ZoomDrawingView.this.createScaledEvent(e));
            }
        };
    }

    protected KeyListener createKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == ' ') {
                    ZoomDrawingView.this.forceRedraw();
                } else if (e.getKeyChar() == 'o') {
                    ZoomDrawingView.this.setScale(ZoomDrawingView.this.getScale() / 2.0);
                } else if (e.getKeyChar() == 'i') {
                    ZoomDrawingView.this.setScale(ZoomDrawingView.this.getScale() * 2.0);
                } else if (e.getKeyChar() == 'c') {
                    ZoomDrawingView.this.centralize(ZoomDrawingView.this.drawing());
                } else {
                    super.keyPressed(e);
                }
            }
        };
    }

    public void deZoom(double zoomFactor, int x, int y) {
        int yOrigin;
        int xOrigin;
        Dimension userSize;
        JViewport viewport;
        if (this.getParent() instanceof JViewport) {
            viewport = (JViewport)this.getParent();
            Dimension viewportSize = viewport.getSize();
            userSize = this.getUserSize();
            xOrigin = x - viewportSize.width / 2;
            yOrigin = y - viewportSize.height / 2;
            if (xOrigin < 0) {
                xOrigin = 0;
            }
            if (yOrigin < 0) {
                yOrigin = 0;
            }
            this.scale *= zoomFactor;
        } else {
            throw new RuntimeException("zooming only works if this view is contained in a ScrollPane");
        }
        this.setUserSize(userSize);
        this.revalidate();
        viewport.setViewPosition(new Point(xOrigin, yOrigin));
        this.forceRedraw();
    }

    public void zoomOut(double zoomFactor, int x, int y) {
        int yOrigin;
        int xOrigin;
        Dimension userSize;
        JViewport viewport;
        if (this.getParent() instanceof JViewport) {
            viewport = (JViewport)this.getParent();
            Dimension viewportSize = viewport.getSize();
            userSize = this.getUserSize();
            this.scale /= zoomFactor;
            int xScreen = (int)((double)x * this.scale);
            int yScreen = (int)((double)y * this.scale);
            xOrigin = xScreen - viewportSize.width / 2;
            yOrigin = yScreen - viewportSize.height / 2;
            if (xOrigin < 0) {
                xOrigin = 0;
            }
            if (yOrigin < 0) {
                yOrigin = 0;
            }
        } else {
            throw new RuntimeException("zooming only works if this view is contained in a ScrollPane");
        }
        this.setUserSize(userSize);
        this.revalidate();
        viewport.setViewPosition(new Point(xOrigin, yOrigin));
        this.forceRedraw();
    }
}

