/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.basics.i18n.ResourceBundle;
import ch.ehi.interlis.modeltopicclass.AbstractClassDef;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.umleditor.application.ElementUtils;
import ch.ehi.umleditor.application.ModelElementSelectionDialog;
import ch.ehi.umleditor.application.ParticipantDialog;
import ch.ehi.umleditor.application.ParticipantsPanelItem;
import ch.softenvironment.util.DeveloperException;
import ch.softenvironment.view.BasePanel;
import ch.softenvironment.view.DataPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class ParticipantsPanel
extends BasePanel
implements DataPanel {
    static java.util.ResourceBundle rsrc = ResourceBundle.getBundle(ParticipantsPanel.class);
    private JScrollPane scpRestricted = new JScrollPane();
    private JTable tabRestricted = new JTable();
    private DefaultTableModel model = new DefaultTableModel(){

        public Class getColumnClass(int columnIndex) {
            return AbstractClassDef.class;
        }
    };
    private JPopupMenu popup = new JPopupMenu();
    private JMenuItem mniAdd = new JMenuItem();
    private JMenuItem mniRemove = new JMenuItem();
    private JMenuItem mniEdit = new JMenuItem();
    private ModelElement context = null;
    private JDialog thisDialog = null;

    public ParticipantsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.model.addColumn(ElementUtils.getDisplayName(AbstractClassDef.class));
        this.scpRestricted.setViewportView(this.tabRestricted);
        this.tabRestricted.setModel(this.model);
        this.tabRestricted.setDefaultRenderer(AbstractClassDef.class, new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object aValue) {
                Object result = aValue;
                if (aValue != null && aValue instanceof ParticipantsPanelItem) {
                    ParticipantsPanelItem stock = (ParticipantsPanelItem)aValue;
                    result = ElementUtils.formatWithPackageName(stock.getTarget());
                    if (stock.getRestrictions().length > 0) {
                        result = "*" + result;
                    }
                }
                super.setValue(result);
            }
        });
        this.popup.setName("MnuClassTable");
        MouseAdapter popupListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    boolean isSelected = ParticipantsPanel.this.tabRestricted.getSelectedRow() >= 0;
                    ParticipantsPanel.this.mniRemove.setEnabled(isSelected);
                    ParticipantsPanel.this.mniEdit.setEnabled(isSelected);
                    ParticipantsPanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.tabRestricted.addMouseListener(popupListener);
        this.scpRestricted.addMouseListener(popupListener);
        this.mniAdd.setName("MniAddClassDef");
        this.mniAdd.setText(rsrc.getString("MniAdd_text"));
        this.mniAdd.setEnabled(true);
        this.mniAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelElementSelectionDialog dialog = new ModelElementSelectionDialog(ParticipantsPanel.this.thisDialog, "AbstractClassDef", true, ParticipantsPanel.this.context, AbstractClassDef.class);
                ArrayList selv = dialog.getSelectedItems();
                for (int i = 0; i < selv.size(); ++i) {
                    ParticipantsPanel.this.model.addRow(new Object[]{new ParticipantsPanelItem((AbstractClassDef)selv.get(i))});
                }
            }
        });
        this.popup.add(this.mniAdd);
        this.mniRemove.setName("MniRemoveClassDef");
        this.mniRemove.setText(rsrc.getString("MniRemove_text"));
        this.mniRemove.setEnabled(true);
        this.mniRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParticipantsPanel.this.model.removeRow(ParticipantsPanel.this.tabRestricted.getSelectedRow());
            }
        });
        this.popup.add(this.mniRemove);
        this.mniEdit.setName("MniEditParticipant");
        this.mniEdit.setText(rsrc.getString("MniEdit_text"));
        this.mniEdit.setEnabled(true);
        this.mniEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selIdx = ParticipantsPanel.this.tabRestricted.getSelectedRow();
                ParticipantsPanelItem item = (ParticipantsPanelItem)ParticipantsPanel.this.model.getValueAt(selIdx, 0);
                ParticipantDialog dlg = new ParticipantDialog(ParticipantsPanel.this.thisDialog, "Edit Restrictions", true, item, ParticipantsPanel.this.context);
                if (dlg.isSaved()) {
                    dlg.getItem();
                    ParticipantsPanel.this.model.setValueAt(dlg.getItem(), selIdx, 0);
                }
            }
        });
        this.popup.add(this.mniEdit);
        this.add((Component)this.scpRestricted, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void setOwnerDialog(JDialog ownerDialog) {
        this.thisDialog = ownerDialog;
    }

    @Override
    public final void setObject(Object object) throws DeveloperException {
        throw new DeveloperException("call setObject(Object, ModelElement) instead");
    }

    public void setObject(Object object, ModelElement context) {
        this.context = context;
        ParticipantsPanelItem[] classv = (ParticipantsPanelItem[])object;
        Object[][] data = new Object[classv.length][1];
        for (int i = 0; i < classv.length; ++i) {
            data[i][0] = classv[i];
        }
        this.model.setDataVector(data, new Object[]{ElementUtils.getDisplayName(AbstractClassDef.class)});
    }

    @Override
    public Object getObject() {
        ParticipantsPanelItem[] result = new ParticipantsPanelItem[this.model.getRowCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (ParticipantsPanelItem)this.model.getValueAt(i, 0);
        }
        return result;
    }
}

