/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerPositionStrategy;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class LayerManager {
    private final List<Layer> layers = new ArrayList<Layer>();
    private final List<LayerChangeListener> layerChangeListeners = new CopyOnWriteArrayList<LayerChangeListener>();

    public void addLayer(final Layer layer) {
        GuiHelper.runInEDTAndWaitWithException(new Runnable(){

            @Override
            public void run() {
                LayerManager.this.realAddLayer(layer);
            }
        });
    }

    protected synchronized void realAddLayer(Layer layer) {
        if (this.containsLayer(layer)) {
            throw new IllegalArgumentException("Cannot add a layer twice.");
        }
        LayerPositionStrategy layerPositionStrategy = layer.getDefaultLayerPosition();
        int n = layerPositionStrategy.getPosition(this);
        this.checkPosition(n);
        this.insertLayerAt(layer, n);
        this.fireLayerAdded(layer);
        if (Main.map != null) {
            layer.hookUpMapView();
        }
    }

    public void removeLayer(final Layer layer) {
        GuiHelper.runInEDTAndWaitWithException(new Runnable(){

            @Override
            public void run() {
                LayerManager.this.realRemoveLayer(layer);
            }
        });
    }

    protected synchronized void realRemoveLayer(Layer layer) {
        GuiHelper.assertCallFromEdt();
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        set.add(layer);
        while (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            Layer layer2 = (Layer)iterator.next();
            iterator.remove();
            this.checkContainsLayer(layer2);
            Collection<Layer> collection = this.realRemoveSingleLayer(layer2);
            set.addAll(collection);
        }
    }

    protected Collection<Layer> realRemoveSingleLayer(Layer layer) {
        Collection<Layer> collection = this.fireLayerRemoving(layer);
        this.layers.remove(layer);
        return collection;
    }

    public void moveLayer(final Layer layer, final int n) {
        GuiHelper.runInEDTAndWaitWithException(new Runnable(){

            @Override
            public void run() {
                LayerManager.this.realMoveLayer(layer, n);
            }
        });
    }

    protected synchronized void realMoveLayer(Layer layer, int n) {
        this.checkContainsLayer(layer);
        this.checkPosition(n);
        int n2 = this.layers.indexOf(layer);
        if (n == n2) {
            return;
        }
        this.layers.remove(n2);
        this.insertLayerAt(layer, n);
        this.fireLayerOrderChanged();
    }

    private void insertLayerAt(Layer layer, int n) {
        if (n == this.layers.size()) {
            this.layers.add(layer);
        } else {
            this.layers.add(n, layer);
        }
    }

    private void checkPosition(int n) {
        if (n < 0 || n > this.layers.size()) {
            throw new IndexOutOfBoundsException("Position " + n + " out of range.");
        }
    }

    public List<Layer> getLayers() {
        return Collections.unmodifiableList(new ArrayList<Layer>(this.layers));
    }

    public <T extends Layer> List<T> getLayersOfType(Class<T> clazz) {
        return new ArrayList(Utils.filteredCollection(this.getLayers(), clazz));
    }

    public synchronized boolean containsLayer(Layer layer) {
        return this.layers.contains(layer);
    }

    protected void checkContainsLayer(Layer layer) {
        if (!this.containsLayer(layer)) {
            throw new IllegalArgumentException(layer + " is not managed by us.");
        }
    }

    public synchronized void addLayerChangeListener(LayerChangeListener layerChangeListener) {
        this.addLayerChangeListener(layerChangeListener, false);
    }

    public synchronized void addLayerChangeListener(LayerChangeListener layerChangeListener, boolean bl) {
        if (this.layerChangeListeners.contains(layerChangeListener)) {
            throw new IllegalArgumentException("Listener already registered.");
        }
        this.layerChangeListeners.add(layerChangeListener);
        if (bl) {
            for (Layer layer : this.getLayers()) {
                layerChangeListener.layerAdded(new LayerAddEvent(this, layer));
            }
        }
    }

    public synchronized void removeLayerChangeListener(LayerChangeListener layerChangeListener) {
        this.removeLayerChangeListener(layerChangeListener, false);
    }

    public synchronized void removeLayerChangeListener(LayerChangeListener layerChangeListener, boolean bl) {
        if (!this.layerChangeListeners.remove(layerChangeListener)) {
            throw new IllegalArgumentException("Listener was not registered before: " + layerChangeListener);
        }
        if (bl) {
            for (Layer layer : this.getLayers()) {
                layerChangeListener.layerRemoving(new LayerRemoveEvent(this, layer));
            }
        }
    }

    private void fireLayerAdded(Layer layer) {
        GuiHelper.assertCallFromEdt();
        LayerAddEvent layerAddEvent = new LayerAddEvent(this, layer);
        for (LayerChangeListener layerChangeListener : this.layerChangeListeners) {
            try {
                layerChangeListener.layerAdded(layerAddEvent);
            }
            catch (RuntimeException runtimeException) {
                throw BugReport.intercept(runtimeException).put("listener", layerChangeListener).put("event", layerAddEvent);
            }
        }
    }

    private Collection<Layer> fireLayerRemoving(Layer layer) {
        GuiHelper.assertCallFromEdt();
        LayerRemoveEvent layerRemoveEvent = new LayerRemoveEvent(this, layer);
        for (LayerChangeListener layerChangeListener : this.layerChangeListeners) {
            try {
                layerChangeListener.layerRemoving(layerRemoveEvent);
            }
            catch (RuntimeException runtimeException) {
                throw BugReport.intercept(runtimeException).put("listener", layerChangeListener).put("event", layerRemoveEvent).put("layer", layer);
            }
        }
        return layerRemoveEvent.scheduleForRemoval;
    }

    private void fireLayerOrderChanged() {
        GuiHelper.assertCallFromEdt();
        LayerOrderChangeEvent layerOrderChangeEvent = new LayerOrderChangeEvent(this);
        for (LayerChangeListener layerChangeListener : this.layerChangeListeners) {
            try {
                layerChangeListener.layerOrderChanged(layerOrderChangeEvent);
            }
            catch (RuntimeException runtimeException) {
                throw BugReport.intercept(runtimeException).put("listener", layerChangeListener).put("event", layerOrderChangeEvent);
            }
        }
    }

    public void resetState() {
        while (!this.getLayers().isEmpty()) {
            this.removeLayer(this.getLayers().get(0));
        }
        this.layerChangeListeners.clear();
    }

    public static class LayerOrderChangeEvent
    extends LayerManagerEvent {
        LayerOrderChangeEvent(LayerManager layerManager) {
            super(layerManager);
        }

        public String toString() {
            return "LayerOrderChangeEvent []";
        }
    }

    public static class LayerRemoveEvent
    extends LayerManagerEvent {
        private final Layer removedLayer;
        private final boolean lastLayer;
        private Collection<Layer> scheduleForRemoval = new ArrayList<Layer>();

        LayerRemoveEvent(LayerManager layerManager, Layer layer) {
            super(layerManager);
            this.removedLayer = layer;
            this.lastLayer = layerManager.getLayers().size() == 1;
        }

        public Layer getRemovedLayer() {
            return this.removedLayer;
        }

        public boolean isLastLayer() {
            return this.lastLayer;
        }

        public void scheduleRemoval(Collection<? extends Layer> collection) {
            for (Layer layer : collection) {
                this.getSource().checkContainsLayer(layer);
            }
            this.scheduleForRemoval.addAll(collection);
        }

        public String toString() {
            return "LayerRemoveEvent [removedLayer=" + this.removedLayer + ", lastLayer=" + this.lastLayer + ']';
        }
    }

    public static class LayerAddEvent
    extends LayerManagerEvent {
        private final Layer addedLayer;

        LayerAddEvent(LayerManager layerManager, Layer layer) {
            super(layerManager);
            this.addedLayer = layer;
        }

        public Layer getAddedLayer() {
            return this.addedLayer;
        }

        public String toString() {
            return "LayerAddEvent [addedLayer=" + this.addedLayer + ']';
        }
    }

    protected static class LayerManagerEvent {
        private final LayerManager source;

        LayerManagerEvent(LayerManager layerManager) {
            this.source = layerManager;
        }

        public LayerManager getSource() {
            return this.source;
        }
    }

    public static interface LayerChangeListener {
        public void layerAdded(LayerAddEvent var1);

        public void layerRemoving(LayerRemoveEvent var1);

        public void layerOrderChanged(LayerOrderChangeEvent var1);
    }
}

