/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.script.SV;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.nbo.NBODialog;
import org.openscience.jmol.app.nbo.NBOJobQueueManager;

public class NBOService {
    static final int MODE_ERROR = -1;
    static final int MODE_RAW = 0;
    static final int MODE_MODEL = 1;
    static final int MODE_RUN = 20;
    static final int MODE_VIEW = 30;
    static final int MODE_SEARCH = 40;
    static final int MODE_VIEW_LIST = 33;
    static final int MODE_SEARCH_VALUE = 45;
    static final int MODE_SEARCH_LIST = 46;
    static final int MODE_SEARCH_SELECT = 47;
    static final int MODE_IMAGE = 88;
    private static final int MODE_ERR = -1;
    private int serverMode = 0;
    protected Viewer vwr;
    NBODialog nboDialog;
    protected Process nboServer;
    protected Thread nboListener;
    private InputStream stdout;
    protected BufferedReader nboReader;
    private PrintWriter stdinWriter;
    protected static NBOJobQueueManager manager;
    private SB sbRet;
    private boolean inData;
    protected boolean isWorking;
    String serverPath;
    String serverDir;
    String workingPath;
    private boolean nboSync;
    private String nboModel;
    protected int dialogMode;
    private Object lock = "jmol_lock";
    public boolean jobCanceled;

    public NBOService(Viewer vwr) {
        this.vwr = vwr;
        this.sbRet = new SB();
        Properties props = JmolPanel.historyFile.getProperties();
        this.setServerPath(props.getProperty("nboServerPath", System.getProperty("user.home") + "/NBOServe"));
        this.setWorkingPath(null);
        if (manager == null) {
            manager = new NBOJobQueueManager();
        }
    }

    private void setServerPath(String path) {
        this.serverPath = path;
        this.serverDir = new File(this.serverPath).getParent() + "/";
    }

    void setWorkingPath(String path) {
        this.workingPath = path == null ? this.vwr.getDefaultDirectory() + "/nbo" : path;
        File dir = new File(this.workingPath);
        if (!dir.exists()) {
            dir.mkdir();
        }
        System.out.println("NBOService setting directory to " + dir);
    }

    public boolean processRequest(Map<String, Object> info, int mode) {
        String s;
        boolean ok = false;
        boolean nboSync = info.get("sync") == Boolean.TRUE;
        boolean isClosed = false;
        this.dialogMode = mode;
        if (this.nboServer != null) {
            try {
                this.nboServer.exitValue();
                isClosed = true;
                System.out.println("NBOServe.exe has closed unexpectedly!");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (nboSync || this.nboSync || this.nboServer == null || isClosed) {
            this.closeProcess();
            this.startProcess(nboSync, this.dialogMode);
        }
        this.serverMode = (Integer)info.get("mode");
        if (this.stdinWriter == null) {
            this.closeProcess();
            this.sbRet.append("ERROR: Could not connect to NBOServe -- Use Tools...NBO... to set up NBOServe");
            this.serverMode = -1;
        }
        String nboAction = (String)info.get("action");
        switch (this.serverMode) {
            case 1: {
                s = (String)info.get("value");
                if (nboAction.equals("load")) {
                    s = "sh " + s;
                    break;
                }
                if (nboAction.equals("run")) break;
                s = null;
                break;
            }
            case 0: 
            case 33: 
            case 88: {
                s = (String)info.get("value");
                if (!s.startsWith("<")) break;
                s = "\n" + s;
                break;
            }
            default: {
                this.nboReport("unknown mode", -1);
                s = null;
            }
        }
        if (s != null) {
            if (nboSync) {
                this.clearServerFile("fort.106");
                this.clearServerFile("jmol_molfile.txt");
            }
            this.sendToNBO(this.serverMode, s);
            if (nboSync) {
                this.waitFor(this.serverMode);
            }
            ok = true;
        }
        if (nboSync) {
            info.put("ret", this.sbRet.toString());
            this.sbRet.setLength(0);
        }
        return ok;
    }

    private boolean waitFor(int mode) {
        String fname = this.serverDir + (mode == 1 ? "jmol_molfile.txt" : "fort.106");
        File f = new File(fname);
        for (int i = 0; i < 200; ++i) {
            if (f.exists()) {
                switch (mode) {
                    case 1: {
                        String dataCmd = this.fixNBOModel(this.getFileData(fname));
                        Logger.info(dataCmd);
                        this.sbRet.append(dataCmd + ";rotate best;");
                        break;
                    }
                }
                break;
            }
            try {
                Thread.sleep(10L);
                System.out.println("NBOService.waitfor()");
                continue;
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return true;
    }

    private boolean clearServerFile(String fname) {
        File f = new File(this.serverDir + fname);
        try {
            f.delete();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void sendToNBO(int mode, String s) {
        s = mode == 0 ? s : "\r\n" + mode + "\r\n" + s + "\r\nexit\r\n" + (this.nboSync ? "x\r\n" : "");
        this.sendCmd(s);
    }

    private void sendCmd(String s) {
        System.out.println("sending " + s);
        if (s.startsWith("\n<")) {
            System.out.println(this.getFileData(this.serverDir + PT.trim(s, "\n<>")));
        }
        try {
            this.stdinWriter.println(s);
            this.stdinWriter.flush();
            Thread.sleep(10L);
            System.out.println("NBOService.sendCmd()");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void nboReport(String line, int dialogMode) {
        if (Logger.debugging) {
            Logger.debug(this.inData + " " + this.nboSync + " " + this.sbRet.length() + " " + "receiving: " + line);
        }
        if (line.startsWith("DATA \" \"")) {
            this.isWorking = false;
        } else if (line.startsWith("DATA ")) {
            if (line.startsWith("DATA \"model")) {
                this.sbRet.setLength(0);
                line = this.fixNBOModel(line);
            }
            boolean bl = this.inData = line.indexOf("exit") < 0;
            if (this.inData) {
                this.sbRet.append(line + "\n");
            }
            return;
        }
        if (!this.inData && line.indexOf("NBO") < 0 && dialogMode == 1 && !line.equals("")) {
            this.nboDialog.addLine(10, line);
        }
        if (this.inData && this.sbRet != null) {
            this.sbRet.append(line + "\n");
            if (line.indexOf("END") >= 0) {
                this.inData = false;
                String m = "\"" + this.nboModel + "\"";
                this.nboModel = "\u0000";
                if (!this.nboSync && line.indexOf(m) >= 0) {
                    String s = this.sbRet.toString();
                    this.sbRet.setLength(0);
                    if (s.contains("\\")) {
                        s = s.replaceAll("\\\\", "");
                    }
                    this.runScriptQueued(s);
                }
                return;
            }
        }
    }

    private String fixNBOModel(String line) {
        this.nboModel = PT.getQuotedStringAt(line, 0);
        String s = " NBO " + this.nboModel;
        int pt = line.indexOf("\n");
        return pt < 0 ? line + s : line.substring(0, pt) + s + line.substring(pt);
    }

    String startProcess(boolean sync, int mode) {
        this.dialogMode = mode;
        try {
            System.out.println("starting NBO process sync=" + sync);
            this.nboSync = sync;
            File pathToExecutable = new File(this.serverPath);
            ProcessBuilder builder = new ProcessBuilder(this.serverPath);
            builder.directory(new File(pathToExecutable.getParent()));
            builder.redirectErrorStream(true);
            this.nboServer = builder.start();
            this.stdout = this.nboServer.getInputStream();
            this.nboReader = new BufferedReader(new InputStreamReader(this.stdout));
            this.nboListener = null;
            this.nboListener = new Thread(new Runnable(){

                @Override
                public void run() {
                    boolean haveStart = false;
                    boolean inOpener = false;
                    boolean inRequest = false;
                    System.out.println("nboListener " + this + " running");
                    while (!Thread.currentThread().isInterrupted()) {
                        String line = null;
                        try {
                            Thread.sleep(25L);
                            System.out.println("NBOService.startProcess()");
                            while ((line = NBOService.this.nboReader.readLine()) != null) {
                                Thread.sleep(1L);
                                System.out.println("NBOService.line");
                                if (line.indexOf("DATA \" \"") >= 0) {
                                    Logger.info(" [NBO opener ignored]");
                                    inOpener = true;
                                    continue;
                                }
                                if (line.indexOf("END \"\"") >= 0) {
                                    inOpener = false;
                                    continue;
                                }
                                if (inOpener) continue;
                                Logger.info(line);
                                if (line.indexOf("*start*") >= 0) {
                                    NBOService.this.isWorking = true;
                                    inRequest = true;
                                    haveStart = true;
                                    NBOService.this.nboDialog.addLine(0, null);
                                    continue;
                                }
                                if (line.indexOf("Permission denied") >= 0 || line.indexOf("PGFIO-F") >= 0 || line.indexOf("Invalid command") >= 0) {
                                    NBOService.this.nboDialog.alert(line + "\n\nNBOServe could not access key files -- Is another version running? Perhaps NBOPro?\n");
                                    inRequest = false;
                                    NBOService.this.isWorking = false;
                                    manager.clearQueue();
                                    continue;
                                }
                                if (line.indexOf("missing or invalid") >= 0) {
                                    NBOService.this.vwr.alert(line);
                                    manager.clearQueue();
                                    NBOService.this.isWorking = false;
                                    inRequest = false;
                                }
                                if (line.indexOf("FORTRAN STOP") >= 0) {
                                    NBOService.this.vwr.alert("NBOServe has stopped working");
                                    NBOService.this.restart();
                                }
                                if (line.indexOf("*end*") >= 0) {
                                    if (haveStart) {
                                        NBOService.this.isWorking = false;
                                    }
                                    haveStart = false;
                                    inRequest = false;
                                    continue;
                                }
                                switch (NBOService.this.dialogMode) {
                                    case 33: 
                                    case 45: {
                                        if (!NBOService.this.isWorking || !inRequest) break;
                                        NBOService.this.nboDialog.addLine(30, line);
                                        break;
                                    }
                                    case 46: {
                                        if (!NBOService.this.isWorking || !inRequest) break;
                                        NBOService.this.nboDialog.addLine(-1, line);
                                        break;
                                    }
                                    case 47: {
                                        if (!line.startsWith(" Select")) break;
                                        NBOService.this.nboDialog.addLine(40, line);
                                        inRequest = false;
                                        NBOService.this.isWorking = false;
                                        break;
                                    }
                                    case 88: {
                                        if (line.startsWith("END")) {
                                            inRequest = false;
                                            NBOService.this.isWorking = false;
                                        }
                                        if (!line.contains("Missing valid")) break;
                                        inRequest = false;
                                        NBOService.this.isWorking = false;
                                        NBOService.this.vwr.alert(line);
                                        break;
                                    }
                                    case 1: {
                                        if (line.indexOf("can't do that") >= 0) {
                                            NBOService.this.nboDialog.addLine(10, line);
                                            inRequest = false;
                                            NBOService.this.isWorking = false;
                                            break;
                                        }
                                    }
                                    default: {
                                        NBOService.this.nboReport(line, NBOService.this.dialogMode);
                                    }
                                }
                                try {
                                    int test = NBOService.this.nboServer.exitValue();
                                    NBOService.this.closeProcess();
                                    System.out.println("NBOService test = " + test);
                                    return;
                                }
                                catch (Exception test) {
                                }
                            }
                        }
                        catch (Throwable e1) {
                            NBOService.this.closeProcess();
                            return;
                        }
                    }
                }
            });
            this.nboListener.setName("NBOServiceThread" + System.currentTimeMillis());
            this.nboListener.start();
            this.stdinWriter = new PrintWriter(this.nboServer.getOutputStream());
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return e.getMessage();
        }
        return null;
    }

    void closeProcess() {
        this.isWorking = false;
        this.stdout = null;
        try {
            this.stdinWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stdinWriter = null;
        try {
            this.nboReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.nboReader = null;
        try {
            this.nboListener.interrupt();
        }
        catch (Exception e) {
            System.out.println("can't interrupt");
        }
        this.nboListener = null;
        try {
            this.nboServer.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.nboServer = null;
    }

    String restart() {
        this.closeProcess();
        return this.startProcess(false, 0);
    }

    public boolean restartIfNecessary() {
        if (this.nboServer == null) {
            this.startProcess(false, 0);
        }
        return this.nboServer != null;
    }

    void runScriptQueued(String script) {
        Logger.info("NBO->JMOL ASYNC: " + script);
        this.vwr.script(script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String runScriptNow(String script) {
        Object object = this.lock;
        synchronized (object) {
            Logger.info("NBO->JMOL SYNC: " + script);
            return this.vwr.runScript(script);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SV evaluateJmol(String expr) {
        Object object = this.lock;
        synchronized (object) {
            return this.vwr.evaluateExpressionAsVariable(expr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String evaluateJmolString(String expr) {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluateJmol(expr).asString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getJmolFilename() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluateJmolString("getProperty('filename')");
        }
    }

    protected void rawCmdNew(String cmd, SB data, boolean doWait, int dialogMode) {
        doWait = true;
        String fname = null;
        File cmdFile = null;
        try {
            if (data == null) {
                Logger.info("issuing\n" + cmd);
            } else {
                fname = cmd + "_test.txt";
                cmdFile = new File(this.serverDir + fname);
                Logger.info("issuing " + fname + "\n" + data);
                this.writeToFile(data.toString(), cmdFile);
                cmd = "<" + fname + ">";
                this.isWorking = doWait;
            }
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            info.put("mode", 0);
            info.put("sync", Boolean.FALSE);
            info.put("action", "cmd");
            info.put("value", cmd);
            if (!this.processRequest(info, dialogMode)) {
                this.nboReport(null, dialogMode);
                this.nboReport("not implemented", dialogMode);
                this.isWorking = false;
            }
            if (doWait) {
                while (this.isWorking) {
                    System.out.println("NBOService rawCmd");
                    Thread.sleep(10L);
                }
            }
            if (cmdFile != null) {
                cmdFile = new File(this.serverDir + fname + "DONE");
                this.writeToFile("", cmdFile);
            }
        }
        catch (IOException e) {
            System.out.println("Could not write to " + fname);
            this.isWorking = false;
        }
        catch (InterruptedException e) {
            this.isWorking = false;
        }
    }

    void writeToFile(String s, File file) throws IOException {
        PrintWriter writer = new PrintWriter(file);
        writer.print(s);
        writer.close();
    }

    String getFileData(String fileName) {
        return this.vwr.getFileAsString4(fileName, Integer.MAX_VALUE, false, false, false, "nbo");
    }

    public void queueJob(String name, String statusInfo, Runnable process) {
        manager.addJob(this, name, statusInfo, process);
    }
}

