/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.InnerInferenceHelper;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImplicitNullAnnotationVerifier;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolymorphicMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;

public class MessageSend
extends Expression
implements Invocation {
    public Expression receiver;
    public char[] selector;
    public Expression[] arguments;
    public MethodBinding binding;
    public MethodBinding syntheticAccessor;
    public TypeBinding expectedType;
    public long nameSourcePosition;
    public TypeBinding actualReceiverType;
    public TypeBinding valueCast;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;
    private ExpressionContext expressionContext = ExpressionContext.VANILLA_CONTEXT;
    private SimpleLookupTable inferenceContexts;
    protected InnerInferenceHelper innerInferenceHelper;
    private static final int TRUE_ASSERTION = 1;
    private static final int FALSE_ASSERTION = 2;
    private static final int NULL_ASSERTION = 3;
    private static final int NONNULL_ASSERTION = 4;

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        int n;
        boolean bl;
        boolean bl2;
        boolean bl3;
        block14: {
            block15: {
                bl3 = !this.binding.isStatic();
                bl2 = (flowContext.tagBits & 0x1000) != 0;
                flowInfo = this.receiver.analyseCode(blockScope, flowContext, flowInfo, bl3).unconditionalInits();
                CompilerOptions compilerOptions = blockScope.compilerOptions();
                bl = compilerOptions.analyseResourceLeaks;
                if (!bl) break block14;
                if (!bl3) break block15;
                if (!CharOperation.equals(TypeConstants.CLOSE, this.selector)) break block14;
                this.recordCallingClose(blockScope, flowContext, flowInfo, this.receiver);
                break block14;
            }
            if (this.arguments != null && this.arguments.length > 0 && FakedTrackingVariable.isAnyCloseable(this.arguments[0].resolvedType)) {
                for (n = 0; n < TypeConstants.closeMethods.length; ++n) {
                    TypeConstants.CloseMethodRecord closeMethodRecord = TypeConstants.closeMethods[n];
                    if (!CharOperation.equals(closeMethodRecord.selector, this.selector) || !CharOperation.equals(closeMethodRecord.typeName, this.binding.declaringClass.compoundName)) continue;
                    int n2 = Math.min(closeMethodRecord.numCloseableArgs, this.arguments.length);
                    for (int i = 0; i < n2; ++i) {
                        this.recordCallingClose(blockScope, flowContext, flowInfo, this.arguments[i]);
                    }
                }
            }
            break block14;
            {
                break;
            }
        }
        if (bl3) {
            this.receiver.checkNPE(blockScope, flowContext, flowInfo);
        }
        if (this.arguments != null) {
            n = this.arguments.length;
            for (int i = 0; i < n; ++i) {
                Expression expression = this.arguments[i];
                expression.checkNPEbyUnboxing(blockScope, flowContext, flowInfo);
                switch (this.detectAssertionUtility(i)) {
                    case 1: {
                        flowInfo = this.analyseBooleanAssertion(blockScope, expression, flowContext, flowInfo, bl2, true);
                        break;
                    }
                    case 2: {
                        flowInfo = this.analyseBooleanAssertion(blockScope, expression, flowContext, flowInfo, bl2, false);
                        break;
                    }
                    case 4: {
                        flowInfo = this.analyseNullAssertion(blockScope, expression, flowContext, flowInfo, false);
                        break;
                    }
                    case 3: {
                        flowInfo = this.analyseNullAssertion(blockScope, expression, flowContext, flowInfo, true);
                        break;
                    }
                    default: {
                        flowInfo = expression.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                    }
                }
                if (!bl) continue;
                flowInfo = FakedTrackingVariable.markPassedToOutside(blockScope, expression, flowInfo, flowContext, false);
            }
            this.analyseArguments(blockScope, flowContext, flowInfo, this.binding, this.arguments);
        }
        TypeBinding[] typeBindingArray = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions != Binding.NO_EXCEPTIONS) {
            if ((this.bits & 0x10000) != 0 && this.genericTypeArguments == null) {
                typeBindingArray = blockScope.environment().convertToRawTypes(this.binding.thrownExceptions, true, true);
            }
            flowContext.checkExceptionHandlers(typeBindingArray, (ASTNode)this, flowInfo.copy(), blockScope);
        }
        this.manageSyntheticAccessIfNecessary(blockScope, flowInfo);
        flowContext.recordAbruptExit();
        flowContext.expireNullCheckedFieldInfo();
        return flowInfo;
    }

    private void recordCallingClose(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, Expression expression) {
        FakedTrackingVariable fakedTrackingVariable = FakedTrackingVariable.getCloseTrackingVariable(expression, flowInfo, flowContext);
        if (fakedTrackingVariable != null) {
            if (fakedTrackingVariable.methodScope == blockScope.methodScope()) {
                fakedTrackingVariable.markClose(flowInfo, flowContext);
            } else {
                fakedTrackingVariable.markClosedInNestedMethod();
            }
        }
    }

    private int detectAssertionUtility(int n) {
        TypeBinding[] typeBindingArray = this.binding.original().parameters;
        if (n < typeBindingArray.length) {
            TypeBinding typeBinding = typeBindingArray[n];
            if (this.actualReceiverType != null && typeBinding != null) {
                switch (this.actualReceiverType.id) {
                    case 68: {
                        if (typeBinding.id == 5) {
                            return 1;
                        }
                        if (typeBinding.id != 1 || !CharOperation.equals(TypeConstants.IS_NOTNULL, this.selector)) break;
                        return 4;
                    }
                    case 69: 
                    case 70: {
                        if (typeBinding.id == 5) {
                            if (CharOperation.equals(TypeConstants.ASSERT_TRUE, this.selector)) {
                                return 1;
                            }
                            if (!CharOperation.equals(TypeConstants.ASSERT_FALSE, this.selector)) break;
                            return 2;
                        }
                        if (typeBinding.id != 1) break;
                        if (CharOperation.equals(TypeConstants.ASSERT_NOTNULL, this.selector)) {
                            return 4;
                        }
                        if (!CharOperation.equals(TypeConstants.ASSERT_NULL, this.selector)) break;
                        return 3;
                    }
                    case 71: {
                        if (typeBinding.id == 5) {
                            if (!CharOperation.equals(TypeConstants.IS_TRUE, this.selector)) break;
                            return 1;
                        }
                        if (typeBinding.id != 1 || !CharOperation.equals(TypeConstants.NOT_NULL, this.selector)) break;
                        return 4;
                    }
                    case 72: {
                        if (typeBinding.id == 5) {
                            if (!CharOperation.equals(TypeConstants.IS_TRUE, this.selector)) break;
                            return 1;
                        }
                        if (!typeBinding.isTypeVariable() || !CharOperation.equals(TypeConstants.NOT_NULL, this.selector)) break;
                        return 4;
                    }
                    case 73: {
                        if (typeBinding.id == 5) {
                            if (!CharOperation.equals(TypeConstants.CHECK_ARGUMENT, this.selector) && !CharOperation.equals(TypeConstants.CHECK_STATE, this.selector)) break;
                            return 1;
                        }
                        if (!typeBinding.isTypeVariable() || !CharOperation.equals(TypeConstants.CHECK_NOT_NULL, this.selector)) break;
                        return 4;
                    }
                    case 74: {
                        if (!typeBinding.isTypeVariable() || !CharOperation.equals(TypeConstants.REQUIRE_NON_NULL, this.selector)) break;
                        return 4;
                    }
                }
            }
        }
        return 0;
    }

    private FlowInfo analyseBooleanAssertion(BlockScope blockScope, Expression expression, FlowContext flowContext, FlowInfo flowInfo, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4;
        FlowInfo flowInfo2;
        UnconditionalFlowInfo unconditionalFlowInfo;
        Constant constant = expression.optimizedBooleanConstant();
        boolean bl5 = constant != Constant.NotAConstant && constant.booleanValue();
        boolean bl6 = constant != Constant.NotAConstant && !constant.booleanValue();
        int n = flowContext.tagBits;
        flowContext.tagBits |= 0x1000;
        if (!bl2) {
            flowContext.tagBits |= 4;
        }
        FlowInfo flowInfo3 = expression.analyseCode(blockScope, flowContext, flowInfo.copy());
        flowContext.extendTimeToLiveForNullCheckedField(2);
        flowContext.tagBits = n;
        if (bl2) {
            unconditionalFlowInfo = flowInfo3.initsWhenTrue().unconditionalInits();
            flowInfo2 = flowInfo3.initsWhenFalse();
            bl4 = bl5;
            bl3 = bl6;
        } else {
            unconditionalFlowInfo = flowInfo3.initsWhenFalse().unconditionalInits();
            flowInfo2 = flowInfo3.initsWhenTrue();
            bl4 = bl6;
            bl3 = bl5;
        }
        if (bl4) {
            flowInfo2.setReachMode(1);
        }
        if (!bl3) {
            flowInfo = flowInfo.mergedWith(flowInfo2.nullInfoLessUnconditionalCopy()).addInitializationsFrom(unconditionalFlowInfo.discardInitializationInfo());
        }
        return flowInfo;
    }

    private FlowInfo analyseNullAssertion(BlockScope blockScope, Expression expression, FlowContext flowContext, FlowInfo flowInfo, boolean bl) {
        FieldBinding fieldBinding;
        int n = expression.nullStatus(flowInfo, flowContext);
        boolean bl2 = n == (bl ? 4 : 2);
        flowInfo = expression.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
        LocalVariableBinding localVariableBinding = expression.localVariableBinding();
        if (localVariableBinding != null) {
            if (bl) {
                flowInfo.markAsDefinitelyNull(localVariableBinding);
            } else {
                flowInfo.markAsDefinitelyNonNull(localVariableBinding);
            }
        } else if (!bl && expression instanceof Reference && blockScope.compilerOptions().enableSyntacticNullAnalysisForFields && (fieldBinding = ((Reference)expression).lastFieldBinding()) != null && (fieldBinding.type.tagBits & 2L) == 0L) {
            flowContext.recordNullCheckedFieldReference((Reference)expression, 3);
        }
        if (bl2) {
            flowInfo.setReachMode(2);
        }
        return flowInfo;
    }

    @Override
    public boolean checkNPE(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if ((this.nullStatus(flowInfo, flowContext) & 0x10) != 0) {
            blockScope.problemReporter().messageSendPotentialNullReference(this.binding, this);
        }
        return true;
    }

    @Override
    public void computeConversion(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (typeBinding == null || typeBinding2 == null) {
            return;
        }
        if (this.binding != null && this.binding.isValidBinding()) {
            TypeBinding typeBinding3;
            MethodBinding methodBinding = this.binding.original();
            TypeBinding typeBinding4 = methodBinding.returnType;
            if (typeBinding4.leafComponentType().isTypeVariable()) {
                typeBinding3 = !typeBinding2.isBaseType() && typeBinding.isBaseType() ? typeBinding2 : typeBinding;
                this.valueCast = typeBinding4.genericCast(typeBinding3);
            } else if (this.binding == scope.environment().arrayClone && typeBinding.id != 1 && scope.compilerOptions().sourceLevel >= 0x310000L) {
                this.valueCast = typeBinding;
            }
            if (this.valueCast instanceof ReferenceBinding && !((ReferenceBinding)(typeBinding3 = (ReferenceBinding)this.valueCast)).canBeSeenBy(scope)) {
                scope.problemReporter().invalidType(this, new ProblemReferenceBinding(CharOperation.splitOn('.', ((ReferenceBinding)typeBinding3).shortReadableName()), (ReferenceBinding)typeBinding3, 2));
            }
        }
        super.computeConversion(scope, typeBinding, typeBinding2);
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        TypeBinding typeBinding;
        int n = codeStream.position;
        MethodBinding methodBinding = this.binding instanceof PolymorphicMethodBinding ? this.binding : this.binding.original();
        boolean bl2 = methodBinding.isStatic();
        if (bl2) {
            this.receiver.generateCode(blockScope, codeStream, false);
        } else if ((this.bits & 0x1FE0) != 0 && this.receiver.isImplicitThis()) {
            typeBinding = blockScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
            Object[] objectArray = blockScope.getEmulationPath((ReferenceBinding)typeBinding, true, false);
            codeStream.generateOuterAccess(objectArray, this, typeBinding, blockScope);
        } else {
            this.receiver.generateCode(blockScope, codeStream, true);
            if ((this.bits & 0x40000) != 0) {
                codeStream.checkcast(this.actualReceiverType);
            }
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
        this.generateArguments(this.binding, this.arguments, blockScope, codeStream);
        n = codeStream.position;
        if (this.syntheticAccessor == null) {
            typeBinding = CodeStream.getConstantPoolDeclaringClass((Scope)blockScope, methodBinding, this.actualReceiverType, this.receiver.isImplicitThis());
            if (bl2) {
                codeStream.invoke((byte)-72, methodBinding, typeBinding, this.typeArguments);
            } else if (this.receiver.isSuper() || methodBinding.isPrivate()) {
                codeStream.invoke((byte)-73, methodBinding, typeBinding, this.typeArguments);
            } else if (typeBinding.isInterface()) {
                codeStream.invoke((byte)-71, methodBinding, typeBinding, this.typeArguments);
            } else {
                codeStream.invoke((byte)-74, methodBinding, typeBinding, this.typeArguments);
            }
        } else {
            codeStream.invoke((byte)-72, this.syntheticAccessor, null, this.typeArguments);
        }
        if (this.valueCast != null) {
            codeStream.checkcast(this.valueCast);
        }
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            boolean bl3;
            boolean bl4 = bl3 = (this.implicitConversion & 0x400) != 0;
            if (bl3) {
                codeStream.generateImplicitConversion(this.implicitConversion);
            }
            switch (bl3 ? this.postConversionType((Scope)blockScope).id : methodBinding.returnType.id) {
                case 7: 
                case 8: {
                    codeStream.pop2();
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(n, (int)(this.nameSourcePosition >>> 32));
    }

    @Override
    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    @Override
    public boolean isSuperAccess() {
        return this.receiver.isSuper();
    }

    @Override
    public boolean isTypeAccess() {
        return this.receiver != null && this.receiver.isTypeReference();
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        MethodBinding methodBinding = this.binding.original();
        if (this.binding.isPrivate()) {
            if (TypeBinding.notEquals(blockScope.enclosingSourceType(), methodBinding.declaringClass)) {
                this.syntheticAccessor = ((SourceTypeBinding)methodBinding.declaringClass).addSyntheticMethod(methodBinding, false);
                blockScope.problemReporter().needToEmulateMethodAccess(methodBinding, this);
                return;
            }
        } else {
            if (this.receiver instanceof QualifiedSuperReference) {
                if (this.actualReceiverType.isInterface()) {
                    return;
                }
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)((QualifiedSuperReference)this.receiver).currentCompatibleType;
                this.syntheticAccessor = sourceTypeBinding.addSyntheticMethod(methodBinding, this.isSuperAccess());
                blockScope.problemReporter().needToEmulateMethodAccess(methodBinding, this);
                return;
            }
            if (this.binding.isProtected() && (this.bits & 0x1FE0) != 0) {
                SourceTypeBinding sourceTypeBinding = blockScope.enclosingSourceType();
                if (methodBinding.declaringClass.getPackage() != sourceTypeBinding.getPackage()) {
                    SourceTypeBinding sourceTypeBinding2 = (SourceTypeBinding)sourceTypeBinding.enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                    this.syntheticAccessor = sourceTypeBinding2.addSyntheticMethod(methodBinding, this.isSuperAccess());
                    blockScope.problemReporter().needToEmulateMethodAccess(methodBinding, this);
                    return;
                }
            }
        }
    }

    @Override
    public int nullStatus(FlowInfo flowInfo, FlowContext flowContext) {
        if (this.binding.isValidBinding()) {
            long l = this.binding.tagBits;
            if ((l & 0x180000000000000L) == 0L) {
                l = this.binding.returnType.tagBits;
            }
            return FlowInfo.tagBitsToNullStatus(l);
        }
        return 1;
    }

    @Override
    public TypeBinding postConversionType(Scope scope) {
        TypeBinding typeBinding = this.resolvedType;
        if (this.valueCast != null) {
            typeBinding = this.valueCast;
        }
        int n = (this.implicitConversion & 0xFF) >> 4;
        switch (n) {
            case 5: {
                typeBinding = TypeBinding.BOOLEAN;
                break;
            }
            case 3: {
                typeBinding = TypeBinding.BYTE;
                break;
            }
            case 4: {
                typeBinding = TypeBinding.SHORT;
                break;
            }
            case 2: {
                typeBinding = TypeBinding.CHAR;
                break;
            }
            case 10: {
                typeBinding = TypeBinding.INT;
                break;
            }
            case 9: {
                typeBinding = TypeBinding.FLOAT;
                break;
            }
            case 7: {
                typeBinding = TypeBinding.LONG;
                break;
            }
            case 8: {
                typeBinding = TypeBinding.DOUBLE;
                break;
            }
        }
        if ((this.implicitConversion & 0x200) != 0) {
            typeBinding = scope.environment().computeBoxingType(typeBinding);
        }
        return typeBinding;
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2;
        if (!this.receiver.isImplicitThis()) {
            this.receiver.printExpression(0, stringBuffer).append('.');
        }
        if (this.typeArguments != null) {
            stringBuffer.append('<');
            n2 = this.typeArguments.length - 1;
            for (int i = 0; i < n2; ++i) {
                this.typeArguments[i].print(0, stringBuffer);
                stringBuffer.append(", ");
            }
            this.typeArguments[n2].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        stringBuffer.append(this.selector).append('(');
        if (this.arguments != null) {
            for (n2 = 0; n2 < this.arguments.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n2].printExpression(0, stringBuffer);
            }
        }
        return stringBuffer.append(')');
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        ReferenceContext referenceContext;
        Object object;
        int n;
        boolean bl;
        boolean bl2;
        this.constant = Constant.NotAConstant;
        long l = blockScope.compilerOptions().sourceLevel;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.receiver instanceof CastExpression) {
            this.receiver.bits |= 0x20;
            bl3 = true;
        }
        if (this.receiver.resolvedType != null) {
            blockScope.problemReporter().genericInferenceError("Receiver was unexpectedly found resolved", this);
        }
        this.actualReceiverType = this.receiver.resolveType(blockScope);
        boolean bl5 = bl2 = this.receiver instanceof NameReference && (((NameReference)this.receiver).bits & 4) != 0;
        if (bl3 && this.actualReceiverType != null && TypeBinding.equalsEquals(((CastExpression)this.receiver).expression.resolvedType, this.actualReceiverType)) {
            blockScope.problemReporter().unnecessaryCast((CastExpression)this.receiver);
        }
        if (this.typeArguments != null) {
            int n2 = this.typeArguments.length;
            bl = l < 0x310000L;
            this.genericTypeArguments = new TypeBinding[n2];
            for (n = 0; n < n2; ++n) {
                TypeReference typeReference = this.typeArguments[n];
                this.genericTypeArguments[n] = typeReference.resolveType(blockScope, true);
                if (this.genericTypeArguments[n] == null) {
                    bl = true;
                }
                if (!bl || !(typeReference instanceof Wildcard)) continue;
                blockScope.problemReporter().illegalUsageOfWildcard(typeReference);
            }
            if (bl) {
                if (this.arguments != null) {
                    int n3 = this.arguments.length;
                    for (n = 0; n < n3; ++n) {
                        this.arguments[n].resolveType(blockScope);
                    }
                }
                return null;
            }
        }
        TypeBinding[] typeBindingArray = Binding.NO_PARAMETERS;
        if (this.arguments != null) {
            bl = false;
            n = this.arguments.length;
            typeBindingArray = new TypeBinding[n];
            for (int i = 0; i < n; ++i) {
                object = this.arguments[i];
                if (this.arguments[i].resolvedType != null) {
                    blockScope.problemReporter().genericInferenceError("Argument was unexpectedly found resolved", this);
                }
                if (object instanceof CastExpression) {
                    ((Expression)object).bits |= 0x20;
                    bl4 = true;
                }
                ((Expression)object).setExpressionContext(ExpressionContext.INVOCATION_CONTEXT);
                typeBindingArray[i] = ((Expression)object).resolveType(blockScope);
                if (typeBindingArray[i] == null) {
                    bl = true;
                }
                if (l < 0x340000L || !((Expression)object).isPolyExpression() && (!(object instanceof Invocation) || !((Invocation)object).usesInference()) || this.innerInferenceHelper != null) continue;
                this.innerInferenceHelper = new InnerInferenceHelper();
            }
            if (bl) {
                if (this.actualReceiverType instanceof ReferenceBinding) {
                    MethodBinding methodBinding;
                    TypeBinding[] typeBindingArray2 = new TypeBinding[n];
                    int n4 = n;
                    while (--n4 >= 0) {
                        typeBindingArray2[n4] = typeBindingArray[n4] == null ? TypeBinding.NULL : typeBindingArray[n4];
                    }
                    MethodBinding methodBinding2 = this.binding = this.receiver.isImplicitThis() ? blockScope.getImplicitMethod(this.selector, typeBindingArray2, this) : blockScope.findMethod((ReferenceBinding)this.actualReceiverType, this.selector, typeBindingArray2, this, false);
                    if (this.binding != null && !this.binding.isValidBinding() && (methodBinding = ((ProblemMethodBinding)this.binding).closestMatch) != null) {
                        if (methodBinding.original().typeVariables != Binding.NO_TYPE_VARIABLES) {
                            methodBinding = blockScope.environment().createParameterizedGenericMethod(methodBinding.original(), (RawTypeBinding)null);
                        }
                        this.binding = methodBinding;
                        MethodBinding methodBinding3 = methodBinding.original();
                        if (methodBinding3.isOrEnclosedByPrivateType() && !blockScope.isDefinedInMethod(methodBinding3)) {
                            methodBinding3.modifiers |= 0x8000000;
                        }
                    }
                }
                return null;
            }
        }
        if (this.actualReceiverType == null) {
            return null;
        }
        if (this.actualReceiverType.isBaseType()) {
            blockScope.problemReporter().errorNoMethodFor(this, this.actualReceiverType, typeBindingArray);
            return null;
        }
        this.findMethodBinding(blockScope, typeBindingArray);
        if (!this.binding.isValidBinding()) {
            ReferenceBinding referenceBinding;
            if (this.binding.declaringClass == null) {
                if (this.actualReceiverType instanceof ReferenceBinding) {
                    this.binding.declaringClass = (ReferenceBinding)this.actualReceiverType;
                } else {
                    blockScope.problemReporter().errorNoMethodFor(this, this.actualReceiverType, typeBindingArray);
                    return null;
                }
            }
            int n5 = n = (referenceBinding = this.binding.declaringClass) != null && referenceBinding.isAnonymousType() && referenceBinding.superclass() instanceof MissingTypeBinding ? 1 : 0;
            if (n == 0) {
                blockScope.problemReporter().invalidMethod(this, this.binding);
            }
            MethodBinding methodBinding = ((ProblemMethodBinding)this.binding).closestMatch;
            switch (this.binding.problemId()) {
                case 3: {
                    break;
                }
                case 2: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    if (methodBinding == null) break;
                    this.resolvedType = methodBinding.returnType;
                }
            }
            if (methodBinding != null) {
                this.binding = methodBinding;
                object = methodBinding.original();
                if (((MethodBinding)object).isOrEnclosedByPrivateType() && !blockScope.isDefinedInMethod((MethodBinding)object)) {
                    ((MethodBinding)object).modifiers |= 0x8000000;
                }
            }
            return this.resolvedType != null && (this.resolvedType.tagBits & 0x80L) == 0L ? this.resolvedType : null;
        }
        CompilerOptions compilerOptions = blockScope.compilerOptions();
        if (compilerOptions.complianceLevel <= 0x320000L && this.binding.isPolymorphic()) {
            blockScope.problemReporter().polymorphicMethodNotBelow17(this);
            return null;
        }
        if (compilerOptions.isAnnotationBasedNullAnalysisEnabled) {
            if ((this.binding.tagBits & 0x1000L) == 0L) {
                new ImplicitNullAnnotationVerifier(blockScope.environment(), compilerOptions.inheritNullAnnotations).checkImplicitNullAnnotations(this.binding, null, false, blockScope);
            }
            if (compilerOptions.sourceLevel >= 0x340000L && this.binding instanceof ParameterizedGenericMethodBinding && this.typeArguments != null) {
                TypeBinding[] typeBindingArray3 = this.binding.original().typeVariables();
                for (int i = 0; i < this.typeArguments.length; ++i) {
                    this.typeArguments[i].checkNullConstraints(blockScope, typeBindingArray3, i);
                }
            }
        }
        if ((this.bits & 0x10) != 0 && this.binding.isPolymorphic()) {
            this.binding = blockScope.environment().updatePolymorphicMethodReturnType((PolymorphicMethodBinding)this.binding, TypeBinding.VOID);
        }
        if ((this.binding.tagBits & 0x80L) != 0L) {
            blockScope.problemReporter().missingTypeInMethod(this, this.binding);
        }
        if (!this.binding.isStatic()) {
            if (bl2) {
                blockScope.problemReporter().mustUseAStaticMethod(this, this.binding);
                if (this.actualReceiverType.isRawType() && (this.receiver.bits & 0x40000000) == 0 && compilerOptions.getSeverity(0x20010000) != 256) {
                    blockScope.problemReporter().rawTypeReference(this.receiver, this.actualReceiverType);
                }
            } else {
                TypeBinding typeBinding = this.actualReceiverType;
                this.actualReceiverType = this.actualReceiverType.getErasureCompatibleType(this.binding.declaringClass);
                this.receiver.computeConversion(blockScope, this.actualReceiverType, this.actualReceiverType);
                if (TypeBinding.notEquals(this.actualReceiverType, typeBinding) && TypeBinding.notEquals(this.receiver.postConversionType(blockScope), this.actualReceiverType)) {
                    this.bits |= 0x40000;
                }
            }
        } else {
            if (!(this.receiver.isImplicitThis() || this.receiver.isSuper() || bl2)) {
                blockScope.problemReporter().nonStaticAccessToStaticMethod(this, this.binding);
            }
            if (!this.receiver.isImplicitThis() && TypeBinding.notEquals(this.binding.declaringClass, this.actualReceiverType)) {
                blockScope.problemReporter().indirectAccessToStaticMethod(this, this.binding);
            }
        }
        if (MessageSend.checkInvocationArguments(blockScope, this.receiver, this.actualReceiverType, this.binding, this.arguments, typeBindingArray, bl4, this)) {
            this.bits |= 0x10000;
        }
        if (this.binding.isAbstract() && this.receiver.isSuper()) {
            blockScope.problemReporter().cannotDireclyInvokeAbstractMethod(this, this.binding);
        }
        if (this.isMethodUseDeprecated(this.binding, blockScope, true)) {
            blockScope.problemReporter().deprecatedMethod(this.binding, this);
        }
        if (this.binding == blockScope.environment().arrayClone && compilerOptions.sourceLevel >= 0x310000L) {
            this.resolvedType = this.actualReceiverType;
        } else {
            TypeBinding typeBinding;
            if ((this.bits & 0x10000) != 0 && this.genericTypeArguments == null) {
                typeBinding = this.binding.returnType;
                if (typeBinding != null) {
                    typeBinding = blockScope.environment().convertToRawType(typeBinding.erasure(), true);
                }
            } else {
                typeBinding = this.binding.returnType;
                if (typeBinding != null) {
                    typeBinding = typeBinding.capture(blockScope, this.sourceEnd);
                }
            }
            this.resolvedType = typeBinding;
        }
        if (this.receiver.isSuper() && compilerOptions.getSeverity(0x20100000) != 256 && (referenceContext = blockScope.methodScope().referenceContext) instanceof AbstractMethodDeclaration) {
            AbstractMethodDeclaration abstractMethodDeclaration = (AbstractMethodDeclaration)referenceContext;
            object = abstractMethodDeclaration.binding;
            if (((MethodBinding)object).isOverriding() && CharOperation.equals(this.binding.selector, ((MethodBinding)object).selector) && this.binding.areParametersEqual((MethodBinding)object)) {
                abstractMethodDeclaration.bits |= 0x10;
            }
        }
        if (this.receiver.isSuper() && this.actualReceiverType.isInterface()) {
            blockScope.checkAppropriateMethodAgainstSupers(this.selector, this.binding, typeBindingArray, this);
        }
        if (this.typeArguments != null && this.binding.original().typeVariables == Binding.NO_TYPE_VARIABLES) {
            blockScope.problemReporter().unnecessaryTypeArgumentsForMethodInvocation(this.binding, this.genericTypeArguments, this.typeArguments);
        }
        this.recordExceptionsForEnclosingLambda(blockScope, this.binding.thrownExceptions);
        return (this.resolvedType.tagBits & 0x80L) == 0L ? this.resolvedType : null;
    }

    protected void findMethodBinding(BlockScope blockScope, TypeBinding[] typeBindingArray) {
        this.binding = this.receiver.isImplicitThis() ? blockScope.getImplicitMethod(this.selector, typeBindingArray, this) : blockScope.getMethod(this.actualReceiverType, this.selector, typeBindingArray, this);
        MessageSend.resolvePolyExpressionArguments(this, this.binding, typeBindingArray, blockScope);
        CompilerOptions compilerOptions = blockScope.compilerOptions();
        if (compilerOptions.sourceLevel >= 0x340000L && this.binding instanceof ParameterizedGenericMethodBinding && this.binding.isValidBinding()) {
            if (!compilerOptions.postResolutionRawTypeCompatibilityCheck) {
                return;
            }
            ParameterizedGenericMethodBinding parameterizedGenericMethodBinding = (ParameterizedGenericMethodBinding)this.binding;
            InferenceContext18 inferenceContext18 = this.getInferenceContext(parameterizedGenericMethodBinding);
            if (inferenceContext18 == null || inferenceContext18.stepCompleted < 3) {
                return;
            }
            int n = parameterizedGenericMethodBinding.typeArguments == null ? 0 : parameterizedGenericMethodBinding.typeArguments.length;
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                if (parameterizedGenericMethodBinding.typeArguments[i].isCapture()) {
                    return;
                }
                if (!parameterizedGenericMethodBinding.typeArguments[i].isRawType()) continue;
                bl = true;
            }
            if (!bl) {
                return;
            }
            int n2 = n = this.arguments == null ? 0 : this.arguments.length;
            if (n == 0) {
                return;
            }
            TypeBinding[] typeBindingArray2 = new TypeBinding[n];
            for (int i = 0; i < n; ++i) {
                TypeBinding typeBinding = this.arguments[i].resolvedType;
                if (typeBinding == null || !typeBinding.isValidBinding()) {
                    return;
                }
                typeBindingArray2[i] = typeBinding;
            }
            if (blockScope.parameterCompatibilityLevel(this.binding, typeBindingArray2, false) == -1) {
                this.binding = new ProblemMethodBinding(this.binding.original(), this.binding.selector, typeBindingArray2, 1);
            }
        }
    }

    @Override
    public TypeBinding checkAgainstFinalTargetType(TypeBinding typeBinding, Scope scope) {
        InferenceContext18 inferenceContext18;
        if (this.binding instanceof ParameterizedGenericMethodBinding && (inferenceContext18 = this.getInferenceContext((ParameterizedMethodBinding)this.binding)) != null && inferenceContext18.stepCompleted < 2) {
            this.expectedType = typeBinding;
            MethodBinding methodBinding = inferenceContext18.inferInvocationType(this, (ParameterizedGenericMethodBinding)this.binding);
            if (this.updateBindings(methodBinding, typeBinding)) {
                ASTNode.resolvePolyExpressionArguments(this, methodBinding, scope);
            }
        }
        return this.resolvedType;
    }

    @Override
    public void setActualReceiverType(ReferenceBinding referenceBinding) {
        if (referenceBinding == null) {
            return;
        }
        this.actualReceiverType = referenceBinding;
    }

    @Override
    public void setDepth(int n) {
        this.bits &= 0xFFFFE01F;
        if (n > 0) {
            this.bits |= (n & 0xFF) << 5;
        }
    }

    @Override
    public void setExpectedType(TypeBinding typeBinding) {
        this.expectedType = typeBinding;
    }

    @Override
    public void setExpressionContext(ExpressionContext expressionContext) {
        this.expressionContext = expressionContext;
    }

    @Override
    public boolean isPolyExpression() {
        return this.isPolyExpression(this.binding);
    }

    @Override
    public boolean isPolyExpression(MethodBinding methodBinding) {
        if (this.expressionContext != ExpressionContext.ASSIGNMENT_CONTEXT && this.expressionContext != ExpressionContext.INVOCATION_CONTEXT) {
            return false;
        }
        if (this.typeArguments != null && this.typeArguments.length > 0) {
            return false;
        }
        if (this.constant != Constant.NotAConstant) {
            throw new UnsupportedOperationException("Unresolved MessageSend can't be queried if it is a polyexpression");
        }
        if (methodBinding != null) {
            MethodBinding methodBinding2;
            if (methodBinding instanceof ParameterizedGenericMethodBinding) {
                methodBinding2 = (ParameterizedGenericMethodBinding)methodBinding;
                if (((ParameterizedGenericMethodBinding)methodBinding2).inferredReturnType) {
                    return true;
                }
            }
            if (methodBinding.returnType != null) {
                methodBinding2 = methodBinding.original();
                return methodBinding2.returnType.mentionsAny(methodBinding2.typeVariables(), -1);
            }
        }
        return false;
    }

    @Override
    public boolean sIsMoreSpecific(TypeBinding typeBinding, TypeBinding typeBinding2, Scope scope) {
        if (super.sIsMoreSpecific(typeBinding, typeBinding2, scope)) {
            return true;
        }
        return this.isPolyExpression() ? !typeBinding.isBaseType() && typeBinding2.isBaseType() : false;
    }

    @Override
    public void setFieldIndex(int n) {
    }

    @Override
    public TypeBinding invocationTargetType() {
        return this.expectedType;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            this.receiver.traverse(aSTVisitor, blockScope);
            if (this.typeArguments != null) {
                n2 = this.typeArguments.length;
                for (n = 0; n < n2; ++n) {
                    this.typeArguments[n].traverse(aSTVisitor, blockScope);
                }
            }
            if (this.arguments != null) {
                n = this.arguments.length;
                for (n2 = 0; n2 < n; ++n2) {
                    this.arguments[n2].traverse(aSTVisitor, blockScope);
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public boolean statementExpression() {
        return true;
    }

    @Override
    public boolean receiverIsImplicitThis() {
        return this.receiver.isImplicitThis();
    }

    @Override
    public MethodBinding binding(TypeBinding typeBinding, boolean bl, Scope scope) {
        if (bl) {
            if (this.binding == null) {
                scope.problemReporter().genericInferenceError("method is unexpectedly unresolved", this);
            } else if (!this.binding.isValidBinding()) {
                scope.problemReporter().invalidMethod(this, this.binding);
            }
        }
        return this.binding;
    }

    @Override
    public Expression[] arguments() {
        return this.arguments;
    }

    @Override
    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    @Override
    public void registerInferenceContext(ParameterizedGenericMethodBinding parameterizedGenericMethodBinding, InferenceContext18 inferenceContext18) {
        if (this.inferenceContexts == null) {
            this.inferenceContexts = new SimpleLookupTable();
        }
        this.inferenceContexts.put(parameterizedGenericMethodBinding, inferenceContext18);
    }

    @Override
    public InferenceContext18 getInferenceContext(ParameterizedMethodBinding parameterizedMethodBinding) {
        if (this.inferenceContexts == null) {
            return null;
        }
        return (InferenceContext18)this.inferenceContexts.get(parameterizedMethodBinding);
    }

    @Override
    public boolean usesInference() {
        return this.binding instanceof ParameterizedGenericMethodBinding && this.getInferenceContext((ParameterizedGenericMethodBinding)this.binding) != null;
    }

    @Override
    public boolean updateBindings(MethodBinding methodBinding, TypeBinding typeBinding) {
        InferenceContext18 inferenceContext18;
        boolean bl;
        boolean bl2 = bl = this.binding != methodBinding;
        if (this.inferenceContexts != null && (inferenceContext18 = (InferenceContext18)this.inferenceContexts.removeKey(this.binding)) != null && methodBinding instanceof ParameterizedGenericMethodBinding) {
            this.inferenceContexts.put(methodBinding, inferenceContext18);
            bl |= inferenceContext18.registerSolution(typeBinding, methodBinding);
        }
        this.binding = methodBinding;
        this.resolvedType = methodBinding.returnType;
        return bl;
    }

    @Override
    public boolean innersNeedUpdate() {
        return this.innerInferenceHelper != null;
    }

    @Override
    public void innerUpdateDone() {
        this.innerInferenceHelper = null;
    }

    @Override
    public InnerInferenceHelper innerInferenceHelper() {
        return this.innerInferenceHelper;
    }

    @Override
    public InferenceContext18 freshInferenceContext(Scope scope) {
        return new InferenceContext18(scope, this.arguments, this);
    }
}

