/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.RecoveredAnnotation;
import org.eclipse.jdt.internal.compiler.parser.RecoveredBlock;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredField;
import org.eclipse.jdt.internal.compiler.parser.RecoveredType;
import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;

public class RecoveredInitializer
extends RecoveredField
implements TerminalTokens {
    public RecoveredType[] localTypes;
    public int localTypeCount;
    public RecoveredBlock initializerBody;
    int pendingModifiers;
    int pendingModifersSourceStart = -1;
    RecoveredAnnotation[] pendingAnnotations;
    int pendingAnnotationCount;

    public RecoveredInitializer(FieldDeclaration fieldDeclaration, RecoveredElement recoveredElement, int n) {
        this(fieldDeclaration, recoveredElement, n, null);
    }

    public RecoveredInitializer(FieldDeclaration fieldDeclaration, RecoveredElement recoveredElement, int n, Parser parser) {
        super(fieldDeclaration, recoveredElement, n, parser);
        this.foundOpeningBrace = true;
    }

    @Override
    public RecoveredElement add(Block block, int n) {
        if (this.fieldDeclaration.declarationSourceEnd > 0 && block.sourceStart > this.fieldDeclaration.declarationSourceEnd) {
            this.resetPendingModifiers();
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(block, n);
        }
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        this.initializerBody = new RecoveredBlock(block, (RecoveredElement)this, n);
        if (block.sourceEnd == 0) {
            return this.initializerBody;
        }
        return this;
    }

    @Override
    public RecoveredElement add(FieldDeclaration fieldDeclaration, int n) {
        char[][] cArray;
        this.resetPendingModifiers();
        if ((fieldDeclaration.modifiers & 0xFFFFFFEF) != 0 || fieldDeclaration.type == null || (cArray = fieldDeclaration.type.getTypeName()).length == 1 && CharOperation.equals(cArray[0], TypeBinding.VOID.sourceName())) {
            if (this.parent == null) {
                return this;
            }
            this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(fieldDeclaration.declarationSourceStart - 1));
            return this.parent.add(fieldDeclaration, n);
        }
        if (this.fieldDeclaration.declarationSourceEnd > 0 && fieldDeclaration.declarationSourceStart > this.fieldDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(fieldDeclaration, n);
        }
        return this;
    }

    @Override
    public RecoveredElement add(LocalDeclaration localDeclaration, int n) {
        if (this.fieldDeclaration.declarationSourceEnd != 0 && localDeclaration.declarationSourceStart > this.fieldDeclaration.declarationSourceEnd) {
            this.resetPendingModifiers();
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(localDeclaration, n);
        }
        Block block = new Block(0);
        block.sourceStart = ((Initializer)this.fieldDeclaration).sourceStart;
        RecoveredElement recoveredElement = this.add(block, 1);
        if (this.initializerBody != null) {
            this.initializerBody.attachPendingModifiers(this.pendingAnnotations, this.pendingAnnotationCount, this.pendingModifiers, this.pendingModifersSourceStart);
        }
        this.resetPendingModifiers();
        return recoveredElement.add(localDeclaration, n);
    }

    @Override
    public RecoveredElement add(Statement statement, int n) {
        if (this.fieldDeclaration.declarationSourceEnd != 0 && statement.sourceStart > this.fieldDeclaration.declarationSourceEnd) {
            this.resetPendingModifiers();
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(statement, n);
        }
        Block block = new Block(0);
        block.sourceStart = ((Initializer)this.fieldDeclaration).sourceStart;
        RecoveredElement recoveredElement = this.add(block, 1);
        if (this.initializerBody != null) {
            this.initializerBody.attachPendingModifiers(this.pendingAnnotations, this.pendingAnnotationCount, this.pendingModifiers, this.pendingModifersSourceStart);
        }
        this.resetPendingModifiers();
        return recoveredElement.add(statement, n);
    }

    @Override
    public RecoveredElement add(TypeDeclaration typeDeclaration, int n) {
        if (this.fieldDeclaration.declarationSourceEnd != 0 && typeDeclaration.declarationSourceStart > this.fieldDeclaration.declarationSourceEnd) {
            this.resetPendingModifiers();
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(typeDeclaration, n);
        }
        if ((typeDeclaration.bits & 0x100) != 0 || this.parser().methodRecoveryActivated || this.parser().statementRecoveryActivated) {
            Block block = new Block(0);
            block.sourceStart = ((Initializer)this.fieldDeclaration).sourceStart;
            RecoveredElement recoveredElement = this.add(block, 1);
            if (this.initializerBody != null) {
                this.initializerBody.attachPendingModifiers(this.pendingAnnotations, this.pendingAnnotationCount, this.pendingModifiers, this.pendingModifersSourceStart);
            }
            this.resetPendingModifiers();
            return recoveredElement.add(typeDeclaration, n);
        }
        if (this.localTypes == null) {
            this.localTypes = new RecoveredType[5];
            this.localTypeCount = 0;
        } else if (this.localTypeCount == this.localTypes.length) {
            this.localTypes = new RecoveredType[2 * this.localTypeCount];
            System.arraycopy(this.localTypes, 0, this.localTypes, 0, this.localTypeCount);
        }
        RecoveredType recoveredType = new RecoveredType(typeDeclaration, (RecoveredElement)this, n);
        this.localTypes[this.localTypeCount++] = recoveredType;
        if (this.pendingAnnotationCount > 0) {
            recoveredType.attach(this.pendingAnnotations, this.pendingAnnotationCount, this.pendingModifiers, this.pendingModifersSourceStart);
        }
        this.resetPendingModifiers();
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        return recoveredType;
    }

    @Override
    public RecoveredElement addAnnotationName(int n, int n2, int n3, int n4) {
        if (this.pendingAnnotations == null) {
            this.pendingAnnotations = new RecoveredAnnotation[5];
            this.pendingAnnotationCount = 0;
        } else if (this.pendingAnnotationCount == this.pendingAnnotations.length) {
            this.pendingAnnotations = new RecoveredAnnotation[2 * this.pendingAnnotationCount];
            System.arraycopy(this.pendingAnnotations, 0, this.pendingAnnotations, 0, this.pendingAnnotationCount);
        }
        RecoveredAnnotation recoveredAnnotation = new RecoveredAnnotation(n, n2, n3, this, n4);
        this.pendingAnnotations[this.pendingAnnotationCount++] = recoveredAnnotation;
        return recoveredAnnotation;
    }

    @Override
    public void addModifier(int n, int n2) {
        this.pendingModifiers |= n;
        if (this.pendingModifersSourceStart < 0) {
            this.pendingModifersSourceStart = n2;
        }
    }

    @Override
    public void resetPendingModifiers() {
        this.pendingAnnotations = null;
        this.pendingAnnotationCount = 0;
        this.pendingModifiers = 0;
        this.pendingModifersSourceStart = -1;
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.tabString(n));
        stringBuffer.append("Recovered initializer:\n");
        this.fieldDeclaration.print(n + 1, stringBuffer);
        if (this.annotations != null) {
            for (int i = 0; i < this.annotationCount; ++i) {
                stringBuffer.append("\n");
                stringBuffer.append(this.annotations[i].toString(n + 1));
            }
        }
        if (this.initializerBody != null) {
            stringBuffer.append("\n");
            stringBuffer.append(this.initializerBody.toString(n + 1));
        }
        return stringBuffer.toString();
    }

    @Override
    public FieldDeclaration updatedFieldDeclaration(int n, Set set) {
        if (this.initializerBody != null) {
            Block block = this.initializerBody.updatedBlock(n, set);
            if (block != null) {
                Initializer initializer = (Initializer)this.fieldDeclaration;
                initializer.block = block;
                if (initializer.declarationSourceEnd == 0) {
                    initializer.declarationSourceEnd = block.sourceEnd;
                    initializer.bodyEnd = block.sourceEnd;
                }
            }
            if (this.localTypeCount > 0) {
                this.fieldDeclaration.bits |= 2;
            }
        }
        if (this.fieldDeclaration.sourceEnd == 0) {
            this.fieldDeclaration.sourceEnd = this.fieldDeclaration.declarationSourceEnd;
        }
        return this.fieldDeclaration;
    }

    @Override
    public RecoveredElement updateOnClosingBrace(int n, int n2) {
        if (--this.bracketBalance <= 0 && this.parent != null) {
            this.updateSourceEndIfNecessary(n, n2);
            return this.parent;
        }
        return this;
    }

    @Override
    public RecoveredElement updateOnOpeningBrace(int n, int n2) {
        ++this.bracketBalance;
        return this;
    }

    @Override
    public void updateSourceEndIfNecessary(int n, int n2) {
        if (this.fieldDeclaration.declarationSourceEnd == 0) {
            Initializer initializer = (Initializer)this.fieldDeclaration;
            if (this.parser().rBraceSuccessorStart >= n2) {
                initializer.declarationSourceEnd = initializer.bodyStart < this.parser().rBraceEnd ? this.parser().rBraceEnd : initializer.bodyStart;
                initializer.bodyEnd = initializer.bodyStart < this.parser().rBraceStart ? this.parser().rBraceStart : initializer.bodyStart;
            } else {
                initializer.declarationSourceEnd = n2;
                initializer.bodyEnd = n - 1;
            }
            if (initializer.block != null) {
                initializer.block.sourceEnd = initializer.declarationSourceEnd;
            }
        }
    }
}

