/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012;

import java.awt.Graphics;
import java.awt.Polygon;
import net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012.ControlCurve;
import net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012.Cubic;

public class NatCubic
extends ControlCurve {
    final int STEPS = 12;

    Cubic[] calcNaturalCubic(int n, int[] x) {
        int i;
        float[] gamma = new float[n + 1];
        float[] delta = new float[n + 1];
        float[] D = new float[n + 1];
        gamma[0] = 0.5f;
        for (i = 1; i < n; ++i) {
            gamma[i] = 1.0f / (4.0f - gamma[i - 1]);
        }
        gamma[n] = 1.0f / (2.0f - gamma[n - 1]);
        delta[0] = (float)(3 * (x[1] - x[0])) * gamma[0];
        for (i = 1; i < n; ++i) {
            delta[i] = ((float)(3 * (x[i + 1] - x[i - 1])) - delta[i - 1]) * gamma[i];
        }
        delta[n] = ((float)(3 * (x[n] - x[n - 1])) - delta[n - 1]) * gamma[n];
        D[n] = delta[n];
        for (i = n - 1; i >= 0; --i) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
        }
        Cubic[] C = new Cubic[n];
        for (i = 0; i < n; ++i) {
            C[i] = new Cubic(x[i], D[i], (float)(3 * (x[i + 1] - x[i])) - 2.0f * D[i] - D[i + 1], (float)(2 * (x[i] - x[i + 1])) + D[i] + D[i + 1]);
        }
        return C;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.pts.npoints >= 2) {
            if (this.getResult() == null) {
                this.calcualteAndSaveResult();
            }
            g.drawPolyline(this.result.xpoints, this.result.ypoints, this.result.npoints);
        }
    }

    @Override
    public Polygon calcualteResult() {
        Cubic[] X = this.calcNaturalCubic(this.pts.npoints - 1, this.pts.xpoints);
        Cubic[] Y = this.calcNaturalCubic(this.pts.npoints - 1, this.pts.ypoints);
        Polygon p = new Polygon();
        p.addPoint(Math.round(X[0].eval(0.0f)), Math.round(Y[0].eval(0.0f)));
        for (int i = 0; i < X.length; ++i) {
            for (int j = 1; j <= 12; ++j) {
                float u = (float)j / 12.0f;
                p.addPoint(Math.round(X[i].eval(u)), Math.round(Y[i].eval(u)));
            }
        }
        return p;
    }
}

