/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.dnd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.DropTarget;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.Controller;
import org.netbeans.core.windows.view.EditorView;
import org.netbeans.core.windows.view.ModeView;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.dnd.DropTargetGlassPane;
import org.netbeans.core.windows.view.dnd.EnhancedDragPainter;
import org.netbeans.core.windows.view.dnd.KeyboardDnd;
import org.netbeans.core.windows.view.dnd.TopComponentDragSupport;
import org.netbeans.core.windows.view.dnd.TopComponentDraggable;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.dnd.ZOrderManager;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.netbeans.core.windows.view.ui.ModeComponent;
import org.netbeans.core.windows.view.ui.MultiSplitPane;
import org.openide.util.Lookup;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;

public final class WindowDnDManager
implements DropTargetGlassPane.Observer,
DropTargetGlassPane.Informer {
    private final TopComponentDragSupport topComponentDragSupport = new TopComponentDragSupport(this);
    private DragSource windowDragSource;
    private boolean dragging;
    private boolean dropSuccess;
    private final Map<JRootPane, Component> root2glass = new HashMap<JRootPane, Component>();
    private final Set<Component> floatingFrames = new WeakSet(4);
    private Reference<DropTargetGlassPane> lastTargetWRef = new WeakReference<Object>(null);
    private final ViewAccessor viewAccessor;
    private TopComponentDroppable startingDroppable;
    private Point startingPoint;
    private TopComponentDraggable startingTransfer;
    private MotionListener motionListener;
    private static Reference<CenterPanelDroppable> centerDropWRef = new WeakReference<Object>(null);
    private static Reference<EditorAreaDroppable> editorDropWRef = new WeakReference<Object>(null);
    private static final boolean DEBUG = Debug.isLoggable(WindowDnDManager.class);
    private CenterSlidingDroppable lastSlideDroppable;

    public WindowDnDManager(ViewAccessor viewAccessor) {
        this.viewAccessor = viewAccessor;
        Toolkit.getDefaultToolkit().addAWTEventListener(this.topComponentDragSupport, 48L);
    }

    public static boolean isDnDEnabled() {
        return !Constants.SWITCH_DND_DISABLE && (Switches.isTopComponentDragAndDropEnabled() || Switches.isEditorModeDragAndDropEnabled() || Switches.isViewModeDragAndDropEnabled());
    }

    public synchronized DragSource getWindowDragSource() {
        if (this.windowDragSource == null) {
            this.windowDragSource = new DragSource();
            this.windowDragSource.addDragSourceMotionListener(this.getMotionListener());
        }
        return this.windowDragSource;
    }

    MotionListener getMotionListener() {
        if (this.motionListener == null) {
            this.motionListener = new MotionListener(this, this.topComponentDragSupport);
        }
        return this.motionListener;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public void setDropSuccess(boolean bl) {
        this.dropSuccess = bl;
    }

    public boolean isDropSuccess() {
        return this.dropSuccess;
    }

    @Override
    public void setLastDropTarget(DropTargetGlassPane dropTargetGlassPane) {
        if (dropTargetGlassPane != this.lastTargetWRef.get()) {
            this.lastTargetWRef = new WeakReference<DropTargetGlassPane>(dropTargetGlassPane);
        }
    }

    public void resetDragSource() {
        this.dragFinished();
    }

    public TopComponentDroppable getStartingDroppable() {
        return this.startingDroppable;
    }

    public Point getStartingPoint() {
        return this.startingPoint;
    }

    public TopComponentDraggable getStartingTransfer() {
        return this.startingTransfer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dragStarting(TopComponentDroppable topComponentDroppable, Point point, TopComponentDraggable topComponentDraggable) {
        Set<Component> set;
        if (DEBUG) {
            WindowDnDManager.debugLog("");
            WindowDnDManager.debugLog("dragStarting");
        }
        this.startingDroppable = topComponentDroppable;
        this.startingPoint = point;
        this.startingTransfer = topComponentDraggable;
        HashMap<JRootPane, Object> hashMap = new HashMap<JRootPane, Object>();
        HashSet<Component> hashSet = new HashSet<Component>();
        for (Component component : this.viewAccessor.getModeComponents()) {
            Object object;
            if (!(component instanceof TopComponentDroppable)) continue;
            JRootPane jRootPane = null;
            if (component instanceof RootPaneContainer) {
                jRootPane = ((RootPaneContainer)((Object)component)).getRootPane();
            } else {
                object = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, component));
                if (object != null) {
                    jRootPane = object.getRootPane();
                }
            }
            if (jRootPane == null || (object = WindowDnDManager.setDropTargetGlassPane(jRootPane, this)) == null) continue;
            hashMap.put(jRootPane, object);
        }
        for (Component component : this.viewAccessor.getSeparateModeFrames()) {
            if (component == null) continue;
            hashSet.add(component);
        }
        if (!hashMap.isEmpty()) {
            set = this.root2glass;
            synchronized (set) {
                this.root2glass.putAll(hashMap);
            }
        }
        if (!hashSet.isEmpty()) {
            set = this.floatingFrames;
            synchronized (set) {
                this.floatingFrames.addAll(hashSet);
            }
        }
        this.dragging = true;
        this.dropSuccess = false;
    }

    private static Component setDropTargetGlassPane(JRootPane jRootPane, WindowDnDManager windowDnDManager) {
        Component component = jRootPane.getGlassPane();
        if (component instanceof DropTargetGlassPane) {
            return null;
        }
        DropTargetGlassPane dropTargetGlassPane = new DropTargetGlassPane(windowDnDManager);
        new DropTarget(dropTargetGlassPane, 3, dropTargetGlassPane);
        jRootPane.setGlassPane(dropTargetGlassPane);
        dropTargetGlassPane.initialize();
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dragFinished() {
        HashMap<JRootPane, Component> hashMap;
        if (DEBUG) {
            WindowDnDManager.debugLog("");
            WindowDnDManager.debugLog("dragFinished");
        }
        this.getMotionListener().dragFinished();
        this.startingDroppable = null;
        this.startingPoint = null;
        this.startingTransfer = null;
        this.topComponentDragSupport.dragFinished();
        this.dragging = false;
        Map<JRootPane, Component> map = this.root2glass;
        synchronized (map) {
            hashMap = new HashMap<JRootPane, Component>(this.root2glass);
            this.root2glass.clear();
        }
        for (JRootPane jRootPane : hashMap.keySet()) {
            WindowDnDManager.setOriginalGlassPane(jRootPane, (Component)hashMap.get(jRootPane));
        }
    }

    private static void setOriginalGlassPane(JRootPane jRootPane, Component component) {
        JComponent jComponent;
        Component component2 = jRootPane.getGlassPane();
        if (component2 instanceof DropTargetGlassPane) {
            jComponent = (DropTargetGlassPane)component2;
            jComponent.setDropTarget(null);
            ((DropTargetGlassPane)jComponent).uninitialize();
        }
        if (component != null) {
            jRootPane.setGlassPane(component);
        }
        if ((jComponent = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, component)) != null && !((JInternalFrame)jComponent).isSelected() && !component.isVisible()) {
            component.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dragFinishedEx() {
        Set<Component> set = this.floatingFrames;
        synchronized (set) {
            this.floatingFrames.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Component> getFloatingFrames() {
        Set<Component> set = this.floatingFrames;
        synchronized (set) {
            return new HashSet<Component>(this.floatingFrames);
        }
    }

    public boolean isInFloatingFrame(Point point) {
        for (Component component : this.getFloatingFrames()) {
            if (!component.getBounds().contains(point)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCopyOperationPossible() {
        return this.topComponentDragSupport.isCopyOperationPossible();
    }

    @Override
    public Controller getController() {
        return this.viewAccessor.getController();
    }

    private static void debugLog(String string) {
        Debug.log(WindowDnDManager.class, string);
    }

    static boolean isInMainWindow(Point point) {
        return WindowManagerImpl.getInstance().getMainWindow().getBounds().contains(point);
    }

    private boolean isInMainWindowDroppable(Point point, TopComponentDraggable topComponentDraggable) {
        return this.findMainWindowDroppable(point, topComponentDraggable) != null;
    }

    private boolean isInFloatingFrameDroppable(Set<Component> set, Point point, TopComponentDraggable topComponentDraggable) {
        return this.findFloatingFrameDroppable(set, point, topComponentDraggable) != null;
    }

    private static boolean isInFreeArea(Point point, Window window) {
        Frame frame = WindowManagerImpl.getInstance().getMainWindow();
        Window[] windowArray = frame.getOwnedWindows();
        Frame[] frameArray = Frame.getFrames();
        Window[] windowArray2 = new Window[windowArray.length + frameArray.length];
        System.arraycopy(frameArray, 0, windowArray2, 0, frameArray.length);
        System.arraycopy(windowArray, 0, windowArray2, frameArray.length, windowArray.length);
        for (int i = 0; i < windowArray2.length; ++i) {
            if (windowArray2[i] == window || !windowArray2[i].isVisible() || !windowArray2[i].getBounds().contains(point.x, point.y)) continue;
            return false;
        }
        return true;
    }

    private TopComponentDroppable findDroppableFromScreen(Set<Component> set, Point point, TopComponentDraggable topComponentDraggable) {
        TopComponentDroppable topComponentDroppable = this.findMainWindowDroppable(point, topComponentDraggable);
        if (topComponentDroppable != null) {
            return topComponentDroppable;
        }
        if (topComponentDraggable.isUndockingEnabled()) {
            topComponentDroppable = this.findFloatingFrameDroppable(set, point, topComponentDraggable);
            if (topComponentDroppable != null) {
                return topComponentDroppable;
            }
            if (WindowDnDManager.isInFreeArea(point, this.motionListener.fakeWindow)) {
                return WindowDnDManager.getFreeAreaDroppable(point);
            }
        }
        return null;
    }

    private TopComponentDroppable findMainWindowDroppable(Point point, TopComponentDraggable topComponentDraggable) {
        Object object;
        JFrame jFrame = (JFrame)WindowManagerImpl.getInstance().getMainWindow();
        if (!ZOrderManager.getInstance().isOnTop(jFrame, point)) {
            return null;
        }
        Point point2 = new Point(point);
        SwingUtilities.convertPointFromScreen(point2, jFrame.getContentPane());
        if (topComponentDraggable.isSlidingEnabled()) {
            CenterSlidingDroppable centerSlidingDroppable;
            if (this.lastSlideDroppable != null && this.lastSlideDroppable.isWithinSlide(point2)) {
                return this.lastSlideDroppable;
            }
            object = WindowDnDManager.findSlideDroppable(this.viewAccessor.getSlidingModeComponent("left"));
            if (object != null && (centerSlidingDroppable = new CenterSlidingDroppable(this.viewAccessor, (TopComponentDroppable)object, "left")).isWithinSlide(point2)) {
                if (!centerSlidingDroppable.supportsKind(topComponentDraggable)) {
                    this.lastSlideDroppable = null;
                    return null;
                }
                this.lastSlideDroppable = centerSlidingDroppable;
                return centerSlidingDroppable;
            }
            object = WindowDnDManager.findSlideDroppable(this.viewAccessor.getSlidingModeComponent("right"));
            if (object != null && (centerSlidingDroppable = new CenterSlidingDroppable(this.viewAccessor, (TopComponentDroppable)object, "right")).isWithinSlide(point2)) {
                if (!centerSlidingDroppable.supportsKind(topComponentDraggable)) {
                    this.lastSlideDroppable = null;
                    return null;
                }
                this.lastSlideDroppable = centerSlidingDroppable;
                return centerSlidingDroppable;
            }
            object = WindowDnDManager.findSlideDroppable(this.viewAccessor.getSlidingModeComponent("bottom"));
            if (object != null && (centerSlidingDroppable = new CenterSlidingDroppable(this.viewAccessor, (TopComponentDroppable)object, "bottom")).isWithinSlide(point2)) {
                if (!centerSlidingDroppable.supportsKind(topComponentDraggable)) {
                    this.lastSlideDroppable = null;
                    return null;
                }
                this.lastSlideDroppable = centerSlidingDroppable;
                return centerSlidingDroppable;
            }
            object = WindowDnDManager.findSlideDroppable(this.viewAccessor.getSlidingModeComponent("top"));
            if (object != null && (centerSlidingDroppable = new CenterSlidingDroppable(this.viewAccessor, (TopComponentDroppable)object, "top")).isWithinSlide(point2)) {
                if (!centerSlidingDroppable.supportsKind(topComponentDraggable)) {
                    this.lastSlideDroppable = null;
                    return null;
                }
                this.lastSlideDroppable = centerSlidingDroppable;
                return centerSlidingDroppable;
            }
        }
        this.lastSlideDroppable = null;
        if (WindowDnDManager.isNearEditorEdge(point, this.viewAccessor, topComponentDraggable.getKind())) {
            return this.getEditorAreaDroppable();
        }
        if (WindowDnDManager.isNearEdge(point, this.viewAccessor)) {
            return this.getCenterPanelDroppable();
        }
        object = new Point(point);
        SwingUtilities.convertPointFromScreen((Point)object, jFrame);
        return this.findDroppable(jFrame, (Point)object, topComponentDraggable);
    }

    private static TopComponentDroppable findSlideDroppable(Component component) {
        if (!Switches.isDragAndDropSlidingEnabled()) {
            return null;
        }
        TopComponentDroppable topComponentDroppable = null;
        topComponentDroppable = component instanceof TopComponentDroppable ? (TopComponentDroppable)((Object)component) : (TopComponentDroppable)((Object)SwingUtilities.getAncestorOfClass(TopComponentDroppable.class, component));
        return topComponentDroppable;
    }

    private TopComponentDroppable findFloatingFrameDroppable(Set<Component> set, Point point, TopComponentDraggable topComponentDraggable) {
        for (Component component : set) {
            TopComponentDroppable topComponentDroppable;
            Rectangle rectangle = component.getBounds();
            if (!rectangle.contains(point) || !ZOrderManager.getInstance().isOnTop((RootPaneContainer)((Object)component), point) || (topComponentDroppable = this.findDroppable(component, new Point(point.x - rectangle.x, point.y - rectangle.y), topComponentDraggable)) == null) continue;
            return topComponentDroppable;
        }
        return null;
    }

    private TopComponentDroppable findDroppable(Component component, Point point, TopComponentDraggable topComponentDraggable) {
        TopComponentDroppable topComponentDroppable;
        Object object;
        Object object2;
        Serializable serializable;
        RootPaneContainer rootPaneContainer;
        if (component instanceof RootPaneContainer) {
            rootPaneContainer = (RootPaneContainer)((Object)component);
        } else {
            serializable = SwingUtilities.getWindowAncestor(component);
            if (serializable instanceof RootPaneContainer) {
                rootPaneContainer = (RootPaneContainer)((Object)serializable);
            } else {
                return null;
            }
        }
        serializable = new Point(point);
        SwingUtilities.convertPointToScreen((Point)serializable, component);
        Container container = rootPaneContainer.getContentPane();
        point = SwingUtilities.convertPoint(component, point, container);
        Component component2 = SwingUtilities.getDeepestComponentAt(container, point.x, point.y);
        if (component2 instanceof MultiSplitPane) {
            object2 = (MultiSplitPane)component2;
            int n = 0;
            int n2 = 0;
            if (((MultiSplitPane)object2).isHorizontalSplit()) {
                n = ((MultiSplitPane)object2).getDividerSize() + 1;
            } else {
                n2 = ((MultiSplitPane)object2).getDividerSize() + 1;
            }
            object = SwingUtilities.convertPoint(container, point, component2);
            component2 = SwingUtilities.getDeepestComponentAt(component2, ((Point)object).x + n, ((Point)object).y + n2);
        }
        if (component2 instanceof TopComponentDroppable && (object2 = (TopComponentDroppable)((Object)component2)).supportsKind(topComponentDraggable)) {
            return object2;
        }
        object2 = null;
        while (component2 != null) {
            TopComponentDroppable topComponentDroppable2 = (TopComponentDroppable)((Object)SwingUtilities.getAncestorOfClass(TopComponentDroppable.class, component2));
            if (topComponentDroppable2 != null && topComponentDroppable2.supportsKind(topComponentDraggable)) {
                object2 = topComponentDroppable2;
                break;
            }
            component2 = (Component)((Object)topComponentDroppable2);
        }
        if (object2 instanceof ModeComponent && topComponentDraggable.getKind() != 1 && ((ModeComponent)object2).getKind() == 1 && (topComponentDroppable = this.getEditorAreaDroppable()).supportsKind(topComponentDraggable)) {
            Point point2 = new Point((Point)serializable);
            SwingUtilities.convertPointFromScreen(point2, object2.getDropComponent());
            object = object2.getConstraintForLocation(point2);
            point2 = new Point((Point)serializable);
            SwingUtilities.convertPointFromScreen(point2, topComponentDroppable.getDropComponent());
            if (null != object && object.equals(topComponentDroppable.getConstraintForLocation(point2))) {
                object2 = topComponentDroppable;
            }
        }
        return object2;
    }

    static boolean isAroundCenterPanel(Point point) {
        Component component = MainWindow.getInstance().getDesktop();
        if (component == null) {
            return false;
        }
        Point point2 = new Point(point);
        SwingUtilities.convertPointFromScreen(point2, component.getParent());
        Rectangle rectangle = component.getBounds();
        if (!rectangle.contains(point2)) {
            rectangle.grow(20, 20);
            if (rectangle.contains(point2)) {
                return true;
            }
        }
        return false;
    }

    static boolean isMixedTCDragDrop(TopComponentDraggable topComponentDraggable, TopComponentDroppable topComponentDroppable) {
        return topComponentDraggable != null && topComponentDroppable != null && (topComponentDroppable.getKind() == 1 && topComponentDraggable.getKind() != 1 || topComponentDroppable.getKind() != 1 && topComponentDraggable.getKind() == 1);
    }

    static boolean isNearEditorEdge(Point point, ViewAccessor viewAccessor, int n) {
        Component component = WindowManagerImpl.getInstance().getEditorAreaComponent();
        if (component == null || component.getParent() == null) {
            return false;
        }
        Point point2 = new Point(point);
        SwingUtilities.convertPointFromScreen(point2, component.getParent());
        Rectangle rectangle = component.getBounds();
        rectangle.y -= 10;
        rectangle.height += 10;
        Rectangle rectangle2 = component.getBounds();
        rectangle2.grow(-10, 0);
        rectangle2.height -= 10;
        Component component2 = viewAccessor.getSlidingModeComponent("right");
        if (component2 != null) {
            rectangle2.width -= component2.getBounds().width;
        }
        if ((component2 = viewAccessor.getSlidingModeComponent("bottom")) != null) {
            rectangle2.height -= component2.getBounds().height;
        }
        return rectangle.contains(point2) && !rectangle2.contains(point2) && n == 1;
    }

    static boolean isNearEdge(Point point, ViewAccessor viewAccessor) {
        Component component = MainWindow.getInstance().getDesktop();
        if (component == null) {
            return false;
        }
        Point point2 = new Point(point);
        SwingUtilities.convertPointFromScreen(point2, component);
        Rectangle rectangle = component.getBounds();
        rectangle.y -= 20;
        rectangle.height += 20;
        Rectangle rectangle2 = component.getBounds();
        rectangle2.grow(-10, 0);
        rectangle2.height -= 10;
        Component component2 = viewAccessor.getSlidingModeComponent("left");
        if (component2 != null) {
            rectangle2.x += component2.getBounds().width;
            rectangle2.width -= component2.getBounds().width;
        }
        if ((component2 = viewAccessor.getSlidingModeComponent("right")) != null) {
            rectangle2.width -= component2.getBounds().width;
        }
        if ((component2 = viewAccessor.getSlidingModeComponent("bottom")) != null) {
            rectangle2.height -= component2.getBounds().height;
        }
        if ((component2 = viewAccessor.getSlidingModeComponent("top")) != null) {
            rectangle2.y += component2.getBounds().height;
        }
        boolean bl = rectangle.contains(point2) && !rectangle2.contains(point2);
        return bl;
    }

    TopComponentDroppable getCenterPanelDroppable() {
        CenterPanelDroppable centerPanelDroppable = centerDropWRef.get();
        if (centerPanelDroppable == null) {
            centerPanelDroppable = new CenterPanelDroppable();
            centerDropWRef = new WeakReference<CenterPanelDroppable>(centerPanelDroppable);
        }
        return centerPanelDroppable;
    }

    private static TopComponentDroppable getFreeAreaDroppable(Point point) {
        return new FreeAreaDroppable(point);
    }

    private TopComponentDroppable getEditorAreaDroppable() {
        EditorAreaDroppable editorAreaDroppable = editorDropWRef.get();
        if (editorAreaDroppable == null) {
            editorAreaDroppable = new EditorAreaDroppable();
            editorDropWRef = new WeakReference<EditorAreaDroppable>(editorAreaDroppable);
        }
        return editorAreaDroppable;
    }

    boolean tryPerformDrop(Controller controller, Set<Component> set, Point point, int n, Transferable transferable) {
        TopComponentDraggable topComponentDraggable = WindowDnDManager.extractTopComponentDraggable(n == 1, transferable);
        if (topComponentDraggable == null) {
            return false;
        }
        TopComponentDroppable topComponentDroppable = this.findDroppableFromScreen(set, point, topComponentDraggable);
        if (topComponentDroppable == null) {
            return false;
        }
        Component component = topComponentDroppable.getDropComponent();
        if (component != null) {
            SwingUtilities.convertPointFromScreen(point, component);
        }
        return WindowDnDManager.performDrop(controller, topComponentDroppable, topComponentDraggable, point);
    }

    static TopComponentDraggable extractTopComponentDraggable(boolean bl, Transferable transferable) {
        Object object;
        DataFlavor dataFlavor = WindowDnDManager.getDataFlavorForDropAction(bl);
        if (dataFlavor == null) {
            return null;
        }
        if (transferable.isDataFlavorSupported(dataFlavor)) {
            try {
                Object object2;
                if (bl) {
                    object2 = (TopComponent.Cloneable)transferable.getTransferData(dataFlavor);
                    object = object2.cloneComponent();
                } else {
                    object = (TopComponent)transferable.getTransferData(dataFlavor);
                }
                if (null != object && null != (object2 = (ModeImpl)WindowManagerImpl.getInstance().findMode((TopComponent)transferable.getTransferData(dataFlavor)))) {
                    return new TopComponentDraggable((TopComponent)object, (ModeImpl)object2);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                Logger.getLogger(WindowDnDManager.class.getName()).log(Level.WARNING, null, unsupportedFlavorException);
            }
            catch (IOException iOException) {
                Logger.getLogger(WindowDnDManager.class.getName()).log(Level.WARNING, null, iOException);
            }
        }
        if (transferable.isDataFlavorSupported(dataFlavor = new DataFlavor("application/x-java-jvm-local-objectref; class=org.netbeans.core.windows.ModeImpl", null))) {
            try {
                object = (ModeImpl)transferable.getTransferData(dataFlavor);
                if (null != object) {
                    return new TopComponentDraggable((ModeImpl)object);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                Logger.getLogger(WindowDnDManager.class.getName()).log(Level.WARNING, null, unsupportedFlavorException);
            }
            catch (IOException iOException) {
                Logger.getLogger(WindowDnDManager.class.getName()).log(Level.WARNING, null, iOException);
            }
        }
        return null;
    }

    private static DataFlavor getDataFlavorForDropAction(boolean bl) {
        DataFlavor dataFlavor = null;
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        try {
            dataFlavor = bl ? new DataFlavor("application/x-java-jvm-local-objectref; class=org.openide.windows.TopComponent$Cloneable", null, classLoader) : new DataFlavor("application/x-java-jvm-local-objectref; class=org.openide.windows.TopComponent", null, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger(WindowDnDManager.class.getName()).log(Level.INFO, null, classNotFoundException);
        }
        return dataFlavor;
    }

    static boolean performDrop(Controller controller, TopComponentDroppable topComponentDroppable, TopComponentDraggable topComponentDraggable, Point point) {
        if (DEBUG) {
            WindowDnDManager.debugLog("");
            WindowDnDManager.debugLog("performDrop");
            WindowDnDManager.debugLog("droppable=" + topComponentDroppable);
        }
        if (topComponentDraggable == null) {
            return true;
        }
        if (!topComponentDroppable.canDrop(topComponentDraggable, point)) {
            return true;
        }
        ViewElement viewElement = topComponentDroppable.getDropViewElement();
        Object object = topComponentDroppable.getConstraintForLocation(point);
        if (viewElement instanceof EditorView) {
            int n = topComponentDraggable.getKind();
            if (n == 1) {
                controller.userDroppedTopComponentsIntoEmptyEditor(topComponentDraggable);
            } else if (object == "top" || object == "left" || object == "right" || object == "bottom") {
                controller.userDroppedTopComponentsAroundEditor(topComponentDraggable, (String)object);
            } else if (topComponentDraggable.isAllowedToMoveAnywhere()) {
                controller.userDroppedTopComponentsIntoEmptyEditor(topComponentDraggable);
            }
        } else if (viewElement instanceof ModeView) {
            ModeView modeView = (ModeView)viewElement;
            if (object == "top" || object == "left" || object == "right" || object == "bottom") {
                controller.userDroppedTopComponents(modeView, topComponentDraggable, (String)object);
            } else if (object instanceof Integer) {
                controller.userDroppedTopComponents(modeView, topComponentDraggable, (Integer)object);
            } else {
                controller.userDroppedTopComponents(modeView, topComponentDraggable);
            }
        } else if (viewElement == null) {
            if (object == "top" || object == "left" || object == "right" || object == "bottom") {
                if (topComponentDroppable instanceof EditorAreaDroppable) {
                    controller.userDroppedTopComponentsAroundEditor(topComponentDraggable, (String)object);
                } else {
                    controller.userDroppedTopComponentsAround(topComponentDraggable, (String)object);
                }
            } else if (object instanceof Rectangle) {
                Rectangle rectangle = (Rectangle)object;
                Rectangle rectangle2 = topComponentDraggable.getBounds();
                if (null != rectangle2) {
                    rectangle.setSize(rectangle2.width, rectangle2.height);
                }
                controller.userDroppedTopComponentsIntoFreeArea(topComponentDraggable, rectangle);
            }
        }
        return true;
    }

    public void startKeyboardDragAndDrop(TopComponentDraggable topComponentDraggable) {
        KeyboardDnd.start(this, topComponentDraggable, this.viewAccessor);
    }

    private static class CenterSlidingDroppable
    implements TopComponentDroppable,
    EnhancedDragPainter {
        private ViewAccessor accesor;
        private TopComponentDroppable original;
        private String side;
        JPanel pan;
        private boolean isShowing;

        public CenterSlidingDroppable(ViewAccessor viewAccessor, TopComponentDroppable topComponentDroppable, String string) {
            this.original = topComponentDroppable;
            this.accesor = viewAccessor;
            this.side = string;
            this.pan = new JPanel();
            this.isShowing = false;
        }

        @Override
        public boolean canDrop(TopComponentDraggable topComponentDraggable, Point point) {
            return this.original.canDrop(topComponentDraggable, point);
        }

        @Override
        public Object getConstraintForLocation(Point point) {
            return this.original.getConstraintForLocation(point);
        }

        @Override
        public Component getDropComponent() {
            return this.original.getDropComponent();
        }

        @Override
        public ViewElement getDropViewElement() {
            return this.original.getDropViewElement();
        }

        @Override
        public Shape getIndicationForLocation(Point point) {
            Shape shape = this.original.getIndicationForLocation(point);
            Rectangle rectangle = this.original.getDropComponent().getBounds();
            if (rectangle.width < 10 || rectangle.height < 10) {
                Rectangle rectangle2 = shape.getBounds();
                if ("left".equals(this.side)) {
                    shape = new Rectangle(0, 0, Math.max(rectangle2.width, 20), Math.max(rectangle2.height, 20));
                } else if ("right".equals(this.side)) {
                    shape = new Rectangle(-20, 0, Math.max(rectangle2.width, 20), Math.max(rectangle2.height, 20));
                } else if ("bottom".equals(this.side)) {
                    shape = new Rectangle(0, -20, Math.max(rectangle2.width, 20), Math.max(rectangle2.height, 20));
                } else if ("top".equals(this.side)) {
                    shape = new Rectangle(0, 0, Math.max(rectangle2.width, 20), Math.max(rectangle2.height, 20));
                }
            }
            return shape;
        }

        public boolean isWithinSlide(Point point) {
            JRootPane jRootPane = SwingUtilities.getRootPane(this.original.getDropComponent());
            if (null == jRootPane || null == SwingUtilities.getWindowAncestor(this.original.getDropComponent())) {
                return false;
            }
            Point point2 = SwingUtilities.convertPoint(jRootPane, point, this.original.getDropComponent());
            if (this.original.getDropComponent().contains(point2)) {
                return true;
            }
            Dimension dimension = this.original.getDropComponent().getSize();
            if ("left".equals(this.side)) {
                int n = Math.abs(point2.x);
                if (point2.y > -20 && point2.y < dimension.height + 20) {
                    if (this.isShowing && n < 20) {
                        return true;
                    }
                    if (!this.isShowing && point2.x <= 0 && point2.x > -20) {
                        return true;
                    }
                }
            } else if ("right".equals(this.side)) {
                if (point2.y > -20 && point2.y < dimension.height + 20) {
                    if (this.isShowing && (point2.x < 0 && point2.x > -20 || point2.x > 0 && point2.x - dimension.width < 20)) {
                        return true;
                    }
                    if (!this.isShowing && point2.x >= 0 && point2.x < 20 + dimension.width) {
                        return true;
                    }
                }
            } else if ("bottom".equals(this.side)) {
                if (point2.x > -20 && point2.x < dimension.width + 20) {
                    if (this.isShowing && (point2.y < 0 && point2.y > -20 || point2.y > 0 && point2.y - dimension.height < 20)) {
                        return true;
                    }
                    if (!this.isShowing && point2.y >= 0 && point2.y < 20 + dimension.height) {
                        return true;
                    }
                }
            } else if ("top".equals(this.side) && point2.x > -20 && point2.x < dimension.width + 20) {
                if (this.isShowing && (point2.y < 0 && point2.y > -20 || point2.y > 0 && point2.y + dimension.height < 20)) {
                    return true;
                }
                if (!this.isShowing && point2.y >= 0 && point2.y < 20 + dimension.height) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean supportsKind(TopComponentDraggable topComponentDraggable) {
            return this.original.supportsKind(topComponentDraggable);
        }

        @Override
        public void additionalDragPaint(Graphics2D graphics2D) {
            Point point;
            Point point2;
            Rectangle rectangle = this.original.getDropComponent().getBounds();
            if (rectangle.width > 10 && rectangle.height > 10) {
                return;
            }
            this.isShowing = true;
            Component component = ((JComponent)this.original.getDropComponent()).getRootPane().getGlassPane();
            Point point3 = SwingUtilities.convertPoint(this.original.getDropComponent(), 0, 0, component);
            if ("right".equals(this.side)) {
                point3 = new Point(point3.x - 24, point3.y);
                point2 = new Point(point3);
                point = new Point(point3.x, point3.y + rectangle.height);
            } else if ("bottom".equals(this.side)) {
                point3 = new Point(0, point3.y - 24);
                point2 = new Point(point3);
                point = new Point(point3.x + component.getBounds().width, point3.y);
            } else if ("top".equals(this.side)) {
                point2 = new Point(point3.x, point3.y + 24);
                point = new Point(point3.x + component.getBounds().width, point3.y + 24);
            } else {
                point2 = new Point(point3.x + 25, point3.y);
                point = new Point(point3.x + 25, point3.y + rectangle.height);
            }
            Rectangle rectangle2 = new Rectangle(point3.x, point3.y, Math.max(25, rectangle.width), Math.max(25, rectangle.height));
            if ("bottom".equals(this.side) || "top".equals(this.side)) {
                rectangle2.width = component.getBounds().width;
            }
            Color color = graphics2D.getColor();
            graphics2D.setColor(this.pan.getBackground());
            graphics2D.fill(rectangle2);
            graphics2D.setColor(this.pan.getBackground().darker());
            graphics2D.drawLine(point2.x, point2.y, point.x, point.y);
            graphics2D.setColor(color);
        }

        @Override
        public Rectangle getPaintArea() {
            Rectangle rectangle = this.original.getDropComponent().getBounds();
            if (rectangle.width > 10 && rectangle.height > 10) {
                return null;
            }
            Component component = ((JComponent)this.original.getDropComponent()).getRootPane().getGlassPane();
            Point point = SwingUtilities.convertPoint(this.original.getDropComponent(), 0, 0, component);
            if ("right".equals(this.side)) {
                point = new Point(point.x - 24, point.y);
            } else if ("bottom".equals(this.side)) {
                point = new Point(0, point.y - 24);
            } else if ("top".equals(this.side)) {
                point = new Point(0, point.y + 24);
            }
            Rectangle rectangle2 = new Rectangle(point.x, point.y, Math.max(25, rectangle.width), Math.max(25, rectangle.height));
            if ("bottom".equals(this.side) || "top".equals(this.side)) {
                rectangle2.width = component.getBounds().width;
            }
            return rectangle2;
        }

        @Override
        public int getKind() {
            return 2;
        }
    }

    private static class FreeAreaDroppable
    implements TopComponentDroppable {
        private Point location;

        public FreeAreaDroppable(Point point) {
            this.location = point;
        }

        @Override
        public Shape getIndicationForLocation(Point point) {
            return null;
        }

        @Override
        public Object getConstraintForLocation(Point point) {
            return new Rectangle(this.location.x, this.location.y, Constants.DROP_NEW_MODE_SIZE.width, Constants.DROP_NEW_MODE_SIZE.height);
        }

        @Override
        public Component getDropComponent() {
            return null;
        }

        @Override
        public ViewElement getDropViewElement() {
            return null;
        }

        @Override
        public boolean canDrop(TopComponentDraggable topComponentDraggable, Point point) {
            if (topComponentDraggable.isAllowedToMoveAnywhere()) {
                return true;
            }
            ModeImpl modeImpl = topComponentDraggable.getMode();
            return null == modeImpl || modeImpl.getState() != 1 || modeImpl.getOpenedTopComponents().size() != 1;
        }

        @Override
        public boolean supportsKind(TopComponentDraggable topComponentDraggable) {
            return true;
        }

        @Override
        public int getKind() {
            return 0;
        }
    }

    private class EditorAreaDroppable
    implements TopComponentDroppable {
        private static final int DROP_BORDER_WIDTH = 30;

        private EditorAreaDroppable() {
        }

        @Override
        public Shape getIndicationForLocation(Point point) {
            Rectangle rectangle = this.getDropComponent().getBounds();
            Rectangle rectangle2 = null;
            double d = 0.25;
            Object object = this.getConstraintForLocation(point);
            if (object == "left") {
                rectangle2 = new Rectangle(0, 0, (int)((double)rectangle.width * d) - 1, rectangle.height - 1);
            } else if (object == "top") {
                rectangle2 = new Rectangle(0, 0, rectangle.width - 1, (int)((double)rectangle.height * d) - 1);
            } else if (object == "right") {
                rectangle2 = new Rectangle(rectangle.width - (int)((double)rectangle.width * d), 0, (int)((double)rectangle.width * d) - 1, rectangle.height - 1);
            } else if (object == "bottom") {
                rectangle2 = new Rectangle(0, rectangle.height - (int)((double)rectangle.height * d), rectangle.width - 1, (int)((double)rectangle.height * d) - 1);
            }
            return rectangle2;
        }

        @Override
        public Object getConstraintForLocation(Point point) {
            Rectangle rectangle = this.getDropComponent().getBounds();
            Component component = WindowDnDManager.this.viewAccessor.getSlidingModeComponent("left");
            Component component2 = WindowDnDManager.this.viewAccessor.getSlidingModeComponent("right");
            Component component3 = WindowDnDManager.this.viewAccessor.getSlidingModeComponent("bottom");
            Component component4 = WindowDnDManager.this.viewAccessor.getSlidingModeComponent("top");
            if (null != component && point.x < component.getBounds().width + 30) {
                return "left";
            }
            if (point.y < rectangle.y) {
                return "top";
            }
            if (null != component2 && null != component && point.x > rectangle.width - 30 - component2.getBounds().width - component.getBounds().width) {
                return "right";
            }
            if (null != component3 && point.y > rectangle.height - 30 - component3.getBounds().height) {
                return "bottom";
            }
            if (null != component4 && point.y < rectangle.y + component4.getBounds().height + 30) {
                return "top";
            }
            return null;
        }

        @Override
        public Component getDropComponent() {
            return WindowManagerImpl.getInstance().getEditorAreaComponent();
        }

        @Override
        public ViewElement getDropViewElement() {
            return null;
        }

        @Override
        public boolean canDrop(TopComponentDraggable topComponentDraggable, Point point) {
            if (topComponentDraggable.isAllowedToMoveAnywhere()) {
                return true;
            }
            return topComponentDraggable.getKind() == 1;
        }

        @Override
        public boolean supportsKind(TopComponentDraggable topComponentDraggable) {
            if (topComponentDraggable.isAllowedToMoveAnywhere()) {
                return true;
            }
            return topComponentDraggable.getKind() == 1;
        }

        @Override
        public int getKind() {
            if (null == WindowDnDManager.this.getStartingDroppable()) {
                return 1;
            }
            return WindowDnDManager.this.getStartingDroppable().getKind();
        }
    }

    private class CenterPanelDroppable
    implements TopComponentDroppable {
        private CenterPanelDroppable() {
        }

        @Override
        public Shape getIndicationForLocation(Point point) {
            Rectangle rectangle = this.getDropComponent().getBounds();
            Rectangle rectangle2 = null;
            double d = 0.25;
            Object object = this.getConstraintForLocation(point);
            if (object == "left") {
                rectangle2 = new Rectangle(0, 0, (int)((double)rectangle.width * d) - 1, rectangle.height - 1);
            } else if (object == "top") {
                rectangle2 = new Rectangle(0, 0, rectangle.width - 1, (int)((double)rectangle.height * d) - 1);
            } else if (object == "right") {
                rectangle2 = new Rectangle(rectangle.width - (int)((double)rectangle.width * d), 0, (int)((double)rectangle.width * d) - 1, rectangle.height - 1);
            } else if (object == "bottom") {
                rectangle2 = new Rectangle(0, rectangle.height - (int)((double)rectangle.height * d), rectangle.width - 1, (int)((double)rectangle.height * d) - 1);
            }
            return rectangle2;
        }

        @Override
        public Object getConstraintForLocation(Point point) {
            Rectangle rectangle = this.getDropComponent().getBounds();
            Component component = WindowDnDManager.this.viewAccessor.getSlidingModeComponent("left");
            Component component2 = WindowDnDManager.this.viewAccessor.getSlidingModeComponent("right");
            Component component3 = WindowDnDManager.this.viewAccessor.getSlidingModeComponent("bottom");
            Component component4 = WindowDnDManager.this.viewAccessor.getSlidingModeComponent("top");
            if (null != component && point.x < component.getBounds().width + 10) {
                return "left";
            }
            if (point.y < rectangle.y) {
                return "top";
            }
            if (null != component2 && null != component && point.x > rectangle.width - 10 - component2.getBounds().width - component.getBounds().width) {
                return "right";
            }
            if (null != component3 && point.y > rectangle.height - 10 - component3.getBounds().height) {
                return "bottom";
            }
            if (null != component4 && point.y < rectangle.y + component4.getBounds().height + 10) {
                return "top";
            }
            return null;
        }

        @Override
        public Component getDropComponent() {
            return MainWindow.getInstance().getDesktop();
        }

        @Override
        public ViewElement getDropViewElement() {
            return null;
        }

        @Override
        public boolean canDrop(TopComponentDraggable topComponentDraggable, Point point) {
            if (topComponentDraggable.isAllowedToMoveAnywhere()) {
                return true;
            }
            return topComponentDraggable.getKind() == 0 || topComponentDraggable.getKind() == 2;
        }

        @Override
        public boolean supportsKind(TopComponentDraggable topComponentDraggable) {
            if (topComponentDraggable.isAllowedToMoveAnywhere()) {
                return true;
            }
            return topComponentDraggable.getKind() == 0 || topComponentDraggable.getKind() == 2;
        }

        @Override
        public int getKind() {
            return 0;
        }
    }

    public static interface ViewAccessor {
        public Set<Component> getModeComponents();

        public Set<Component> getSeparateModeFrames();

        public Controller getController();

        public Component getSlidingModeComponent(String var1);
    }

    private static class MotionListener
    implements DragSourceMotionListener {
        private final WindowDnDManager windowDnDManager;
        private final TopComponentDragSupport topComponentDragSupport;
        private Point previousDragLoc;
        private Window fakeWindow;
        private boolean isSizeSet;

        private MotionListener(WindowDnDManager windowDnDManager, TopComponentDragSupport topComponentDragSupport) {
            this.windowDnDManager = windowDnDManager;
            this.topComponentDragSupport = topComponentDragSupport;
        }

        @Override
        public void dragMouseMoved(DragSourceDragEvent dragSourceDragEvent) {
            Point point;
            if (DEBUG) {
                WindowDnDManager.debugLog("dragMouseMoved evt=" + dragSourceDragEvent);
            }
            if ((point = dragSourceDragEvent.getLocation()) == null) {
                return;
            }
            if (this.windowDnDManager.startingTransfer == null) {
                return;
            }
            boolean bl = this.windowDnDManager.isInMainWindowDroppable(point, this.windowDnDManager.startingTransfer);
            boolean bl2 = this.windowDnDManager.isInFloatingFrameDroppable(this.windowDnDManager.getFloatingFrames(), point, this.windowDnDManager.startingTransfer) && this.windowDnDManager.startingTransfer.isUndockingEnabled();
            boolean bl3 = WindowDnDManager.isAroundCenterPanel(point);
            boolean bl4 = WindowDnDManager.isMixedTCDragDrop(this.windowDnDManager.startingTransfer, this.windowDnDManager.findDroppableFromScreen(this.windowDnDManager.getFloatingFrames(), point, this.windowDnDManager.startingTransfer));
            if (bl || bl2 || bl3) {
                TopComponentDroppable topComponentDroppable = this.windowDnDManager.findDroppableFromScreen(this.windowDnDManager.getFloatingFrames(), point, this.windowDnDManager.startingTransfer);
                if (topComponentDroppable instanceof FreeAreaDroppable) {
                    if (WindowManagerImpl.getInstance().getEditorAreaState() == 1 && topComponentDroppable.canDrop(this.windowDnDManager.startingTransfer, point)) {
                        this.topComponentDragSupport.setSuccessCursor(true, bl4);
                    } else {
                        this.topComponentDragSupport.setUnsuccessCursor(bl4);
                    }
                } else if (topComponentDroppable != null) {
                    JComponent jComponent = (JComponent)topComponentDroppable.getDropComponent();
                    Component component = jComponent.getRootPane().getGlassPane();
                    if (component instanceof DropTargetGlassPane) {
                        this.windowDnDManager.setLastDropTarget((DropTargetGlassPane)component);
                    }
                    Point point2 = new Point(point);
                    SwingUtilities.convertPointFromScreen(point2, topComponentDroppable.getDropComponent());
                    if (topComponentDroppable.canDrop(this.windowDnDManager.startingTransfer, point2)) {
                        this.topComponentDragSupport.setSuccessCursor(false, bl4);
                    } else {
                        this.topComponentDragSupport.setUnsuccessCursor(bl4);
                    }
                    this.dragOverDropTarget(point, topComponentDroppable);
                }
            } else if (!WindowDnDManager.isInMainWindow(point) && this.windowDnDManager.isInFloatingFrame(point)) {
                this.topComponentDragSupport.setSuccessCursor(false, bl4);
            } else if (WindowDnDManager.isInFreeArea(point, this.fakeWindow) && WindowDnDManager.getFreeAreaDroppable(point).canDrop(this.windowDnDManager.startingTransfer, point) && this.windowDnDManager.startingTransfer.isUndockingEnabled()) {
                this.topComponentDragSupport.setSuccessCursor(true, bl4);
            } else {
                this.topComponentDragSupport.setUnsuccessCursor(bl4);
            }
            if (!(bl || bl2 || bl3)) {
                this.clearExitedDropTarget();
            }
        }

        private void dragOverDropTarget(Point point, TopComponentDroppable topComponentDroppable) {
            DropTargetGlassPane dropTargetGlassPane = (DropTargetGlassPane)this.windowDnDManager.lastTargetWRef.get();
            if (dropTargetGlassPane != null) {
                Point point2 = new Point(point);
                SwingUtilities.convertPointFromScreen(point2, dropTargetGlassPane);
                dropTargetGlassPane.dragOver(point2, topComponentDroppable);
            }
        }

        private void clearExitedDropTarget() {
            DropTargetGlassPane dropTargetGlassPane = (DropTargetGlassPane)this.windowDnDManager.lastTargetWRef.get();
            if (dropTargetGlassPane != null) {
                dropTargetGlassPane.clearIndications();
                this.windowDnDManager.lastTargetWRef = new WeakReference<Object>(null);
            }
        }

        void dragFinished() {
            this.previousDragLoc = null;
            if (this.fakeWindow != null) {
                this.fakeWindow.dispose();
                this.fakeWindow = null;
            }
        }
    }
}

