/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;

public class Clinit
extends AbstractMethodDeclaration {
    private static int ENUM_CONSTANTS_THRESHOLD = 2000;
    private FieldBinding assertionSyntheticFieldBinding = null;
    private FieldBinding classLiteralSyntheticField = null;

    public Clinit(CompilationResult compilationResult) {
        super(compilationResult);
        this.modifiers = 0;
        this.selector = TypeConstants.CLINIT;
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializationFlowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            ExceptionHandlingFlowContext exceptionHandlingFlowContext = new ExceptionHandlingFlowContext(initializationFlowContext.parent, this, Binding.NO_EXCEPTIONS, initializationFlowContext, this.scope, FlowInfo.DEAD_END);
            if ((flowInfo.tagBits & 1) == 0) {
                this.bits |= 0x40;
            }
            flowInfo = flowInfo.mergedWith(initializationFlowContext.initsOnReturn);
            for (FieldBinding fieldBinding : this.scope.enclosingSourceType().fields()) {
                if (!fieldBinding.isStatic() || flowInfo.isDefinitelyAssigned(fieldBinding)) continue;
                if (fieldBinding.isFinal()) {
                    this.scope.problemReporter().uninitializedBlankFinalField(fieldBinding, this.scope.referenceType().declarationOf(fieldBinding.original()));
                    continue;
                }
                if (!fieldBinding.isNonNull()) continue;
                this.scope.problemReporter().uninitializedNonNullField(fieldBinding, this.scope.referenceType().declarationOf(fieldBinding.original()));
            }
            initializationFlowContext.checkInitializerExceptions(this.scope, exceptionHandlingFlowContext, flowInfo);
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    @Override
    public void generateCode(ClassScope classScope, ClassFile classFile) {
        int n = 0;
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        boolean bl = false;
        do {
            try {
                n = classFile.contentsOffset;
                this.generateCode(classScope, classFile, n);
                bl = false;
            }
            catch (AbortMethod abortMethod) {
                if (abortMethod.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                    classFile.contentsOffset = n;
                    --classFile.methodCount;
                    classFile.codeStream.resetInWideMode();
                    bl = true;
                    continue;
                }
                if (abortMethod.compilationResult == CodeStream.RESTART_CODE_GEN_FOR_UNUSED_LOCALS_MODE) {
                    classFile.contentsOffset = n;
                    --classFile.methodCount;
                    classFile.codeStream.resetForCodeGenUnusedLocals();
                    bl = true;
                    continue;
                }
                classFile.contentsOffset = n;
                --classFile.methodCount;
                bl = false;
            }
        } while (bl);
    }

    private void generateCode(ClassScope classScope, ClassFile classFile, int n) {
        int n2;
        int n3;
        TypeDeclaration typeDeclaration;
        CodeStream codeStream;
        int n4;
        int n5;
        int n6;
        ConstantPool constantPool;
        block29: {
            Object object;
            MethodScope methodScope;
            block26: {
                int n7;
                int n8;
                int n9;
                block28: {
                    block27: {
                        constantPool = classFile.constantPool;
                        n6 = constantPool.currentOffset;
                        n5 = constantPool.currentIndex;
                        classFile.generateMethodInfoHeaderForClinit();
                        n4 = classFile.contentsOffset;
                        classFile.generateCodeAttributeHeader();
                        codeStream = classFile.codeStream;
                        this.resolve(classScope);
                        codeStream.reset(this, classFile);
                        typeDeclaration = classScope.referenceContext;
                        methodScope = typeDeclaration.staticInitializerScope;
                        methodScope.computeLocalVariablePositions(0, codeStream);
                        if (this.assertionSyntheticFieldBinding != null) {
                            codeStream.generateClassLiteralAccessForType(classScope.outerMostClassScope().enclosingSourceType(), this.classLiteralSyntheticField);
                            codeStream.invokeJavaLangClassDesiredAssertionStatus();
                            object = new BranchLabel(codeStream);
                            codeStream.ifne((BranchLabel)object);
                            codeStream.iconst_1();
                            BranchLabel branchLabel = new BranchLabel(codeStream);
                            codeStream.decrStackSize(1);
                            codeStream.goto_(branchLabel);
                            ((BranchLabel)object).place();
                            codeStream.iconst_0();
                            branchLabel.place();
                            codeStream.fieldAccess((byte)-77, this.assertionSyntheticFieldBinding, null);
                        }
                        object = typeDeclaration.fields;
                        n3 = -1;
                        n9 = 0;
                        if (TypeDeclaration.kind(typeDeclaration.modifiers) != 3) break block26;
                        n2 = typeDeclaration.enumConstantsCounter;
                        if (n2 <= ENUM_CONSTANTS_THRESHOLD) break block27;
                        n8 = -1;
                        n7 = 0;
                        if (object == null) break block28;
                        int n10 = ((FieldDeclaration[])object).length;
                        for (int i = 0; i < n10; ++i) {
                            Object object2 = object[i];
                            if (!((FieldDeclaration)object2).isStatic()) continue;
                            if (((FieldDeclaration)object2).getKind() == 3) {
                                if (n8 == -1) {
                                    n8 = i;
                                }
                                if (++n7 <= ENUM_CONSTANTS_THRESHOLD) continue;
                                SyntheticMethodBinding syntheticMethodBinding = typeDeclaration.binding.addSyntheticMethodForEnumInitialization(n8, i);
                                codeStream.invoke((byte)-72, syntheticMethodBinding, null);
                                n8 = i;
                                n7 = 1;
                                continue;
                            }
                            ++n9;
                        }
                        if (n7 == 0) break block28;
                        SyntheticMethodBinding syntheticMethodBinding = typeDeclaration.binding.addSyntheticMethodForEnumInitialization(n8, n10);
                        codeStream.invoke((byte)-72, syntheticMethodBinding, null);
                        break block28;
                    }
                    if (object != null) {
                        n7 = ((FieldDeclaration[])object).length;
                        for (n8 = 0; n8 < n7; ++n8) {
                            FieldDeclaration fieldDeclaration = object[n8];
                            if (!fieldDeclaration.isStatic()) continue;
                            if (fieldDeclaration.getKind() == 3) {
                                fieldDeclaration.generateCode(methodScope, codeStream);
                                continue;
                            }
                            ++n9;
                        }
                    }
                }
                codeStream.generateInlinedValue(n2);
                codeStream.anewarray(typeDeclaration.binding);
                if (n2 > 0 && object != null) {
                    for (Object object3 : object) {
                        if (((FieldDeclaration)object3).getKind() != 3) continue;
                        codeStream.dup();
                        codeStream.generateInlinedValue(((FieldDeclaration)object3).binding.id);
                        codeStream.fieldAccess((byte)-78, ((FieldDeclaration)object3).binding, null);
                        codeStream.aastore();
                    }
                }
                codeStream.fieldAccess((byte)-77, typeDeclaration.enumValuesSyntheticfield, null);
                if (n9 != 0) {
                    n7 = ((Object)object).length;
                    block12: for (n8 = 0; n8 < n7 && n9 >= 0; ++n8) {
                        Object object4 = object[n8];
                        switch (((FieldDeclaration)object4).getKind()) {
                            case 3: {
                                continue block12;
                            }
                            case 2: {
                                if (!((FieldDeclaration)object4).isStatic()) continue block12;
                                --n9;
                                n3 = ((Initializer)object4).block.sourceEnd;
                                ((FieldDeclaration)object4).generateCode(methodScope, codeStream);
                                continue block12;
                            }
                            case 1: {
                                if (!((FieldDeclaration)object4).binding.isStatic()) continue block12;
                                --n9;
                                n3 = ((FieldDeclaration)object4).declarationEnd;
                                ((FieldDeclaration)object4).generateCode(methodScope, codeStream);
                            }
                        }
                    }
                }
                break block29;
            }
            if (object != null) {
                block13: for (FieldDeclaration fieldDeclaration : object) {
                    switch (fieldDeclaration.getKind()) {
                        case 2: {
                            if (!fieldDeclaration.isStatic()) continue block13;
                            n3 = ((Initializer)fieldDeclaration).block.sourceEnd;
                            fieldDeclaration.generateCode(methodScope, codeStream);
                            continue block13;
                        }
                        case 1: {
                            if (!fieldDeclaration.binding.isStatic()) continue block13;
                            n3 = fieldDeclaration.declarationEnd;
                            fieldDeclaration.generateCode(methodScope, codeStream);
                        }
                    }
                }
            }
        }
        if (codeStream.position == 0) {
            classFile.contentsOffset = n;
            --classFile.methodCount;
            constantPool.resetForClinit(n5, n6);
        } else {
            if ((this.bits & 0x40) != 0) {
                n2 = codeStream.position;
                codeStream.return_();
                if (n3 != -1) {
                    codeStream.recordPositionsFrom(n2, n3);
                }
            }
            codeStream.recordPositionsFrom(0, typeDeclaration.sourceStart);
            classFile.completeCodeAttributeForClinit(n4);
        }
    }

    @Override
    public boolean isClinit() {
        return true;
    }

    @Override
    public boolean isInitializationMethod() {
        return true;
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public void parseStatements(Parser parser, CompilationUnitDeclaration compilationUnitDeclaration) {
    }

    @Override
    public StringBuffer print(int n, StringBuffer stringBuffer) {
        Clinit.printIndent(n, stringBuffer).append("<clinit>()");
        this.printBody(n + 1, stringBuffer);
        return stringBuffer;
    }

    @Override
    public void resolve(ClassScope classScope) {
        this.scope = new MethodScope(classScope, classScope.referenceContext, true);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        aSTVisitor.visit(this, classScope);
        aSTVisitor.endVisit(this, classScope);
    }

    public void setAssertionSupport(FieldBinding fieldBinding, boolean bl) {
        SourceTypeBinding sourceTypeBinding;
        this.assertionSyntheticFieldBinding = fieldBinding;
        if (bl && !(sourceTypeBinding = this.scope.outerMostClassScope().enclosingSourceType()).isInterface() && !sourceTypeBinding.isBaseType()) {
            this.classLiteralSyntheticField = sourceTypeBinding.addSyntheticFieldForClassLiteral(sourceTypeBinding, this.scope);
        }
    }
}

