/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.ea.opp.selection;

import java.io.Serializable;
import java.util.Random;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.opp.selection.SelectionOperator;
import org.encog.ml.ea.species.Species;
import org.encog.ml.ea.train.EvolutionaryAlgorithm;
import org.encog.ml.ea.train.basic.BasicEA;

public class TournamentSelection
implements SelectionOperator,
Serializable {
    private static final long serialVersionUID = 1L;
    private EvolutionaryAlgorithm trainer;
    private int rounds;

    public TournamentSelection(EvolutionaryAlgorithm theTrainer, int theRounds) {
        this.trainer = theTrainer;
        this.rounds = theRounds;
    }

    public int getRounds() {
        return this.rounds;
    }

    @Override
    public EvolutionaryAlgorithm getTrainer() {
        return this.trainer;
    }

    @Override
    public int performAntiSelection(Random rnd, Species species) {
        int worstIndex = rnd.nextInt(species.getMembers().size());
        Genome worst = species.getMembers().get(worstIndex);
        BasicEA.calculateScoreAdjustment(worst, this.trainer.getScoreAdjusters());
        for (int i = 0; i < this.rounds; ++i) {
            int competitorIndex = rnd.nextInt(species.getMembers().size());
            Genome competitor = species.getMembers().get(competitorIndex);
            if (Double.isInfinite(competitor.getAdjustedScore()) || Double.isNaN(competitor.getAdjustedScore())) {
                return competitorIndex;
            }
            BasicEA.calculateScoreAdjustment(competitor, this.trainer.getScoreAdjusters());
            if (this.trainer.getSelectionComparator().isBetterThan(competitor, worst)) continue;
            worst = competitor;
            worstIndex = competitorIndex;
        }
        return worstIndex;
    }

    @Override
    public int performSelection(Random rnd, Species species) {
        int bestIndex = rnd.nextInt(species.getMembers().size());
        Genome best = species.getMembers().get(bestIndex);
        BasicEA.calculateScoreAdjustment(best, this.trainer.getScoreAdjusters());
        for (int i = 0; i < this.rounds; ++i) {
            int competitorIndex = rnd.nextInt(species.getMembers().size());
            Genome competitor = species.getMembers().get(competitorIndex);
            if (Double.isInfinite(competitor.getAdjustedScore()) || Double.isNaN(competitor.getAdjustedScore())) continue;
            BasicEA.calculateScoreAdjustment(competitor, this.trainer.getScoreAdjusters());
            if (!this.trainer.getSelectionComparator().isBetterThan(competitor, best)) continue;
            best = competitor;
            bestIndex = competitorIndex;
        }
        return bestIndex;
    }

    public void setRounds(int rounds) {
        this.rounds = rounds;
    }

    public void setTrainer(EvolutionaryAlgorithm trainer) {
        this.trainer = trainer;
    }
}

