/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.general;

import org.apache.commons.math3.analysis.DifferentiableMultivariateVectorFunction;
import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.optimization.ConvergenceChecker;
import org.apache.commons.math3.optimization.DifferentiableMultivariateVectorOptimizer;
import org.apache.commons.math3.optimization.PointVectorValuePair;
import org.apache.commons.math3.optimization.direct.BaseAbstractMultivariateVectorOptimizer;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLeastSquaresOptimizer
extends BaseAbstractMultivariateVectorOptimizer<DifferentiableMultivariateVectorFunction>
implements DifferentiableMultivariateVectorOptimizer {
    private static final double DEFAULT_SINGULARITY_THRESHOLD = 1.0E-14;
    protected double[][] weightedResidualJacobian;
    protected int cols;
    protected int rows;
    protected double[] point;
    protected double[] objective;
    protected double[] weightedResiduals;
    protected double cost;
    private MultivariateMatrixFunction jF;
    private int jacobianEvaluations;

    protected AbstractLeastSquaresOptimizer() {
    }

    protected AbstractLeastSquaresOptimizer(ConvergenceChecker<PointVectorValuePair> checker) {
        super(checker);
    }

    public int getJacobianEvaluations() {
        return this.jacobianEvaluations;
    }

    protected void updateJacobian() {
        ++this.jacobianEvaluations;
        this.weightedResidualJacobian = this.jF.value(this.point);
        if (this.weightedResidualJacobian.length != this.rows) {
            throw new DimensionMismatchException(this.weightedResidualJacobian.length, this.rows);
        }
        double[] residualsWeights = this.getWeightRef();
        for (int i = 0; i < this.rows; ++i) {
            double[] ji = this.weightedResidualJacobian[i];
            double wi = FastMath.sqrt(residualsWeights[i]);
            for (int j = 0; j < this.cols; ++j) {
                this.weightedResidualJacobian[i][j] = -ji[j] * wi;
            }
        }
    }

    protected void updateResidualsAndCost() {
        this.objective = this.computeObjectiveValue(this.point);
        if (this.objective.length != this.rows) {
            throw new DimensionMismatchException(this.objective.length, this.rows);
        }
        double[] targetValues = this.getTargetRef();
        double[] residualsWeights = this.getWeightRef();
        this.cost = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            double residual = targetValues[i] - this.objective[i];
            this.weightedResiduals[i] = residual * FastMath.sqrt(residualsWeights[i]);
            this.cost += residualsWeights[i] * residual * residual;
        }
        this.cost = FastMath.sqrt(this.cost);
    }

    public double getRMS() {
        return FastMath.sqrt(this.getChiSquare() / (double)this.rows);
    }

    public double getChiSquare() {
        return this.cost * this.cost;
    }

    public double[][] getCovariances() {
        return this.getCovariances(1.0E-14);
    }

    public double[][] getCovariances(double threshold) {
        this.updateJacobian();
        double[][] jTj = new double[this.cols][this.cols];
        for (int i = 0; i < this.cols; ++i) {
            for (int j = i; j < this.cols; ++j) {
                double sum = 0.0;
                for (int k = 0; k < this.rows; ++k) {
                    sum += this.weightedResidualJacobian[k][i] * this.weightedResidualJacobian[k][j];
                }
                jTj[i][j] = sum;
                jTj[j][i] = sum;
            }
        }
        DecompositionSolver solver = new QRDecomposition(MatrixUtils.createRealMatrix(jTj), threshold).getSolver();
        return solver.getInverse().getData();
    }

    public double[] guessParametersErrors() {
        if (this.rows <= this.cols) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NO_DEGREES_OF_FREEDOM, (Number)this.rows, this.cols, false);
        }
        double[] errors = new double[this.cols];
        double c = FastMath.sqrt(this.getChiSquare() / (double)(this.rows - this.cols));
        double[][] covar = this.getCovariances();
        for (int i = 0; i < errors.length; ++i) {
            errors[i] = FastMath.sqrt(covar[i][i]) * c;
        }
        return errors;
    }

    @Override
    public PointVectorValuePair optimize(int maxEval, DifferentiableMultivariateVectorFunction f, double[] target, double[] weights, double[] startPoint) {
        this.jacobianEvaluations = 0;
        this.jF = f.jacobian();
        this.point = (double[])startPoint.clone();
        this.rows = target.length;
        this.cols = this.point.length;
        this.weightedResidualJacobian = new double[this.rows][this.cols];
        this.weightedResiduals = new double[this.rows];
        this.cost = Double.POSITIVE_INFINITY;
        return super.optimize(maxEval, f, target, weights, startPoint);
    }
}

