/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.bridges.java_remote;

import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XInstanceProvider;
import com.sun.star.connection.XConnection;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lib.uno.bridges.java_remote.ProxyFactory;
import com.sun.star.lib.uno.bridges.java_remote.RequestHandler;
import com.sun.star.lib.uno.bridges.java_remote.XConnectionInputStream_Adapter;
import com.sun.star.lib.uno.bridges.java_remote.XConnectionOutputStream_Adapter;
import com.sun.star.lib.uno.environments.java.java_environment;
import com.sun.star.lib.uno.environments.remote.IProtocol;
import com.sun.star.lib.uno.environments.remote.IReceiver;
import com.sun.star.lib.uno.environments.remote.IThreadPool;
import com.sun.star.lib.uno.environments.remote.Job;
import com.sun.star.lib.uno.environments.remote.Message;
import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.lib.uno.environments.remote.ThreadPoolManager;
import com.sun.star.lib.uno.typedesc.TypeDescription;
import com.sun.star.lib.util.DisposeListener;
import com.sun.star.lib.util.DisposeNotifier;
import com.sun.star.uno.Any;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.IEnvironment;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class java_remote_bridge
implements IBridge,
IReceiver,
RequestHandler,
XBridge,
XComponent,
DisposeNotifier {
    private static final boolean DEBUG = false;
    protected XConnection _xConnection;
    protected XInstanceProvider _xInstanceProvider;
    protected String _name = "remote";
    private final String protocol;
    protected IProtocol _iProtocol;
    protected IEnvironment _java_environment;
    protected MessageDispatcher _messageDispatcher;
    protected int _life_count = 0;
    private final ArrayList<XEventListener> _listeners = new ArrayList();
    protected IThreadPool _iThreadPool;
    private boolean disposed = false;
    private final HashMap<String, LinkedList<RefHolder>> refHolders = new HashMap();
    private final ProxyFactory proxyFactory;
    private final ArrayList<DisposeListener> disposeListeners = new ArrayList();

    int getLifeCount() {
        return this._life_count;
    }

    IProtocol getProtocol() {
        return this._iProtocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasRefHolder(String oid, Type type) {
        HashMap<String, LinkedList<RefHolder>> hashMap = this.refHolders;
        synchronized (hashMap) {
            LinkedList<RefHolder> l = this.refHolders.get(oid);
            if (l != null) {
                for (RefHolder rh : l) {
                    if (!type.isSupertypeOf(rh.getType())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addRefHolder(Object obj, Type type, String oid) {
        HashMap<String, LinkedList<RefHolder>> hashMap = this.refHolders;
        synchronized (hashMap) {
            LinkedList<RefHolder> l = this.refHolders.get(oid);
            if (l == null) {
                l = new LinkedList();
                this.refHolders.put(oid, l);
            }
            boolean found = false;
            Iterator i = l.iterator();
            while (!found && i.hasNext()) {
                RefHolder rh = (RefHolder)i.next();
                if (!rh.getType().equals(type)) continue;
                found = true;
                rh.acquire();
            }
            if (!found) {
                l.add(new RefHolder(type, obj));
            }
        }
        this.acquire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void remRefHolder(Type type, String oid) {
        HashMap<String, LinkedList<RefHolder>> hashMap = this.refHolders;
        synchronized (hashMap) {
            LinkedList<RefHolder> l = this.refHolders.get(oid);
            if (l == null) {
                return;
            }
            for (RefHolder rh : l) {
                if (!rh.getType().equals(type)) continue;
                try {
                    if (!rh.release()) break;
                    l.remove(rh);
                    if (!l.isEmpty()) break;
                    this.refHolders.remove(oid);
                    break;
                }
                finally {
                    this.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void freeHolders() {
        HashMap<String, LinkedList<RefHolder>> hashMap = this.refHolders;
        synchronized (hashMap) {
            for (Map.Entry<String, LinkedList<RefHolder>> e : this.refHolders.entrySet()) {
                String oid = e.getKey();
                LinkedList<RefHolder> l = e.getValue();
                for (RefHolder rh : l) {
                    boolean done = false;
                    while (!done) {
                        done = rh.release();
                        this._java_environment.revokeInterface(oid, rh.getType());
                        this.release();
                    }
                }
            }
            this.refHolders.clear();
        }
    }

    public java_remote_bridge(IEnvironment java_environment2, IEnvironment remote_environment2, Object[] args) throws Exception {
        String attr;
        int i;
        this._java_environment = java_environment2;
        String proto = (String)args[0];
        this._xConnection = (XConnection)args[1];
        this._xInstanceProvider = (XInstanceProvider)args[2];
        if (args.length > 3) {
            this._name = (String)args[3];
        }
        if ((i = proto.indexOf(44)) >= 0) {
            this.protocol = proto.substring(0, i);
            attr = proto.substring(i + 1);
        } else {
            this.protocol = proto;
            attr = null;
        }
        this._iProtocol = (IProtocol)Class.forName("com.sun.star.lib.uno.protocols." + this.protocol + "." + this.protocol).getConstructor(IBridge.class, String.class, InputStream.class, OutputStream.class).newInstance(this, attr, new XConnectionInputStream_Adapter(this._xConnection), new XConnectionOutputStream_Adapter(this._xConnection));
        this.proxyFactory = new ProxyFactory(this, this);
        this._iThreadPool = ThreadPoolManager.create();
        this._messageDispatcher = new MessageDispatcher();
        this._messageDispatcher.start();
        this._iProtocol.init();
    }

    private void notifyListeners() {
        EventObject eventObject = new EventObject(this);
        for (XEventListener xEventListener : this._listeners) {
            try {
                xEventListener.disposing(eventObject);
            }
            catch (com.sun.star.uno.RuntimeException runtimeException) {}
        }
    }

    public java_remote_bridge(Object[] args) throws Exception {
        this(UnoRuntime.getEnvironment("java", null), UnoRuntime.getEnvironment("remote", null), args);
    }

    public Object mapInterfaceTo(Object object, Type type) {
        this.checkDisposed();
        if (object == null) {
            return null;
        }
        String[] oid = new String[1];
        if (!this.proxyFactory.isProxy(object = this._java_environment.registerInterface(object, oid, type))) {
            this.addRefHolder(object, type, oid[0]);
        }
        return oid[0];
    }

    public Object mapInterfaceFrom(Object oId, Type type) {
        this.checkDisposed();
        this.acquire();
        String oid = (String)oId;
        Object object = this._java_environment.getRegisteredInterface(oid, type);
        if (object == null) {
            object = this._java_environment.registerInterface(this.proxyFactory.create(oid, type), new String[]{oid}, type);
        } else if (!this.hasRefHolder(oid, type)) {
            this.sendInternalRequest(oid, type, "release", null);
        }
        return object;
    }

    public IEnvironment getSourceEnvironment() {
        return this._java_environment;
    }

    public IEnvironment getTargetEnvironment() {
        return null;
    }

    public synchronized void acquire() {
        ++this._life_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        boolean dispose;
        java_remote_bridge java_remote_bridge2 = this;
        synchronized (java_remote_bridge2) {
            --this._life_count;
            dispose = this._life_count <= 0;
        }
        if (dispose) {
            this.dispose(new Throwable("end of life"));
        }
    }

    public void dispose() {
        this.dispose(new Throwable("user dispose"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(Throwable throwable) {
        java_remote_bridge java_remote_bridge2 = this;
        synchronized (java_remote_bridge2) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
        }
        this.notifyListeners();
        Iterator<DisposeListener> i = this.disposeListeners.iterator();
        while (i.hasNext()) {
            i.next().notifyDispose(this);
        }
        this._iProtocol.terminate();
        try {
            this._messageDispatcher.terminate();
            try {
                this._xConnection.close();
            }
            catch (com.sun.star.io.IOException e) {
                System.err.println(this.getClass().getName() + ".dispose - IOException:" + e);
            }
            if (Thread.currentThread() != this._messageDispatcher && this._messageDispatcher.isAlive()) {
                this._messageDispatcher.join(1000L);
                if (this._messageDispatcher.isAlive()) {
                    this._messageDispatcher.interrupt();
                    this._messageDispatcher.join();
                }
            }
            this._iThreadPool.dispose(throwable);
            this.freeHolders();
            ((java_environment)this._java_environment).revokeAllProxies();
            this.proxyFactory.dispose();
            this._xConnection = null;
            this._java_environment = null;
            this._messageDispatcher = null;
        }
        catch (InterruptedException e) {
            System.err.println(this.getClass().getName() + ".dispose - InterruptedException:" + e);
        }
    }

    public Object getInstance(String instanceName) {
        Type t = new Type(XInterface.class);
        return this.sendInternalRequest(instanceName, t, "queryInterface", new Object[]{t});
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this.protocol + "," + this._xConnection.getDescription();
    }

    public void sendReply(boolean exception, ThreadId threadId, Object result) {
        this.checkDisposed();
        try {
            this._iProtocol.writeReply(exception, threadId, result);
        }
        catch (IOException e) {
            this.dispose(e);
            throw (DisposedException)new DisposedException("unexpected " + e).initCause(e);
        }
        catch (RuntimeException e) {
            this.dispose(e);
            throw e;
        }
        catch (Error e) {
            this.dispose(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendRequest(String oid, Type type, String operation, Object[] params) throws Throwable {
        Object result = null;
        this.checkDisposed();
        ThreadId threadId = this._iThreadPool.getThreadId();
        Object handle = this._iThreadPool.attach(threadId);
        try {
            boolean sync;
            try {
                sync = this._iProtocol.writeRequest(oid, TypeDescription.getTypeDescription(type), operation, threadId, params);
            }
            catch (IOException e) {
                this.dispose(e);
                throw (DisposedException)new DisposedException(e.toString()).initCause(e);
            }
            if (sync && Thread.currentThread() != this._messageDispatcher) {
                result = this._iThreadPool.enter(handle, threadId);
            }
        }
        finally {
            this._iThreadPool.detach(handle, threadId);
            if (operation.equals("release")) {
                this.release();
            }
        }
        if (operation.equals("queryInterface") && result instanceof Any) {
            Any a = (Any)result;
            result = a.getType().getTypeClass() == TypeClass.INTERFACE ? a.getObject() : null;
        }
        return result;
    }

    private Object sendInternalRequest(String oid, Type type, String operation, Object[] arguments) {
        try {
            return this.sendRequest(oid, type, operation, arguments);
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("Unexpected " + e);
        }
    }

    public void addEventListener(XEventListener xEventListener) {
        this._listeners.add(xEventListener);
    }

    public void removeEventListener(XEventListener xEventListener) {
        this._listeners.remove(xEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisposeListener(DisposeListener listener) {
        java_remote_bridge java_remote_bridge2 = this;
        synchronized (java_remote_bridge2) {
            if (!this.disposed) {
                this.disposeListeners.add(listener);
                return;
            }
        }
        listener.notifyDispose(this);
    }

    private synchronized void checkDisposed() {
        if (this.disposed) {
            throw new DisposedException("java_remote_bridge " + this + " is disposed");
        }
    }

    private static final class RefHolder {
        private final Type type;
        private final Object object;
        private int count = 1;

        public RefHolder(Type type, Object object) {
            this.type = type;
            this.object = object;
        }

        public Type getType() {
            return this.type;
        }

        public void acquire() {
            ++this.count;
        }

        public boolean release() {
            return --this.count == 0;
        }
    }

    private final class MessageDispatcher
    extends Thread {
        private boolean terminate;

        public MessageDispatcher() {
            super("MessageDispatcher");
            this.terminate = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    MessageDispatcher messageDispatcher = this;
                    synchronized (messageDispatcher) {
                        if (this.terminate) {
                            break;
                        }
                    }
                    Message msg = java_remote_bridge.this._iProtocol.readMessage();
                    Object obj = null;
                    if (msg.isRequest()) {
                        String oid = msg.getObjectId();
                        Type type = new Type(msg.getType());
                        int fid = msg.getMethod().getIndex();
                        if (fid == 2) {
                            java_remote_bridge.this._java_environment.revokeInterface(oid, type);
                            java_remote_bridge.this.remRefHolder(type, oid);
                            if (!msg.isSynchronous()) continue;
                            java_remote_bridge.this.sendReply(false, msg.getThreadId(), null);
                            continue;
                        }
                        obj = java_remote_bridge.this._java_environment.getRegisteredInterface(oid, type);
                        if (obj == null && fid == 0) {
                            if (java_remote_bridge.this._xInstanceProvider == null) {
                                java_remote_bridge.this.sendReply(true, msg.getThreadId(), new com.sun.star.uno.RuntimeException("unknown OID " + oid));
                                continue;
                            }
                            UnoRuntime.setCurrentContext(msg.getCurrentContext());
                            try {
                                obj = java_remote_bridge.this._xInstanceProvider.getInstance(oid);
                            }
                            catch (com.sun.star.uno.RuntimeException e) {
                                java_remote_bridge.this.sendReply(true, msg.getThreadId(), e);
                                continue;
                            }
                            catch (Exception e) {
                                java_remote_bridge.this.sendReply(true, msg.getThreadId(), new com.sun.star.uno.RuntimeException(e.toString()));
                                continue;
                            }
                            finally {
                                UnoRuntime.setCurrentContext(null);
                                continue;
                            }
                        }
                    }
                    java_remote_bridge.this._iThreadPool.putJob(new Job(obj, java_remote_bridge.this, msg));
                }
            }
            catch (Throwable e) {
                java_remote_bridge.this.dispose(e);
            }
        }

        public synchronized void terminate() {
            this.terminate = true;
        }
    }
}

