/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.io;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.document.XDocumentSubStorageSupplier;
import com.sun.star.embed.XStorage;
import com.sun.star.embed.XTransactedObject;
import com.sun.star.frame.XModel;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.io.XStream;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.PathUtils;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class XStorageHelper
implements XEventListener {
    XStorage[] xStorages;
    XStream xStream;
    XInputStream xIs = null;
    XOutputStream xOs = null;
    static Map<String, XModel> modelMap = new HashMap<String, XModel>();
    XModel xModel = null;
    private static XStorageHelper listener = new XStorageHelper();

    private XStorageHelper() {
    }

    public XStorageHelper(String path, int mode, boolean create) throws IOException {
        String modelUrl = null;
        int indexOfScriptsDir = path.lastIndexOf("Scripts");
        if (indexOfScriptsDir > -1) {
            modelUrl = path.substring(0, indexOfScriptsDir - 1);
            path = path.substring(indexOfScriptsDir, path.length());
        }
        LogUtils.DEBUG("XStorageHelper ctor, path: " + path);
        this.xModel = this.getModelForURL(modelUrl);
        try {
            StringTokenizer tokens = new StringTokenizer(path, "/");
            if (tokens.countTokens() == 0) {
                throw new IOException("Invalid path");
            }
            XDocumentSubStorageSupplier xDocumentSubStorageSupplier = (XDocumentSubStorageSupplier)UnoRuntime.queryInterface(XDocumentSubStorageSupplier.class, (Object)this.xModel);
            this.xStorages = new XStorage[tokens.countTokens()];
            LogUtils.DEBUG("XStorageHelper ctor, path chunks length: " + this.xStorages.length);
            for (int i = 0; i < this.xStorages.length; ++i) {
                LogUtils.DEBUG("XStorageHelper, processing index " + i);
                String name = tokens.nextToken();
                LogUtils.DEBUG("XStorageHelper, getting: " + name);
                XStorage storage = null;
                if (i == 0) {
                    XPropertySet xProps;
                    storage = xDocumentSubStorageSupplier.getDocumentSubStorage(name, mode);
                    if (storage == null) {
                        LogUtils.DEBUG("** boo hoo Storage is null ");
                    }
                    if ((xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)storage)) != null) {
                        String mediaType = AnyConverter.toString((Object)xProps.getPropertyValue("MediaType"));
                        LogUtils.DEBUG("***** media type is " + mediaType);
                        if (!mediaType.equals("scripts")) {
                            xProps.setPropertyValue("MediaType", (Object)"scripts");
                        }
                    }
                } else {
                    XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)this.xStorages[i - 1]);
                    if (xNameAccess == null) {
                        this.disposeObject();
                        throw new IOException("No name access " + name);
                    }
                    if (!xNameAccess.hasByName(name) || !this.xStorages[i - 1].isStorageElement(name)) {
                        if (!create) {
                            this.disposeObject();
                            throw new IOException("No subdir: " + name);
                        }
                        LogUtils.DEBUG("Attempt to create new storage for " + name);
                    }
                    storage = this.xStorages[i - 1].openStorageElement(name, mode);
                }
                if (storage == null) {
                    this.disposeObject();
                    throw new IOException("storage not found: " + name);
                }
                this.xStorages[i] = storage;
            }
        }
        catch (com.sun.star.io.IOException ioe) {
            this.disposeObject();
        }
        catch (com.sun.star.uno.Exception ex1) {
            this.disposeObject();
            IOException ex2 = new IOException();
            ex2.initCause(ex1);
            throw ex2;
        }
    }

    public static synchronized void addNewModel(XModel model) {
        modelMap.put(PathUtils.getOidForModel(model), model);
        XComponent xComp = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)model);
        if (xComp != null) {
            try {
                xComp.addEventListener((XEventListener)listener);
            }
            catch (Exception e) {
                LogUtils.DEBUG(LogUtils.getTrace(e));
            }
        }
    }

    public void disposing(EventObject Source) {
        XModel model = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)Source.Source);
        if (model != null) {
            LogUtils.DEBUG(" Disposing doc " + model.getURL());
            modelMap.remove(PathUtils.getOidForModel(model));
        }
    }

    public XStorage getStorage() {
        return this.xStorages[this.xStorages.length - 1];
    }

    public XModel getModel() {
        return this.xModel;
    }

    public void disposeObject() {
        this.disposeObject(false);
    }

    public void disposeObject(boolean shouldCommit) {
        LogUtils.DEBUG("In disposeObject");
        for (int i = this.xStorages.length - 1; i > -1; --i) {
            LogUtils.DEBUG("In disposeObject disposing storage " + i);
            try {
                XStorage xStorage = this.xStorages[i];
                if (shouldCommit) {
                    XStorageHelper.commit((XInterface)xStorage);
                }
                XStorageHelper.disposeObject((XInterface)xStorage);
                LogUtils.DEBUG("In disposeObject disposed storage " + i);
                continue;
            }
            catch (Exception ignore) {
                LogUtils.DEBUG("Exception disposing storage " + i);
            }
        }
    }

    public static void disposeObject(XInterface xInterface) {
        if (xInterface == null) {
            return;
        }
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xInterface);
        if (xComponent == null) {
            return;
        }
        xComponent.dispose();
    }

    public static void commit(XInterface xInterface) {
        XTransactedObject xTrans = (XTransactedObject)UnoRuntime.queryInterface(XTransactedObject.class, (Object)xInterface);
        if (xTrans != null) {
            try {
                xTrans.commit();
            }
            catch (Exception e) {
                LogUtils.DEBUG("Something went bellyup exception: " + e);
            }
        }
    }

    public XModel getModelForURL(String url) {
        return modelMap.get(url);
    }
}

