/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.TextElement;

public class PlaceholderTextElement
extends TextElement {
    private String hint;
    private String placeHolderText;
    private XMultiServiceFactory xmsf;

    public PlaceholderTextElement(XTextRange textRange, String placeHolderText_, String hint_, XMultiServiceFactory xmsf_) {
        super(textRange);
        this.placeHolderText = placeHolderText_;
        this.hint = hint_;
        this.xmsf = xmsf_;
    }

    public void write(Object textRange) {
        super.write(textRange);
        if (this.text == null || this.text.equals(PropertyNames.EMPTY_STRING)) {
            XTextRange xTextRange = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)textRange);
            try {
                XTextContent xTextContent = PlaceholderTextElement.createPlaceHolder(this.xmsf, this.placeHolderText, this.hint);
                xTextRange.getText().insertTextContent(xTextRange.getStart(), xTextContent, true);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static XTextContent createPlaceHolder(XMultiServiceFactory xmsf, String ph, String hint) {
        Object placeHolder;
        try {
            placeHolder = xmsf.createInstance("com.sun.star.text.TextField.JumpEdit");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        Helper.setUnoPropertyValue(placeHolder, "PlaceHolder", ph);
        Helper.setUnoPropertyValue(placeHolder, "Hint", hint);
        Helper.setUnoPropertyValue(placeHolder, "PlaceHolderType", (short)0);
        return (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)placeHolder);
    }
}

