/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost.basic;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oauth.signpost.http.HttpRequest;

public class HttpURLConnectionRequestAdapter
implements HttpRequest {
    protected HttpURLConnection connection;

    public HttpURLConnectionRequestAdapter(HttpURLConnection httpURLConnection) {
        this.connection = httpURLConnection;
    }

    @Override
    public String getMethod() {
        return this.connection.getRequestMethod();
    }

    @Override
    public String getRequestUrl() {
        return this.connection.getURL().toExternalForm();
    }

    @Override
    public void setRequestUrl(String string) {
    }

    @Override
    public void setHeader(String string, String string2) {
        this.connection.setRequestProperty(string, string2);
    }

    @Override
    public String getHeader(String string) {
        return this.connection.getRequestProperty(string);
    }

    @Override
    public Map<String, String> getAllHeaders() {
        Map<String, List<String>> map = this.connection.getRequestProperties();
        HashMap<String, String> hashMap = new HashMap<String, String>(map.size());
        for (String string : map.keySet()) {
            List<String> list = map.get(string);
            if (list.isEmpty()) continue;
            hashMap.put(string, list.get(0));
        }
        return hashMap;
    }

    @Override
    public InputStream getMessagePayload() throws IOException {
        return null;
    }

    @Override
    public String getContentType() {
        return this.connection.getRequestProperty("Content-Type");
    }

    @Override
    public HttpURLConnection unwrap() {
        return this.connection;
    }
}

