/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;

public class LambertAzimuthalEqualArea
extends AbstractProj {
    private static final double EPSILON = 1.0E-7;
    private static final double FINE_EPSILON = 1.0E-10;
    private static final double EPSILON_LATITUDE = 1.0E-10;
    private static final double P00 = 0.3333333333333333;
    private static final double P01 = 0.17222222222222222;
    private static final double P02 = 0.10257936507936508;
    private static final double P10 = 0.06388888888888888;
    private static final double P11 = 0.0664021164021164;
    private static final double P20 = 0.016415012942191543;
    private Mode mode;
    private double sinb1;
    private double cosb1;
    private double xmf;
    private double ymf;
    private double qp;
    private double dd;
    private double rq;
    private double aPA0;
    private double aPA1;
    private double aPA2;
    private double latitudeOfOrigin;

    @Override
    public String getName() {
        return I18n.tr("Lambert Azimuthal Equal Area", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "laea";
    }

    @Override
    public void initialize(ProjParameters projParameters) throws ProjectionConfigurationException {
        super.initialize(projParameters);
        if (projParameters.lat0 == null) {
            throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_0"));
        }
        this.latitudeOfOrigin = Math.toRadians(projParameters.lat0);
        double d = Math.abs(this.latitudeOfOrigin);
        this.mode = Math.abs(d - 1.5707963267948966) < 1.0E-10 ? (this.latitudeOfOrigin < 0.0 ? Mode.SOUTH_POLE : Mode.NORTH_POLE) : (Math.abs(d) < 1.0E-10 ? Mode.EQUATORIAL : Mode.OBLIQUE);
        double d2 = this.e2 * this.e2;
        double d3 = this.e2 * d2;
        this.aPA0 = 0.10257936507936508 * d3 + 0.17222222222222222 * d2 + 0.3333333333333333 * this.e2;
        this.aPA1 = 0.0664021164021164 * d3 + 0.06388888888888888 * d2;
        this.aPA2 = 0.016415012942191543 * d3;
        this.qp = this.qsfn(1.0);
        this.rq = Math.sqrt(0.5 * this.qp);
        double d4 = Math.sin(this.latitudeOfOrigin);
        this.sinb1 = this.qsfn(d4) / this.qp;
        this.cosb1 = Math.sqrt(1.0 - this.sinb1 * this.sinb1);
        switch (this.mode) {
            case NORTH_POLE: 
            case SOUTH_POLE: {
                this.dd = 1.0;
                this.xmf = this.ymf = this.rq;
                break;
            }
            case EQUATORIAL: {
                this.dd = 1.0 / this.rq;
                this.xmf = 1.0;
                this.ymf = 0.5 * this.qp;
                break;
            }
            case OBLIQUE: {
                this.dd = Math.cos(this.latitudeOfOrigin) / (Math.sqrt(1.0 - this.e2 * d4 * d4) * this.rq * this.cosb1);
                this.xmf = this.rq * this.dd;
                this.ymf = this.rq / this.dd;
                break;
            }
            default: {
                throw new AssertionError((Object)this.mode);
            }
        }
    }

    @Override
    public double[] project(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6 = Math.cos(d2);
        double d7 = Math.sin(d2);
        double d8 = Math.sin(d);
        double d9 = this.qsfn(d8);
        switch (this.mode) {
            case OBLIQUE: {
                double d10 = d9 / this.qp;
                double d11 = Math.sqrt(1.0 - d10 * d10);
                d5 = 1.0 + this.sinb1 * d10 + this.cosb1 * d11 * d6;
                double d12 = Math.sqrt(2.0 / d5);
                d4 = this.ymf * d12 * (this.cosb1 * d10 - this.sinb1 * d11 * d6);
                d3 = this.xmf * d12 * d11 * d7;
                break;
            }
            case EQUATORIAL: {
                double d13 = d9 / this.qp;
                double d14 = Math.sqrt(1.0 - d13 * d13);
                d5 = 1.0 + d14 * d6;
                double d15 = Math.sqrt(2.0 / d5);
                d4 = this.ymf * d15 * d13;
                d3 = this.xmf * d15 * d14 * d7;
                break;
            }
            case NORTH_POLE: {
                d5 = 1.5707963267948966 + d;
                d9 = this.qp - d9;
                if (d9 >= 0.0) {
                    double d16 = Math.sqrt(d9);
                    d3 = d16 * d7;
                    d4 = d6 * -d16;
                    break;
                }
                d4 = 0.0;
                d3 = 0.0;
                break;
            }
            case SOUTH_POLE: {
                d5 = d - 1.5707963267948966;
                d9 = this.qp + d9;
                if (d9 >= 0.0) {
                    double d17 = Math.sqrt(d9);
                    d3 = d17 * d7;
                    d4 = d6 * d17;
                    break;
                }
                d4 = 0.0;
                d3 = 0.0;
                break;
            }
            default: {
                throw new AssertionError((Object)this.mode);
            }
        }
        if (Math.abs(d5) < 1.0E-10) {
            return new double[]{0.0, 0.0};
        }
        return new double[]{d3, d4};
    }

    @Override
    public double[] invproject(double d, double d2) {
        double d3;
        double d4;
        switch (this.mode) {
            case EQUATORIAL: 
            case OBLIQUE: {
                double d5;
                double d6 = Math.hypot(d /= this.dd, d2 *= this.dd);
                if (d6 < 1.0E-10) {
                    d4 = 0.0;
                    d3 = this.latitudeOfOrigin;
                    break;
                }
                double d7 = 2.0 * Math.asin(0.5 * d6 / this.rq);
                double d8 = Math.cos(d7);
                d7 = Math.sin(d7);
                d *= d7;
                if (this.mode == Mode.OBLIQUE) {
                    d5 = d8 * this.sinb1 + d2 * d7 * this.cosb1 / d6;
                    d2 = d6 * this.cosb1 * d8 - d2 * this.sinb1 * d7;
                } else {
                    d5 = d2 * d7 / d6;
                    d2 = d6 * d8;
                }
                d4 = Math.atan2(d, d2);
                d3 = this.authlat(Math.asin(d5));
                break;
            }
            case NORTH_POLE: {
                d2 = -d2;
            }
            case SOUTH_POLE: {
                double d9 = d * d + d2 * d2;
                if (d9 == 0.0) {
                    d4 = 0.0;
                    d3 = this.latitudeOfOrigin;
                    break;
                }
                double d10 = 1.0 - d9 / this.qp;
                if (this.mode == Mode.SOUTH_POLE) {
                    d10 = -d10;
                }
                d4 = Math.atan2(d, d2);
                d3 = this.authlat(Math.asin(d10));
                break;
            }
            default: {
                throw new AssertionError((Object)this.mode);
            }
        }
        return new double[]{d3, d4};
    }

    private double qsfn(double d) {
        if (this.e >= 1.0E-7) {
            double d2 = this.e * d;
            return (1.0 - this.e2) * (d / (1.0 - d2 * d2) - 0.5 / this.e * Math.log((1.0 - d2) / (1.0 + d2)));
        }
        return d + d;
    }

    private double authlat(double d) {
        double d2 = d + d;
        return d + this.aPA0 * Math.sin(d2) + this.aPA1 * Math.sin(d2 + d2) + this.aPA2 * Math.sin(d2 + d2 + d2);
    }

    @Override
    public Bounds getAlgorithmBounds() {
        return new Bounds(-89.0, -174.0, 89.0, 174.0, false);
    }

    private static enum Mode {
        OBLIQUE,
        EQUATORIAL,
        NORTH_POLE,
        SOUTH_POLE;

    }
}

