/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetSelector;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public final class TaggingPresetSearchPrimitiveDialog
extends ExtendedDialog {
    private static TaggingPresetSearchPrimitiveDialog instance;
    private final TaggingPresetSelector selector = new TaggingPresetSelector(false, false);

    public static synchronized TaggingPresetSearchPrimitiveDialog getInstance() {
        if (instance == null) {
            instance = new TaggingPresetSearchPrimitiveDialog();
        }
        return instance;
    }

    TaggingPresetSearchPrimitiveDialog() {
        super(Main.parent, I18n.tr("Presets", new Object[0]), new String[]{I18n.tr("Search", new Object[0]), I18n.tr("Cancel", new Object[0])});
        this.setContent(this.selector, false);
        this.selector.setDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaggingPresetSearchPrimitiveDialog.this.buttonAction(0, null);
            }
        });
    }

    @Override
    public ExtendedDialog showDialog() {
        this.selector.init();
        super.showDialog();
        this.selector.clearSelection();
        return this;
    }

    @Override
    protected void buttonAction(int n, ActionEvent actionEvent) {
        TaggingPreset taggingPreset;
        super.buttonAction(n, actionEvent);
        if (n == 0 && (taggingPreset = this.selector.getSelectedPresetAndUpdateClassification()) != null) {
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(Utils.filter(Main.getLayerManager().getEditDataSet().allPrimitives(), taggingPreset));
            Main.getLayerManager().getEditDataSet().setSelected(hashSet);
        }
    }

    public static class Action
    extends JosmAction {
        public Action() {
            super(I18n.tr("Search for objects by preset...", new Object[0]), "dialogs/search", I18n.tr("Show preset search dialog", new Object[0]), Shortcut.registerShortcut("preset:search-objects", I18n.tr("Search for objects by preset", new Object[0]), 114, 5005), false);
            this.putValue("toolbar", "presets/search-objects");
            Main.toolbar.register(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (Main.getLayerManager().getEditLayer() != null) {
                TaggingPresetSearchPrimitiveDialog.getInstance().showDialog();
            }
        }

        @Override
        protected void updateEnabledState() {
            this.setEnabled(this.getLayerManager().getEditLayer() != null);
        }
    }
}

