/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.Elevatable;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Selectable;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class Polyline
implements Serializable,
Selectable,
Elevatable {
    private static final long serialVersionUID = 1L;
    private float[][] points;
    private float thickness;
    private transient CapStyle capStyle;
    private String capStyleName;
    private transient JoinStyle joinStyle;
    private String joinStyleName;
    private transient DashStyle dashStyle;
    private String dashStyleName;
    private transient ArrowStyle startArrowStyle;
    private String startArrowStyleName;
    private transient ArrowStyle endArrowStyle;
    private String endArrowStyleName;
    private boolean closedPath;
    private int color;
    private Level level;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private transient Shape polylinePathCache;
    private transient Shape shapeCache;

    public Polyline(float[][] fArray) {
        this(fArray, 1.0f, CapStyle.BUTT, JoinStyle.MITER, DashStyle.SOLID, ArrowStyle.NONE, ArrowStyle.NONE, false, 0);
    }

    public Polyline(float[][] fArray, float f, CapStyle capStyle, JoinStyle joinStyle, DashStyle dashStyle, ArrowStyle arrowStyle, ArrowStyle arrowStyle2, boolean bl, int n) {
        this.points = this.deepCopy(fArray);
        this.thickness = f;
        this.capStyle = capStyle;
        this.joinStyle = joinStyle;
        this.dashStyle = dashStyle;
        this.startArrowStyle = arrowStyle;
        this.endArrowStyle = arrowStyle2;
        this.closedPath = bl;
        this.color = n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        objectInputStream.defaultReadObject();
        try {
            if (this.capStyleName != null) {
                this.capStyle = CapStyle.valueOf(this.capStyleName);
                this.capStyleName = null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            if (this.joinStyleName != null) {
                this.joinStyle = JoinStyle.valueOf(this.joinStyleName);
                this.joinStyleName = null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            if (this.dashStyleName != null) {
                this.dashStyle = DashStyle.valueOf(this.dashStyleName);
                this.dashStyleName = null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            if (this.startArrowStyleName != null) {
                this.startArrowStyle = ArrowStyle.valueOf(this.startArrowStyleName);
                this.startArrowStyleName = null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            if (this.endArrowStyleName != null) {
                this.endArrowStyle = ArrowStyle.valueOf(this.endArrowStyleName);
                this.endArrowStyleName = null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.capStyleName = this.capStyle.name();
        this.joinStyleName = this.joinStyle.name();
        this.dashStyleName = this.dashStyle.name();
        this.startArrowStyleName = this.startArrowStyle.name();
        this.endArrowStyleName = this.endArrowStyle.name();
        objectOutputStream.defaultWriteObject();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public float[][] getPoints() {
        return this.deepCopy(this.points);
    }

    public int getPointCount() {
        return this.points.length;
    }

    private float[][] deepCopy(float[][] fArray) {
        float[][] fArrayArray = new float[fArray.length][];
        for (int i = 0; i < fArray.length; ++i) {
            fArrayArray[i] = (float[])fArray[i].clone();
        }
        return fArrayArray;
    }

    public void setPoints(float[][] fArray) {
        if (!Arrays.deepEquals((Object[])this.points, (Object[])fArray)) {
            this.updatePoints(fArray);
        }
    }

    private void updatePoints(float[][] fArray) {
        float[][] fArray2 = this.points;
        this.points = this.deepCopy(fArray);
        this.polylinePathCache = null;
        this.shapeCache = null;
        this.propertyChangeSupport.firePropertyChange(Property.POINTS.name(), fArray2, fArray);
    }

    public void addPoint(float f, float f2) {
        this.addPoint(f, f2, this.points.length);
    }

    public void addPoint(float f, float f2, int n) {
        if (n < 0 || n > this.points.length) {
            throw new IndexOutOfBoundsException("Invalid index " + n);
        }
        float[][] fArrayArray = new float[this.points.length + 1][];
        System.arraycopy(this.points, 0, fArrayArray, 0, n);
        fArrayArray[n] = new float[]{f, f2};
        System.arraycopy(this.points, n, fArrayArray, n + 1, this.points.length - n);
        float[][] fArray = this.points;
        this.points = fArrayArray;
        this.polylinePathCache = null;
        this.shapeCache = null;
        this.propertyChangeSupport.firePropertyChange(Property.POINTS.name(), fArray, this.deepCopy(this.points));
    }

    public void setPoint(float f, float f2, int n) {
        if (n < 0 || n >= this.points.length) {
            throw new IndexOutOfBoundsException("Invalid index " + n);
        }
        if (this.points[n][0] != f || this.points[n][1] != f2) {
            float[][] fArray = this.points;
            this.points = this.deepCopy(this.points);
            this.points[n][0] = f;
            this.points[n][1] = f2;
            this.polylinePathCache = null;
            this.shapeCache = null;
            this.propertyChangeSupport.firePropertyChange(Property.POINTS.name(), fArray, this.deepCopy(this.points));
        }
    }

    public void removePoint(int n) {
        if (n < 0 || n >= this.points.length) {
            throw new IndexOutOfBoundsException("Invalid index " + n);
        }
        float[][] fArrayArray = new float[this.points.length - 1][];
        System.arraycopy(this.points, 0, fArrayArray, 0, n);
        System.arraycopy(this.points, n + 1, fArrayArray, n, this.points.length - n - 1);
        float[][] fArray = this.points;
        this.points = fArrayArray;
        this.polylinePathCache = null;
        this.shapeCache = null;
        this.propertyChangeSupport.firePropertyChange(Property.POINTS.name(), fArray, this.deepCopy(this.points));
    }

    public float getThickness() {
        return this.thickness;
    }

    public void setThickness(float f) {
        if (f != this.thickness) {
            float f2 = this.thickness;
            this.thickness = f;
            this.propertyChangeSupport.firePropertyChange(Property.THICKNESS.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public CapStyle getCapStyle() {
        return this.capStyle;
    }

    public void setCapStyle(CapStyle capStyle) {
        if (capStyle != this.capStyle) {
            CapStyle capStyle2 = this.capStyle;
            this.capStyle = capStyle;
            this.propertyChangeSupport.firePropertyChange(Property.CAP_STYLE.name(), (Object)capStyle2, (Object)capStyle);
        }
    }

    public JoinStyle getJoinStyle() {
        return this.joinStyle;
    }

    public void setJoinStyle(JoinStyle joinStyle) {
        if (joinStyle != this.joinStyle) {
            JoinStyle joinStyle2 = this.joinStyle;
            this.joinStyle = joinStyle;
            this.polylinePathCache = null;
            this.shapeCache = null;
            this.propertyChangeSupport.firePropertyChange(Property.JOIN_STYLE.name(), (Object)joinStyle2, (Object)joinStyle);
        }
    }

    public DashStyle getDashStyle() {
        return this.dashStyle;
    }

    public void setDashStyle(DashStyle dashStyle) {
        if (dashStyle != this.dashStyle) {
            DashStyle dashStyle2 = this.dashStyle;
            this.dashStyle = dashStyle;
            this.propertyChangeSupport.firePropertyChange(Property.DASH_STYLE.name(), (Object)dashStyle2, (Object)dashStyle);
        }
    }

    public ArrowStyle getStartArrowStyle() {
        return this.startArrowStyle;
    }

    public void setStartArrowStyle(ArrowStyle arrowStyle) {
        if (arrowStyle != this.startArrowStyle) {
            ArrowStyle arrowStyle2 = this.startArrowStyle;
            this.startArrowStyle = arrowStyle;
            this.propertyChangeSupport.firePropertyChange(Property.START_ARROW_STYLE.name(), (Object)arrowStyle2, (Object)arrowStyle);
        }
    }

    public ArrowStyle getEndArrowStyle() {
        return this.endArrowStyle;
    }

    public void setEndArrowStyle(ArrowStyle arrowStyle) {
        if (arrowStyle != this.endArrowStyle) {
            ArrowStyle arrowStyle2 = this.endArrowStyle;
            this.endArrowStyle = arrowStyle;
            this.propertyChangeSupport.firePropertyChange(Property.END_ARROW_STYLE.name(), (Object)arrowStyle2, (Object)arrowStyle);
        }
    }

    public boolean isClosedPath() {
        return this.closedPath;
    }

    public void setClosedPath(boolean bl) {
        if (bl != this.closedPath) {
            this.closedPath = bl;
            this.propertyChangeSupport.firePropertyChange(Property.CLOSED_PATH.name(), !bl, bl);
        }
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int n) {
        if (n != this.color) {
            int n2 = this.color;
            this.color = n;
            this.propertyChangeSupport.firePropertyChange(Property.COLOR.name(), n2, n);
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        if (level != this.level) {
            Level level2 = this.level;
            this.level = level;
            this.propertyChangeSupport.firePropertyChange(Property.LEVEL.name(), level2, level);
        }
    }

    public boolean isAtLevel(Level level) {
        return this.level == level || this.level != null && level != null && this.level.getElevation() == level.getElevation() && this.level.getElevationIndex() < level.getElevationIndex();
    }

    public float getLength() {
        float[] fArray = new float[2];
        float[] fArray2 = new float[2];
        float[] fArray3 = new float[2];
        float f = 0.0f;
        PathIterator pathIterator = this.getPolylinePath().getPathIterator(null, 0.1);
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray3)) {
                case 4: {
                    f = (float)((double)f + Point2D.distance(fArray[0], fArray[1], fArray2[0], fArray2[1]));
                    break;
                }
                case 0: {
                    System.arraycopy(fArray3, 0, fArray, 0, 2);
                    System.arraycopy(fArray3, 0, fArray2, 0, 2);
                    break;
                }
                case 1: {
                    f = (float)((double)f + Point2D.distance(fArray2[0], fArray2[1], fArray3[0], fArray3[1]));
                    System.arraycopy(fArray3, 0, fArray2, 0, 2);
                }
            }
            pathIterator.next();
        }
        return f;
    }

    public boolean intersectsRectangle(float f, float f2, float f3, float f4) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, 0.0f, 0.0f);
        float_.add(f3, f4);
        return this.getShape().intersects(float_);
    }

    public boolean containsPoint(float f, float f2, float f3) {
        return this.containsShapeAtWithMargin(this.getShape(), f, f2, f3);
    }

    public int getPointIndexAt(float f, float f2, float f3) {
        for (int i = 0; i < this.points.length; ++i) {
            if (!(Math.abs(f - this.points[i][0]) <= f3) || !(Math.abs(f2 - this.points[i][1]) <= f3)) continue;
            return i;
        }
        return -1;
    }

    private boolean containsShapeAtWithMargin(Shape shape, float f, float f2, float f3) {
        if (f3 == 0.0f) {
            return shape.contains(f, f2);
        }
        return shape.intersects(f - f3, f2 - f3, 2.0f * f3, 2.0f * f3);
    }

    private Shape getPolylinePath() {
        if (this.polylinePathCache == null) {
            GeneralPath generalPath = new GeneralPath();
            if (this.joinStyle == JoinStyle.CURVED) {
                int n;
                int n2 = n = this.closedPath ? this.points.length : this.points.length - 1;
                for (int i = 0; i < n; ++i) {
                    CubicCurve2D.Float float_ = new CubicCurve2D.Float();
                    float[] fArray = this.points[i == 0 ? this.points.length - 1 : i - 1];
                    float[] fArray2 = this.points[i];
                    float[] fArray3 = this.points[i == this.points.length - 1 ? 0 : i + 1];
                    float[] fArray4 = new float[]{fArray3[0] - fArray[0], fArray3[1] - fArray[1]};
                    float[] fArray5 = this.points[(i + 2) % this.points.length];
                    float[] fArray6 = new float[]{fArray2[0] - fArray5[0], fArray2[1] - fArray5[1]};
                    float_.setCurve(fArray2[0], fArray2[1], fArray2[0] + (i != 0 || this.closedPath ? fArray4[0] / 3.625f : 0.0f), fArray2[1] + (i != 0 || this.closedPath ? fArray4[1] / 3.625f : 0.0f), fArray3[0] + (i != this.points.length - 2 || this.closedPath ? fArray6[0] / 3.625f : 0.0f), fArray3[1] + (i != this.points.length - 2 || this.closedPath ? fArray6[1] / 3.625f : 0.0f), fArray3[0], fArray3[1]);
                    generalPath.append(float_, true);
                }
            } else {
                generalPath.moveTo(this.points[0][0], this.points[0][1]);
                for (int i = 1; i < this.points.length; ++i) {
                    generalPath.lineTo(this.points[i][0], this.points[i][1]);
                }
                if (this.closedPath) {
                    generalPath.closePath();
                }
            }
            this.polylinePathCache = generalPath;
        }
        return this.polylinePathCache;
    }

    private Shape getShape() {
        if (this.shapeCache == null) {
            this.shapeCache = new BasicStroke(this.thickness).createStrokedShape(this.getPolylinePath());
        }
        return this.shapeCache;
    }

    public void move(float f, float f2) {
        if (f != 0.0f || f2 != 0.0f) {
            float[][] fArray = this.getPoints();
            for (int i = 0; i < fArray.length; ++i) {
                float[] fArray2 = fArray[i];
                fArray2[0] = fArray2[0] + f;
                float[] fArray3 = fArray[i];
                fArray3[1] = fArray3[1] + f2;
            }
            this.updatePoints(fArray);
        }
    }

    public Polyline clone() {
        try {
            Polyline polyline = (Polyline)super.clone();
            polyline.propertyChangeSupport = new PropertyChangeSupport(polyline);
            return polyline;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Super class isn't cloneable");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DashStyle {
        SOLID,
        DOT,
        DASH,
        DASH_DOT,
        DASH_DOT_DOT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArrowStyle {
        NONE,
        DELTA,
        OPEN,
        DISC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JoinStyle {
        BEVEL,
        MITER,
        ROUND,
        CURVED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CapStyle {
        BUTT,
        SQUARE,
        ROUND;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        POINTS,
        THICKNESS,
        CAP_STYLE,
        JOIN_STYLE,
        DASH_STYLE,
        START_ARROW_STYLE,
        END_ARROW_STYLE,
        CLOSED_PATH,
        COLOR,
        LEVEL;

    }
}

