/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import org.netbeans.modules.search.GraphicalSearchListener;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.ResultViewPanel;
import org.netbeans.spi.search.provider.SearchComposition;
import org.netbeans.spi.search.provider.SearchResultsDisplayer;
import org.openide.LifecycleManager;
import org.openide.util.Cancellable;
import org.openide.util.Mutex;

final class SearchTask
implements Runnable,
Cancellable {
    private boolean notifyWhenFinished = true;
    private volatile boolean interrupted = false;
    private volatile boolean finished = false;
    private SearchComposition<?> searchComposition;
    private boolean replacing;
    private ResultViewPanel resultViewPanel = null;

    public SearchTask(SearchComposition<?> searchComposition, boolean bl) {
        this.searchComposition = searchComposition;
        this.replacing = bl;
    }

    private boolean isSearchAndReplace() {
        return this.replacing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.interrupted) {
            return;
        }
        if (this.isSearchAndReplace()) {
            LifecycleManager.getDefault().saveAll();
        }
        if (this.resultViewPanel == null) {
            this.resultViewPanel = ResultView.getInstance().addTab(this);
        }
        GraphicalSearchListener graphicalSearchListener = this.resultViewPanel.createListener();
        try {
            graphicalSearchListener.searchStarted();
            Mutex.EVENT.writeAccess(new Runnable(){

                @Override
                public void run() {
                    SearchTask.this.resultViewPanel.requestFocusInWindow();
                }
            });
            this.searchComposition.start(graphicalSearchListener);
        }
        catch (RuntimeException runtimeException) {
            graphicalSearchListener.generalError(runtimeException);
        }
        finally {
            this.finished = true;
            graphicalSearchListener.searchFinished();
        }
    }

    void stop(boolean bl) {
        if (!bl) {
            this.notifyWhenFinished = bl;
        }
        this.stop();
    }

    void stop() {
        if (!this.finished) {
            this.interrupted = true;
        }
        if (this.searchComposition != null) {
            this.searchComposition.terminate();
        }
    }

    public boolean cancel() {
        this.stop();
        return true;
    }

    boolean notifyWhenFinished() {
        return this.notifyWhenFinished;
    }

    boolean wasInterrupted() {
        return this.interrupted;
    }

    SearchResultsDisplayer<?> getDisplayer() {
        return this.searchComposition.getSearchResultsDisplayer();
    }

    SearchComposition<?> getComposition() {
        return this.searchComposition;
    }

    void setResultViewPanel(ResultViewPanel resultViewPanel) {
        this.resultViewPanel = resultViewPanel;
    }
}

