/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.common.model.Filter;
import net.sourceforge.glsof.common.preferences.AbstractCommandDialog;
import net.sourceforge.glsof.common.preferences.LsofParameterType;
import net.sourceforge.glsof.common.utils.GBC;
import net.sourceforge.glsof.common.utils.GLabel;

class NetworkCommandDialog
extends AbstractCommandDialog {
    private JTextField _address;
    private JTextField _port;
    private JComboBox _protocol;
    private JComboBox _ipv;

    public NetworkCommandDialog(LsofParameterType type) {
        super(type);
    }

    @Override
    protected void createDialogArea(JPanel parent) {
        parent.setLayout(new GridBagLayout());
        parent.add((Component)new GLabel("Address").tooltip(this.getTip("_address")).get(), new GBC().gridx(0).gridy(0).insets(new Insets(5, 5, 5, 5)).anchor(17).get());
        this._address = new JTextField(17);
        parent.add((Component)this._address, new GBC().gridx(1).gridy(0).weightx(1.0).anchor(17).insets(new Insets(5, 5, 5, 5)).fill(2).gridwidth(2).insets(new Insets(5, 5, 5, 5)).get());
        parent.add((Component)new GLabel("Port").tooltip(this.getTip("_port")).get(), new GBC().gridx(0).gridy(1).anchor(17).insets(new Insets(5, 5, 5, 5)).get());
        this._port = new JTextField(12);
        parent.add((Component)this._port, new GBC().gridx(1).gridy(1).anchor(17).insets(new Insets(5, 5, 5, 5)).get());
        this._protocol = this.createComboEntry(parent, "Protocol", this.getTip("_protocol"), new String[]{" ", "TCP", "UDP"}, 0, 2);
        this._ipv = this.createComboEntry(parent, "IPV", this.getTip("_ipv"), new String[]{" ", "4", "6"}, 0, 3);
    }

    private JComboBox createComboEntry(JPanel panel, String text, String tip, String[] items, int x, int y) {
        JLabel label = new GLabel(Messages.NLS(text)).tooltip(tip).get();
        panel.add((Component)label, new GBC().gridx(x).gridy(y).anchor(17).insets(new Insets(5, 5, 5, 5)).get());
        JComboBox<String> combo = new JComboBox<String>(items);
        panel.add(combo, new GBC().gridx(x + 1).gridy(y).anchor(17).insets(new Insets(5, 5, 5, 5)).get());
        return combo;
    }

    @Override
    protected boolean inputIsCorrect() {
        return true;
    }

    @Override
    public void copyValuesInTheMask(Filter filter) {
        List<String> values = filter.getValues();
        this._address.setText(values.get(0).trim());
        this._port.setText(values.get(1).trim());
        this._protocol.setSelectedIndex(values.get(2).equals(" ") ? 0 : (values.get(2).equals("TCP") ? 1 : 2));
        this._ipv.setSelectedIndex(values.get(3).equals(" ") ? 0 : (values.get(3).equals("4") ? 1 : 2));
    }

    @Override
    protected List<String> getModelFilterValuesFromTheMask() {
        return Arrays.asList(this._address.getText().trim().equals("") ? " " : this._address.getText().trim(), this._port.getText().trim().equals("") ? " " : this._port.getText().trim(), this._protocol.getSelectedItem().toString(), this._ipv.getSelectedItem().toString());
    }
}

