/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.spnego;

import java.security.Provider;
import java.util.Vector;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.GSSManagerImpl;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.ProviderList;
import sun.security.jgss.SunProvider;
import sun.security.jgss.krb5.Krb5AcceptCredential;
import sun.security.jgss.krb5.Krb5InitCredential;
import sun.security.jgss.krb5.Krb5MechFactory;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.jgss.spi.MechanismFactory;
import sun.security.jgss.spnego.SpNegoContext;
import sun.security.jgss.spnego.SpNegoCredElement;

public final class SpNegoMechFactory
implements MechanismFactory {
    static final Provider PROVIDER = new SunProvider();
    static final Oid GSS_SPNEGO_MECH_OID = GSSUtil.createOid("1.3.6.1.5.5.2");
    private static Oid[] nameTypes = new Oid[]{GSSName.NT_USER_NAME, GSSName.NT_HOSTBASED_SERVICE, GSSName.NT_EXPORT_NAME};
    private static final Oid DEFAULT_SPNEGO_MECH_OID = ProviderList.DEFAULT_MECH_OID.equals(GSS_SPNEGO_MECH_OID) ? GSSUtil.GSS_KRB5_MECH_OID : ProviderList.DEFAULT_MECH_OID;
    final GSSManagerImpl manager;
    final Oid[] availableMechs;

    private static SpNegoCredElement getCredFromSubject(GSSNameSpi gSSNameSpi, boolean bl) throws GSSException {
        GSSCredentialSpi gSSCredentialSpi;
        SpNegoCredElement spNegoCredElement;
        Vector<SpNegoCredElement> vector = GSSUtil.searchSubject(gSSNameSpi, GSS_SPNEGO_MECH_OID, bl, SpNegoCredElement.class);
        SpNegoCredElement spNegoCredElement2 = spNegoCredElement = vector == null || vector.isEmpty() ? null : vector.firstElement();
        if (spNegoCredElement != null && GSSUtil.isKerberosMech((gSSCredentialSpi = spNegoCredElement.getInternalCred()).getMechanism())) {
            if (bl) {
                Krb5InitCredential krb5InitCredential = (Krb5InitCredential)gSSCredentialSpi;
                Krb5MechFactory.checkInitCredPermission((Krb5NameElement)krb5InitCredential.getName());
            } else {
                Krb5AcceptCredential krb5AcceptCredential = (Krb5AcceptCredential)gSSCredentialSpi;
                Krb5MechFactory.checkAcceptCredPermission((Krb5NameElement)krb5AcceptCredential.getName(), gSSNameSpi);
            }
        }
        return spNegoCredElement;
    }

    public SpNegoMechFactory(GSSCaller gSSCaller) {
        int n;
        this.manager = new GSSManagerImpl(gSSCaller, false);
        Oid[] oidArray = this.manager.getMechs();
        this.availableMechs = new Oid[oidArray.length - 1];
        int n2 = 0;
        for (n = 0; n < oidArray.length; ++n) {
            if (oidArray[n].equals(GSS_SPNEGO_MECH_OID)) continue;
            this.availableMechs[n2++] = oidArray[n];
        }
        for (n = 0; n < this.availableMechs.length; ++n) {
            if (!this.availableMechs[n].equals(DEFAULT_SPNEGO_MECH_OID)) continue;
            if (n == 0) break;
            this.availableMechs[n] = this.availableMechs[0];
            this.availableMechs[0] = DEFAULT_SPNEGO_MECH_OID;
            break;
        }
    }

    @Override
    public GSSNameSpi getNameElement(String string, Oid oid) throws GSSException {
        return this.manager.getNameElement(string, oid, DEFAULT_SPNEGO_MECH_OID);
    }

    @Override
    public GSSNameSpi getNameElement(byte[] byArray, Oid oid) throws GSSException {
        return this.manager.getNameElement(byArray, oid, DEFAULT_SPNEGO_MECH_OID);
    }

    @Override
    public GSSCredentialSpi getCredentialElement(GSSNameSpi gSSNameSpi, int n, int n2, int n3) throws GSSException {
        SpNegoCredElement spNegoCredElement = SpNegoMechFactory.getCredFromSubject(gSSNameSpi, n3 != 2);
        if (spNegoCredElement == null) {
            spNegoCredElement = new SpNegoCredElement(this.manager.getCredentialElement(gSSNameSpi, n, n2, null, n3));
        }
        return spNegoCredElement;
    }

    @Override
    public GSSContextSpi getMechanismContext(GSSNameSpi gSSNameSpi, GSSCredentialSpi gSSCredentialSpi, int n) throws GSSException {
        if (gSSCredentialSpi == null) {
            gSSCredentialSpi = SpNegoMechFactory.getCredFromSubject(null, true);
        } else if (!(gSSCredentialSpi instanceof SpNegoCredElement)) {
            SpNegoCredElement spNegoCredElement = new SpNegoCredElement(gSSCredentialSpi);
            return new SpNegoContext(this, gSSNameSpi, spNegoCredElement, n);
        }
        return new SpNegoContext(this, gSSNameSpi, gSSCredentialSpi, n);
    }

    @Override
    public GSSContextSpi getMechanismContext(GSSCredentialSpi gSSCredentialSpi) throws GSSException {
        if (gSSCredentialSpi == null) {
            gSSCredentialSpi = SpNegoMechFactory.getCredFromSubject(null, false);
        } else if (!(gSSCredentialSpi instanceof SpNegoCredElement)) {
            SpNegoCredElement spNegoCredElement = new SpNegoCredElement(gSSCredentialSpi);
            return new SpNegoContext(this, spNegoCredElement);
        }
        return new SpNegoContext(this, gSSCredentialSpi);
    }

    @Override
    public GSSContextSpi getMechanismContext(byte[] byArray) throws GSSException {
        return new SpNegoContext(this, byArray);
    }

    @Override
    public final Oid getMechanismOid() {
        return GSS_SPNEGO_MECH_OID;
    }

    @Override
    public Provider getProvider() {
        return PROVIDER;
    }

    @Override
    public Oid[] getNameTypes() {
        return nameTypes;
    }
}

