/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import java.security.GeneralSecurityException;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.crypto.Aes256;
import sun.security.krb5.internal.crypto.EType;

public final class Aes256CtsHmacSha1EType
extends EType {
    @Override
    public int eType() {
        return 18;
    }

    @Override
    public int minimumPadSize() {
        return 0;
    }

    @Override
    public int confounderSize() {
        return this.blockSize();
    }

    @Override
    public int checksumType() {
        return 16;
    }

    @Override
    public int checksumSize() {
        return Aes256.getChecksumLength();
    }

    @Override
    public int blockSize() {
        return 16;
    }

    @Override
    public int keyType() {
        return 3;
    }

    @Override
    public int keySize() {
        return 32;
    }

    @Override
    public byte[] encrypt(byte[] byArray, byte[] byArray2, int n) throws KrbCryptoException {
        byte[] byArray3 = new byte[this.blockSize()];
        return this.encrypt(byArray, byArray2, byArray3, n);
    }

    @Override
    public byte[] encrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) throws KrbCryptoException {
        try {
            return Aes256.encrypt(byArray2, n, byArray3, byArray, 0, byArray.length);
        }
        catch (GeneralSecurityException generalSecurityException) {
            KrbCryptoException krbCryptoException = new KrbCryptoException(generalSecurityException.getMessage());
            krbCryptoException.initCause(generalSecurityException);
            throw krbCryptoException;
        }
    }

    @Override
    public byte[] decrypt(byte[] byArray, byte[] byArray2, int n) throws KrbApErrException, KrbCryptoException {
        byte[] byArray3 = new byte[this.blockSize()];
        return this.decrypt(byArray, byArray2, byArray3, n);
    }

    @Override
    public byte[] decrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) throws KrbApErrException, KrbCryptoException {
        try {
            return Aes256.decrypt(byArray2, n, byArray3, byArray, 0, byArray.length);
        }
        catch (GeneralSecurityException generalSecurityException) {
            KrbCryptoException krbCryptoException = new KrbCryptoException(generalSecurityException.getMessage());
            krbCryptoException.initCause(generalSecurityException);
            throw krbCryptoException;
        }
    }

    @Override
    public byte[] decryptedData(byte[] byArray) {
        return byArray;
    }
}

