/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.run;

import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.deployment.internal.DeploymentHandle;
import org.gradle.play.internal.run.PlayApplicationRunnerToken;

public class PlayApplicationDeploymentHandle
implements DeploymentHandle {
    private static final Logger LOGGER = Logging.getLogger(PlayApplicationDeploymentHandle.class);
    private PlayApplicationRunnerToken runnerToken;
    private final String id;

    public PlayApplicationDeploymentHandle(String id) {
        this.id = id;
    }

    public void start(PlayApplicationRunnerToken runnerToken) {
        this.runnerToken = runnerToken;
    }

    public boolean isRunning() {
        return this.runnerToken != null && this.runnerToken.isRunning();
    }

    public void onNewBuild(Gradle gradle) {
        gradle.addBuildListener((BuildListener)new BuildAdapter(){

            public void buildFinished(BuildResult result) {
                PlayApplicationDeploymentHandle.this.reloadFromResult(result);
            }
        });
    }

    void reloadFromResult(BuildResult result) {
        if (this.isRunning()) {
            Throwable failure = result.getFailure();
            if (failure != null) {
                this.runnerToken.rebuildFailure(failure);
            } else {
                this.runnerToken.rebuildSuccess();
            }
        }
    }

    public void stop() {
        if (this.isRunning()) {
            LOGGER.info("Stopping Play deployment handle for {}", (Object)this.id);
            this.runnerToken.stop();
        }
    }
}

