/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks;

import com.google.common.collect.Lists;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Incubating;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.plugin.devel.PluginDeclaration;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class GeneratePluginDescriptors
extends ConventionTask {
    @Input
    private List<PluginDeclaration> declarations = Lists.newArrayList();
    private Object outputDirectory;

    @TaskAction
    public void generatePluginDescriptors() {
        this.clearOutputDirectory();
        for (PluginDeclaration declaration : this.getDeclarations()) {
            File descriptorFile = new File(this.getOutputDirectory(), declaration.getId() + ".properties");
            Properties properties = new Properties();
            properties.setProperty("implementation-class", declaration.getImplementationClass());
            this.writePropertiesTo(properties, descriptorFile);
        }
    }

    private void clearOutputDirectory() {
        try {
            FileUtils.cleanDirectory((File)this.getOutputDirectory());
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private void writePropertiesTo(Properties properties, File descriptorFile) {
        try {
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(descriptorFile));
            GUtil.savePropertiesNoDateComment((Properties)properties, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public List<PluginDeclaration> getDeclarations() {
        return this.declarations;
    }

    public void setDeclarations(List<PluginDeclaration> declarations) {
        this.declarations = declarations;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        if (this.outputDirectory == null) {
            return null;
        }
        return this.getProject().file(this.outputDirectory);
    }

    public void setOutputDirectory(Object outputDirectory) {
        this.outputDirectory = outputDirectory;
    }
}

