/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import org.gradle.internal.logging.console.ProgressOperation;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;

public class DefaultStatusBarFormatter {
    private final ConsoleMetaData consoleMetaData;

    public DefaultStatusBarFormatter(ConsoleMetaData consoleMetaData) {
        this.consoleMetaData = consoleMetaData;
    }

    public String format(ProgressOperation op) {
        StringBuilder builder = new StringBuilder();
        for (ProgressOperation current = op; current != null; current = current.getParent()) {
            String message = current.getMessage();
            if (message == null) continue;
            builder.insert(0, " > ").insert(3, message);
        }
        if (builder.length() > 0) {
            builder.delete(0, 1);
        }
        return this.trim(builder);
    }

    private String trim(StringBuilder formattedString) {
        int width = this.consoleMetaData.getCols() - 1;
        if (width > 0 && width < formattedString.length()) {
            return formattedString.substring(0, width);
        }
        return formattedString.toString();
    }
}

