/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.read.bytes;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.read.SourceNode;
import org.jruby.truffle.core.rope.AsciiOnlyLeafRope;

@NodeChildren(value={@NodeChild(value="value", type=SourceNode.class)})
public abstract class ReadBitStringNode
extends FormatNode {
    private final ByteOrder byteOrder;
    private final boolean star;
    private final int length;

    public ReadBitStringNode(RubyContext context, ByteOrder byteOrder, boolean star, int length) {
        super(context);
        this.byteOrder = byteOrder;
        this.star = star;
        this.length = length;
    }

    @Specialization
    public Object read(VirtualFrame frame, byte[] source) {
        int position = this.getSourcePosition(frame);
        ByteBuffer encode = ByteBuffer.wrap(source, position, this.getSourceLength(frame) - position);
        int occurrences = this.star || this.length > encode.remaining() * 8 ? encode.remaining() * 8 : this.length;
        byte[] lElem = new byte[occurrences];
        int bitsMask = this.byteOrder == ByteOrder.BIG_ENDIAN ? 128 : 1;
        int bits = 0;
        for (int lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
            bits = (lCurByte & 7) != 0 ? (this.byteOrder == ByteOrder.BIG_ENDIAN ? (bits <<= 1) : (bits >>>= 1)) : encode.get();
            lElem[lCurByte] = (bits & bitsMask) != 0 ? 49 : 48;
        }
        this.setSourcePosition(frame, encode.position());
        return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), new AsciiOnlyLeafRope(lElem, (Encoding)USASCIIEncoding.INSTANCE));
    }
}

