/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Hashtable;
import java.util.Map;
import javajs.J2SRequireImport;
import javajs.awt.Font;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.T3;
import org.jmol.export.Export3D;
import org.jmol.export.UseTable;
import org.jmol.export.__CartesianExporter;
import org.jmol.export.___Exporter;
import org.jmol.java.BS;

@J2SRequireImport(value={___Exporter.class, __CartesianExporter.class, Export3D.class})
public class JSExporter
extends __CartesianExporter {
    private Map<String, Boolean> htSpheresRendered = new Hashtable<String, Boolean>();
    private Map<String, Object[]> htObjects = new Hashtable<String, Object[]>();
    Object html5Applet;
    private UseTable useTable;
    private String[] ret = new String[1];

    private void jsInitExport(Object applet) {
    }

    private void jsEndExport(Object applet) {
    }

    private void jsCylinder(Object applet, String id, boolean isNew, P3 pt1, P3 pt2, Object[] o) {
    }

    private void jsSphere(Object applet, String id, boolean isNew, T3 pt, Object[] o) {
    }

    protected void jsSurface(Object applet, T3[] vertices, T3[] normals, int[][] indices, int nVertices, int nPolygons, int nFaces, BS bsPolygons, int faceVertexMax, int color, int[] vertexColors, int[] polygonColors) {
    }

    void jsTriangle(Object applet, int color, T3 pt1, T3 pt2, T3 pt3) {
    }

    @Override
    protected void outputHeader() {
        this.html5Applet = this.vwr.html5Applet;
        this.useTable = new UseTable("JS");
        this.htSpheresRendered.clear();
        this.htObjects.clear();
        this.jsInitExport(this.html5Applet);
    }

    @Override
    protected void outputFooter() {
        this.jsEndExport(this.html5Applet);
        this.htSpheresRendered.clear();
        this.htObjects.clear();
        this.useTable = null;
    }

    @Override
    protected void outputSphere(T3 ptCenter, float radius, short colix, boolean checkRadius) {
        Object[] o;
        int iRad = Math.round(radius * 100.0f);
        String check = JSExporter.round(ptCenter) + (checkRadius ? " " + iRad : "");
        if (this.htSpheresRendered.get(check) != null) {
            return;
        }
        this.htSpheresRendered.put(check, Boolean.TRUE);
        boolean found = this.useTable.getDefRet("S" + colix + "_" + iRad, this.ret);
        if (found) {
            o = this.htObjects.get(this.ret[0]);
        } else {
            o = new Object[]{this.getColor(colix), Float.valueOf(radius)};
            this.htObjects.put(this.ret[0], o);
        }
        this.jsSphere(this.html5Applet, this.ret[0], !found, ptCenter, o);
    }

    @Override
    protected boolean outputCylinder(P3 ptCenter, P3 pt1, P3 pt2, short colix, byte endcaps, float radius, P3 ptX, P3 ptY, boolean checkRadius) {
        Object[] o;
        if (ptX != null) {
            return false;
        }
        float length = pt1.distance(pt2);
        boolean found = this.useTable.getDefRet("C" + colix + "_" + Math.round(length * 100.0f) + "_" + radius + "_" + endcaps, this.ret);
        if (found) {
            o = this.htObjects.get(this.ret[0]);
        } else {
            o = new Object[]{this.getColor(colix), Float.valueOf(length), Float.valueOf(radius)};
            this.htObjects.put(this.ret[0], o);
        }
        this.jsCylinder(this.html5Applet, this.ret[0], !found, pt1, pt2, o);
        return true;
    }

    @Override
    protected void outputCircle(P3 pt1, P3 pt2, float radius, short colix, boolean doFill) {
    }

    @Override
    protected void outputEllipsoid(P3 center, P3[] points, short colix) {
    }

    @Override
    protected void outputCone(P3 ptBase, P3 ptTip, float radius, short colix) {
        this.outputCylinder(null, ptBase, ptTip, colix, (byte)0, radius, null, null, false);
    }

    private Integer getColor(short colix) {
        return this.gdata.getColorArgbOrGray(colix);
    }

    @Override
    protected void outputSurface(T3[] vertices, T3[] normals, short[] vertexColixes, int[][] indices, short[] polygonColixes, int nVertices, int nPolygons, int nFaces, BS bsPolygons, int faceVertexMax, short colix, Lst<Short> colorList, Map<Short, Integer> htColixes, P3 offset) {
        int[] vertexColors = this.getColors(vertexColixes);
        int[] polygonColors = this.getColors(polygonColixes);
        this.jsSurface(this.html5Applet, vertices, normals, indices, nVertices, nPolygons, nFaces, bsPolygons, faceVertexMax, this.gdata.getColorArgbOrGray(colix), vertexColors, polygonColors);
    }

    @Override
    protected void outputTriangle(T3 pt1, T3 pt2, T3 pt3, short colix) {
        this.jsTriangle(this.html5Applet, this.gdata.getColorArgbOrGray(colix), pt1, pt2, pt3);
    }

    @Override
    protected void outputTextPixel(P3 pt, int argb) {
    }

    @Override
    protected void outputFace(int[] is, int[] coordMap, int faceVertexMax) {
    }

    @Override
    protected void output(T3 pt) {
    }

    @Override
    void plotImage(int x, int y, int z, Object image, short bgcolix, int width, int height) {
    }

    @Override
    void plotText(int x, int y, int z, short colix, String text, Font font3d) {
    }

    private int[] getColors(short[] colixes) {
        if (colixes == null) {
            return null;
        }
        int[] colors = new int[colixes.length];
        int i = colors.length;
        while (--i >= 0) {
            colors[i] = this.gdata.getColorArgbOrGray(colixes[i]);
        }
        return colors;
    }
}

