/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BC;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.readers.cif.MMCifReader;
import org.jmol.adapter.readers.cif.MessagePackReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Structure;
import org.jmol.java.BS;
import org.jmol.script.SV;
import org.jmol.util.Logger;

public class MMTFReader
extends MMCifReader {
    private Map<String, Object> map;
    private int fileAtomCount;
    private int opCount = 0;
    private int[] groupModels;
    private String[] labelAsymList;
    private int[] atomMap;

    @Override
    protected void addHeader() {
    }

    @Override
    protected void setup(String fullPath, Map<String, Object> htParams, Object reader) {
        this.isBinary = true;
        this.isMMCIF = true;
        this.setupASCR(fullPath, htParams, reader);
    }

    @Override
    protected void processBinaryDocument() throws Exception {
        boolean doDoubleBonds = !this.isCourseGrained && !this.checkFilterKey("NODOUBLE");
        this.isDSSP1 = this.checkFilterKey("DSSP1");
        boolean mmtfImplementsDSSP2 = false;
        this.applySymmetryToBonds = true;
        this.map = new MessagePackReader(this.binaryDoc, true).readMap();
        this.asc.setInfo("noAutoBond", Boolean.TRUE);
        Logger.info("MMTF version " + this.map.get("mmtfVersion"));
        Logger.info("MMTF Producer " + this.map.get("mmtfProducer"));
        this.appendLoadNote((String)this.map.get("title"));
        String id = (String)this.map.get("structureId");
        this.fileAtomCount = (Integer)this.map.get("numAtoms");
        int nBonds = (Integer)this.map.get("numBonds");
        Logger.info("id atoms bonds " + id + " " + this.fileAtomCount + " " + nBonds);
        this.getAtoms(doDoubleBonds);
        if (!this.isCourseGrained) {
            this.getBonds(doDoubleBonds);
            if (this.isDSSP1 || mmtfImplementsDSSP2) {
                this.getStructure((byte[])this.map.get("secStructList"));
            }
        }
        this.setSymmetry();
        this.getBioAssembly();
        this.setModelPDB(true);
        if (Logger.debuggingHigh) {
            Logger.info(SV.getVariable(this.map).asString());
        }
    }

    private int[] rldecode32(byte[] b, int n) {
        if (b == null) {
            return null;
        }
        int[] ret = new int[n];
        int i = 0;
        int pt = -1;
        while (i < n) {
            int val = BC.bytesToInt(b, ++pt << 2, true);
            int j = BC.bytesToInt(b, ++pt << 2, true);
            while (--j >= 0) {
                ret[i++] = val;
            }
        }
        return ret;
    }

    private int[] rldecode32Delta(byte[] b, int n) {
        if (b == null) {
            return null;
        }
        int[] ret = new int[n];
        int i = 0;
        int pt = 0;
        int val = 0;
        while (i < n) {
            int diff = BC.bytesToInt(b, pt++ << 2, true);
            int j = BC.bytesToInt(b, pt++ << 2, true);
            while (--j >= 0) {
                ret[i++] = val += diff;
            }
        }
        return ret;
    }

    private float[] getFloatsSplit(String xyz, float factor) {
        byte[] big = (byte[])this.map.get(xyz + "Big");
        return big == null ? null : this.splitDelta(big, (byte[])this.map.get(xyz + "Small"), this.fileAtomCount, factor);
    }

    private float[] splitDelta(byte[] big, byte[] small, int n, float factor) {
        float[] ret = new float[n];
        int smallpt = 0;
        int val = 0;
        int datapt = 0;
        int len = big.length >> 2;
        for (int i = 0; i < len; ++i) {
            ret[datapt++] = (float)(val += BC.bytesToInt(big, i << 2, true)) / factor;
            if (++i >= len) continue;
            int j = BC.bytesToInt(big, i << 2, true);
            while (--j >= 0) {
                ret[datapt++] = (float)(val += BC.bytesToShort(small, smallpt << 1, true)) / factor;
                ++smallpt;
            }
        }
        return ret;
    }

    private int[] getInts(byte[] b, int nbytes) {
        if (b == null) {
            return null;
        }
        int len = b.length / nbytes;
        int[] a = new int[len];
        switch (nbytes) {
            case 2: {
                int i = 0;
                int j = 0;
                while (i < len) {
                    a[i] = BC.bytesToShort(b, j, true);
                    ++i;
                    j += nbytes;
                }
                break;
            }
            case 4: {
                int i = 0;
                int j = 0;
                while (i < len) {
                    a[i] = BC.bytesToInt(b, j, true);
                    ++i;
                    j += nbytes;
                }
                break;
            }
        }
        return a;
    }

    private String[] bytesTo4CharArray(byte[] b) {
        String[] id = new String[b.length / 4];
        int len = id.length;
        int pt = 0;
        block3: for (int i = 0; i < len; ++i) {
            SB sb = new SB();
            block4: for (int j = 0; j < 4; ++j) {
                switch (b[pt]) {
                    case 0: {
                        id[i] = sb.toString();
                        pt += 4 - j;
                        continue block3;
                    }
                    default: {
                        sb.appendC((char)b[pt++]);
                        continue block4;
                    }
                }
            }
        }
        return id;
    }

    private void getBonds(boolean doMulti) {
        byte[] b = (byte[])this.map.get("bondOrderList");
        int[] bi = this.getInts((byte[])this.map.get("bondAtomList"), 4);
        int pt = 0;
        int n = b.length;
        for (int i = 0; i < n; ++i) {
            int a1 = this.atomMap[bi[pt++]] - 1;
            int a2 = this.atomMap[bi[pt++]] - 1;
            if (a1 < 0 || a2 < 0) continue;
            this.addBond(new Bond(a1, a2, doMulti ? b[i] : 1), true);
        }
    }

    private void setSymmetry() {
        this.setSpaceGroupName((String)this.map.get("spaceGroup"));
        float[] o = (float[])this.map.get("unitCell");
        if (o != null) {
            for (int i = 0; i < 6; ++i) {
                this.setUnitCellItem(i, o[i]);
            }
        }
    }

    private void getBioAssembly() {
        Object[] o = (Object[])this.map.get("bioAssemblyList");
        if (this.vBiomolecules == null) {
            this.vBiomolecules = new Lst();
        }
        int i = o.length;
        while (--i >= 0) {
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            this.vBiomolecules.addLast(info);
            int iMolecule = i + 1;
            this.checkFilterAssembly("" + iMolecule, info);
            info.put("name", "biomolecule " + iMolecule);
            info.put("molecule", iMolecule);
            Lst<String> assemb = new Lst<String>();
            Lst<String> ops = new Lst<String>();
            info.put("biomts", new Lst());
            info.put("chains", new Lst());
            info.put("assemblies", assemb);
            info.put("operators", ops);
            Map m = (Map)o[i];
            Object[] tlist = (Object[])m.get("transformList");
            SB chlist = new SB();
            int n = tlist.length;
            for (int j = 0; j < n; ++j) {
                Map t = (Map)tlist[j];
                chlist.setLength(0);
                int[] chainList = (int[])t.get("chainIndexList");
                int kn = chainList.length;
                for (int k = 0; k < kn; ++k) {
                    chlist.append("$").append(this.labelAsymList[chainList[k]]);
                }
                assemb.addLast(chlist.append("$").toString());
                String id = "" + ++this.opCount;
                this.addMatrix(id, M4.newA16((float[])t.get("matrix")), true);
                ops.addLast(id);
            }
        }
    }

    private void getAtoms(boolean doMulti) throws Exception {
        int[] chainsPerModel = (int[])this.map.get("chainsPerModel");
        int[] groupsPerChain = (int[])this.map.get("groupsPerChain");
        this.labelAsymList = this.bytesTo4CharArray((byte[])this.map.get("chainIdList"));
        String[] authAsymList = this.bytesTo4CharArray((byte[])this.map.get("chainNameList"));
        int[] groupTypeList = this.getInts((byte[])this.map.get("groupTypeList"), 4);
        int groupCount = groupTypeList.length;
        this.groupModels = new int[groupCount];
        int[] groupIdList = this.rldecode32Delta((byte[])this.map.get("groupIdList"), groupCount);
        Object[] groupList = (Object[])this.map.get("groupList");
        int[] insCodes = this.rldecode32((byte[])this.map.get("insCodeList"), groupCount);
        int[] atomId = this.rldecode32Delta((byte[])this.map.get("atomIdList"), this.fileAtomCount);
        boolean haveSerial = atomId != null;
        int[] altloc = this.rldecode32((byte[])this.map.get("altLocList"), this.fileAtomCount);
        int[] occ = this.rldecode32((byte[])this.map.get("occupancyList"), this.fileAtomCount);
        float[] x = this.getFloatsSplit("xCoord", 1000.0f);
        float[] y = this.getFloatsSplit("yCoord", 1000.0f);
        float[] z = this.getFloatsSplit("zCoord", 1000.0f);
        float[] bf = this.getFloatsSplit("bFactor", 100.0f);
        int iatom = 0;
        String[] nameList = this.useAuthorChainID ? authAsymList : this.labelAsymList;
        int iModel = -1;
        int iChain = 0;
        int nChain = 0;
        int iGroup = 0;
        int nGroup = 0;
        int chainpt = 0;
        int seqNo = 0;
        String chainID = "";
        String authAsym = "";
        String labelAsym = "";
        int insCode = 0;
        this.atomMap = new int[this.fileAtomCount];
        for (int j = 0; j < groupCount; ++j) {
            int[] bo;
            int a0 = iatom;
            if (insCodes != null) {
                insCode = insCodes[j];
            }
            seqNo = groupIdList[j];
            if (++iGroup >= nGroup) {
                chainID = nameList[chainpt];
                authAsym = authAsymList[chainpt];
                labelAsym = this.labelAsymList[chainpt];
                nGroup = groupsPerChain[chainpt++];
                iGroup = 0;
                if (++iChain >= nChain) {
                    this.groupModels[j] = ++iModel;
                    nChain = chainsPerModel[iModel];
                    iChain = 0;
                    this.setModelPDB(true);
                    this.incrementModel(iModel + 1);
                    this.nAtoms0 = this.asc.ac;
                }
            }
            Map g = (Map)groupList[groupTypeList[j]];
            String group3 = (String)g.get("groupName");
            this.addHetero(group3, "" + g.get("chemCompType"), true);
            String[] atomNameList = (String[])g.get("atomNameList");
            String[] elementList = (String[])g.get("elementList");
            int len = atomNameList.length;
            int ia = 0;
            int pt = 0;
            while (ia < len) {
                Atom a = new Atom();
                if (insCode != 0) {
                    a.insertionCode = (char)insCode;
                }
                this.setAtomCoordXYZ(a, x[iatom], y[iatom], z[iatom]);
                a.elementSymbol = elementList[pt];
                a.atomName = atomNameList[pt++];
                if (seqNo >= 0) {
                    a.sequenceNumber = seqNo;
                }
                a.group3 = group3;
                this.setChainID(a, chainID);
                if (bf != null) {
                    a.bfactor = bf[iatom];
                }
                if (altloc != null) {
                    a.altLoc = (char)altloc[iatom];
                }
                if (occ != null) {
                    a.foccupancy = (float)occ[iatom] / 100.0f;
                }
                if (haveSerial) {
                    a.atomSerial = atomId[iatom];
                }
                if (this.filterAtom(a, -1) && this.processSubclassAtom(a, labelAsym, authAsym)) {
                    if (haveSerial) {
                        this.asc.addAtomWithMappedSerialNumber(a);
                    } else {
                        this.asc.addAtom(a);
                    }
                    this.atomMap[iatom] = ++this.ac;
                }
                ++ia;
                ++iatom;
            }
            if (this.isCourseGrained || (bo = (int[])g.get("bondOrderList")) == null) continue;
            int[] bi = (int[])g.get("bondAtomList");
            int pt2 = 0;
            int nj = bo.length;
            for (int bj = 0; bj < nj; ++bj) {
                int a1 = this.atomMap[bi[pt2++] + a0] - 1;
                int a2 = this.atomMap[bi[pt2++] + a0] - 1;
                if (a1 < 0 || a2 < 0) continue;
                this.addBond(new Bond(a1, a2, doMulti ? bo[bj] : 1), false);
            }
        }
    }

    private void addBond(Bond bond, boolean isInter) {
        this.asc.addBond(bond);
        if (Logger.debugging && isInter) {
            Logger.info("bond " + this.asc.atoms[bond.atomIndex1].group3 + "." + this.asc.atoms[bond.atomIndex1].atomName + " " + this.asc.atoms[bond.atomIndex2].atomName + " " + bond.order);
        }
    }

    private void getStructure(byte[] a) {
        int n;
        BS[] bsStructures = new BS[]{new BS(), null, new BS(), new BS(), new BS(), null, new BS()};
        if (Logger.debugging) {
            Logger.info(PT.toJSON("secStructList", a));
        }
        int lastGroup = -1;
        for (int i = 0; i < a.length; ++i) {
            byte type = a[i];
            switch (type) {
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    bsStructures[type].set(i);
                    lastGroup = i;
                }
            }
        }
        int n2 = n = this.isDSSP1 ? this.asc.iSet : this.groupModels[lastGroup];
        if (lastGroup >= 0) {
            this.asc.addStructure(new Structure(n, null, null, null, 0, 0, bsStructures));
        }
    }
}

