/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.nbo.NBODialogConfig;

abstract class NBODialogModel
extends NBODialogConfig {
    private static final String INPUT_FILE_EXTENSIONS = ";adf;cfi;gau;gms;jag;mm2;mnd;mp;nw;orc;pqs;qc;vfi;g09;com";
    private static final String[] SAVE_OPTIONS = new String[]{"", "JMol Cartesian   [.cfi]", "JMol Valence     [.vfi]", "Gaussian Input   [.gau]", "GAMESS Input     [.gms]", "ADF Input        [.adf]", "Jaguar Input     [.jag]", "MM2-Input        [.mm2]", "Dewar Type Input [.mnd]", "Molpro Input     [.mp]", "NWChem Input     [.nw]", "Orca Input       [.orc]", "PQS Input        [.pqs]", "Q-Chem Input     [.qc]"};
    private static final int ALTER = 4;
    private static final int CLIP = 2;
    private static final int MUTATE = 1;
    protected static final int VALUE = 5;
    private static final String LOAD_SCRIPT = ";set zoomlarge false;zoomTo 0.5 {*} 0;";
    protected static final int CONFIRM_SAVE = 0;
    protected static final int CONFIRM_VIEWOUTPUT = 1;
    protected int editMode;
    protected String savePath;
    protected String selected = "";
    protected String usePath;
    protected Box editBox;
    protected JTextField jtSelectAtoms;
    protected JTextField tfFolderS;
    protected JTextField tfNameS;
    protected JTextField tfExtS;
    protected JTextField jtJmolInput;
    protected JTextField jtLineInput;
    protected JButton jbEdit;
    protected static final Color titleColor = new Color(0, 128, 255);
    protected static final Font titleFont = new Font("Arial", 1, 18);
    protected String editAction;
    protected JTextField currVal;
    protected JTextField[] atomNumBox;
    protected JLabel valLab;

    protected abstract void nboResetV();

    protected NBODialogModel(JFrame f) {
        super(f);
    }

    protected void buildModel(Container p) {
        p.removeAll();
        p.setLayout(new BorderLayout());
        if (this.topPanel == null) {
            this.topPanel = this.buildTopPanel();
        }
        p.add((Component)this.topPanel, "First");
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        leftPanel.add(this.useBox());
        leftPanel.add(this.editBox()).setVisible(false);
        leftPanel.add(this.saveBox()).setVisible(false);
        JSplitPane sp = new JSplitPane(1, leftPanel, this.modelOut());
        sp.setDividerLocation(350);
        sp.setBorder(BorderFactory.createLoweredBevelBorder());
        p.add((Component)sp, "Center");
        p.add((Component)this.statusPanel, "Last");
        if (this.vwr.ms.ac != 0 && !this.isJmolNBO) {
            this.loadModel();
            this.enableComponentsR(this, true);
        } else if (this.isJmolNBO) {
            this.loadModel(this.inputFile.getParent(), this.jobStem, "47");
            this.tfExt.setText("47");
            this.enableComponentsR(this, true);
        }
    }

    private Component editBox() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JLabel title = new JLabel(" Edit Model ");
        Box box = Box.createVerticalBox();
        title.setBackground(titleColor);
        title.setAlignmentX(0.0f);
        title.setFont(titleFont);
        title.setOpaque(true);
        box.add(title);
        title.setForeground(Color.WHITE);
        box.add(p);
        box.setAlignmentX(0.0f);
        p.setAlignmentX(0.0f);
        p.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        Box b = Box.createVerticalBox();
        final String[] actions = new String[]{"Alter", "Clip", "Fuse", "Link", "Mutate", "Switch", "Twist"};
        JRadioButton[] btns = new JRadioButton[actions.length];
        ButtonGroup rg = new ButtonGroup();
        for (int i = 0; i < actions.length; ++i) {
            btns[i] = new JRadioButton(actions[i]);
            b.add(btns[i]);
            rg.add(btns[i]);
            final int op = i;
            btns[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NBODialogModel.this.editAction = actions[op].toLowerCase();
                    NBODialogModel.this.actionSelected(NBODialogModel.this.editAction);
                    NBODialogModel.this.clearSelected();
                }
            });
        }
        p.add(b);
        b = Box.createVerticalBox();
        this.editBox = Box.createVerticalBox();
        this.editBox.setBorder(BorderFactory.createLoweredBevelBorder());
        this.editBox.setMaximumSize(new Dimension(275, 200));
        this.editBox.add(Box.createRigidArea(new Dimension(250, 75)));
        this.editBox.setAlignmentX(0.5f);
        JButton sym = new JButton("Symmetry?");
        JButton getVal = new JButton("Current Value?");
        getVal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NBODialogModel.this.selected.trim().equals("")) {
                    NBODialogModel.this.vwr.alert("Select atoms");
                } else {
                    String[] ats = NBODialogModel.this.selected.split(" ");
                    if (ats.length == 1) {
                        NBODialogModel.this.vwr.alert("Atom number: " + NBODialogModel.this.nboService.runScriptNow("print {*}[" + NBODialogModel.this.selected + "].elemno"));
                    } else {
                        String script = "print measure(";
                        for (String x : ats) {
                            script = script + "{*}[" + x + "]";
                        }
                        script = script + ")";
                        NBODialogModel.this.vwr.alert(NBODialogModel.this.nboService.runScriptNow(script));
                    }
                }
            }
        });
        sym.setAlignmentX(0.5f);
        sym.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.getSymmetry();
            }
        });
        Box box2 = Box.createHorizontalBox();
        box2.add(getVal);
        box2.add(sym);
        b.add(box2);
        b.add(this.editBox);
        p.add(b);
        this.jtSelectAtoms = new JTextField("Select atoms...");
        this.jtSelectAtoms.setMaximumSize(new Dimension(200, 30));
        this.jtSelectAtoms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.editModel(NBODialogModel.this.editAction);
            }
        });
        this.jtSelectAtoms.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                if (!NBODialogModel.this.jtSelectAtoms.getText().equals("")) {
                    NBODialogModel.this.jbEdit.setEnabled(true);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                if (NBODialogModel.this.jtSelectAtoms.getText().equals("")) {
                    NBODialogModel.this.jbEdit.setEnabled(false);
                }
            }
        });
        return box;
    }

    private Component saveBox() {
        JPanel p = new JPanel();
        p.setMaximumSize(new Dimension(350, 150));
        p.setLayout(new BoxLayout(p, 1));
        Box b = Box.createVerticalBox();
        b.setAlignmentX(0.0f);
        JLabel title = new JLabel(" Save Model ");
        title.setOpaque(true);
        title.setBackground(titleColor);
        title.setAlignmentX(0.0f);
        title.setForeground(Color.white);
        title.setFont(titleFont);
        b.add(title);
        b.add(p);
        p.setAlignmentX(0.0f);
        p.setBorder(BorderFactory.createLineBorder(Color.black));
        final JComboBox<String> jComboSave = new JComboBox<String>(SAVE_OPTIONS);
        jComboSave.setEnabled(false);
        jComboSave.setFont(this.nboFont);
        jComboSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object item = jComboSave.getSelectedItem();
                if (jComboSave.getSelectedIndex() != 0) {
                    String s = item.toString();
                    String ext = s.substring(s.indexOf("[") + 2, s.indexOf("]"));
                    NBODialogModel.this.tfExtS.setText(ext);
                }
            }
        });
        p.add(jComboSave);
        title = new JLabel("File type");
        title.setAlignmentX(0.5f);
        p.add(title);
        p.add(this.folderSaveBox(jComboSave));
        return b;
    }

    private Component useBox() {
        JPanel p = new JPanel();
        p.setMaximumSize(new Dimension(355, 155));
        p.setLayout(new BoxLayout(p, 1));
        JLabel title = new JLabel(" Input Model ");
        title.setAlignmentX(0.0f);
        title.setBackground(titleColor);
        title.setForeground(Color.white);
        title.setFont(titleFont);
        title.setOpaque(true);
        Box box = Box.createVerticalBox();
        box.add(title);
        box.add(p);
        p.setAlignmentX(0.0f);
        box.setAlignmentX(0.0f);
        p.setBorder(BorderFactory.createLineBorder(Color.black));
        Box b = Box.createHorizontalBox();
        JRadioButton jrJmolIn = new JRadioButton("Jmol Input");
        jrJmolIn.setFont(this.nboFont);
        jrJmolIn.setSelected(true);
        JRadioButton jrLineIn = new JRadioButton("Line Formula");
        jrLineIn.setFont(this.nboFont);
        JRadioButton jrFileIn = new JRadioButton("File Input");
        jrFileIn.setFont(this.nboFont);
        ButtonGroup rg = new ButtonGroup();
        rg.add(jrJmolIn);
        rg.add(jrLineIn);
        rg.add(jrFileIn);
        this.jtJmolInput = new JTextField();
        this.createInput(this.jtJmolInput, jrJmolIn);
        this.jtLineInput = new JTextField();
        this.createInput(this.jtLineInput, jrLineIn);
        this.jtLineInput.add(new JLabel("line formula"));
        String[] useOps = new String[]{"-All File Types-", "[.cfi]  JMol Cartesian", "[.vfi]  JMol Valence", "[.47]   NBO Archive", "[.gau]  Gaussian Input", "[.log]  Gaussian Output", "[.gms]  GAMESS Input", "[.adf]  ADF Input", "[.jag]  Jaguar Input", "[.mm2]  MM2-Input", "[.mnd]  Dewar Type Input", "[.mp]   Molpro Input", "[.nw]   NWChem Input", "[.orc]  Orca Input", "[.pqs]  PQS Input", "[.qc]   Q-Chem Input"};
        final JComboBox<String> jComboUse = new JComboBox<String>(useOps);
        jComboUse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object item = jComboUse.getSelectedItem();
                String tmp = NBODialogModel.this.tfExt.getText();
                if (jComboUse.getSelectedIndex() != 0) {
                    String s = item.toString();
                    s = s.substring(s.indexOf("[") + 2, s.indexOf("]"));
                    NBODialogModel.this.tfExt.setText(s);
                    if (!NBODialogModel.this.showWorkpathDialogM(NBODialogModel.this.usePath, s)) {
                        NBODialogModel.this.tfExt.setText(tmp);
                    }
                } else {
                    NBODialogModel.this.tfExt.setText("");
                    if (!NBODialogModel.this.showWorkpathDialogM(null, null)) {
                        NBODialogModel.this.tfExt.setText(tmp);
                    }
                }
            }
        });
        JPanel p2 = new JPanel(new GridLayout(3, 2));
        p2.add(jrJmolIn);
        p2.add(this.jtJmolInput);
        p2.add(jrLineIn);
        p2.add(this.jtLineInput);
        p2.add(jrFileIn);
        p2.add(jComboUse);
        this.addListenersAndSize(jComboUse, jrFileIn);
        b.add(p2);
        p.add(b);
        p.add(new JLabel("              file type"));
        p.add(this.folderBox());
        return box;
    }

    private void createInput(final JTextField field, JRadioButton radio) {
        field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.getModel(field);
            }
        });
        this.addListenersAndSize(field, radio);
    }

    private void addListenersAndSize(JComponent field, final JRadioButton radio) {
        field.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                radio.setSelected(true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        field.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                radio.setSelected(true);
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private JPanel folderSaveBox(final JComboBox<String> cBox) {
        JPanel b = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        this.tfFolderS = new JTextField();
        this.tfFolderS.setPreferredSize(new Dimension(130, 20));
        this.tfFolderS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.showSaveDialog(NBODialogModel.this.tfExt.getText().equals("") ? "cfi,vfi,47,gau,log,gms,adf,jag,mm2,mnd,mp,nw,orc,pqs,qc" : NBODialogModel.this.tfExt.getText());
            }
        });
        b.add((Component)this.tfFolderS, c);
        this.tfFolderS.setText(this.savePath.substring(0, this.savePath.lastIndexOf("\\")));
        c.gridx = 1;
        this.tfNameS = new JTextField();
        this.tfNameS.setPreferredSize(new Dimension(100, 20));
        this.tfNameS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.showSaveDialog(NBODialogModel.this.tfExt.getText().equals("") ? "cfi,vfi,47,gau,log,gms,adf,jag,mm2,mnd,mp,nw,orc,pqs,qc" : NBODialogModel.this.tfExt.getText());
            }
        });
        b.add((Component)this.tfNameS, c);
        c.gridx = 0;
        c.gridy = 1;
        b.add((Component)new JLabel("         folder"), c);
        c.gridx = 1;
        b.add((Component)new JLabel("          name"), c);
        c.gridx = 2;
        c.gridy = 0;
        this.tfExtS = new JTextField();
        this.tfExtS.setPreferredSize(new Dimension(40, 20));
        this.tfExtS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.showSaveDialog(!NBODialogModel.this.tfExtS.getText().equals("") ? NBODialogModel.this.tfExtS.getText() : "cfi,vfi,47,gau,log,gms,adf,jag,mm2,mnd,mp,nw,orc,pqs,qc");
            }
        });
        b.add((Component)this.tfExtS, c);
        c.gridy = 1;
        b.add((Component)new JLabel("  ext"), c);
        c.gridx = 3;
        c.gridy = 0;
        c.gridheight = 2;
        JButton btn = new JButton("Save");
        btn.setEnabled(this.jmolAtomCount > 0);
        b.add((Component)btn, c);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NBODialogModel.this.tfNameS.getText().trim().equals("") || NBODialogModel.this.tfExtS.getText().equals("") || cBox.getSelectedIndex() == 0) {
                    NBODialogModel.this.vwr.alert("Enter name and valid extension");
                    return;
                }
                NBODialogModel.this.showSaveDialog(!NBODialogModel.this.tfExtS.getText().equals("") ? NBODialogModel.this.tfExtS.getText() : "cfi,vfi,47,gau,log,gms,adf,jag,mm2,mnd,mp,nw,orc,pqs,qc");
            }
        });
        return b;
    }

    protected void actionSelected(String selected) {
        String item = selected.split(" ")[0];
        int cnt = selected.split(" ").length;
        if (item.equals("-Action-")) {
            return;
        }
        if (item.equals("clip") || item.equals("fuse") || item.equals("link") || item.equals("switch")) {
            this.editMode = 2;
            if (cnt > 2) {
                selected = "";
            }
            this.clip(item, "Select two atoms:", null);
        } else if (item.equals("mutate")) {
            if (cnt > 1) {
                selected = "";
                this.showSelected(selected.split(" "));
            }
            this.editMode = 1;
            this.clip(item, "Formula: ", this.jtSelectAtoms);
        } else if (item.equals("rebond")) {
            if (cnt > 2) {
                selected = "";
            }
            this.clip(item, "Symtype: ", this.jtSelectAtoms);
        } else if (item.equals("alter") || item.equals("twist") || item.equals("value")) {
            this.editMode = 4;
            this.clip(item, "New Value: ", this.jtSelectAtoms);
        }
    }

    protected void clip(final String action, String st, Component c) {
        this.editBox.removeAll();
        Box box = Box.createHorizontalBox();
        this.jbEdit = new JButton("Apply");
        this.jbEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.editModel(action);
            }
        });
        box.add(new JLabel(st));
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Atoms: "));
        this.atomNumBox = new JTextField[this.editMode];
        for (int i = 0; i < this.editMode; ++i) {
            this.atomNumBox[i] = new JTextField();
            final int num = i;
            this.atomNumBox[i].addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    if (num == NBODialogModel.this.editMode - 1) {
                        NBODialogModel.this.jbEdit.setEnabled(true);
                    }
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                    int atnum = 0;
                    try {
                        atnum = Integer.parseInt(NBODialogModel.this.atomNumBox[num].getText());
                    }
                    catch (Exception e) {
                        return;
                    }
                    if (atnum > NBODialogModel.this.jmolAtomCount) {
                        NBODialogModel.this.atomNumBox[num].setText("");
                    }
                    String[] tmp = new String[NBODialogModel.this.editMode];
                    NBODialogModel.this.selected = "";
                    for (int j = 0; j < NBODialogModel.this.atomNumBox.length; ++j) {
                        tmp[j] = NBODialogModel.this.atomNumBox[j].getText();
                        NBODialogModel.this.selected = NBODialogModel.this.selected + (tmp[j].length() > 0 ? tmp[j] + " " : "");
                    }
                    NBODialogModel.this.showSelected(NBODialogModel.this.selected.split(" "));
                    NBODialogModel.this.jtSelectAtoms.setText("");
                    NBODialogModel.this.jtSelectAtoms.setEnabled(true);
                }
            });
            this.atomNumBox[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[] tmp = new String[NBODialogModel.this.editMode];
                    NBODialogModel.this.selected = "";
                    for (int j = 0; j < NBODialogModel.this.atomNumBox.length; ++j) {
                        tmp[j] = NBODialogModel.this.atomNumBox[j].getText();
                        NBODialogModel.this.selected = NBODialogModel.this.selected + (tmp[j].length() > 0 ? tmp[j] + " " : "");
                    }
                    NBODialogModel.this.editModel(action);
                }
            });
            b2.add(this.atomNumBox[i]).setMaximumSize(new Dimension(40, 40));
        }
        this.editBox.add(b2);
        if (this.selected.equals("")) {
            this.jtSelectAtoms.setText("Select atoms...");
            this.jtSelectAtoms.setEnabled(false);
        } else {
            this.jtSelectAtoms.setText("");
            this.jtSelectAtoms.setEnabled(true);
        }
        if (this.editMode == 4) {
            b2 = Box.createHorizontalBox();
            b2.add(new JLabel("Current Value"));
            this.currVal = new JTextField();
            b2.add(this.currVal).setMaximumSize(new Dimension(200, 40));
            this.editBox.add(b2);
            this.valLab = new JLabel(" ");
            this.editBox.add(this.valLab);
        }
        if (c != null) {
            box.add(c);
        }
        this.editBox.add(box);
        box = Box.createHorizontalBox();
        JButton bu = new JButton("Clear Selected");
        bu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.clearSelected();
            }
        });
        box.add(bu);
        box.add(this.jbEdit);
        this.editBox.add(box);
        this.editBox.repaint();
        this.editBox.revalidate();
    }

    protected void clearSelected() {
        for (int i = 0; i < this.editMode; ++i) {
            this.atomNumBox[i].setText("");
        }
        if (this.currVal != null) {
            this.currVal.setText("");
        }
        if (this.valLab != null) {
            this.valLab.setText(" ");
        }
        if (!this.jCheckAtomNum.isSelected()) {
            this.nboService.runScriptQueued("label off");
        }
        this.nboService.runScriptQueued("measure off;select remove {selected};refresh");
        this.selected = "";
        this.jtSelectAtoms.setText("Select atoms...");
        this.jtSelectAtoms.setEnabled(false);
        this.jbEdit.setEnabled(false);
    }

    protected void editModel(String item) {
        SB sb = new SB();
        String cmd = item + " " + this.selected;
        if (this.jtSelectAtoms != null && (this.editMode == 4 || this.editMode == 1)) {
            cmd = cmd + " " + this.jtSelectAtoms.getText();
        }
        this.appendToFile("CMD " + cmd, sb);
        this.appendOutputWithCaret(cmd, 'i');
        this.modelCmd(sb);
        this.clearSelected();
    }

    protected JPanel modelOut() {
        JPanel s = new JPanel();
        s.setLayout(new BorderLayout());
        JLabel lab = new JLabel("Session Dialog");
        lab.setFont(this.nboFont);
        s.add((Component)lab, "First");
        JScrollPane p1 = new JScrollPane();
        if (this.jpNboOutput == null) {
            this.jpNboOutput = new JTextPane();
            this.jpNboOutput.setEditable(false);
            this.jpNboOutput.setFont(new Font("Arial", 0, 16));
            this.bodyText = "";
        }
        this.jpNboOutput.setContentType("text/html");
        this.setComponents(s, Color.WHITE, Color.BLACK);
        p1.getViewport().add(this.jpNboOutput);
        s.add((Component)p1, "Center");
        JPanel box = new JPanel(new GridLayout(4, 1));
        JButton b = new JButton("Clear");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.clearOutput();
            }
        });
        box.add(b);
        box.add(this.jCheckAtomNum);
        box.add(this.jCheckNboView);
        s.add((Component)box, "South");
        return s;
    }

    protected void saveHistoryM() {
        Properties props = new Properties();
        props.setProperty("savePath", this.savePath);
        props.setProperty("usePath", this.usePath);
        JmolPanel.historyFile.addProperties(props);
    }

    protected void getSymmetry() {
        this.editMode = 0;
        SB sb = new SB();
        this.appendToFile("CMD symmetry", sb);
        this.appendOutputWithCaret("Symmetry: ", 'p');
        this.modelCmd(sb);
    }

    protected void getModel(JTextField textBox) {
        this.clearModel();
        if (textBox.getText().equals("")) {
            return;
        }
        String s = "";
        if (textBox.equals(this.jtJmolInput)) {
            this.jobStem = textBox.getText();
            s = "load $" + this.jobStem;
            this.appendOutputWithCaret(s, 'i');
            if (this.nboService.runScriptNow(s) == null) {
                if (this.nboService.runScriptNow("load :" + textBox.getText()) != null) {
                    return;
                }
                this.appendOutputWithCaret("File not found", 'i');
                return;
            }
        } else if (textBox.equals(this.jtLineInput)) {
            SB sb = new SB();
            this.jobStem = textBox.getText();
            s = "show " + this.jobStem;
            this.appendToFile("CMD " + s, sb);
            this.modelCmd(sb);
        }
        this.enableComponentsR(this, true);
        this.appendOutputWithCaret(s, 'i');
    }

    private void loadModel(String path, String fname, String ext) {
        this.clearModel();
        String ess = this.getEss(ext);
        SB sb = new SB();
        this.appendToFile("GLOBAL C_PATH " + path + sep, sb);
        this.appendToFile("GLOBAL C_ESS " + ess + sep, sb);
        this.appendToFile("GLOBAL C_FNAME " + fname + sep, sb);
        this.appendToFile("GLOBAL C_IN_EXT " + ext.toLowerCase() + sep, sb);
        this.appendToFile("CMD use", sb);
        this.appendOutputWithCaret("use." + ess + " " + fname + "." + ext, 'i');
        this.modelCmd(sb);
    }

    protected void clearModel() {
        this.tfName.setText("");
        this.tfExt.setText("");
        this.tfExtS.setText("");
        this.tfNameS.setText("");
    }

    protected void loadModel() {
        this.clearModel();
        File f = new File(new File(this.nboService.serverPath).getParent() + "/jmol_outfile.gau");
        SB sb = new SB();
        this.vwr.script(LOAD_SCRIPT);
        try {
            String fileContents = this.nboService.evaluateJmolString("data({visible},'gau')");
            this.nboService.writeToFile(fileContents, f);
            this.appendToFile("GLOBAL C_PATH " + f.getParent() + sep, sb);
            this.appendToFile("GLOBAL C_ESS g" + sep, sb);
            this.appendToFile("GLOBAL C_FNAME jmol_outfile" + sep, sb);
            this.appendToFile("GLOBAL C_IN_EXT gau" + sep, sb);
            this.appendToFile("CMD use", sb);
            this.modelCmd(sb);
            this.enableComponentsR(this, true);
        }
        catch (IOException e) {
            System.out.println("could not write file contents to " + f);
        }
    }

    protected void saveModel(String path, String fname, String ext) {
        String ess = this.getEss(ext);
        SB sb = new SB();
        this.appendToFile("GLOBAL C_PATH " + path + sep, sb);
        this.appendToFile("GLOBAL C_ESS " + ess + sep, sb);
        this.appendToFile("GLOBAL C_FNAME " + fname + sep, sb);
        this.appendToFile("GLOBAL C_OUT_EXT " + ext + sep, sb);
        this.appendToFile("CMD save", sb);
        this.modelCmd(sb);
        this.appendOutputWithCaret("save." + ess + " " + fname, 'i');
        this.appendOutputWithCaret("--Model Saved--\n" + path + "\\" + fname + "." + ext, 'b');
        this.tfFolderS.setText(path);
        this.tfNameS.setText(fname);
        this.tfExtS.setText(ext);
    }

    private String getEss(String ext) {
        if ((ext = ext.toLowerCase()).equals("cfi") || ext.equals("vfi") || ext.equals("gau") || ext.equals("log") || ext.equals("g09")) {
            return "" + ext.charAt(0);
        }
        if (ext.equals("47")) {
            return "a";
        }
        if (ext.equals("mm2")) {
            return "mm";
        }
        if (ext.equals("com")) {
            return "g";
        }
        return ext;
    }

    protected synchronized void modelCmd(final SB sb) {
        this.nboService.queueJob("model", "creating model...", new Runnable(){

            @Override
            public void run() {
                NBODialogModel.this.nboService.rawCmdNew("m", sb, false, 1);
            }
        });
    }

    @Override
    protected boolean showWorkpathDialogM(String path, String type) {
        String folder;
        if (path == null) {
            path = this.usePath;
            type = "47,adf,cfi,com,gau,g09,gms,jag,log,mp,nw,orc,pqs,qc,vfi";
        }
        if (!(folder = this.tfFolder.getText().trim()).equals("")) {
            if (!folder.contains(":")) {
                folder = "C:/" + folder;
            }
            path = folder + "/" + (this.tfName.getText().equals("") ? "new" : this.tfName.getText()) + "." + this.tfExt.getText();
        }
        if (!this.tfExt.getText().equals("")) {
            type = this.tfExt.getText();
        }
        JFileChooser myChooser = new JFileChooser();
        if (type != null) {
            myChooser.setFileFilter(new FileNameExtensionFilter(type, type.split(",")));
        }
        myChooser.setFileHidingEnabled(true);
        myChooser.setSelectedFile(new File(path));
        int button = myChooser.showDialog(this, GT._("Select"));
        if (button == 0) {
            this.jtJmolInput.setText("");
            File newFile = myChooser.getSelectedFile();
            if (newFile.toString().indexOf(".") < 0) {
                this.appendOutputWithCaret("File not found", 'i');
                return false;
            }
            this.loadModel(newFile.getParent(), this.getJobStem(newFile), this.getExt(newFile));
            this.setInputFile(newFile, this.getExt(newFile), null);
            this.nboResetV();
            this.usePath = newFile.toString();
            this.saveHistoryM();
            this.enableComponentsR(this, true);
            return true;
        }
        return false;
    }

    protected void showSaveDialog(String type) {
        JFileChooser myChooser = new JFileChooser();
        myChooser.setFileFilter(new FileNameExtensionFilter(type, type.split(",")));
        myChooser.setFileHidingEnabled(true);
        String savePath = this.savePath;
        String folder = this.tfFolderS.getText().trim();
        if (!folder.equals("")) {
            if (!folder.contains(":")) {
                folder = "C:/" + folder;
            }
        } else {
            folder = new File(this.savePath).getParent();
        }
        System.out.println("-----" + folder + this.savePath);
        savePath = this.tfNameS.getText().equals("") ? folder + "/" + (this.jobStem.equals("") ? "new.cfi" : this.jobStem + "." + this.tfExtS.getText()) : folder + "/" + this.tfNameS.getText() + "." + this.tfExtS.getText();
        myChooser.setSelectedFile(new File(savePath));
        int button = myChooser.showSaveDialog(this);
        if (button == 0) {
            File newFile = myChooser.getSelectedFile();
            String ext = this.getExt(newFile);
            if (newFile.exists()) {
                this.showConfirmationDialog("File already exists, overwrite file?", newFile, ext, 0);
            } else if (PT.isOneOf(ext, INPUT_FILE_EXTENSIONS)) {
                this.savePath = newFile.toString();
                this.saveModel(newFile.getParent(), this.getJobStem(newFile), ext);
                this.saveHistoryM();
            } else {
                this.appendOutputWithCaret("No valid extension defined", 'b');
            }
        }
    }

    @Override
    protected void showConfirmationDialog(String st, File newFile, String ext, int mode) {
        JDialog d = new JDialog();
        int i = JOptionPane.showConfirmDialog(this, st, "Message", 0);
        if (i == 0) {
            if (mode == 0) {
                this.savePath = newFile.toString();
                this.saveModel(newFile.getParent(), this.getJobStem(newFile), ext);
                this.saveHistoryM();
                d.setVisible(false);
            } else if (mode == 1) {
                d.setVisible(false);
                this.showNboOutput(newFile.toString());
            } else if (mode == 2) {
                d.setVisible(false);
                this.goRunClicked("PLOT", "gennbo", newFile, this.showRunDone);
            }
        }
    }

    protected void notifyCallbackM(String atomno) {
        if (this.editMode != 0) {
            this.jtSelectAtoms.requestFocus();
            this.jtSelectAtoms.setText("");
            this.jtSelectAtoms.setEnabled(true);
            String st = this.nboService.runScriptNow("print {*}[" + atomno + "].selected");
            if (st.contains("1.0")) {
                this.appendOutputWithCaret("Atom # " + atomno + " deselected", 'i');
                this.selected = this.selected.replace(atomno + " ", "");
                this.nboService.runScriptNow("select remove {*}[" + atomno + "];measure off;measure " + this.selected);
                for (int i = 0; i < this.atomNumBox.length; ++i) {
                    if (i >= this.selected.split(" ").length) {
                        this.atomNumBox[i].setText("");
                        continue;
                    }
                    this.atomNumBox[i].setText(this.selected.split(" ")[i]);
                }
                return;
            }
            int cnt = this.selected.equals("") ? 1 : this.selected.split(" ").length + 1;
            switch (this.editMode) {
                case 4: {
                    String[] ats = this.selected.split(" ");
                    if (cnt == 1) {
                        this.valLab.setText("(Atomic number)");
                        this.jtSelectAtoms.setText("");
                        this.jtSelectAtoms.setEnabled(true);
                        String script = "print {*}[" + atomno + "].elemno";
                        this.currVal.setText(this.nboService.runScriptNow(script));
                        break;
                    }
                    if (cnt == 5) {
                        this.clearSelected();
                        this.valLab.setText("(Atomic number)");
                        String script = "print {*}[" + atomno + "].elemno";
                        this.currVal.setText(this.nboService.runScriptNow(script));
                        cnt = 1;
                        break;
                    }
                    if (!this.jCheckAtomNum.isSelected()) {
                        this.nboService.runScriptQueued("label off");
                    }
                    if (cnt == 2) {
                        this.valLab.setText("(Bond length)");
                        this.nboService.runScriptQueued("measure off;measure " + this.selected + " " + atomno + "\"2:%0.4VALUE //A\"" + ";measure " + this.selected + " " + atomno + "\"2:%0.4VALUE //A\"");
                    } else {
                        this.nboService.runScriptQueued("measure off;measure " + this.selected + " " + atomno);
                        if (cnt == 3) {
                            this.valLab.setText("(Valence angle)");
                        } else if (cnt == 4) {
                            this.valLab.setText("(Dihedral angle)");
                        }
                    }
                    String script = "print measure({*}[";
                    for (String x : ats) {
                        script = script + x + "],{*}[";
                    }
                    script = script + atomno + "])";
                    this.currVal.setText(this.nboService.runScriptNow(script).split("\\s+")[1]);
                    break;
                }
                case 2: {
                    if (cnt == 2) {
                        this.jbEdit.setEnabled(true);
                        break;
                    }
                    if (cnt != 3) break;
                    this.clearSelected();
                    cnt = 1;
                    break;
                }
                case 1: {
                    if (cnt == 1) {
                        this.jtSelectAtoms.setEnabled(true);
                        this.jtSelectAtoms.setText("");
                    }
                    if (cnt != 2) break;
                    this.clearSelected();
                    cnt = 1;
                }
            }
            this.nboService.runScriptQueued("select add {*}[" + atomno + "]");
            this.selected = this.selected + atomno + " ";
            this.atomNumBox[cnt - 1].setText("  " + atomno);
        }
    }

    protected void getValue() {
        String script = "";
        String[] ats = this.selected.split(" ");
        int cnt = ats.length;
        if (cnt == 1) {
            this.valLab.setText("(Atomic number)");
            this.jtSelectAtoms.setText("");
            this.jtSelectAtoms.setEnabled(true);
            script = "print {*}[" + this.selected + "].elemno";
            this.currVal.setText(this.nboService.runScriptNow(script));
        } else {
            if (cnt == 2) {
                this.valLab.setText("(Bond length)");
                this.nboService.runScriptQueued("measure off;measure " + this.selected + "\"2:%0.4VALUE //A\"" + ";measure " + this.selected + "\"2:%0.4VALUE //A\"");
            } else {
                this.nboService.runScriptQueued("measure off;measure " + this.selected + " ");
                if (cnt == 3) {
                    this.valLab.setText("(Valence angle)");
                } else if (cnt == 4) {
                    this.valLab.setText("(Dihedral angle)");
                }
            }
            script = "print measure({*}[";
            for (int i = 0; i < ats.length - 1; ++i) {
                script = script + ats[i] + "],{*}[";
            }
            script = script + ats[ats.length - 1] + "]);";
            String s = this.nboService.runScriptNow(script);
            this.currVal.setText(s.split("\\s+")[1]);
        }
    }

    protected void notifyLoadModel() {
        if (this.nboView) {
            String s2 = this.nboService.runScriptNow("print {*}.bonds");
            this.nboService.runScriptQueued("select " + s2 + ";color bonds lightgrey; wireframe 0.1");
        }
        if (this.jCheckAtomNum.isSelected()) {
            this.showAtomNums();
        }
        this.jmolAtomCount = this.vwr.ms.ac;
        this.nboService.runScriptQueued("select on");
        if (this.selected.equals("")) {
            return;
        }
        this.showSelected(this.selected.split(" "));
        if (this.editMode == 4) {
            int cnt = this.selected.split(" ").length;
            if (cnt == 1) {
                return;
            }
            if (cnt == 2) {
                this.nboService.runScriptQueued("measure off;measure " + this.selected + "\"2:%0.4VALUE //A\"" + ";measure " + this.selected + "\"2:%0.4VALUE //A\"");
            } else {
                this.nboService.runScriptQueued("measure off;measure " + this.selected);
            }
        }
    }

    protected boolean helpDialogM(JTextPane p, String key) {
        if (key.equals("")) {
            if (this.jtJmolInput.hasFocus()) {
                p.setText("SHOW <formula> (create a molecule model from\n                its 'formula')\nSHOW <acceptor> <donor-1> <donor-2>...\n               (create supramolecular model from\n                radical 'acceptor' and ligand\n                'donor-i' formulas)\nThe chemical 'formula' is a valid Lewis-typeline formula, similar to textbook examples.Use colons to denote multiple bonds (C::O doublebond, C:::N triple bond, etc.) and parenthesesto identify repeat units or side groups.Atomic symbols in the range H-Cf (Z = 1-98)and repetition numbers 1-9 are allowed.Chemical formula symbols are case-sensitive.\n \nLigated free radicals (with free-valent acceptorsites) can also be formed in specified hapticitymotifs with chosen molecular ligands. Radical<acceptor> and ligand <donor-i> monomers arespecified by valid line formulas, with eachligand <donor> formula preceded by a number ofcolons (:) representing the number of 2e sitesin the desired ligand denticity (such as ':NH3'for monodentate ammine ligand, '::NH2CH::CH2'for bidentate vinylamine ligand, or ':::Bz' fortridentate benzene ligand). Each such ligationsymbol may be prefixed with a stoichiometriccoefficient 2-9 for the number of ligands.\n \nIn both molecular and supramolecular formulas,valid transition metal duodectet structuresare also accepted. For d-block molecular species,the default idealized metal hybridization isomercan be altered with the REBOND command.For d-block species one can also includecoordinative ligands (:Lig), enclosed inparentheses and preceded by a colon symbol.Formal 'ylidic' charges are allowed only foradjacent atom pairs (e.g., dative pi-bonds).\n \nModels may also be specified by using acronymsfrom a library of pre-formed species (manyat B3LYP/6-31+G* optimized level). Each suchacronym can also be used as a monovalent ligandin MUTATE commands, as illustrated below.\n \nCommon cyclic aromatic species\n Bz        C6H6   benzene\n A10R2L    C10H8  naphthalene\n A14R3L    C14H12 anthracene\n A18R4L    C18H16 tetracene\n A22R5L    C22H20 pentacene\n A14R3     C14H10 phenanthrene\n A14R4     C14H12 chrysene\n A16R4     C16H10 pyrene\n A18R4     C18H12 triphenylene\n A20R5     C20H12 benzopyrene\n A20R6     C20H10 corannulene\n A24R7     C24H12 coronene\n A32R10    C32H14 ovalene\nCommon cyclic saturated species\n R6C       C6H12 cyclohexane (chair)\n R6B         '        '      (boat t.s.) \n R6T         '        '      (twist-boat)\n R5        C5H10 cyclopentane\n R4        C4H8  cyclobutane\n R3        C3H6  cyclopropane\n RB222     [2,2,2]bicyclooctane\n RB221     [2,2,1]bicycloheptane (norbornane)\n RB211     [2,1,1]bicyclohexane\n RB111     [1,1,1]bicyclopentane (propellane)\n R5S       spiropentane\n RAD       adamantane\n \nCommon inorganic ligands\n acac   acetylacetonate anion   (bidentate)\n bipy   2,2\"\"-bipyridine         (bidentate)\n cp     cyclopentadienyl anion  (:, ::, :::)\n dien   diethylenetriamine      (tridentate)\n dppe   1,2-bis(diphenylphosphino)ethane\n                                (bidentate)\n edta   ethylenediaminetetraacetate anion\n                                (hexadentate)\n en     ethylenediamine         (bidentate)\n phen   1,10-phenanthroline     (bidentate)\n tren   tris(2-aminoethyl)amine (tetradentate)\n trien  triethylenetetramine    (tetradentate)\n \nPeptide fragments (HC::ONHCH2R)\n GLY       glycine\n ALA       alanine\n VAL       valine\n LEU       leucine\n ILE       isoleucine\n PRO       proline\n PHE       phenylalanine\n TYR       tyrosine\n TRP       tryptophan\n SER       serine\n THR       threonine\n CYS       cysteine\n MET       methionine\n ASN       asparagine\n GLN       glutamine\n ASP       aspartate\n GLU       glutamate\n LYS       lysine\n ARG       argenine\n HIS       histidine\n \nNucleic acid fragments\n NA_G      guanine\n NA_C      cytosine\n NA_A      adenine\n NA_T      thymine\n NA_U      uracil\n NA_R      ribose backbone fragment\n \nIn addition, the SHOW command recognizes\n'D3H' (trigonal bipyramid) or 'D4H' (octahedral)\nspecies, created as SF5, SF6, respectively.\n \n('SHOW' and 'FORM' are synonymous commands.) \nMolecular examples:\n SHOW CH3C::OOH      acetic acid\n SHOW CH3(CH2)4CH3   n-hexane\n SHOW WH2(:NH3)2     diammine of WH2\n SHOW NA_C           cytosine\n SHOW CH4            methane\n  MUTATE 3 RAD       methyladamantane\n SHOW ALA            alanine\n  MUTATE 7 ALA       ala-ala\n  MUTATE 17 ALA      ala-ala-ala, etc.\nSupramolecular examples:\n SHOW CH3 :H2O       hydrated methyl radical\n SHOW Cr 2:::Bz      dibenzene chromium\n SHOW CrCl3 2:H2O :NH3\n SHOW Cr 3::acac\n SHOW Cr ::::::edta\n");
            } else {
                p.setText("NBOModel COMMAND SYNTAX\n \nCommand verbs are case-insensitive and canbe abbreviated by the leading unique characters.Arguments are separated by commas or spaces.Parameters are attached to the command verbafter a dot (viz., DRAW.ap MODEL).  Argumentsand parameters are case-insensitive, exceptfor chemical formulas and group acronyms.Use 'HELP <command>' (e.g., 'HELP SHOW') forfurther specifics of each COMMAND type.\n \nCOMMAND(.t)   arguments\n------------------------------------\nALTER         IA [IB IC ID] newvalue\nCLIP          IA IB\nDRAW          filename\nFUSE(.R)      IA IB\nHELP          command\nLINK          IA IB\nMUTATE        IA formula\nREBOND        IA symtype\nROTATE        AXIS angle\nSAVE.t        filename\nSHOW          formula\nSWITCH        IA IB\nSYMMETRY\nTRANSLATE     AXIS shift\nTWIST         IA IB IC ID newvalue\nUNIFY         CFI1 CFI2 IA1 IB1 IA2 IB2 dist\nUSE.t         filename\nVALUE         IA [IB IC ID]\n3CHB          IA IB :Ligand\n\n\nSHOW <formula> (create a molecule model from\n                its 'formula')\nSHOW <acceptor> <donor-1> <donor-2>...\n               (create supramolecular model from\n                radical 'acceptor' and ligand\n                'donor-i' formulas)\nThe chemical 'formula' is a valid Lewis-typeline formula, similar to textbook examples.Use colons to denote multiple bonds (C::O doublebond, C:::N triple bond, etc.) and parenthesesto identify repeat units or side groups.Atomic symbols in the range H-Cf (Z = 1-98)and repetition numbers 1-9 are allowed.Chemical formula symbols are case-sensitive.\n \nLigated free radicals (with free-valent acceptorsites) can also be formed in specified hapticitymotifs with chosen molecular ligands. Radical<acceptor> and ligand <donor-i> monomers arespecified by valid line formulas, with eachligand <donor> formula preceded by a number ofcolons (:) representing the number of 2e sitesin the desired ligand denticity (such as ':NH3'for monodentate ammine ligand, '::NH2CH::CH2'for bidentate vinylamine ligand, or ':::Bz' fortridentate benzene ligand). Each such ligationsymbol may be prefixed with a stoichiometriccoefficient 2-9 for the number of ligands.\n \nIn both molecular and supramolecular formulas,valid transition metal duodectet structuresare also accepted. For d-block molecular species,the default idealized metal hybridization isomercan be altered with the REBOND command.For d-block species one can also includecoordinative ligands (:Lig), enclosed inparentheses and preceded by a colon symbol.Formal 'ylidic' charges are allowed only foradjacent atom pairs (e.g., dative pi-bonds).\n \nModels may also be specified by using acronymsfrom a library of pre-formed species (manyat B3LYP/6-31+G* optimized level). Each suchacronym can also be used as a monovalent ligandin MUTATE commands, as illustrated below.\n \nCommon cyclic aromatic species\n Bz        C6H6   benzene\n A10R2L    C10H8  naphthalene\n A14R3L    C14H12 anthracene\n A18R4L    C18H16 tetracene\n A22R5L    C22H20 pentacene\n A14R3     C14H10 phenanthrene\n A14R4     C14H12 chrysene\n A16R4     C16H10 pyrene\n A18R4     C18H12 triphenylene\n A20R5     C20H12 benzopyrene\n A20R6     C20H10 corannulene\n A24R7     C24H12 coronene\n A32R10    C32H14 ovalene\nCommon cyclic saturated species\n R6C       C6H12 cyclohexane (chair)\n R6B         '        '      (boat t.s.) \n R6T         '        '      (twist-boat)\n R5        C5H10 cyclopentane\n R4        C4H8  cyclobutane\n R3        C3H6  cyclopropane\n RB222     [2,2,2]bicyclooctane\n RB221     [2,2,1]bicycloheptane (norbornane)\n RB211     [2,1,1]bicyclohexane\n RB111     [1,1,1]bicyclopentane (propellane)\n R5S       spiropentane\n RAD       adamantane\n \nCommon inorganic ligands\n acac   acetylacetonate anion   (bidentate)\n bipy   2,2\"\"-bipyridine         (bidentate)\n cp     cyclopentadienyl anion  (:, ::, :::)\n dien   diethylenetriamine      (tridentate)\n dppe   1,2-bis(diphenylphosphino)ethane\n                                (bidentate)\n edta   ethylenediaminetetraacetate anion\n                                (hexadentate)\n en     ethylenediamine         (bidentate)\n phen   1,10-phenanthroline     (bidentate)\n tren   tris(2-aminoethyl)amine (tetradentate)\n trien  triethylenetetramine    (tetradentate)\n \nPeptide fragments (HC::ONHCH2R)\n GLY       glycine\n ALA       alanine\n VAL       valine\n LEU       leucine\n ILE       isoleucine\n PRO       proline\n PHE       phenylalanine\n TYR       tyrosine\n TRP       tryptophan\n SER       serine\n THR       threonine\n CYS       cysteine\n MET       methionine\n ASN       asparagine\n GLN       glutamine\n ASP       aspartate\n GLU       glutamate\n LYS       lysine\n ARG       argenine\n HIS       histidine\n \nNucleic acid fragments\n NA_G      guanine\n NA_C      cytosine\n NA_A      adenine\n NA_T      thymine\n NA_U      uracil\n NA_R      ribose backbone fragment\n \nIn addition, the SHOW command recognizes\n'D3H' (trigonal bipyramid) or 'D4H' (octahedral)\nspecies, created as SF5, SF6, respectively.\n \n('SHOW' and 'FORM' are synonymous commands.) \nMolecular examples:\n SHOW CH3C::OOH      acetic acid\n SHOW CH3(CH2)4CH3   n-hexane\n SHOW WH2(:NH3)2     diammine of WH2\n SHOW NA_C           cytosine\n SHOW CH4            methane\n  MUTATE 3 RAD       methyladamantane\n SHOW ALA            alanine\n  MUTATE 7 ALA       ala-ala\n  MUTATE 17 ALA      ala-ala-ala, etc.\nSupramolecular examples:\n SHOW CH3 :H2O       hydrated methyl radical\n SHOW Cr 2:::Bz      dibenzene chromium\n SHOW CrCl3 2:H2O :NH3\n SHOW Cr 3::acac\n SHOW Cr ::::::edta\n\nUSE.t filename  (use file 'filename' of type 't'\n                 to initiate a modeling session)\n \n't' parameters: \n .v   = valence coordinate VFILE ([.vfi])\n .c   = cartesian coordinate CFILE (.cfi)\n .a   = NBO archive file (.47)\n .adf = ADF input file (.adf)\n .g   = Gaussian input file (.gau)\n .gms = GAMESS input file (.gms)\n .jag = Jaguar input file (.jag)\n .l   = Gaussian log file (.log)\n .mp  = Molpro input file (.mp)\n .nw  = NWChem input file (.nw)\n .orc = Orca input file (.orc)\n .pqs = PQS input file (.pqs)\n .qc  = Q-Chem input file (.qc)\nExample:\n USE.G ACETIC   (use Gaussian-type ACETIC.GAU\n                input file to start session)\n\nSYMMETRY           (determine point group)\n \nNote that exact point-group symmetry is amathematical idealization. NBOModel recognizes'effective' symmetry, adequate for chemicalpurposes even if actual atom positions deviateslightly (say, ~0.02A) from idealized symmetry.");
            }
        } else if (key.equals("alter")) {
            p.setText("ALTER IA newval     (nuclear charge of atom IA)\n      IA IB newval          (bond length IA-IB)\n      IA IB IC newval  (valence angle IA-IB-IC)\n      IA IB IC ID newval (dihedral IA-IB-IC-IC)\n \nExamples:\n ALTER 10 14.   [change atom 10 to Si (Z = 14)]\n ALTER  2 5 1.69  [change R(5-8) bond to 1.69A]\n ALTER  1 2 3 4 180.   [change 1-2-3-4 dihedral\n                          angle to 180 degrees]\n \nNote that 'ALTER 1 2 3 4 180.' changes ONLYthe 1-2-3-4 dihedral (often giving unphysicaldistorted geometry).  Use 'TWIST 1 2 3 4 180.'to form a proper torsional rotamer.\n \nUse VFILE to determine which angles can besafely ALTERed.  Otherwise, the coordinatesmay be re-defined, with unexpected effectson other variables.");
        } else if (key.equals("clip")) {
            p.setText("CLIP IA IB          (erase bond between IA, IB)\n \nExample:\n CLIP 1 2        [erase bond between atoms 1,2]\n \nNote that CLIP takes no account of electronicrequirements for a Lewis-compliant model.");
        } else if (key.equals("fuse")) {
            p.setText("FUSE IA,IB       (remove IA,IB and join the two\n                'dangling' sites by a new bond)\n \nAllowed parameter:\n .r = ring-forming (conformational search)\n \nExamples:\n FUSE 4 12    [remove atoms 4, 12 and draw a new\n          bond between resulting radical centers\n          (e.g., 3-11), with no geometry change]\n FUSE.r 4 12      [similar, but a conformational\n            search is performed to find the most\n                 suitable ring-closing geometry]\n \nNote that IA, IB must have similar valency, so\nthe resulting structure remains Lewis-compliant.\n");
        } else if (key.equals("link")) {
            p.setText("LINK IA IB  (draw a 'bond' between atoms IA, IB)\nExamples:\n LINK 3 17    [draws a 'bond: between atoms 3-17\nNote that this command (unlike FUSE) takes no\naccount of chemical reasonability.\n");
        } else if (key.equals("mutate")) {
            p.setText("MUTATE IA formula (replace atom IA by the group\n               of specified chemical 'formula',\n             if both are of consistent valency)\n \nExample:\n MUTATE 4 CH3     [remove monovalent atom 4 and\n           attach a methyl (CH3) radical in its\n         place, preserving valence consistency]\n");
        } else if (key.equals("rebond")) {
            p.setText("REBOND IA symtype   (select a new Lewis valence\n                   isomer of 'symtype' symmetry\n                   at transition metal atom IA)\n \nAllowed 'symtype' parameters (TM species only):\n \n ML6 bonding: c3vo      ('Outer' C3v [default])\n              c3vi       ('Inner' C3v symmetry)\n              c5vo       ('Outer' C5v symmetry)\n              c5vi       ('Inner' C5v symmetry)\n \n ML5 bonding: c4vo      ('Outer' C4v [default])\n              c4vi       ('Inner' C4v symmetry)\n \n ML4 bonding: td        (Td symmetry [default])\n              c3vi       ('Inner' C3v symmetry)\n              c4v        (C4v symmetry)\nExample:\n SHOW WH6       [Tungsten hexahydride, in ideal\n                        'c3vo' isomer geometry]\n REBOND 2 c5vi     [reform preceding WH6 isomer\n                     to alternative 'inner C5v'\n                         geometry at TM atom 2]\n");
        } else if (key.equals("switch")) {
            p.setText("SWITCH IA IB      [switch atoms IA, IB (and\n                  attached groups) to invert\n                  configuration at an attached\n                  stereocenter.]\nExample:\n SHOW ALA         (L-alanine)\n SWITCH 6 7       (switch to D-alanine)\n");
        } else if (key.equals("twist")) {
            p.setText("TWIST IA IB IC IC newval\n              IA-IB-IC-ID angle to 'newval')\n \nExample:\n SHOW C2H6          ethane (staggered)\n TWIST 1 2 3 4 0.   ethane (eclipsed)\n");
        } else if (key.equals("unify")) {
            p.setText("UNIFY CFI-1 CFI-2 IA1 IB1 IA2 IB2 dist\n          (form a complex from molecules in\n           cfiles CFI-1, CFI-2, chosen to have\n           linear IA1-IB1-IB2-IA2 alignment\n           and IA1-IA2 separation 'dist')\n \nCFI-1 and CFI-2 are two CFILES (previously\ncreated with SAVE.C); IA1, IB1 are two atoms\nof CFI-1 and IA2, IB2 are two atoms of CFI-2\nthat will be 'unified' in linear IA1-IB1-IB2-IA2\narrangement, with specified IA1-IA2 'dist'.\n \nExample:\n SHOW H2C::O       (create formaldehyde)\n SAVE.C H2CO       (save H2CO.cfi)\n SHOW NH3          (create ammonia)\n SAVE.C NH3        (save NH3.cfi)\n UNIFY H2CO.cfi NH3.cfi 2 3 1 2 4.3\n                   (creates H-bonded complex)\n");
        } else if (key.equals("3chb")) {
            p.setText("3CHB IA IB :Lig     (form 3-center hyperbond\n                    IA-IB-Lig to ligand :Lig)\nExamples:\n SHOW W(:NH3)3      (normal-valent W triammine)\n 3CHB  1 2 :NH3     (hyperbonded N-W-N triad)\n SHOW H2O           (water monomer)\n 3CHB  2 3 :OH2     (H-bonded water dimer)\n");
        } else if (key.equals("save")) {
            p.setText("SAVE.t filename     (save current model as file\n              'filename' of type 't' extension)\n \nParameters: \n .v   = valence coordinate VFILE ([.vfi])\n .c   = cartesian coordinate CFILE (.cfi)\n .adf = ADF input file (.adf)\n .g   = Gaussian input file (.gau)\n .gms = GAMESS input file (.gms)\n .jag = Jaguar input file (.jag)\n .mm  = MM2 molecular mechanics file (.mm2)\n .mnd = AM1/MINDO-type input file (.mnd)\n .mp  = Molpro input file (.mp)\n .nw  = NWChem input file (.nw)\n .orc = Orca input file (.orc)\n .pqs = PQS input file (.pqs)\n .qc  = Q-Chem input file (.qc)\nExample:\n SAVE.G job   [save Gaussian-type 'job.gau' file]\n");
        } else if (key.equals("use")) {
            p.setText("USE.t filename  (use file 'filename' of type 't'\n                 to initiate a modeling session)\n \n't' parameters: \n .v   = valence coordinate VFILE ([.vfi])\n .c   = cartesian coordinate CFILE (.cfi)\n .a   = NBO archive file (.47)\n .adf = ADF input file (.adf)\n .g   = Gaussian input file (.gau)\n .gms = GAMESS input file (.gms)\n .jag = Jaguar input file (.jag)\n .l   = Gaussian log file (.log)\n .mp  = Molpro input file (.mp)\n .nw  = NWChem input file (.nw)\n .orc = Orca input file (.orc)\n .pqs = PQS input file (.pqs)\n .qc  = Q-Chem input file (.qc)\nExample:\n USE.G ACETIC   (use Gaussian-type ACETIC.GAU\n                input file to start session)\n");
        } else if (key.contains("sym")) {
            p.setText("SYMMETRY           (determine point group)\n \nNote that exact point-group symmetry is amathematical idealization. NBOModel recognizes'effective' symmetry, adequate for chemicalpurposes even if actual atom positions deviateslightly (say, ~0.02A) from idealized symmetry.");
        } else {
            this.appendOutputWithCaret("Unkown command type", 'p');
            return false;
        }
        return true;
    }

    protected void rawInputM(String cmd) {
        SB sb = new SB();
        String[] tokens = cmd.split(" ");
        if (tokens.length == 0) {
            return;
        }
        cmd = tokens[0].toLowerCase();
        if (cmd.startsWith("al")) {
            cmd = "alter";
        } else if (cmd.startsWith("sh")) {
            cmd = "show";
            this.enableComponentsR(this, true);
        } else if (cmd.startsWith("cl")) {
            cmd = "clip";
        } else if (cmd.startsWith("mu")) {
            cmd = "mutate";
        } else if (cmd.startsWith("fu")) {
            cmd = "fuse";
        } else if (cmd.startsWith("sy")) {
            cmd = "symmetry";
            this.editMode = 0;
        } else if (cmd.startsWith("sw")) {
            cmd = "switch";
        } else if (cmd.startsWith("li")) {
            cmd = "link";
        } else if (cmd.startsWith("re")) {
            cmd = "rebond";
        } else if (!cmd.startsWith("save")) {
            if (cmd.startsWith("va")) {
                cmd = "value";
                this.editMode = 5;
            } else if (cmd.startsWith("tw")) {
                cmd = "twist";
            } else if (cmd.startsWith("ro")) {
                cmd = "rotate";
            }
        }
        for (int i = 1; i < tokens.length; ++i) {
            cmd = cmd + " " + tokens[i];
        }
        this.appendToFile("CMD " + cmd, sb);
        this.appendOutputWithCaret(cmd, 'i');
        this.modelCmd(sb);
    }
}

