/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;

public class ImmutableGpxTrackSegment
implements GpxTrackSegment {
    private final Collection<WayPoint> wayPoints;
    private final Bounds bounds;
    private final double length;

    public ImmutableGpxTrackSegment(Collection<WayPoint> collection) {
        this.wayPoints = Collections.unmodifiableCollection(new ArrayList<WayPoint>(collection));
        this.bounds = this.calculateBounds();
        this.length = this.calculateLength();
    }

    private Bounds calculateBounds() {
        Bounds bounds = null;
        for (WayPoint wayPoint : this.wayPoints) {
            if (bounds == null) {
                bounds = new Bounds(wayPoint.getCoor());
                continue;
            }
            bounds.extend(wayPoint.getCoor());
        }
        return bounds;
    }

    private double calculateLength() {
        double d = 0.0;
        WayPoint wayPoint = null;
        for (WayPoint wayPoint2 : this.wayPoints) {
            Double d2;
            if (wayPoint != null && !(d2 = Double.valueOf(wayPoint.getCoor().greatCircleDistance(wayPoint2.getCoor()))).isNaN() && !d2.isInfinite()) {
                d += d2.doubleValue();
            }
            wayPoint = wayPoint2;
        }
        return d;
    }

    @Override
    public Bounds getBounds() {
        if (this.bounds == null) {
            return null;
        }
        return new Bounds(this.bounds);
    }

    @Override
    public Collection<WayPoint> getWayPoints() {
        return this.wayPoints;
    }

    @Override
    public double length() {
        return this.length;
    }

    @Override
    public int getUpdateCount() {
        return 0;
    }
}

