/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bbox;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.bbox.BBoxChooser;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TileSelectionBBoxChooser
extends JPanel
implements BBoxChooser {
    private transient Bounds bbox;
    private final TileBoundsMapView mapViewer = new TileBoundsMapView();
    private final TileGridInputPanel pnlTileGrid = new TileGridInputPanel();
    private final TileAddressInputPanel pnlTileAddress = new TileAddressInputPanel();

    protected final void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.pnlTileGrid, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.pnlTileAddress, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.mapViewer, gridBagConstraints);
        this.mapViewer.setFocusable(false);
        this.mapViewer.setZoomContolsVisible(false);
        this.mapViewer.setMapMarkerVisible(false);
        this.pnlTileAddress.addPropertyChangeListener(this.pnlTileGrid);
        this.pnlTileGrid.addPropertyChangeListener(new TileBoundsChangeListener());
    }

    public TileSelectionBBoxChooser() {
        this.build();
    }

    @Override
    public Bounds getBoundingBox() {
        return this.bbox;
    }

    @Override
    public void setBoundingBox(Bounds bounds) {
        this.pnlTileGrid.initFromBoundingBox(bounds);
    }

    protected void refreshMapView() {
        if (this.bbox == null) {
            return;
        }
        ArrayList<MapMarker> arrayList = new ArrayList<MapMarker>(2);
        arrayList.add(new MapMarkerDot(this.bbox.getMinLat(), this.bbox.getMinLon()));
        arrayList.add(new MapMarkerDot(this.bbox.getMaxLat(), this.bbox.getMaxLon()));
        this.mapViewer.setBoundingBox(this.bbox);
        this.mapViewer.setMapMarkerList(arrayList);
        this.mapViewer.setDisplayToFitMapMarkers();
        this.mapViewer.zoomOut();
    }

    protected Bounds convertTileBoundsToBoundingBox(TileBounds tileBounds) {
        LatLon latLon = this.getNorthWestLatLonOfTile(tileBounds.min, tileBounds.zoomLevel);
        Point point = new Point(tileBounds.max);
        ++point.x;
        ++point.y;
        LatLon latLon2 = this.getNorthWestLatLonOfTile(point, tileBounds.zoomLevel);
        return new Bounds(latLon2.lat(), latLon.lon(), latLon.lat(), latLon2.lon());
    }

    protected LatLon getNorthWestLatLonOfTile(Point point, int n) {
        double d = (double)point.x / Math.pow(2.0, n) * 360.0 - 180.0;
        double d2 = Math.toDegrees(Math.atan(Math.sinh(Math.PI - Math.PI * 2 * (double)point.y / Math.pow(2.0, n))));
        return new LatLon(d2, d);
    }

    private static final class TileBoundsMapView
    extends JMapViewer {
        private Point min;
        private Point max;

        private TileBoundsMapView() {
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            TileLoader tileLoader = this.tileController.getTileLoader();
            if (tileLoader instanceof OsmTileLoader) {
                ((OsmTileLoader)tileLoader).headers.put("User-Agent", Version.getInstance().getFullAgentString());
            }
        }

        public void setBoundingBox(Bounds bounds) {
            if (bounds == null) {
                this.min = null;
                this.max = null;
            } else {
                Point point = this.tileSource.latLonToXY(bounds.getMinLat(), bounds.getMinLon(), 22);
                Point point2 = this.tileSource.latLonToXY(bounds.getMaxLat(), bounds.getMaxLon(), 22);
                this.min = new Point(Math.min(point.x, point2.x), Math.min(point.y, point2.y));
                this.max = new Point(Math.max(point.x, point2.x), Math.max(point.y, point2.y));
            }
            this.repaint();
        }

        protected Point getTopLeftCoordinates() {
            return new Point(this.center.x - this.getWidth() / 2, this.center.y - this.getHeight() / 2);
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.min == null || this.max == null) {
                return;
            }
            int n = 22 - this.zoom;
            Point point = this.getTopLeftCoordinates();
            int n2 = (this.min.x >> n) - point.x;
            int n3 = (this.min.y >> n) - point.y;
            int n4 = (this.max.x >> n) - point.x;
            int n5 = (this.max.y >> n) - point.y;
            int n6 = n4 - n2;
            int n7 = n5 - n3;
            graphics.setColor(new Color(0.9f, 0.7f, 0.7f, 0.6f));
            graphics.fillRect(n2, n3, n6, n7);
            graphics.setColor(Color.BLACK);
            graphics.drawRect(n2, n3, n6, n7);
        }
    }

    private static final class TileBounds {
        private Point min;
        private Point max;
        private int zoomLevel;

        private TileBounds() {
            this.zoomLevel = 0;
            this.min = new Point(0, 0);
            this.max = new Point(0, 0);
        }

        private TileBounds(Point point, Point point2, int n) {
            this.min = point;
            this.max = point2;
            this.zoomLevel = n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(24);
            stringBuilder.append("min=").append(this.min.x).append(',').append(this.min.y).append(",max=").append(this.max.x).append(',').append(this.max.y).append(",zoom=").append(this.zoomLevel);
            return stringBuilder.toString();
        }
    }

    private static class TileCoordinateValidator
    extends AbstractTextComponentValidator {
        private int zoomLevel;
        private int tileIndex;

        TileCoordinateValidator(JTextComponent jTextComponent) {
            super(jTextComponent);
        }

        public void setZoomLevel(int n) {
            this.zoomLevel = n;
            this.validate();
        }

        @Override
        public boolean isValid() {
            String string = this.getComponent().getText().trim();
            try {
                this.tileIndex = string.isEmpty() ? 0 : Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return this.tileIndex >= 0 && !((double)this.tileIndex >= Math.pow(2.0, this.zoomLevel));
        }

        @Override
        public void validate() {
            if (this.isValid()) {
                this.feedbackValid(I18n.tr("Please enter a tile index", new Object[0]));
            } else {
                this.feedbackInvalid(I18n.tr("The current value isn''t a valid tile index for the given zoom level", this.getComponent().getText()));
            }
        }

        public int getTileIndex() {
            return this.tileIndex;
        }
    }

    private static class TileAddressValidator
    extends AbstractTextComponentValidator {
        private TileBounds tileBounds;

        TileAddressValidator(JTextComponent jTextComponent) {
            super(jTextComponent);
        }

        @Override
        public boolean isValid() {
            int n;
            int n2;
            int n3;
            String string = this.getComponent().getText().trim();
            Matcher matcher = Pattern.compile("(\\d+)[^\\d]+(\\d+)[^\\d]+(\\d+)").matcher(string);
            this.tileBounds = null;
            if (!matcher.matches()) {
                return false;
            }
            try {
                n3 = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n3 < 0 || n3 > 18) {
                return false;
            }
            try {
                n2 = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n2 < 0 || (double)n2 >= Math.pow(2.0, n3)) {
                return false;
            }
            try {
                n = Integer.parseInt(matcher.group(3));
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n < 0 || (double)n >= Math.pow(2.0, n3)) {
                return false;
            }
            this.tileBounds = new TileBounds(new Point(n2, n), new Point(n2, n), n3);
            return true;
        }

        @Override
        public void validate() {
            if (this.isValid()) {
                this.feedbackValid(I18n.tr("Please enter a tile address", new Object[0]));
            } else {
                this.feedbackInvalid(I18n.tr("The current value isn''t a valid tile address", this.getComponent().getText()));
            }
        }

        public TileBounds getTileBounds() {
            return this.tileBounds;
        }
    }

    private static class TileAddressInputPanel
    extends JPanel {
        public static final String TILE_BOUNDS_PROP = TileAddressInputPanel.class.getName() + ".tileBounds";
        private transient TileAddressValidator valTileAddress;

        protected JPanel buildTextPanel() {
            JPanel jPanel = new JPanel(new BorderLayout());
            HtmlPanel htmlPanel = new HtmlPanel();
            htmlPanel.setText(I18n.tr("<html>Alternatively you may enter a <strong>tile address</strong> for a single tile in the format <i>zoomlevel/x/y</i>, e.g. <i>15/256/223</i>. Tile addresses in the format <i>zoom,x,y</i> or <i>zoom;x;y</i> are valid too.</html>", new Object[0]));
            jPanel.add(htmlPanel);
            return jPanel;
        }

        protected JPanel buildTileAddressInputPanel() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 2, 2);
            jPanel.add((Component)new JLabel(I18n.tr("Tile address:", new Object[0])), gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            JosmTextField josmTextField = new JosmTextField();
            jPanel.add((Component)josmTextField, gridBagConstraints);
            this.valTileAddress = new TileAddressValidator(josmTextField);
            SelectAllOnFocusGainedDecorator.decorate(josmTextField);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 2;
            ApplyTileAddressAction applyTileAddressAction = new ApplyTileAddressAction();
            JButton jButton = new JButton(applyTileAddressAction);
            jButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            jPanel.add((Component)jButton, gridBagConstraints);
            josmTextField.addActionListener(applyTileAddressAction);
            return jPanel;
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 5, 0);
            this.add((Component)this.buildTextPanel(), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.add((Component)this.buildTileAddressInputPanel(), gridBagConstraints);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)new JPanel(), gridBagConstraints);
        }

        TileAddressInputPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.build();
        }

        protected void fireTileBoundsChanged(TileBounds tileBounds) {
            this.firePropertyChange(TILE_BOUNDS_PROP, null, tileBounds);
        }

        class ApplyTileAddressAction
        extends AbstractAction {
            ApplyTileAddressAction() {
                this.putValue("SmallIcon", ImageProvider.get("apply"));
                this.putValue("ShortDescription", I18n.tr("Apply the tile address", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TileBounds tileBounds = TileAddressInputPanel.this.valTileAddress.getTileBounds();
                if (tileBounds != null) {
                    TileAddressInputPanel.this.fireTileBoundsChanged(tileBounds);
                }
            }
        }
    }

    private static class TileGridInputPanel
    extends JPanel
    implements PropertyChangeListener {
        public static final String TILE_BOUNDS_PROP = TileGridInputPanel.class.getName() + ".tileBounds";
        private final JosmTextField tfMaxY = new JosmTextField();
        private final JosmTextField tfMinY = new JosmTextField();
        private final JosmTextField tfMaxX = new JosmTextField();
        private final JosmTextField tfMinX = new JosmTextField();
        private transient TileCoordinateValidator valMaxY;
        private transient TileCoordinateValidator valMinY;
        private transient TileCoordinateValidator valMaxX;
        private transient TileCoordinateValidator valMinX;
        private final JSpinner spZoomLevel = new JSpinner(new SpinnerNumberModel(0, 0, 18, 1));
        private final transient TileBoundsBuilder tileBoundsBuilder = new TileBoundsBuilder();
        private boolean doFireTileBoundChanged = true;

        protected JPanel buildTextPanel() {
            JPanel jPanel = new JPanel(new BorderLayout());
            HtmlPanel htmlPanel = new HtmlPanel();
            htmlPanel.setText(I18n.tr("<html>Please select a <strong>range of OSM tiles</strong> at a given zoom level.</html>", new Object[0]));
            jPanel.add(htmlPanel);
            return jPanel;
        }

        protected JPanel buildZoomLevelPanel() {
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(new JLabel(I18n.tr("Zoom level:", new Object[0])));
            jPanel.add(this.spZoomLevel);
            this.spZoomLevel.addChangeListener(new ZomeLevelChangeHandler());
            this.spZoomLevel.addChangeListener(this.tileBoundsBuilder);
            return jPanel;
        }

        protected JPanel buildTileGridInputPanel() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 0, 2, 2);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.buildZoomLevelPanel(), gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 1;
            jPanel.add((Component)new JLabel(I18n.tr("from tile", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            jPanel.add((Component)new JLabel(I18n.tr("up to tile", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)new JLabel("X:"), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.5;
            jPanel.add((Component)this.tfMinX, gridBagConstraints);
            this.valMinX = new TileCoordinateValidator(this.tfMinX);
            SelectAllOnFocusGainedDecorator.decorate(this.tfMinX);
            this.tfMinX.addActionListener(this.tileBoundsBuilder);
            this.tfMinX.addFocusListener(this.tileBoundsBuilder);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.5;
            jPanel.add((Component)this.tfMaxX, gridBagConstraints);
            this.valMaxX = new TileCoordinateValidator(this.tfMaxX);
            SelectAllOnFocusGainedDecorator.decorate(this.tfMaxX);
            this.tfMaxX.addActionListener(this.tileBoundsBuilder);
            this.tfMaxX.addFocusListener(this.tileBoundsBuilder);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)new JLabel("Y:"), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.5;
            jPanel.add((Component)this.tfMinY, gridBagConstraints);
            this.valMinY = new TileCoordinateValidator(this.tfMinY);
            SelectAllOnFocusGainedDecorator.decorate(this.tfMinY);
            this.tfMinY.addActionListener(this.tileBoundsBuilder);
            this.tfMinY.addFocusListener(this.tileBoundsBuilder);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.5;
            jPanel.add((Component)this.tfMaxY, gridBagConstraints);
            this.valMaxY = new TileCoordinateValidator(this.tfMaxY);
            SelectAllOnFocusGainedDecorator.decorate(this.tfMaxY);
            this.tfMaxY.addActionListener(this.tileBoundsBuilder);
            this.tfMaxY.addFocusListener(this.tileBoundsBuilder);
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            jPanel.add((Component)new JPanel(), gridBagConstraints);
            return jPanel;
        }

        protected void build() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)this.buildTextPanel(), "North");
            this.add((Component)this.buildTileGridInputPanel(), "Center");
            HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(0));
            hashSet.add(KeyStroke.getKeyStroke(10, 0));
            this.setFocusTraversalKeys(0, hashSet);
        }

        TileGridInputPanel() {
            this.build();
        }

        public void initFromBoundingBox(Bounds bounds) {
            if (bounds == null) {
                return;
            }
            TileBounds tileBounds = new TileBounds();
            tileBounds.zoomLevel = (Integer)this.spZoomLevel.getValue();
            tileBounds.min = new Point(Math.max(0, TileGridInputPanel.lonToTileX(tileBounds.zoomLevel, bounds.getMinLon())), Math.max(0, TileGridInputPanel.latToTileY(tileBounds.zoomLevel, bounds.getMaxLat() - 1.0E-5)));
            tileBounds.max = new Point(Math.max(0, TileGridInputPanel.lonToTileX(tileBounds.zoomLevel, bounds.getMaxLon())), Math.max(0, TileGridInputPanel.latToTileY(tileBounds.zoomLevel, bounds.getMinLat() - 1.0E-5)));
            this.doFireTileBoundChanged = false;
            this.setTileBounds(tileBounds);
            this.doFireTileBoundChanged = true;
        }

        public static int latToTileY(int n, double d) {
            if (n < 3 || n > 18) {
                return -1;
            }
            double d2 = d / 180.0 * Math.PI;
            double d3 = Math.log(Math.tan(d2) + 1.0 / Math.cos(d2));
            return (int)((double)(1 << n - 1) * (Math.PI - d3) / Math.PI);
        }

        public static int lonToTileX(int n, double d) {
            if (n < 3 || n > 18) {
                return -1;
            }
            return (int)((double)(1 << n - 3) * (d + 180.0) / 45.0);
        }

        public void setTileBounds(TileBounds tileBounds) {
            this.tfMinX.setText(Integer.toString(((TileBounds)tileBounds).min.x));
            this.tfMinY.setText(Integer.toString(((TileBounds)tileBounds).min.y));
            this.tfMaxX.setText(Integer.toString(((TileBounds)tileBounds).max.x));
            this.tfMaxY.setText(Integer.toString(((TileBounds)tileBounds).max.y));
            this.spZoomLevel.setValue(tileBounds.zoomLevel);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(TileAddressInputPanel.TILE_BOUNDS_PROP)) {
                TileBounds tileBounds = (TileBounds)propertyChangeEvent.getNewValue();
                this.setTileBounds(tileBounds);
                this.fireTileBoundsChanged(tileBounds);
            }
        }

        protected void fireTileBoundsChanged(TileBounds tileBounds) {
            if (!this.doFireTileBoundChanged) {
                return;
            }
            this.firePropertyChange(TILE_BOUNDS_PROP, null, tileBounds);
        }

        class TileBoundsBuilder
        implements ActionListener,
        FocusListener,
        ChangeListener {
            TileBoundsBuilder() {
            }

            protected void buildTileBounds() {
                if (!TileGridInputPanel.this.valMaxX.isValid()) {
                    return;
                }
                if (!TileGridInputPanel.this.valMaxY.isValid()) {
                    return;
                }
                if (!TileGridInputPanel.this.valMinX.isValid()) {
                    return;
                }
                if (!TileGridInputPanel.this.valMinY.isValid()) {
                    return;
                }
                Point point = new Point(TileGridInputPanel.this.valMinX.getTileIndex(), TileGridInputPanel.this.valMinY.getTileIndex());
                Point point2 = new Point(TileGridInputPanel.this.valMaxX.getTileIndex(), TileGridInputPanel.this.valMaxY.getTileIndex());
                int n = (Integer)TileGridInputPanel.this.spZoomLevel.getValue();
                TileBounds tileBounds = new TileBounds(point, point2, n);
                TileGridInputPanel.this.fireTileBoundsChanged(tileBounds);
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                this.buildTileBounds();
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.buildTileBounds();
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                this.buildTileBounds();
            }
        }

        class ZomeLevelChangeHandler
        implements ChangeListener {
            ZomeLevelChangeHandler() {
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = (Integer)TileGridInputPanel.this.spZoomLevel.getValue();
                TileGridInputPanel.this.valMaxX.setZoomLevel(n);
                TileGridInputPanel.this.valMaxY.setZoomLevel(n);
                TileGridInputPanel.this.valMinX.setZoomLevel(n);
                TileGridInputPanel.this.valMinY.setZoomLevel(n);
            }
        }
    }

    class TileBoundsChangeListener
    implements PropertyChangeListener {
        TileBoundsChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!propertyChangeEvent.getPropertyName().equals(TileGridInputPanel.TILE_BOUNDS_PROP)) {
                return;
            }
            TileBounds tileBounds = (TileBounds)propertyChangeEvent.getNewValue();
            Bounds bounds = TileSelectionBBoxChooser.this.bbox;
            TileSelectionBBoxChooser.this.bbox = TileSelectionBBoxChooser.this.convertTileBoundsToBoundingBox(tileBounds);
            TileSelectionBBoxChooser.this.firePropertyChange(BBoxChooser.BBOX_PROP, bounds, TileSelectionBBoxChooser.this.bbox);
            TileSelectionBBoxChooser.this.refreshMapView();
        }
    }
}

