/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.layer.ActivateLayerAction;
import org.openstreetmap.josm.gui.dialogs.layer.DeleteLayerAction;
import org.openstreetmap.josm.gui.dialogs.layer.DuplicateAction;
import org.openstreetmap.josm.gui.dialogs.layer.IEnabledStateUpdating;
import org.openstreetmap.josm.gui.dialogs.layer.LayerVisibilityAction;
import org.openstreetmap.josm.gui.dialogs.layer.MergeAction;
import org.openstreetmap.josm.gui.dialogs.layer.MoveDownAction;
import org.openstreetmap.josm.gui.dialogs.layer.MoveUpAction;
import org.openstreetmap.josm.gui.dialogs.layer.ShowHideLayerAction;
import org.openstreetmap.josm.gui.layer.JumpToMarkerActions;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.NativeScaleLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.DisableShortcutsOnFocusGainedTextField;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.MultikeyActionsHandler;
import org.openstreetmap.josm.tools.MultikeyShortcutAction;
import org.openstreetmap.josm.tools.Shortcut;

public class LayerListDialog
extends ToggleDialog {
    private static volatile LayerListDialog instance;
    private final LayerListModel model;
    private final LayerList layerList;
    private final ActivateLayerAction activateLayerAction;
    private final ShowHideLayerAction showHideLayerAction;
    private final transient Shortcut[] visibilityToggleShortcuts = new Shortcut[10];
    private final ToggleLayerIndexVisibility[] visibilityToggleActions = new ToggleLayerIndexVisibility[10];
    private final transient MainLayerManager layerManager;

    public static void createInstance(MapFrame mapFrame) {
        if (instance != null) {
            throw new IllegalStateException("Dialog was already created");
        }
        instance = new LayerListDialog(mapFrame);
    }

    public static LayerListDialog getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Dialog not created yet. Invoke createInstance() first");
        }
        return instance;
    }

    private void createVisibilityToggleShortcuts() {
        for (int i = 0; i < 10; ++i) {
            int n = i + 1;
            this.visibilityToggleShortcuts[i] = Shortcut.registerShortcut("subwindow:layers:toggleLayer" + n, I18n.tr("Toggle visibility of layer: {0}", n), 48 + n % 10, 5004);
            this.visibilityToggleActions[i] = new ToggleLayerIndexVisibility(i);
            Main.registerActionShortcut(this.visibilityToggleActions[i], this.visibilityToggleShortcuts[i]);
        }
    }

    protected LayerListDialog(MapFrame mapFrame) {
        this(mapFrame.mapView.getLayerManager());
    }

    public LayerListDialog(MainLayerManager mainLayerManager) {
        super(I18n.tr("Layers", new Object[0]), "layerlist", I18n.tr("Open a list of all loaded layers.", new Object[0]), Shortcut.registerShortcut("subwindow:layers", I18n.tr("Toggle: {0}", I18n.tr("Layers", new Object[0])), 76, 5007), 100, true);
        Serializable serializable2;
        this.layerManager = mainLayerManager;
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        defaultListSelectionModel.setSelectionMode(2);
        this.model = new LayerListModel(mainLayerManager, defaultListSelectionModel);
        this.layerList = new LayerList(this.model);
        this.layerList.setSelectionModel(defaultListSelectionModel);
        this.layerList.addMouseListener(new PopupMenuHandler());
        this.layerList.setBackground(UIManager.getColor("Button.background"));
        this.layerList.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.layerList.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.layerList.setSelectionMode(2);
        this.layerList.setTableHeader(null);
        this.layerList.setShowGrid(false);
        this.layerList.setIntercellSpacing(new Dimension(0, 0));
        this.layerList.getColumnModel().getColumn(0).setCellRenderer(new ActiveLayerCellRenderer());
        this.layerList.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(new ActiveLayerCheckBox()));
        this.layerList.getColumnModel().getColumn(0).setMaxWidth(12);
        this.layerList.getColumnModel().getColumn(0).setPreferredWidth(12);
        this.layerList.getColumnModel().getColumn(0).setResizable(false);
        this.layerList.getColumnModel().getColumn(1).setCellRenderer(new NativeScaleLayerCellRenderer());
        this.layerList.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(new NativeScaleLayerCheckBox()));
        this.layerList.getColumnModel().getColumn(1).setMaxWidth(12);
        this.layerList.getColumnModel().getColumn(1).setPreferredWidth(12);
        this.layerList.getColumnModel().getColumn(1).setResizable(false);
        this.layerList.getColumnModel().getColumn(2).setCellRenderer(new LayerVisibleCellRenderer());
        this.layerList.getColumnModel().getColumn(2).setCellEditor(new LayerVisibleCellEditor(new LayerVisibleCheckBox()));
        this.layerList.getColumnModel().getColumn(2).setMaxWidth(16);
        this.layerList.getColumnModel().getColumn(2).setPreferredWidth(16);
        this.layerList.getColumnModel().getColumn(2).setResizable(false);
        this.layerList.getColumnModel().getColumn(3).setCellRenderer(new LayerNameCellRenderer());
        this.layerList.getColumnModel().getColumn(3).setCellEditor(new LayerNameCellEditor(new DisableShortcutsOnFocusGainedTextField()));
        for (Serializable serializable2 : new KeyStroke[]{KeyStroke.getKeyStroke(67, GuiHelper.getMenuShortcutKeyMaskEx()), KeyStroke.getKeyStroke(86, GuiHelper.getMenuShortcutKeyMaskEx()), KeyStroke.getKeyStroke(40, 64), KeyStroke.getKeyStroke(38, 64), KeyStroke.getKeyStroke(37, 64), KeyStroke.getKeyStroke(39, 64), KeyStroke.getKeyStroke(40, 128), KeyStroke.getKeyStroke(38, 128), KeyStroke.getKeyStroke(37, 128), KeyStroke.getKeyStroke(39, 128), KeyStroke.getKeyStroke(33, 0), KeyStroke.getKeyStroke(34, 0), KeyStroke.getKeyStroke(9, 0), KeyStroke.getKeyStroke(119, 0)}) {
            this.layerList.getInputMap(1).put((KeyStroke)serializable2, new Object());
        }
        this.model.populate();
        this.model.setSelectedLayer(mainLayerManager.getActiveLayer());
        this.model.addLayerListModelListener(new LayerListModelListener(){

            @Override
            public void makeVisible(int n, Layer layer) {
                LayerListDialog.this.layerList.scrollToVisible(n, 0);
                LayerListDialog.this.layerList.repaint();
            }

            @Override
            public void refresh() {
                LayerListDialog.this.layerList.repaint();
            }
        });
        MoveUpAction moveUpAction = new MoveUpAction(this.model);
        this.adaptTo((IEnabledStateUpdating)moveUpAction, this.model);
        this.adaptTo((IEnabledStateUpdating)moveUpAction, defaultListSelectionModel);
        MoveDownAction moveDownAction = new MoveDownAction(this.model);
        this.adaptTo((IEnabledStateUpdating)moveDownAction, this.model);
        this.adaptTo((IEnabledStateUpdating)moveDownAction, defaultListSelectionModel);
        this.activateLayerAction = new ActivateLayerAction(this.model);
        this.activateLayerAction.updateEnabledState();
        MultikeyActionsHandler.getInstance().addAction(this.activateLayerAction);
        this.adaptTo((IEnabledStateUpdating)this.activateLayerAction, defaultListSelectionModel);
        JumpToMarkerActions.initialize();
        this.showHideLayerAction = new ShowHideLayerAction(this.model);
        MultikeyActionsHandler.getInstance().addAction(this.showHideLayerAction);
        this.adaptTo((IEnabledStateUpdating)this.showHideLayerAction, defaultListSelectionModel);
        LayerVisibilityAction layerVisibilityAction = new LayerVisibilityAction(this.model);
        this.adaptTo((IEnabledStateUpdating)layerVisibilityAction, defaultListSelectionModel);
        serializable2 = new SideButton((Action)layerVisibilityAction, false);
        layerVisibilityAction.setCorrespondingSideButton((SideButton)serializable2);
        DeleteLayerAction deleteLayerAction = new DeleteLayerAction(this.model);
        this.layerList.getActionMap().put("deleteLayer", deleteLayerAction);
        this.adaptTo((IEnabledStateUpdating)deleteLayerAction, defaultListSelectionModel);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getActionMap().put("delete", deleteLayerAction);
        InputMapUtils.addEnterAction(this.layerList, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LayerListDialog.this.activateLayerAction.actionPerformed(null);
                LayerListDialog.this.layerList.requestFocus();
            }
        });
        InputMapUtils.addSpacebarAction(this.layerList, this.showHideLayerAction);
        this.createLayout(this.layerList, true, Arrays.asList(new SideButton((Action)moveUpAction, false), new SideButton((Action)moveDownAction, false), new SideButton((Action)this.activateLayerAction, false), serializable2, new SideButton((Action)deleteLayerAction, false)));
        this.createVisibilityToggleShortcuts();
    }

    public MainLayerManager getLayerManager() {
        return this.layerManager;
    }

    @Override
    public void showNotify() {
        this.layerManager.addActiveLayerChangeListener(this.activateLayerAction);
        this.layerManager.addLayerChangeListener(this.model, true);
        this.layerManager.addAndFireActiveLayerChangeListener(this.model);
        this.model.populate();
    }

    @Override
    public void hideNotify() {
        this.layerManager.removeLayerChangeListener(this.model, true);
        this.layerManager.removeActiveLayerChangeListener(this.model);
        this.layerManager.removeActiveLayerChangeListener(this.activateLayerAction);
    }

    public LayerListModel getModel() {
        return this.model;
    }

    protected void adaptTo(final IEnabledStateUpdating iEnabledStateUpdating, ListSelectionModel listSelectionModel) {
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                iEnabledStateUpdating.updateEnabledState();
            }
        });
    }

    protected void adaptTo(final IEnabledStateUpdating iEnabledStateUpdating, LayerListModel layerListModel) {
        layerListModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                iEnabledStateUpdating.updateEnabledState();
            }
        });
    }

    @Override
    public void destroy() {
        for (int i = 0; i < 10; ++i) {
            Main.unregisterActionShortcut(this.visibilityToggleActions[i], this.visibilityToggleShortcuts[i]);
        }
        MultikeyActionsHandler.getInstance().removeAction(this.activateLayerAction);
        MultikeyActionsHandler.getInstance().removeAction(this.showHideLayerAction);
        JumpToMarkerActions.unregisterActions();
        super.destroy();
        instance = null;
    }

    public ShowHideLayerAction createShowHideLayerAction() {
        return new ShowHideLayerAction(this.model);
    }

    public DeleteLayerAction createDeleteLayerAction() {
        return new DeleteLayerAction(this.model);
    }

    public ActivateLayerAction createActivateLayerAction(Layer layer) {
        return new ActivateLayerAction(layer, this.model);
    }

    public MergeAction createMergeLayerAction(Layer layer) {
        return new MergeAction(layer, this.model);
    }

    public DuplicateAction createDuplicateLayerAction(Layer layer) {
        return new DuplicateAction(layer, this.model);
    }

    public static Layer getLayerForIndex(int n) {
        List<Layer> list = Main.getLayerManager().getLayers();
        if (n < list.size() && n >= 0) {
            return list.get(n);
        }
        return null;
    }

    public static List<MultikeyShortcutAction.MultikeyInfo> getLayerInfoByClass(Class<?> clazz) {
        ArrayList<MultikeyShortcutAction.MultikeyInfo> arrayList = new ArrayList<MultikeyShortcutAction.MultikeyInfo>();
        List<Layer> list = Main.getLayerManager().getLayers();
        int n = 0;
        for (Layer layer : list) {
            if (clazz.isAssignableFrom(layer.getClass())) {
                arrayList.add(new MultikeyShortcutAction.MultikeyInfo(n, layer.getName()));
            }
            ++n;
        }
        return arrayList;
    }

    public static boolean isLayerValid(Layer layer) {
        if (layer == null) {
            return false;
        }
        return Main.getLayerManager().containsLayer(layer);
    }

    public static MultikeyShortcutAction.MultikeyInfo getLayerInfo(Layer layer) {
        if (layer == null) {
            return null;
        }
        int n = Main.getLayerManager().getLayers().indexOf(layer);
        if (n < 0) {
            return null;
        }
        return new MultikeyShortcutAction.MultikeyInfo(n, layer.getName());
    }

    static class LayerList
    extends JTable {
        LayerList(LayerListModel layerListModel) {
            super(layerListModel);
            layerListModel.setLayerList(this);
        }

        public void scrollToVisible(int n, int n2) {
            if (!(this.getParent() instanceof JViewport)) {
                return;
            }
            JViewport jViewport = (JViewport)this.getParent();
            Rectangle rectangle = this.getCellRect(n, n2, true);
            Point point = jViewport.getViewPosition();
            rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
            jViewport.scrollRectToVisible(rectangle);
        }
    }

    public static final class LayerListModel
    extends AbstractTableModel
    implements LayerManager.LayerChangeListener,
    MainLayerManager.ActiveLayerChangeListener,
    PropertyChangeListener {
        private final DefaultListSelectionModel selectionModel;
        private final CopyOnWriteArrayList<LayerListModelListener> listeners;
        private LayerList layerList;
        private final MainLayerManager layerManager;

        LayerListModel(MainLayerManager mainLayerManager, DefaultListSelectionModel defaultListSelectionModel) {
            this.layerManager = mainLayerManager;
            this.selectionModel = defaultListSelectionModel;
            this.listeners = new CopyOnWriteArrayList();
        }

        void setLayerList(LayerList layerList) {
            this.layerList = layerList;
        }

        public MainLayerManager getLayerManager() {
            return this.layerManager;
        }

        public void addLayerListModelListener(LayerListModelListener layerListModelListener) {
            if (layerListModelListener != null) {
                this.listeners.addIfAbsent(layerListModelListener);
            }
        }

        public void removeLayerListModelListener(LayerListModelListener layerListModelListener) {
            this.listeners.remove(layerListModelListener);
        }

        protected void fireMakeVisible(int n, Layer layer) {
            for (LayerListModelListener layerListModelListener : this.listeners) {
                layerListModelListener.makeVisible(n, layer);
            }
        }

        protected void fireRefresh() {
            for (LayerListModelListener layerListModelListener : this.listeners) {
                layerListModelListener.refresh();
            }
        }

        public void populate() {
            for (Layer layer : this.getLayers()) {
                layer.removePropertyChangeListener(this);
                layer.addPropertyChangeListener(this);
            }
            this.fireTableDataChanged();
        }

        public void setSelectedLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            int n = this.getLayers().indexOf(layer);
            if (n >= 0) {
                this.selectionModel.setSelectionInterval(n, n);
            }
            this.ensureSelectedIsVisible();
        }

        public List<Layer> getSelectedLayers() {
            ArrayList<Layer> arrayList = new ArrayList<Layer>();
            List<Layer> list = this.getLayers();
            for (int i = 0; i < list.size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                arrayList.add(list.get(i));
            }
            return arrayList;
        }

        public List<Integer> getSelectedRows() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < this.getLayers().size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                arrayList.add(i);
            }
            return arrayList;
        }

        private void onRemoveLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            layer.removePropertyChangeListener(this);
            int n = this.getRowCount();
            List<Integer> list = this.getSelectedRows();
            if (list.isEmpty() && n > 0) {
                this.selectionModel.setSelectionInterval(n - 1, n - 1);
            }
            this.fireTableDataChanged();
            this.fireRefresh();
            this.ensureActiveSelected();
        }

        private void onAddLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            layer.addPropertyChangeListener(this);
            this.fireTableDataChanged();
            int n = this.getLayers().indexOf(layer);
            if (this.layerList != null) {
                this.layerList.setRowHeight(n, Math.max(16, layer.getIcon().getIconHeight()));
            }
            this.selectionModel.setSelectionInterval(n, n);
            this.ensureSelectedIsVisible();
        }

        public Layer getFirstLayer() {
            if (this.getRowCount() == 0) {
                return null;
            }
            return this.getLayers().get(0);
        }

        public Layer getLayer(int n) {
            if (n < 0 || n >= this.getRowCount()) {
                return null;
            }
            return this.getLayers().get(n);
        }

        public boolean canMoveUp() {
            List<Integer> list = this.getSelectedRows();
            return !list.isEmpty() && list.get(0) > 0;
        }

        public void moveUp() {
            if (!this.canMoveUp()) {
                return;
            }
            List<Integer> list = this.getSelectedRows();
            List<Layer> list2 = this.getLayers();
            for (int n : list) {
                Layer layer = list2.get(n);
                Layer layer2 = list2.get(n - 1);
                Main.map.mapView.moveLayer(layer2, n);
                Main.map.mapView.moveLayer(layer, n - 1);
            }
            this.fireTableDataChanged();
            this.selectionModel.clearSelection();
            for (int n : list) {
                this.selectionModel.addSelectionInterval(n - 1, n - 1);
            }
            this.ensureSelectedIsVisible();
        }

        public boolean canMoveDown() {
            List<Integer> list = this.getSelectedRows();
            return !list.isEmpty() && list.get(list.size() - 1) < this.getLayers().size() - 1;
        }

        public void moveDown() {
            if (!this.canMoveDown()) {
                return;
            }
            List<Integer> list = this.getSelectedRows();
            Collections.reverse(list);
            List<Layer> list2 = this.getLayers();
            for (int n : list) {
                Layer layer = list2.get(n);
                Layer layer2 = list2.get(n + 1);
                Main.map.mapView.moveLayer(layer, n + 1);
                Main.map.mapView.moveLayer(layer2, n);
            }
            this.fireTableDataChanged();
            this.selectionModel.clearSelection();
            for (int n : list) {
                this.selectionModel.addSelectionInterval(n + 1, n + 1);
            }
            this.ensureSelectedIsVisible();
        }

        protected void ensureSelectedIsVisible() {
            int n = this.selectionModel.getMinSelectionIndex();
            if (n < 0) {
                return;
            }
            List<Layer> list = this.getLayers();
            if (n >= list.size()) {
                return;
            }
            Layer layer = list.get(n);
            this.fireMakeVisible(n, layer);
        }

        public List<Layer> getPossibleMergeTargets(Layer layer) {
            ArrayList<Layer> arrayList = new ArrayList<Layer>();
            if (layer == null) {
                return arrayList;
            }
            for (Layer layer2 : this.getLayers()) {
                if (layer == layer2 || !layer2.isMergable(layer) || !layer.isMergable(layer2)) continue;
                arrayList.add(layer2);
            }
            return arrayList;
        }

        public List<Layer> getLayers() {
            return this.getLayerManager().getLayers();
        }

        protected void ensureActiveSelected() {
            List<Layer> list = this.getLayers();
            if (list.isEmpty()) {
                return;
            }
            Layer layer = this.getActiveLayer();
            if (layer != null) {
                int n = list.indexOf(layer);
                this.selectionModel.setSelectionInterval(n, n);
                this.ensureSelectedIsVisible();
            } else {
                this.selectionModel.setSelectionInterval(0, 0);
                this.ensureSelectedIsVisible();
            }
        }

        protected Layer getActiveLayer() {
            return this.getLayerManager().getActiveLayer();
        }

        @Deprecated
        protected NativeScaleLayer getNativeScaleLayer() {
            return Main.isDisplayingMapView() ? Main.map.mapView.getNativeScaleLayer() : null;
        }

        @Override
        public int getRowCount() {
            List<Layer> list = this.getLayers();
            return list == null ? 0 : list.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            List<Layer> list = this.getLayers();
            if (n >= 0 && n < list.size()) {
                switch (n2) {
                    case 0: {
                        return list.get(n) == this.getActiveLayer();
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        return list.get(n);
                    }
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0 || this.getActiveLayer() != this.getLayers().get(n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            List<Layer> list = this.getLayers();
            if (n < list.size()) {
                Layer layer = list.get(n);
                switch (n2) {
                    case 0: {
                        this.getLayerManager().setActiveLayer(layer);
                        layer.setVisible(true);
                        break;
                    }
                    case 1: {
                        int n3;
                        NativeScaleLayer nativeScaleLayer = Main.map.mapView.getNativeScaleLayer();
                        if (nativeScaleLayer == layer) {
                            Main.map.mapView.setNativeScaleLayer(null);
                            break;
                        }
                        if (!(layer instanceof NativeScaleLayer)) break;
                        Main.map.mapView.setNativeScaleLayer((NativeScaleLayer)((Object)layer));
                        if (nativeScaleLayer == null || (n3 = this.getLayers().indexOf(nativeScaleLayer)) < 0) break;
                        this.fireTableCellUpdated(n3, n2);
                        break;
                    }
                    case 2: {
                        layer.setVisible((Boolean)object);
                        break;
                    }
                    case 3: {
                        layer.rename((String)object);
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                this.fireTableCellUpdated(n, n2);
            }
        }

        @Override
        public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent activeLayerChangeEvent) {
            int n;
            Layer layer;
            int n2;
            Layer layer2 = activeLayerChangeEvent.getPreviousActiveLayer();
            if (layer2 != null && (n2 = this.getLayers().indexOf(layer2)) >= 0) {
                this.fireTableRowsUpdated(n2, n2);
            }
            if ((layer = this.getActiveLayer()) != null && (n = this.getLayers().indexOf(layer)) >= 0) {
                this.fireTableRowsUpdated(n, n);
            }
            this.ensureActiveSelected();
        }

        @Override
        public void layerAdded(LayerManager.LayerAddEvent layerAddEvent) {
            this.onAddLayer(layerAddEvent.getAddedLayer());
        }

        @Override
        public void layerRemoving(LayerManager.LayerRemoveEvent layerRemoveEvent) {
            this.onRemoveLayer(layerRemoveEvent.getRemovedLayer());
        }

        @Override
        public void layerOrderChanged(LayerManager.LayerOrderChangeEvent layerOrderChangeEvent) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() instanceof Layer) {
                Layer layer = (Layer)propertyChangeEvent.getSource();
                int n = this.getLayers().indexOf(layer);
                if (n < 0) {
                    return;
                }
                this.fireRefresh();
            }
        }
    }

    public static interface LayerListModelListener {
        public void makeVisible(int var1, Layer var2);

        public void refresh();
    }

    class PopupMenuHandler
    extends PopupMenuLauncher {
        PopupMenuHandler() {
        }

        @Override
        public void showMenu(MouseEvent mouseEvent) {
            this.menu = new LayerListPopup(LayerListDialog.this.getModel().getSelectedLayers());
            super.showMenu(mouseEvent);
        }
    }

    private static class LayerNameCellEditor
    extends DefaultCellEditor {
        LayerNameCellEditor(DisableShortcutsOnFocusGainedTextField disableShortcutsOnFocusGainedTextField) {
            super(disableShortcutsOnFocusGainedTextField);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            JosmTextField josmTextField = (JosmTextField)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            josmTextField.setText(object == null ? "" : ((Layer)object).getName());
            return josmTextField;
        }
    }

    private class LayerNameCellRenderer
    extends DefaultTableCellRenderer {
        private LayerNameCellRenderer() {
        }

        protected boolean isActiveLayer(Layer layer) {
            return LayerListDialog.this.getLayerManager().getActiveLayer() == layer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            Layer layer = (Layer)object;
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, layer.getName(), bl, bl2, n, n2);
            if (this.isActiveLayer(layer)) {
                jLabel.setFont(jLabel.getFont().deriveFont(1));
            }
            if (Main.pref.getBoolean("dialog.layer.colorname", true)) {
                Color color = layer.getColor(false);
                if (color != null) {
                    Color color2 = null;
                    for (Layer layer2 : LayerListDialog.this.model.getLayers()) {
                        color2 = layer2.getColor(false);
                        if (color2 == null) continue;
                        if (!color2.equals(color)) break;
                        color2 = null;
                    }
                    if (color2 == null) {
                        color = null;
                    }
                }
                if (color == null) {
                    color = UIManager.getColor(bl ? "Table.selectionForeground" : "Table.foreground");
                }
                jLabel.setForeground(color);
            }
            jLabel.setIcon(layer.getIcon());
            jLabel.setToolTipText(layer.getToolTipText());
            return jLabel;
        }
    }

    private static class NativeScaleLayerCellRenderer
    implements TableCellRenderer {
        private final JCheckBox cb = new NativeScaleLayerCheckBox();

        NativeScaleLayerCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Layer layer = (Layer)object;
            if (layer instanceof NativeScaleLayer) {
                boolean bl3 = (NativeScaleLayer)((Object)layer) == Main.map.mapView.getNativeScaleLayer();
                this.cb.setSelected(bl3);
                this.cb.setToolTipText(bl3 ? I18n.tr("scale follows native resolution of this layer", new Object[0]) : I18n.tr("scale follows native resolution of another layer (click to set this layer)", new Object[0]));
            } else {
                this.cb.setSelected(false);
                this.cb.setToolTipText(I18n.tr("this layer has no native resolution", new Object[0]));
            }
            return this.cb;
        }
    }

    private static class LayerVisibleCellEditor
    extends DefaultCellEditor {
        private final LayerVisibleCheckBox cb;

        LayerVisibleCellEditor(LayerVisibleCheckBox layerVisibleCheckBox) {
            super(layerVisibleCheckBox);
            this.cb = layerVisibleCheckBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.cb.updateStatus((Layer)object);
            return this.cb;
        }
    }

    private static class LayerVisibleCellRenderer
    implements TableCellRenderer {
        private final LayerVisibleCheckBox cb = new LayerVisibleCheckBox();

        LayerVisibleCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                this.cb.updateStatus((Layer)object);
            }
            return this.cb;
        }
    }

    private static class ActiveLayerCellRenderer
    implements TableCellRenderer {
        private final JCheckBox cb = new ActiveLayerCheckBox();

        ActiveLayerCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3 = object != null && (Boolean)object != false;
            this.cb.setSelected(bl3);
            this.cb.setToolTipText(bl3 ? I18n.tr("this layer is the active layer", new Object[0]) : I18n.tr("this layer is not currently active (click to activate)", new Object[0]));
            return this.cb;
        }
    }

    private static class NativeScaleLayerCheckBox
    extends JCheckBox {
        NativeScaleLayerCheckBox() {
            this.setHorizontalAlignment(0);
            ImageIcon imageIcon = ImageProvider.get("dialogs/layerlist", "blank");
            ImageIcon imageIcon2 = ImageProvider.get("dialogs/layerlist", "scale");
            this.setIcon(imageIcon);
            this.setSelectedIcon(imageIcon2);
        }
    }

    private static class LayerVisibleCheckBox
    extends JCheckBox {
        private final ImageIcon iconEye;
        private final ImageIcon iconEyeTranslucent;
        private boolean isTranslucent;

        LayerVisibleCheckBox() {
            this.setHorizontalAlignment(4);
            this.iconEye = ImageProvider.get("dialogs/layerlist", "eye");
            this.iconEyeTranslucent = ImageProvider.get("dialogs/layerlist", "eye-translucent");
            this.setIcon(ImageProvider.get("dialogs/layerlist", "eye-off"));
            this.setPressedIcon(ImageProvider.get("dialogs/layerlist", "eye-pressed"));
            this.setSelectedIcon(this.iconEye);
            this.isTranslucent = false;
        }

        public void setTranslucent(boolean bl) {
            if (this.isTranslucent == bl) {
                return;
            }
            if (bl) {
                this.setSelectedIcon(this.iconEyeTranslucent);
            } else {
                this.setSelectedIcon(this.iconEye);
            }
            this.isTranslucent = bl;
        }

        public void updateStatus(Layer layer) {
            boolean bl = layer.isVisible();
            this.setSelected(bl);
            this.setTranslucent(layer.getOpacity() < 1.0);
            this.setToolTipText(bl ? I18n.tr("layer is currently visible (click to hide layer)", new Object[0]) : I18n.tr("layer is currently hidden (click to show layer)", new Object[0]));
        }
    }

    private static class ActiveLayerCheckBox
    extends JCheckBox {
        ActiveLayerCheckBox() {
            this.setHorizontalAlignment(0);
            ImageIcon imageIcon = ImageProvider.get("dialogs/layerlist", "blank");
            ImageIcon imageIcon2 = ImageProvider.get("dialogs/layerlist", "active");
            this.setIcon(imageIcon);
            this.setSelectedIcon(imageIcon2);
            this.setRolloverIcon(imageIcon);
            this.setRolloverSelectedIcon(imageIcon2);
            this.setPressedIcon(ImageProvider.get("dialogs/layerlist", "active-pressed"));
        }
    }

    private final class ToggleLayerIndexVisibility
    extends AbstractAction {
        private final int layerIndex;

        ToggleLayerIndexVisibility(int n) {
            this.layerIndex = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Layer layer = LayerListDialog.this.model.getLayer(LayerListDialog.this.model.getRowCount() - this.layerIndex - 1);
            if (layer != null) {
                layer.toggleVisible();
            }
        }
    }
}

