/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.layer;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.layer.IEnabledStateUpdating;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public final class DuplicateAction
extends AbstractAction
implements IEnabledStateUpdating {
    private transient Layer layer;
    private final LayerListDialog.LayerListModel model;

    public DuplicateAction(Layer layer, LayerListDialog.LayerListModel layerListModel) {
        this(layerListModel);
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        this.layer = layer;
        this.updateEnabledState();
    }

    public DuplicateAction(LayerListDialog.LayerListModel layerListModel) {
        this.model = layerListModel;
        this.putValue("Name", I18n.tr("Duplicate", new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get("dialogs", "duplicatelayer"));
        this.putValue("ShortDescription", I18n.tr("Duplicate this layer", new Object[0]));
        this.putValue("help", HelpUtil.ht("/Dialog/LayerList#DuplicateLayer"));
        this.updateEnabledState();
    }

    /*
     * WARNING - void declaration
     */
    private void duplicate(Layer layer) {
        if (!Main.isDisplayingMapView()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Layer object : Main.getLayerManager().getLayers()) {
            arrayList.add(object.getName());
        }
        if (layer instanceof OsmDataLayer) {
            void var4_6;
            OsmDataLayer osmDataLayer = (OsmDataLayer)layer;
            String string = I18n.tr("Copy of {0}", osmDataLayer.getName());
            int n = 2;
            while (arrayList.contains(var4_6)) {
                String string2 = I18n.tr("Copy {1} of {0}", osmDataLayer.getName(), n);
                ++n;
            }
            Main.getLayerManager().addLayer(new OsmDataLayer(new DataSet(osmDataLayer.data), (String)var4_6, null));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.layer != null) {
            this.duplicate(this.layer);
        } else {
            this.duplicate(this.model.getSelectedLayers().get(0));
        }
    }

    @Override
    public void updateEnabledState() {
        if (this.layer == null) {
            if (this.model.getSelectedLayers().size() == 1) {
                this.setEnabled(this.model.getSelectedLayers().get(0) instanceof OsmDataLayer);
            } else {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(this.layer instanceof OsmDataLayer);
        }
    }
}

