/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.actions.SaveAction;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.session.AbstractSessionExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.w3c.dom.Element;

public abstract class GenericSessionExporter<T extends Layer>
extends AbstractSessionExporter<T> {
    private final String type;
    private final String version;
    private final String extension;
    private final JRadioButton link;
    private final JRadioButton include;

    protected GenericSessionExporter(T t, String string, String string2, String string3) {
        super(t);
        this.type = string;
        this.version = string2;
        this.extension = string3;
        this.link = new JRadioButton(I18n.tr("local file", new Object[0]));
        this.include = new JRadioButton(I18n.tr("include", new Object[0]));
    }

    @Override
    public JPanel getExportPanel() {
        JComponent jComponent;
        JButton jButton;
        final JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.export.setSelected(true);
        JLabel jLabel = new JLabel(this.layer.getName(), this.layer.getIcon(), 2);
        jLabel.setToolTipText(this.layer.getToolTipText());
        jLabel.setLabelFor(this.export);
        JLabel jLabel2 = new JLabel(I18n.tr("Data:", new Object[0]));
        this.link.putClientProperty("actionname", "link");
        if (this.layer instanceof OsmDataLayer) {
            this.link.setToolTipText(I18n.tr("Link to a OSM data file on your local disk.", new Object[0]));
            this.include.setToolTipText(I18n.tr("Include OSM data in the .joz session file.", new Object[0]));
        } else if (this.layer instanceof GpxLayer) {
            this.link.setToolTipText(I18n.tr("Link to a GPX data file on your local disk.", new Object[0]));
            this.include.setToolTipText(I18n.tr("Include GPX data in the .joz session file.", new Object[0]));
        }
        this.include.putClientProperty("actionname", "include");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.link);
        buttonGroup.add(this.include);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        final File file = this.layer.getAssociatedFile();
        boolean bl = this.layer instanceof AbstractModifiableLayer;
        final LayerSaveAction layerSaveAction = bl ? new LayerSaveAction() : null;
        JButton jButton2 = jButton = bl ? new JButton(layerSaveAction) : null;
        if (file != null && file.exists()) {
            jComponent = new JosmTextField();
            ((JTextComponent)jComponent).setText(file.getPath());
            ((JTextComponent)jComponent).setEditable(false);
            jPanel3.add((Component)jComponent, GBC.std());
            if (jButton != null) {
                jButton.setMargin(new Insets(0, 0, 0, 0));
                jPanel3.add((Component)jButton, GBC.eol().insets(2, 0, 0, 0));
            }
        } else {
            jPanel3.add((Component)new JLabel(I18n.tr("No file association", new Object[0])), GBC.eol());
        }
        jComponent = new JPanel(new GridBagLayout());
        JLabel jLabel3 = new JLabel(this.layer instanceof GpxLayer ? I18n.tr("GPX data will be included in the session file.", new Object[0]) : I18n.tr("OSM data will be included in the session file.", new Object[0]));
        jLabel3.setFont(jLabel3.getFont().deriveFont(0));
        jComponent.add((Component)jLabel3, GBC.eol().fill(2));
        final CardLayout cardLayout = new CardLayout();
        final JPanel jPanel4 = new JPanel(cardLayout);
        jPanel4.add((Component)jPanel3, "link");
        jPanel4.add((Component)jComponent, "include");
        if (file != null && file.exists()) {
            this.link.setSelected(true);
        } else {
            this.link.setEnabled(false);
            this.link.setToolTipText(I18n.tr("No file association", new Object[0]));
            this.include.setSelected(true);
            cardLayout.show(jPanel4, "include");
        }
        this.link.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                cardLayout.show(jPanel4, "link");
            }
        });
        this.include.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                cardLayout.show(jPanel4, "include");
            }
        });
        jPanel2.add((Component)this.export, GBC.std());
        jPanel2.add((Component)jLabel, GBC.std());
        jPanel2.add(GBC.glue(1, 0), GBC.std().fill(2));
        jPanel.add((Component)jPanel2, GBC.eol().fill(2));
        jPanel.add((Component)jLabel2, GBC.std().insets(10, 0, 0, 0));
        jPanel.add((Component)this.link, GBC.std());
        jPanel.add((Component)this.include, GBC.eol());
        jPanel.add((Component)jPanel4, GBC.eol().insets(15, 0, 3, 3));
        this.export.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    GuiHelper.setEnabledRec(jPanel, false);
                    GenericSessionExporter.this.export.setEnabled(true);
                } else {
                    GuiHelper.setEnabledRec(jPanel, true);
                    if (jButton != null && layerSaveAction != null) {
                        jButton.setEnabled(layerSaveAction.isEnabled());
                    }
                    GenericSessionExporter.this.link.setEnabled(file != null && file.exists());
                }
            }
        });
        return jPanel;
    }

    @Override
    public Element export(SessionWriter.ExportSupport exportSupport) throws IOException {
        Element element = exportSupport.createElement("layer");
        element.setAttribute("type", this.type);
        element.setAttribute("version", this.version);
        Element element2 = exportSupport.createElement("file");
        element.appendChild(element2);
        if (this.requiresZip()) {
            String string = "layers/" + String.format("%02d", exportSupport.getLayerIndex()) + "/data." + this.extension;
            element2.appendChild(exportSupport.createTextNode(string));
            this.addDataFile(exportSupport.getOutputStreamZip(string));
        } else {
            try {
                File file = this.layer.getAssociatedFile();
                if (file != null) {
                    element2.appendChild(exportSupport.createTextNode(file.toURI().toURL().toString()));
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new IOException(malformedURLException);
            }
        }
        return element;
    }

    @Override
    public boolean requiresZip() {
        return this.include.isSelected();
    }

    protected abstract void addDataFile(OutputStream var1) throws IOException;

    private class LayerSaveAction
    extends AbstractAction {
        LayerSaveAction() {
            new ImageProvider("save").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", ((AbstractModifiableLayer)GenericSessionExporter.this.layer).requiresSaveToFile() ? I18n.tr("Layer contains unsaved data - save to file.", new Object[0]) : I18n.tr("Layer does not contain unsaved data.", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SaveAction.getInstance().doSave(GenericSessionExporter.this.layer);
            this.updateEnabledState();
        }

        public final void updateEnabledState() {
            this.setEnabled(((AbstractModifiableLayer)GenericSessionExporter.this.layer).requiresSaveToFile());
        }
    }
}

