/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.gui.layer.ImageProcessor;
import org.openstreetmap.josm.tools.ImageProvider;

public class ImageOverlay
implements ImageProcessor {
    public ImageProvider image;
    private final double offsetLeft;
    private final double offsetRight;
    private final double offsetTop;
    private final double offsetBottom;

    public ImageOverlay(ImageProvider imageProvider, double d, double d2, double d3, double d4) {
        this.image = imageProvider;
        this.offsetLeft = d;
        this.offsetTop = d2;
        this.offsetRight = d3;
        this.offsetBottom = d4;
    }

    public ImageOverlay(ImageProvider imageProvider) {
        this.image = imageProvider;
        this.offsetLeft = -1.0;
        this.offsetTop = -1.0;
        this.offsetRight = 1.0;
        this.offsetBottom = 1.0;
    }

    @Override
    public BufferedImage process(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = -1;
        int n4 = -1;
        if (this.offsetRight > 0.0 && this.offsetLeft > 0.0) {
            n3 = (int)((double)n * (this.offsetRight - this.offsetLeft));
        }
        if (this.offsetTop > 0.0 && this.offsetBottom > 0.0) {
            n4 = (int)((double)n2 * (this.offsetBottom - this.offsetTop));
        }
        if (n3 != -1 || n4 != -1) {
            this.image = new ImageProvider(this.image).resetMaxSize(new Dimension(n3, n4));
        }
        ImageIcon imageIcon = this.image.get();
        int n5 = n3 == -1 && this.offsetLeft < 0.0 ? (int)((double)n * this.offsetRight) - imageIcon.getIconWidth() : (int)((double)n * this.offsetLeft);
        int n6 = n4 == -1 && this.offsetTop < 0.0 ? (int)((double)n2 * this.offsetBottom) - imageIcon.getIconHeight() : (int)((double)n2 * this.offsetTop);
        imageIcon.paintIcon(null, bufferedImage.getGraphics(), n5, n6);
        return bufferedImage;
    }
}

