/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.widgets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.parosproxy.paros.control.Control;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.users.User;

public class UsersMultiSelectTable
extends JTable {
    private static final long serialVersionUID = 7473652413044348214L;
    private static ExtensionUserManagement usersExtension;
    private UsersSelectTableModel tableModel;

    public UsersMultiSelectTable(int n) {
        UsersMultiSelectTable.loadUsersManagementExtension();
        this.setTableHeader(null);
        this.reloadUsers(n);
        this.getColumnModel().getColumn(0).setMaxWidth(40);
    }

    private static void loadUsersManagementExtension() {
        if (usersExtension == null && (usersExtension = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class)) == null) {
            throw new IllegalStateException("Trying to create MultiUserSelectBox without the ExtensionUsersManagement being enabled.");
        }
    }

    public void reloadUsers(int n) {
        ArrayList<User> arrayList = new ArrayList<User>(usersExtension.getContextUserAuthManager(n).getUsers());
        this.tableModel = new UsersSelectTableModel(arrayList);
        this.setModel(this.tableModel);
    }

    public List<User> getSelectedUsers() {
        return this.tableModel.generateSelectedUsers();
    }

    public int getSelectedUsersCount() {
        return this.tableModel.getSelectedUsersCount();
    }

    public void addCustomUser(User user) {
        this.tableModel.addUser(user);
    }

    private static class UsersSelectTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -2187948264137599317L;
        private Set<Integer> selectedUsersIds;
        private List<User> users;

        public UsersSelectTableModel(List<User> list) {
            this.users = list;
            this.selectedUsersIds = new HashSet<Integer>(this.users.size());
        }

        public List<User> generateSelectedUsers() {
            ArrayList<User> arrayList = new ArrayList<User>(this.selectedUsersIds.size());
            for (User user : this.users) {
                if (!this.selectedUsersIds.contains(user.getId())) continue;
                arrayList.add(user);
            }
            return arrayList;
        }

        public int getSelectedUsersCount() {
            return this.selectedUsersIds.size();
        }

        public void addUser(User user) {
            this.users.add(user);
            this.fireTableRowsInserted(this.users.size() - 1, this.users.size() - 1);
        }

        @Override
        public int getRowCount() {
            return this.users.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.selectedUsersIds.contains(this.users.get(n).getId());
                }
                case 1: {
                    return this.users.get(n).getName();
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return super.getColumnClass(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0 && object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    this.selectedUsersIds.add(this.users.get(n).getId());
                } else {
                    this.selectedUsersIds.remove(this.users.get(n).getId());
                }
                this.fireTableCellUpdated(n, n2);
            }
        }
    }
}

