/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc;

import java.io.IOException;
import java.util.ArrayList;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.DocumentSerializer;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.StyleCatalog;
import org.openoffice.xmerge.converter.xml.sxc.BookSettings;
import org.openoffice.xmerge.converter.xml.sxc.CellStyle;
import org.openoffice.xmerge.converter.xml.sxc.ColumnRowInfo;
import org.openoffice.xmerge.converter.xml.sxc.ColumnStyle;
import org.openoffice.xmerge.converter.xml.sxc.Format;
import org.openoffice.xmerge.converter.xml.sxc.NameDefinition;
import org.openoffice.xmerge.converter.xml.sxc.RowStyle;
import org.openoffice.xmerge.converter.xml.sxc.SpreadsheetEncoder;
import org.openoffice.xmerge.converter.xml.sxc.SxcDocument;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class SxcDocumentSerializer
implements OfficeConstants,
DocumentSerializer {
    private Format fmt = new Format();
    private int rowID = 1;
    private int colID = 1;
    private int rowsRepeated = 1;
    private int colsRepeated = 1;
    private StyleCatalog styleCat = null;
    private ArrayList<ColumnRowInfo> ColumnRowList;
    protected SpreadsheetEncoder encoder = null;

    public abstract ConvertData serialize() throws ConvertException, IOException;

    public void traverseSettings(Node node) throws IOException {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int len = nodeList.getLength();
            for (int i = 0; i < len; ++i) {
                Node child = nodeList.item(i);
                if (child.getNodeType() != 1) continue;
                String nodeName = child.getNodeName();
                if (nodeName.equals("config:config-item-set")) {
                    this.traverseSettings(child);
                    continue;
                }
                if (nodeName.equals("config:config-item-map-indexed")) {
                    this.traverseSettings(child);
                    continue;
                }
                if (nodeName.equals("config:config-item-map-entry")) {
                    BookSettings bs = new BookSettings(child);
                    this.encoder.addSettings(bs);
                    continue;
                }
                Debug.log(4, "<OTHERS " + XmlUtil.getNodeInfo(child) + " />");
            }
        }
    }

    protected void loadStyles(SxcDocument sxcDoc) {
        Document stylesDom;
        this.styleCat = new StyleCatalog(25);
        NodeList nl = null;
        String[] families = new String[]{"table-column", "table-row", "table-cell"};
        Class[] classes = new Class[]{ColumnStyle.class, RowStyle.class, CellStyle.class};
        Document contentDom = sxcDoc.getContentDOM();
        nl = contentDom.getElementsByTagName("office:automatic-styles");
        if (nl.getLength() != 0) {
            this.styleCat.add(nl.item(0), families, classes, null, false);
        }
        if ((nl = (stylesDom = sxcDoc.getStyleDOM()).getElementsByTagName("office:styles")).getLength() != 0) {
            this.styleCat.add(nl.item(0), families, classes, null, false);
        }
    }

    protected void traverseBody(Node node) throws IOException {
        Debug.log(4, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        Debug.log(4, "<DEBUGLOG>");
        if (node.hasChildNodes()) {
            String nodeName;
            int i;
            NodeList nodeList = node.getChildNodes();
            int len = nodeList.getLength();
            for (i = 0; i < len; ++i) {
                Node searchNode = nodeList.item(i);
                if (searchNode.getNodeType() != 1) continue;
                nodeName = searchNode.getNodeName();
                if (nodeName.equals("table:named-expressions")) {
                    this.traverseNamedExpressions(searchNode);
                    continue;
                }
                Debug.log(4, "Skipping " + XmlUtil.getNodeInfo(searchNode) + " />");
            }
            for (i = 0; i < len; ++i) {
                Node child = nodeList.item(i);
                if (child.getNodeType() != 1) continue;
                nodeName = child.getNodeName();
                if (nodeName.equals("table:table")) {
                    this.traverseTable(child);
                    continue;
                }
                Debug.log(4, "<OTHERS " + XmlUtil.getNodeInfo(child) + " />");
            }
        }
        Debug.log(4, "</DEBUGLOG>");
    }

    protected void traverseNamedExpressions(Node node) throws IOException {
        Debug.log(4, "<NAMED:EXPRESSIONS>");
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int len = nodeList.getLength();
            for (int i = 0; i < len; ++i) {
                Node child = nodeList.item(i);
                if (child.getNodeType() != 1) continue;
                NameDefinition nd = new NameDefinition(child);
                this.encoder.setNameDefinition(nd);
            }
        }
        Debug.log(4, "</NAMED:EXPRESSIONS>");
    }

    protected void traverseTable(Node node) throws IOException {
        Debug.log(4, "<TABLE>");
        this.ColumnRowList = new ArrayList();
        NamedNodeMap att = node.getAttributes();
        String tableName = att.getNamedItem("table:name").getNodeValue();
        this.rowID = 1;
        this.encoder.createWorksheet(tableName);
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int len = nodeList.getLength();
            for (int i = 0; i < len; ++i) {
                Node child = nodeList.item(i);
                if (child.getNodeType() != 1) continue;
                String nodeName = child.getNodeName();
                if (nodeName.equals("table:table-row")) {
                    this.traverseTableRow(child);
                    continue;
                }
                if (nodeName.equals("table:table-column")) {
                    this.traverseTableColumn(child);
                    continue;
                }
                if (nodeName.equals("table:scenario")) continue;
                Debug.log(4, "<OTHERS " + XmlUtil.getNodeInfo(child) + " />");
            }
        }
        this.encoder.setColumnRows(this.ColumnRowList);
        Debug.log(4, "</TABLE>");
    }

    protected void traverseTableRow(Node node) throws IOException {
        NamedNodeMap cellAtt = node.getAttributes();
        if (cellAtt != null) {
            Node rowStyle = cellAtt.getNamedItem("table:style-name");
            Node tableNumRowRepeatingNode = cellAtt.getNamedItem("table:number-rows-repeated");
            int repeatedRows = 1;
            if (tableNumRowRepeatingNode != null) {
                String repeatStr = tableNumRowRepeatingNode.getNodeValue();
                Debug.log(4, "traverseTableRow() repeated-rows : " + repeatStr);
                repeatedRows = Integer.parseInt(repeatStr);
            }
            String styleName = "";
            if (rowStyle != null) {
                styleName = rowStyle.getNodeValue();
            }
            if (styleName.equalsIgnoreCase("Default") || styleName.length() == 0) {
                Debug.log(4, "No defined Row Style Attribute was found");
            } else {
                RowStyle rStyle = (RowStyle)this.styleCat.lookup(styleName, "table-row", null, RowStyle.class);
                int rowHeight = rStyle.getRowHeight();
                Debug.log(4, "traverseTableRow() Row Height : " + rowHeight);
                ColumnRowInfo ri = new ColumnRowInfo(rowHeight, repeatedRows, 2, rowHeight != 0);
                this.ColumnRowList.add(ri);
            }
            Node rowsRepeatedNode = cellAtt.getNamedItem("table:number-rows-repeated");
            if (rowsRepeatedNode != null) {
                String rowsRepeatedString = rowsRepeatedNode.getNodeValue();
                this.rowsRepeated = Integer.parseInt(rowsRepeatedString);
            } else {
                this.rowsRepeated = 1;
            }
        }
        Debug.log(4, "<TR>");
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int len = nodeList.getLength();
            for (int i = 0; i < len; ++i) {
                Node child = nodeList.item(i);
                if (child.getNodeType() != 1) continue;
                String nodeName = child.getNodeName();
                if (nodeName.equals("table:table-cell")) {
                    this.traverseCell(child);
                    continue;
                }
                Debug.log(4, "<OTHERS " + XmlUtil.getNodeInfo(child) + " />");
            }
        }
        this.rowID += this.rowsRepeated;
        this.rowsRepeated = 1;
        this.colID = 1;
        this.colsRepeated = 1;
        Debug.log(4, "</TR>");
    }

    protected void traverseTableColumn(Node node) throws IOException {
        Debug.log(4, "traverseColumn() : ");
        NamedNodeMap cellAtt = node.getAttributes();
        Node tableStyleNode = cellAtt.getNamedItem("table:style-name");
        Node tableNumColRepeatingNode = cellAtt.getNamedItem("table:number-columns-repeated");
        Node tableDefaultCellStyle = cellAtt.getNamedItem("table:default-cell-style-name");
        int repeatedColumns = 1;
        int columnWidth = 0;
        ColumnRowInfo col = new ColumnRowInfo(1);
        if (tableNumColRepeatingNode != null) {
            Debug.log(4, "traverseColumn() repeated-cols : " + tableNumColRepeatingNode.getNodeValue());
            repeatedColumns = Integer.parseInt(tableNumColRepeatingNode.getNodeValue());
            col.setRepeated(repeatedColumns);
        }
        String cellStyleName = "";
        if (tableDefaultCellStyle != null) {
            cellStyleName = tableDefaultCellStyle.getNodeValue();
            Debug.log(4, "traverseColumn() default-cell-style : " + cellStyleName);
        }
        if (cellStyleName.equalsIgnoreCase("Default") || cellStyleName.length() == 0) {
            Debug.log(4, "No default cell Style Attribute was found");
        } else {
            CellStyle cellStyle = (CellStyle)this.styleCat.lookup(cellStyleName, "table-cell", null, CellStyle.class);
            Format defaultFmt = new Format(cellStyle.getFormat());
            col.setFormat(defaultFmt);
        }
        String styleName = "";
        if (tableStyleNode != null) {
            styleName = tableStyleNode.getNodeValue();
        }
        if (styleName.equalsIgnoreCase("Default") || styleName.length() == 0) {
            Debug.log(4, "No defined Style Attribute was found");
        } else {
            ColumnStyle cStyle = (ColumnStyle)this.styleCat.lookup(styleName, "table-column", null, ColumnStyle.class);
            columnWidth = cStyle.getColWidth();
            col.setSize(columnWidth);
            Debug.log(4, "traverseColumn() Column Width : " + columnWidth);
        }
        this.ColumnRowList.add(col);
    }

    protected void traverseCell(Node node) throws IOException {
        Node tableFormulaNode;
        Node tableStringValueNode;
        NamedNodeMap cellAtt = node.getAttributes();
        this.fmt.clearFormatting();
        Node tableValueTypeNode = cellAtt.getNamedItem("table:value-type");
        Node colsRepeatedNode = cellAtt.getNamedItem("table:number-columns-repeated");
        Node tableStyleNode = cellAtt.getNamedItem("table:style-name");
        String styleName = "";
        if (tableStyleNode != null) {
            styleName = tableStyleNode.getNodeValue();
        }
        if (styleName.equalsIgnoreCase("Default")) {
            Debug.log(4, "No defined Style Attribute was found");
        } else if (styleName.length() != 0) {
            CellStyle cStyle = (CellStyle)this.styleCat.lookup(styleName, "table-cell", null, CellStyle.class);
            Format definedFormat = cStyle.getFormat();
            this.fmt = new Format(definedFormat);
        }
        if (colsRepeatedNode != null) {
            String colsRepeatedString = colsRepeatedNode.getNodeValue();
            this.colsRepeated = Integer.parseInt(colsRepeatedString);
        } else {
            this.colsRepeated = 1;
        }
        if (this.fmt.isDefault() && styleName.length() == 0) {
            int index = 1;
            for (ColumnRowInfo cri : this.ColumnRowList) {
                if (!cri.isColumn()) continue;
                if (this.colID >= index && this.colID < index + cri.getRepeated()) {
                    this.fmt = new Format(cri.getFormat());
                }
                index += cri.getRepeated();
            }
        }
        if (tableValueTypeNode != null) {
            Node tableValueNode;
            String cellType = tableValueTypeNode.getNodeValue();
            if (cellType.equalsIgnoreCase("string")) {
                this.fmt.setCategory("string");
                tableStringValueNode = cellAtt.getNamedItem("table:string-value");
                Debug.log(4, "Cell Type String :  " + tableStringValueNode);
                if (tableStringValueNode != null) {
                    this.fmt.setValue(tableStringValueNode.getNodeValue());
                }
            } else if (cellType.equalsIgnoreCase("float")) {
                this.fmt.setCategory("float");
                this.fmt.setDecimalPlaces(this.getDecimalPlaces(node));
                tableValueNode = cellAtt.getNamedItem("table:value");
                this.fmt.setValue(tableValueNode.getNodeValue());
            } else if (cellType.equalsIgnoreCase("time")) {
                this.fmt.setCategory("time");
                Node tableTimeNode = cellAtt.getNamedItem("table:time-value");
                this.fmt.setValue(tableTimeNode.getNodeValue());
            } else if (cellType.equalsIgnoreCase("date")) {
                this.fmt.setCategory("date");
                Node tableDateNode = cellAtt.getNamedItem("table:date-value");
                this.fmt.setValue(tableDateNode.getNodeValue());
            } else if (cellType.equalsIgnoreCase("currency")) {
                this.fmt.setCategory("currency");
                this.fmt.setDecimalPlaces(this.getDecimalPlaces(node));
                tableValueNode = cellAtt.getNamedItem("table:value");
                this.fmt.setValue(tableValueNode.getNodeValue());
            } else if (cellType.equalsIgnoreCase("boolean")) {
                this.fmt.setCategory("boolean");
                Node tableBooleanNode = cellAtt.getNamedItem("table:boolean-value");
                this.fmt.setValue(tableBooleanNode.getNodeValue());
            } else if (cellType.equalsIgnoreCase("percentage")) {
                this.fmt.setCategory("percentage");
                this.fmt.setDecimalPlaces(this.getDecimalPlaces(node));
                tableValueNode = cellAtt.getNamedItem("table:value");
                this.fmt.setValue(tableValueNode.getNodeValue());
            } else {
                Debug.log(4, "No defined value type" + cellType);
            }
        }
        if ((tableFormulaNode = cellAtt.getNamedItem("table:formula")) != null) {
            if (tableValueTypeNode == null) {
                this.fmt.setCategory("string");
                tableStringValueNode = cellAtt.getNamedItem("table:string-value");
                this.fmt.setValue(tableStringValueNode.getNodeValue());
            }
            String cellFormula = tableFormulaNode.getNodeValue();
            this.addCell(cellFormula);
        } else {
            Debug.log(1, "TextNode, DateNode, TimeNode or BooleanNode\n");
            if (node.hasChildNodes()) {
                NodeList childList = node.getChildNodes();
                int len = childList.getLength();
                for (int i = 0; i < len; ++i) {
                    String childName;
                    Node child = childList.item(i);
                    if (child.getNodeType() != 1 || !(childName = child.getNodeName()).equals("text:p")) continue;
                    this.traverseParagraph(child);
                }
            } else if (!this.fmt.isDefault()) {
                this.addCell("");
            }
        }
        this.colID += this.colsRepeated;
        this.colsRepeated = 1;
    }

    protected void traverseParagraph(Node node) throws IOException {
        NamedNodeMap cellAtt = node.getAttributes();
        int debug_i = 0;
        Node debug_attrib = null;
        if (cellAtt == null || cellAtt.item(0) == null) {
            Debug.log(1, "No Paragraph Attributes\n");
        } else {
            while ((debug_attrib = cellAtt.item(debug_i++)) != null) {
                Debug.log(1, "Paragraph Attribute " + debug_i + ": " + debug_attrib.getNodeName() + " : " + debug_attrib.getNodeValue() + "\n");
            }
        }
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int len = nodeList.getLength();
            StringBuffer buffer = new StringBuffer();
            block5: for (int i = 0; i < len; ++i) {
                Node child = nodeList.item(i);
                short nodeType = child.getNodeType();
                switch (nodeType) {
                    case 3: {
                        buffer.append(child.getNodeValue());
                        continue block5;
                    }
                    case 5: {
                        NodeList nodeList2 = child.getChildNodes();
                        int len2 = nodeList2.getLength();
                        for (int j = 0; j < len2; ++j) {
                            Node child2 = nodeList2.item(j);
                            if (child2.getNodeType() != 3) continue;
                            buffer.append(child2.getNodeValue());
                        }
                        continue block5;
                    }
                }
            }
            String s = buffer.toString();
            this.addCell(s);
        }
    }

    protected void addCell(String cellValue) throws IOException {
        int col = this.colID;
        int row = this.rowID;
        for (int i = 0; i < this.rowsRepeated; ++i) {
            if (i > 0) {
                Debug.log(4, "</TR>");
                Debug.log(4, "<TR>");
            }
            col = this.colID;
            for (int j = 0; j < this.colsRepeated; ++j) {
                Debug.log(4, "<TD>");
                this.encoder.addCell(row, col, this.fmt, cellValue);
                Debug.log(4, cellValue);
                Debug.log(4, "</TD>");
                ++col;
            }
            ++row;
        }
    }

    protected int getDecimalPlaces(Node node) {
        int decimals = 0;
        Element element = null;
        if (!(node instanceof Element)) {
            return decimals;
        }
        element = (Element)node;
        NodeList list = element.getElementsByTagName("text:p");
        if (list.getLength() != 1) {
            return decimals;
        }
        Node paragraph = list.item(0);
        if (paragraph.hasChildNodes()) {
            NodeList nodeList = paragraph.getChildNodes();
            int len = nodeList.getLength();
            for (int j = 0; j < len; ++j) {
                String s;
                int k;
                Node child = nodeList.item(j);
                if (child.getNodeType() != 3 || (k = (s = child.getNodeValue()).lastIndexOf(46)) <= 0) continue;
                s = s.substring(k + 1);
                decimals = s.length();
            }
        }
        return decimals;
    }
}

