/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts.xy;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.RoundBorder;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipModel;

public class ProfilerXYTooltipPainter
extends JPanel {
    private JLabel caption;
    private JLabel[] valuePainters;
    private JLabel[] unitsPainters;
    private JLabel[] extraValuePainters;
    private JLabel[] extraUnitsPainters;
    private ProfilerXYTooltipModel model;
    private boolean initialized;

    public ProfilerXYTooltipPainter(float f, Color color, Color color2, ProfilerXYTooltipModel profilerXYTooltipModel) {
        this.model = profilerXYTooltipModel;
        this.initialized = false;
        RoundBorder roundBorder = new RoundBorder(f, color, color2, 10, 7);
        Border border = BorderFactory.createEmptyBorder(0, 5, 0, 5);
        this.setBorder(BorderFactory.createCompoundBorder((Border)roundBorder, border));
    }

    public void update(List<ItemSelection> list) {
        int n;
        if (!this.initialized) {
            this.initComponents();
        }
        int n2 = this.model.getRowsCount();
        if (list.size() != n2) {
            throw new IllegalStateException("Rows and selected items don't match");
        }
        XYItemSelection xYItemSelection = (XYItemSelection)list.get(0);
        long l = xYItemSelection.getItem().getXValue(xYItemSelection.getValueIndex());
        this.caption.setText(this.model.getTimeValue(l));
        for (n = 0; n < n2; ++n) {
            XYItemSelection xYItemSelection2 = (XYItemSelection)list.get(n);
            long l2 = xYItemSelection2.getItem().getYValue(xYItemSelection2.getValueIndex());
            this.valuePainters[n].setText(this.model.getRowValue(n, l2));
            this.unitsPainters[n].setText(this.model.getRowUnits(n, l2));
        }
        n = this.model.getExtraRowsCount();
        for (int i = 0; i < n; ++i) {
            this.extraValuePainters[i].setText(this.model.getExtraRowValue(i));
            this.extraUnitsPainters[i].setText(this.model.getExtraRowUnits(i));
        }
    }

    private void initComponents() {
        JComponent jComponent;
        JLabel jLabel;
        JLabel jLabel2;
        JComponent jComponent2;
        int n;
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.caption = new JLabel();
        this.caption.setEnabled(false);
        float f = this.caption.getFont().getSize2D();
        this.caption.setFont(this.caption.getFont().deriveFont(f - 1.0f));
        this.caption.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.caption, gridBagConstraints);
        int n2 = this.model.getRowsCount();
        this.valuePainters = new JLabel[n2];
        this.unitsPainters = new JLabel[n2];
        for (n = 0; n < n2; ++n) {
            jComponent2 = new JLabel();
            ((JLabel)jComponent2).setText(this.model.getRowName(n));
            jComponent2.setFont(jComponent2.getFont().deriveFont(f + 1.0f));
            jComponent2.setForeground(this.model.getRowColor(n));
            jComponent2.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n + 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)jComponent2, gridBagConstraints);
            this.valuePainters[n] = jLabel2 = new JLabel();
            jLabel2.setFont(jComponent2.getFont().deriveFont(1, f + 1.0f));
            jLabel2.setForeground(this.model.getRowColor(n));
            jLabel2.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n + 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.insets = new Insets(0, 8, 0, 0);
            this.add((Component)jLabel2, gridBagConstraints);
            this.unitsPainters[n] = jLabel = new JLabel();
            jLabel.setFont(jLabel.getFont().deriveFont(f + 1.0f));
            jLabel.setForeground(this.model.getRowColor(n));
            jLabel.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = n + 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 4, 0, 0);
            this.add((Component)jLabel, gridBagConstraints);
            jComponent = new JPanel(null);
            jComponent.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = n + 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)jComponent, gridBagConstraints);
        }
        n = this.model.getExtraRowsCount();
        if (n > 0) {
            jComponent2 = new JPanel(null){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, 1);
                }

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            jComponent2.setBackground(Color.GRAY);
            jComponent2.setOpaque(true);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2 + 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(7, 0, 7, 0);
            this.add((Component)jComponent2, gridBagConstraints);
        }
        this.extraValuePainters = new JLabel[n];
        this.extraUnitsPainters = new JLabel[n];
        for (int i = 0; i < n; ++i) {
            jLabel2 = new JLabel();
            jLabel2.setText(this.model.getExtraRowName(i));
            jLabel2.setFont(jLabel2.getFont().deriveFont(f - 1.0f));
            jLabel2.setForeground(this.model.getRowColor(i));
            jLabel2.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2 + i + 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)jLabel2, gridBagConstraints);
            this.extraValuePainters[i] = jLabel = new JLabel();
            jLabel.setFont(jLabel2.getFont().deriveFont(1, f - 1.0f));
            jLabel.setForeground(this.model.getExtraRowColor(i));
            jLabel.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n2 + i + 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.insets = new Insets(0, 8, 0, 0);
            this.add((Component)jLabel, gridBagConstraints);
            jComponent = new JLabel();
            this.extraUnitsPainters[i] = jComponent;
            jComponent.setFont(jComponent.getFont().deriveFont(f - 1.0f));
            jComponent.setForeground(this.model.getExtraRowColor(i));
            jComponent.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = n2 + i + 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 4, 0, 0);
            this.add((Component)jComponent, gridBagConstraints);
            JPanel jPanel = new JPanel(null);
            jPanel.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = n2 + i + 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)jPanel, gridBagConstraints);
        }
        this.initialized = true;
    }
}

