/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import org.netbeans.lib.profiler.charts.Timeline;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.memory.ClassHistoryDataManager;
import org.netbeans.lib.profiler.ui.graphs.GraphsUI;

public final class ClassHistoryModels {
    private final ClassHistoryDataManager dataManager;
    private final Timeline timeline;
    private final SynchronousXYItemsModel allocationsItemsModel;
    private final SynchronousXYItemsModel livenessItemsModel;

    public ClassHistoryModels(ClassHistoryDataManager classHistoryDataManager) {
        this.dataManager = classHistoryDataManager;
        this.timeline = this.createTimeline();
        this.allocationsItemsModel = this.createAllocationsItemsModel(this.timeline);
        this.livenessItemsModel = this.createLivenessItemsModel(this.timeline);
        classHistoryDataManager.addDataListener(new DataManagerListener(){

            public void dataChanged() {
                ClassHistoryModels.this.dataChangedImpl();
            }

            public void dataReset() {
                ClassHistoryModels.this.dataResetImpl();
            }
        });
    }

    public ClassHistoryDataManager getDataManager() {
        return this.dataManager;
    }

    public SynchronousXYItemsModel allocationsItemsModel() {
        return this.allocationsItemsModel;
    }

    public SynchronousXYItemsModel livenessItemsModel() {
        return this.livenessItemsModel;
    }

    private void dataChangedImpl() {
        this.allocationsItemsModel.valuesAdded();
        this.livenessItemsModel.valuesAdded();
    }

    private void dataResetImpl() {
        this.allocationsItemsModel.valuesReset();
        this.livenessItemsModel.valuesReset();
    }

    private Timeline createTimeline() {
        return new Timeline(){

            public int getTimestampsCount() {
                return ClassHistoryModels.this.dataManager.getItemCount();
            }

            public long getTimestamp(int n) {
                return ((ClassHistoryModels)ClassHistoryModels.this).dataManager.timeStamps[n];
            }
        };
    }

    private SynchronousXYItemsModel createAllocationsItemsModel(Timeline timeline) {
        SynchronousXYItem synchronousXYItem = new SynchronousXYItem(GraphsUI.A_ALLOC_OBJECTS_NAME, 0L){

            public long getYValue(int n) {
                return ((ClassHistoryModels)ClassHistoryModels.this).dataManager.nTotalAllocObjects[n];
            }
        };
        synchronousXYItem.setInitialBounds(new LongRect(0L, 0L, 0L, 100L));
        SynchronousXYItem synchronousXYItem2 = new SynchronousXYItem(GraphsUI.A_ALLOC_BYTES_NAME, 0L){

            public long getYValue(int n) {
                return ((ClassHistoryModels)ClassHistoryModels.this).dataManager.totalAllocObjectsSize[n];
            }
        };
        synchronousXYItem2.setInitialBounds(new LongRect(0L, 0L, 0L, 102400L));
        SynchronousXYItemsModel synchronousXYItemsModel = new SynchronousXYItemsModel(timeline, new SynchronousXYItem[]{synchronousXYItem, synchronousXYItem2});
        return synchronousXYItemsModel;
    }

    private SynchronousXYItemsModel createLivenessItemsModel(Timeline timeline) {
        SynchronousXYItem synchronousXYItem = new SynchronousXYItem(GraphsUI.L_LIVE_OBJECTS_NAME, 0L){

            public long getYValue(int n) {
                return ((ClassHistoryModels)ClassHistoryModels.this).dataManager.nTrackedLiveObjects[n];
            }
        };
        synchronousXYItem.setInitialBounds(new LongRect(0L, 0L, 0L, 100L));
        SynchronousXYItem synchronousXYItem2 = new SynchronousXYItem(GraphsUI.L_LIVE_BYTES_NAME, 0L){

            public long getYValue(int n) {
                return ((ClassHistoryModels)ClassHistoryModels.this).dataManager.trackedLiveObjectsSize[n];
            }
        };
        synchronousXYItem2.setInitialBounds(new LongRect(0L, 0L, 0L, 102400L));
        SynchronousXYItem synchronousXYItem3 = new SynchronousXYItem(GraphsUI.A_ALLOC_OBJECTS_NAME, 0L){

            public long getYValue(int n) {
                return ((ClassHistoryModels)ClassHistoryModels.this).dataManager.nTotalAllocObjects[n];
            }
        };
        synchronousXYItem3.setInitialBounds(new LongRect(0L, 0L, 0L, 100L));
        SynchronousXYItemsModel synchronousXYItemsModel = new SynchronousXYItemsModel(timeline, new SynchronousXYItem[]{synchronousXYItem, synchronousXYItem2, synchronousXYItem3});
        return synchronousXYItemsModel;
    }
}

