/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.URLHandler;
import org.apache.ivy.util.url.URLHandlerRegistry;

public class ApacheURLLister {
    private static final Pattern PATTERN = Pattern.compile("<a[^>]*href=\"([^\"]*)\"[^>]*>(?:<[^>]+>)*?([^<>]+?)(?:<[^>]+>)*?</a>", 2);

    public List listAll(URL url) throws IOException {
        return this.retrieveListing(url, true, true);
    }

    public List listDirectories(URL url) throws IOException {
        return this.retrieveListing(url, false, true);
    }

    public List listFiles(URL url) throws IOException {
        return this.retrieveListing(url, true, false);
    }

    public List retrieveListing(URL url, boolean includeFiles, boolean includeDirectories) throws IOException {
        URLHandler urlHandler;
        URLHandler.URLInfo urlInfo;
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (!url.getPath().endsWith("/") && !url.getPath().endsWith(".html")) {
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath() + "/");
        }
        if ((urlInfo = (urlHandler = URLHandlerRegistry.getDefault()).getURLInfo(url)) == URLHandler.UNAVAILABLE) {
            return urlList;
        }
        String charset = urlInfo.getBodyCharset();
        InputStream contentStream = urlHandler.openStream(url);
        BufferedReader r = null;
        r = charset == null ? new BufferedReader(new InputStreamReader(contentStream)) : new BufferedReader(new InputStreamReader(contentStream, charset));
        String htmlText = FileUtil.readEntirely(r);
        Matcher matcher = PATTERN.matcher(htmlText);
        while (matcher.find()) {
            boolean directory;
            String strippedText;
            String strippedHref;
            String href = matcher.group(1);
            String text = matcher.group(2);
            if (href == null || text == null) continue;
            text = text.trim();
            if (href.startsWith("http:") || href.startsWith("https:")) {
                try {
                    href = new URL(href).getPath();
                    if (!href.startsWith(url.getPath())) continue;
                    href = href.substring(url.getPath().length());
                }
                catch (Exception ignore) {
                    continue;
                }
            }
            if (href.startsWith("../")) continue;
            if (href.startsWith("/")) {
                int slashIndex = href.substring(0, href.length() - 1).lastIndexOf(47);
                href = href.substring(slashIndex + 1);
            }
            if (href.startsWith("./")) {
                href = href.substring("./".length());
            }
            if (text.endsWith("..>")) {
                if (!href.startsWith(text.substring(0, text.length() - 3))) {
                    continue;
                }
            } else if (!text.endsWith("..&gt;") ? !(strippedHref = href.endsWith("/") ? href.substring(0, href.length() - 1) : href).equalsIgnoreCase(strippedText = text.endsWith("/") ? text.substring(0, text.length() - 1) : text) : !href.startsWith(text.substring(0, text.length() - 6))) continue;
            if ((!(directory = href.endsWith("/")) || !includeDirectories) && (directory || !includeFiles)) continue;
            URL child = new URL(url, href);
            urlList.add(child);
            Message.debug("ApacheURLLister found URL=[" + child + "].");
        }
        return urlList;
    }
}

