/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import com.carrotsearch.hppc.IntArrayList;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.ShardFetchSearchRequest;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.threadpool.ThreadPool;

class SearchDfsQueryThenFetchAsyncAction
extends AbstractSearchAsyncAction<DfsSearchResult> {
    final AtomicArray<QuerySearchResult> queryResults;
    final AtomicArray<FetchSearchResult> fetchResults;
    final AtomicArray<IntArrayList> docIdsToLoad;

    SearchDfsQueryThenFetchAsyncAction(ESLogger logger, SearchServiceTransportAction searchService, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, SearchPhaseController searchPhaseController, ThreadPool threadPool, SearchRequest request, ActionListener<SearchResponse> listener) {
        super(logger, searchService, clusterService, indexNameExpressionResolver, searchPhaseController, threadPool, request, listener);
        this.queryResults = new AtomicArray(this.firstResults.length());
        this.fetchResults = new AtomicArray(this.firstResults.length());
        this.docIdsToLoad = new AtomicArray(this.firstResults.length());
    }

    @Override
    protected String firstPhaseName() {
        return "dfs";
    }

    @Override
    protected void sendExecuteFirstPhase(DiscoveryNode node, ShardSearchTransportRequest request, ActionListener<DfsSearchResult> listener) {
        this.searchService.sendExecuteDfs(node, request, listener);
    }

    @Override
    protected void moveToSecondPhase() {
        AggregatedDfs dfs = this.searchPhaseController.aggregateDfs(this.firstResults);
        AtomicInteger counter = new AtomicInteger(this.firstResults.asList().size());
        for (AtomicArray.Entry entry : this.firstResults.asList()) {
            DfsSearchResult dfsResult = (DfsSearchResult)entry.value;
            DiscoveryNode node = this.nodes.get(dfsResult.shardTarget().nodeId());
            QuerySearchRequest querySearchRequest = new QuerySearchRequest(this.request, dfsResult.id(), dfs);
            this.executeQuery(entry.index, dfsResult, counter, querySearchRequest, node);
        }
    }

    void executeQuery(final int shardIndex, final DfsSearchResult dfsResult, final AtomicInteger counter, final QuerySearchRequest querySearchRequest, final DiscoveryNode node) {
        this.searchService.sendExecuteQuery(node, querySearchRequest, new ActionListener<QuerySearchResult>(){

            @Override
            public void onResponse(QuerySearchResult result) {
                result.shardTarget(dfsResult.shardTarget());
                SearchDfsQueryThenFetchAsyncAction.this.queryResults.set(shardIndex, result);
                if (counter.decrementAndGet() == 0) {
                    SearchDfsQueryThenFetchAsyncAction.this.executeFetchPhase();
                }
            }

            @Override
            public void onFailure(Throwable t) {
                try {
                    SearchDfsQueryThenFetchAsyncAction.this.onQueryFailure(t, querySearchRequest, shardIndex, dfsResult, counter);
                }
                finally {
                    SearchDfsQueryThenFetchAsyncAction.this.sendReleaseSearchContext(querySearchRequest.id(), node);
                }
            }
        });
    }

    void onQueryFailure(Throwable t, QuerySearchRequest querySearchRequest, int shardIndex, DfsSearchResult dfsResult, AtomicInteger counter) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}] Failed to execute query phase", t, querySearchRequest.id());
        }
        this.addShardFailure(shardIndex, dfsResult.shardTarget(), t);
        this.successfulOps.decrementAndGet();
        if (counter.decrementAndGet() == 0) {
            if (this.successfulOps.get() == 0) {
                this.listener.onFailure(new SearchPhaseExecutionException("query", "all shards failed", this.buildShardFailures()));
            } else {
                this.executeFetchPhase();
            }
        }
    }

    void executeFetchPhase() {
        try {
            this.innerExecuteFetchPhase();
        }
        catch (Throwable e) {
            this.listener.onFailure(new ReduceSearchPhaseException("query", "", e, this.buildShardFailures()));
        }
    }

    void innerExecuteFetchPhase() throws Exception {
        boolean useScroll = this.request.scroll() != null;
        this.sortedShardList = this.searchPhaseController.sortDocs(useScroll, this.queryResults);
        this.searchPhaseController.fillDocIdsToLoad(this.docIdsToLoad, this.sortedShardList);
        if (this.docIdsToLoad.asList().isEmpty()) {
            this.finishHim();
            return;
        }
        ScoreDoc[] lastEmittedDocPerShard = this.searchPhaseController.getLastEmittedDocPerShard(this.request, this.sortedShardList, this.firstResults.length());
        AtomicInteger counter = new AtomicInteger(this.docIdsToLoad.asList().size());
        for (AtomicArray.Entry<IntArrayList> entry : this.docIdsToLoad.asList()) {
            QuerySearchResult queryResult = this.queryResults.get(entry.index);
            DiscoveryNode node = this.nodes.get(queryResult.shardTarget().nodeId());
            ShardFetchSearchRequest fetchSearchRequest = this.createFetchRequest(queryResult, entry, lastEmittedDocPerShard);
            this.executeFetch(entry.index, queryResult.shardTarget(), counter, fetchSearchRequest, node);
        }
    }

    void executeFetch(final int shardIndex, final SearchShardTarget shardTarget, final AtomicInteger counter, final ShardFetchSearchRequest fetchSearchRequest, DiscoveryNode node) {
        this.searchService.sendExecuteFetch(node, fetchSearchRequest, new ActionListener<FetchSearchResult>(){

            @Override
            public void onResponse(FetchSearchResult result) {
                result.shardTarget(shardTarget);
                SearchDfsQueryThenFetchAsyncAction.this.fetchResults.set(shardIndex, result);
                if (counter.decrementAndGet() == 0) {
                    SearchDfsQueryThenFetchAsyncAction.this.finishHim();
                }
            }

            @Override
            public void onFailure(Throwable t) {
                SearchDfsQueryThenFetchAsyncAction.this.docIdsToLoad.set(shardIndex, null);
                SearchDfsQueryThenFetchAsyncAction.this.onFetchFailure(t, fetchSearchRequest, shardIndex, shardTarget, counter);
            }
        });
    }

    void onFetchFailure(Throwable t, ShardFetchSearchRequest fetchSearchRequest, int shardIndex, SearchShardTarget shardTarget, AtomicInteger counter) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}] Failed to execute fetch phase", t, fetchSearchRequest.id());
        }
        this.addShardFailure(shardIndex, shardTarget, t);
        this.successfulOps.decrementAndGet();
        if (counter.decrementAndGet() == 0) {
            this.finishHim();
        }
    }

    private void finishHim() {
        this.threadPool.executor("search").execute(new ActionRunnable<SearchResponse>(this.listener){

            @Override
            public void doRun() throws IOException {
                InternalSearchResponse internalResponse = SearchDfsQueryThenFetchAsyncAction.this.searchPhaseController.merge(SearchDfsQueryThenFetchAsyncAction.this.sortedShardList, SearchDfsQueryThenFetchAsyncAction.this.queryResults, SearchDfsQueryThenFetchAsyncAction.this.fetchResults, SearchDfsQueryThenFetchAsyncAction.this.request);
                String scrollId = null;
                if (SearchDfsQueryThenFetchAsyncAction.this.request.scroll() != null) {
                    scrollId = TransportSearchHelper.buildScrollId(SearchDfsQueryThenFetchAsyncAction.this.request.searchType(), (AtomicArray<? extends SearchPhaseResult>)SearchDfsQueryThenFetchAsyncAction.this.firstResults, null);
                }
                this.listener.onResponse(new SearchResponse(internalResponse, scrollId, SearchDfsQueryThenFetchAsyncAction.this.expectedSuccessfulOps, SearchDfsQueryThenFetchAsyncAction.this.successfulOps.get(), SearchDfsQueryThenFetchAsyncAction.this.buildTookInMillis(), SearchDfsQueryThenFetchAsyncAction.this.buildShardFailures()));
                SearchDfsQueryThenFetchAsyncAction.this.releaseIrrelevantSearchContexts(SearchDfsQueryThenFetchAsyncAction.this.queryResults, SearchDfsQueryThenFetchAsyncAction.this.docIdsToLoad);
            }

            @Override
            public void onFailure(Throwable t) {
                try {
                    ReduceSearchPhaseException failure = new ReduceSearchPhaseException("merge", "", t, SearchDfsQueryThenFetchAsyncAction.this.buildShardFailures());
                    if (SearchDfsQueryThenFetchAsyncAction.this.logger.isDebugEnabled()) {
                        SearchDfsQueryThenFetchAsyncAction.this.logger.debug("failed to reduce search", failure, new Object[0]);
                    }
                    super.onFailure(failure);
                }
                finally {
                    SearchDfsQueryThenFetchAsyncAction.this.releaseIrrelevantSearchContexts(SearchDfsQueryThenFetchAsyncAction.this.queryResults, SearchDfsQueryThenFetchAsyncAction.this.docIdsToLoad);
                }
            }
        });
    }
}

